/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui;

import be.iminds.ilabt.jfed.fedmon.util.TiParamExpander;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui.LoadConfigFromUrlDialog;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.dropwizard.jackson.Jackson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadConfigFromUrlController {
    private static final Logger LOG = LoggerFactory.getLogger(LoadConfigFromUrlDialog.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private FedmonWebApiClient fedmonWebApiClient;
    @FXML
    private VBox root;
    @FXML
    public TextField urlField;
    @FXML
    public Label errorInfoText;
    @FXML
    public Label tiIdText;
    @FXML
    public Label tdIdText;
    @FXML
    public Label testClassText;
    @FXML
    public Label serverIdText;
    @FXML
    public Label testGroupText;
    @FXML
    public Label configText;
    private LoadConfigFromUrlDialog.LoadConfigFromUrlDialogResult currentConfig;

    @Inject
    public LoadConfigFromUrlController(FedmonWebApiClient fedmonWebApiClient) {
        this.fedmonWebApiClient = fedmonWebApiClient;
    }

    @Nullable
    private Integer parseInstanceID(@Nonnull URL url) {
        String path = url.getPath();
        Pattern tiPattern = Pattern.compile("^/?testinstance/([0-9]+)$");
        Matcher tiMatcher = tiPattern.matcher(path);
        if (tiMatcher.matches()) {
            return Integer.parseInt(tiMatcher.group(1));
        }
        Pattern histPattern = Pattern.compile("^/?history/([0-9]+)$");
        Matcher histMatcher = histPattern.matcher(path);
        if (histMatcher.matches()) {
            return Integer.parseInt(histMatcher.group(1));
        }
        return null;
    }

    public LoadConfigFromUrlDialog.LoadConfigFromUrlDialogResult getConfigFromTestInstance(@Nonnull TestInstance testInstance, @Nonnull TestDefinition testDefinition) {
        boolean unsupportedTest;
        Integer serverId = testInstance.getServerIdParameter();
        String testClassName = null;
        String testGroup = null;
        String config = null;
        LOG.debug("getConfigFromTestInstance serverId=" + serverId);
        switch (testDefinition.getType()) {
            case "ping": 
            case "aggregatetestbedstatus": 
            case "resourcestotests": 
            case "replayandsummarize": 
            case "parallelstitch": 
            case "listresources": 
            case "selftest": {
                unsupportedTest = true;
                break;
            }
            case "automatedtestertestcall": {
                unsupportedTest = false;
                testClassName = testInstance.getStringParameterOrDefault("test_class", testDefinition);
                testGroup = testInstance.getStringParameterOrDefault("test_group", testDefinition);
                String contextFileContent = testInstance.getStringParameterOrDefault("context-file", testDefinition);
                break;
            }
            case "automatedtester2testcall": 
            case "automatedtesterespectestcall": {
                unsupportedTest = false;
                testClassName = testInstance.getStringParameterOrDefault("test_class", testDefinition);
                testGroup = testInstance.getStringParameterOrDefault("test_group", testDefinition);
                Object at2config = testInstance.getParameterOrDefault("automated_tester_config", testDefinition);
                if (at2config != null) {
                    if (!(at2config instanceof Map)) {
                        throw new RuntimeException("Non Map configuration specified in automated_tester_config (must be json object)");
                    }
                    Map at2configMap = (Map)at2config;
                    at2configMap = TiParamExpander.expandTiParameters((Map)at2configMap, (TestInstance)testInstance);
                    try {
                        config = MAPPER.enable(SerializationFeature.INDENT_OUTPUT).writeValueAsString((Object)at2configMap);
                    }
                    catch (JsonProcessingException e) {
                        LOG.error("Failed to convert config to JSON", (Throwable)e);
                        config = null;
                    }
                    break;
                }
                config = null;
                break;
            }
            default: {
                LOG.warn("Unmapped TestDefinition: " + testInstance.getTestDefinitionId());
                unsupportedTest = true;
            }
        }
        LOG.debug("Looking up testDefinition " + testInstance.getTestDefinitionId() + " of type " + testDefinition.getType() + " unsupportedTest=" + unsupportedTest + " testClassName=" + testClassName + " testGroup=" + testGroup + " config=" + config);
        if (unsupportedTest) {
            LOG.info("The TestDefinition does not match a test that the automated tester GUI can run: " + testInstance.getTestDefinitionId());
            return null;
        }
        if (testClassName != null) {
            return new LoadConfigFromUrlDialog.LoadConfigFromUrlDialogResult(testClassName, testGroup, config, serverId);
        }
        return null;
    }

    public void fetch() {
        boolean error = false;
        try {
            this.errorInfoText.setVisible(false);
            URL url = new URL(this.urlField.getText());
            Integer testInstanceId = this.parseInstanceID(url);
            if (testInstanceId != null) {
                this.tiIdText.setText("" + testInstanceId);
                TestInstance testInstance = (TestInstance)this.fedmonWebApiClient.get(TestInstance.class, (Object)testInstanceId).get();
                TestDefinition testDefinition = (TestDefinition)this.fedmonWebApiClient.get(TestDefinition.class, (Object)testInstance.getTestDefinitionId()).get();
                this.tiIdText.setText(testInstanceId + " (" + testInstance.getName() + ")");
                this.tdIdText.setText((String)testDefinition.getId());
                this.currentConfig = this.getConfigFromTestInstance(testInstance, testDefinition);
            } else {
                this.tiIdText.setText("*none*");
                this.tdIdText.setText("*none*");
                this.currentConfig = null;
            }
            if (this.currentConfig != null && this.currentConfig.getTestClassName() != null) {
                this.testClassText.setText(this.currentConfig.getTestClassName());
            } else {
                this.testClassText.setText("");
            }
            if (this.currentConfig != null && this.currentConfig.getTestGroup() != null) {
                this.testGroupText.setText(this.currentConfig.getTestGroup());
            } else {
                this.testGroupText.setText("");
            }
            if (this.currentConfig != null && this.currentConfig.getConfig() != null) {
                this.configText.setText(this.currentConfig.getConfig());
            } else {
                this.configText.setText("");
            }
            if (this.currentConfig != null && this.currentConfig.getServerId() != null) {
                this.serverIdText.setText("" + this.currentConfig.getServerId());
            } else {
                this.serverIdText.setText("");
            }
        }
        catch (MalformedURLException e) {
            LOG.debug("Malformed URL in LoadConfigFromUrlController: \"" + this.urlField.getText() + "\": " + e.getMessage());
            this.errorInfoText.setText("Malformed URL: " + e.getMessage());
            error = true;
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            LOG.debug("Failure when contacting web API.", (Throwable)e);
            this.errorInfoText.setText("Failure when contacting web API: " + e.getMessage());
            error = true;
        }
        if (error) {
            this.currentConfig = null;
            this.errorInfoText.setVisible(true);
            this.tiIdText.setText("*error*");
            this.tdIdText.setText("*error*");
            this.testClassText.setText("*error*");
            this.testGroupText.setText("*error*");
            this.configText.setText("*error*");
            this.serverIdText.setText("*error*");
        }
    }

    @Nullable
    public LoadConfigFromUrlDialog.LoadConfigFromUrlDialogResult getConfig() {
        return this.currentConfig;
    }

    @FXML
    public void initialize() {
    }
}

