/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui;

import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.GuiceFXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.automated_testing_gui.LoadConfigFromUrlController;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadConfigFromUrlDialog
extends Dialog<LoadConfigFromUrlDialogResult> {
    private static final Logger LOG = LoggerFactory.getLogger(LoadConfigFromUrlDialog.class);
    private final LoadConfigFromUrlController controller;

    @Inject
    public LoadConfigFromUrlDialog(GuiceFXMLUtil guiceFXMLUtil) {
        GuiceFXMLUtil.Result fxmlResult = guiceFXMLUtil.createFromFXML(LoadConfigFromUrlController.class);
        this.controller = (LoadConfigFromUrlController)fxmlResult.getController();
        this.setTitle("Fetch config from Fedmon URL");
        this.getDialogPane().setContent((Node)fxmlResult.getRoot());
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.HDD_ALT, (Color)Color.BLACK));
        ButtonType loadConfigFromUrlButtonType = new ButtonType("Load Config", ButtonBar.ButtonData.OK_DONE);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{loadConfigFromUrlButtonType, ButtonType.CANCEL});
        this.setResultConverter(param -> {
            if (param == loadConfigFromUrlButtonType) {
                return this.controller.getConfig();
            }
            return null;
        });
    }

    public static class LoadConfigFromUrlDialogResult {
        @Nonnull
        private final String testClassName;
        @Nullable
        private final String testGroup;
        @Nullable
        private final String config;
        @Nullable
        private final Integer serverId;

        public LoadConfigFromUrlDialogResult(@Nonnull String testClassName, @Nullable String testGroup, @Nullable String config, @Nullable Integer serverId) {
            this.testClassName = testClassName;
            this.testGroup = testGroup;
            this.config = config;
            this.serverId = serverId;
        }

        @Nonnull
        public String getTestClassName() {
            return this.testClassName;
        }

        @Nullable
        public String getTestGroup() {
            return this.testGroup;
        }

        @Nullable
        public String getConfig() {
            return this.config;
        }

        @Nullable
        public Integer getServerId() {
            return this.serverId;
        }
    }
}

