/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.graphmaker;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.rrd.base.PropertiesRrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.GraphTask;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.GraphTaskFilter;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.RrdGraphManager;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.MemoryApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.authority.JFedTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.embed.swing.JFXPanel;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMakerCli {
    private static final Logger LOG = LoggerFactory.getLogger(GraphMakerCli.class);
    private final FedmonWebApiClient fedmonWebApiClient;
    private final Properties configProperties;
    private static boolean javaFXInitialized = false;

    public static void initJavaFX() {
        if (javaFXInitialized) {
            return;
        }
        try {
            long timeMillis = System.currentTimeMillis();
            new JFXPanel();
            System.out.println("JavaFX was initialised in " + (System.currentTimeMillis() - timeMillis) + "ms");
            javaFXInitialized = true;
        }
        catch (Throwable t) {
            javaFXInitialized = true;
            LOG.warn("Failed to initialize JavaFX (perhaps no X11 server present?). This could be ignored, but might cause very hard to debug problems later on. Will instead stop to prevent this", t);
            throw new RuntimeException("Failed to initialize JavaFX. Stopping to prevent hard to find bugs.");
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            new GraphMakerCli(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
    }

    public static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "monitorService [options ... ]", "Options:", options, "");
        System.exit(0);
    }

    public GraphMakerCli(String[] args) throws IOException {
        LinkedList<? extends GraphTask> tasks;
        LOG.debug("starting GraphMakerCli");
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"Amount of threads to use. Default is the number of availableProcessors.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number of threads");
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"max-runs");
        OptionBuilder.withDescription((String)"Limit the maximum number of tests that can be run. (if specified, must be > 0)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"maximum number of tests");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"force");
        OptionBuilder.withDescription((String)"Force remaking graphs, even if up to date. (Useful for debugging)");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"graph-period");
        OptionBuilder.withDescription((String)"Limit graph generation by graph period. Multiple values should be separated by ',' e.g. graphperiod1,graphperiod2.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"graphperiod(s)");
        options.addOption(OptionBuilder.create((String)"tdn"));
        OptionBuilder.withLongOpt((String)"graph-type");
        OptionBuilder.withDescription((String)"Limit graph generation by graphtype(s). Multiple values should be separated by ',' e.g. graphtype1,graphtype2.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"graphtype(s)");
        options.addOption(OptionBuilder.create((String)"tdn"));
        OptionBuilder.withLongOpt((String)"test-instance-id");
        OptionBuilder.withDescription((String)"Limit graph generation by instance id(s). Multiple values should be separated by ',' e.g. 17,31.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"testinstanceid");
        options.addOption(OptionBuilder.create((String)"tid"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"print some debug info");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"configfile");
        OptionBuilder.withDescription((String)"location of the property file containing the configuration. Default ~/.jFed/config");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"conf"));
        CommandLine line = null;
        BasicParser parser = new BasicParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            GraphMakerCli.help(options);
            throw new RuntimeException("Error parsing command line parameters: " + ex.getMessage(), ex);
        }
        if (line.hasOption("help")) {
            GraphMakerCli.help(options);
            throw new RuntimeException("Help");
        }
        int threadCount = Integer.parseInt(line.getOptionValue("threads", "" + (Runtime.getRuntime().availableProcessors() * 2 + 1)));
        String maxRunHelper = line.getOptionValue("max-runs", null);
        Integer maxRunCount = maxRunHelper == null ? null : Integer.valueOf(Integer.parseInt(maxRunHelper));
        String graphPeriodFilter = line.getOptionValue("graph-period", null);
        String graphTypeFilter = line.getOptionValue("graph-type", null);
        String testInstanceIdFilter = line.getOptionValue("test-instance-id", "ALL");
        boolean forceUpdate = line.hasOption("force");
        String originsServiceConfigFilename = line.getOptionValue("configfile", "~/.jFed/config");
        this.configProperties = new Properties();
        try {
            this.configProperties.load(new FileInputStream(originsServiceConfigFilename));
        }
        catch (Exception e) {
            System.out.println("Config file not found: \"" + originsServiceConfigFilename + "\"");
            System.exit(-2);
        }
        GraphMakerCli.initJavaFX();
        JFedCorePreferences jFedPreferences = new JFedCorePreferences();
        ConnectivityDetector connectivityDetector = new ConnectivityDetector(null);
        connectivityDetector.setNoInternet(false);
        TestbedInfoSource testbedInfoSource = new JFedTestbedInfoSource((JFedPreferences)jFedPreferences, connectivityDetector, new URL("https://flsmonitor-api.fed4fire.eu/"), null).get();
        AuthorityFinder authorityFinder = new AuthorityFinder(testbedInfoSource, (JFedPreferences)jFedPreferences);
        SerializableApiCallDetailsFactory serializableApiCallDetailsFactory = new SerializableApiCallDetailsFactory();
        MemoryApiCallDetailsCache apiCallDetailsCache = new MemoryApiCallDetailsCache(serializableApiCallDetailsFactory);
        CallReportFactory callReportFactory = new CallReportFactory((ApiCallDetailsCache)apiCallDetailsCache);
        CallReportWriter callReportWriter = new CallReportWriter((ApiCallDetailsCache)apiCallDetailsCache);
        PropertiesRrdConfig rrdConfig = new PropertiesRrdConfig(this.configProperties);
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        this.fedmonWebApiClient = new FedmonWebApiCachedClient((FedmonWebApiClientConfig)new FedmonWebApiClientPropertiesConfig(this.configProperties, jFedTrustStore, null, null, null));
        RrdGraphManager rrdManager = new RrdGraphManager((RrdConfig)rrdConfig, this.fedmonWebApiClient);
        GraphTaskFilter filter = new GraphTaskFilter(graphPeriodFilter, graphTypeFilter, testInstanceIdFilter);
        try {
            tasks = new LinkedList<GraphTask>(rrdManager.getGraphTasks(filter, forceUpdate));
        }
        catch (Throwable t) {
            LOG.error("Something went wrong getting all GraphTasks. Will abort.", t);
            System.err.println("Something went wrong getting all GraphTasks. Will abort. " + t.getMessage());
            System.exit(-1);
            return;
        }
        LOG.debug("jFed graphmaker run at: " + new Date().getTime() + " Tasks in queue: " + tasks.size());
        if (tasks.isEmpty()) {
            System.out.println("jFed graphmaker service will not start: No tasks where received.");
            System.exit(0);
        }
        LOG.debug("Creating threadpool with " + threadCount + " threads.");
        ExecutorService threadPool = Executors.newFixedThreadPool(threadCount, ThreadFactoryUtil.getFactory((String)"graphmaker-pool"));
        int sheduledCount = 0;
        while (!tasks.isEmpty()) {
            GraphTask graphTask = (GraphTask)tasks.poll();
            if (filter.mustRun(graphTask)) {
                threadPool.submit(graphTask);
                System.out.println("SCHEDULING " + graphTask);
                ++sheduledCount;
                continue;
            }
            System.out.println("SKIPPING      " + graphTask);
        }
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            LOG.info("InterruptedException", (Throwable)ex);
        }
        LOG.debug("jFed graphmaker service has finished");
        System.out.println("jFed graphmaker service has finished.");
        System.exit(0);
    }
}

