/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.graphmaker;

import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphTask.class);
    private final TestInstanceRrd.GraphInfo graphInfo;
    private final TestInstanceRrd rrd;
    private final FedmonWebApiClient fedmonWebApiClient;

    public GraphTask(TestInstanceRrd rrd, TestInstanceRrd.GraphInfo graphInfo, FedmonWebApiClient fedmonWebApiClient) {
        this.rrd = rrd;
        this.graphInfo = graphInfo;
        this.fedmonWebApiClient = fedmonWebApiClient;
    }

    @Override
    public void run() {
        File tmpGraphFile = null;
        try {
            tmpGraphFile = this.rrd.makeGraph(this.graphInfo);
            tmpGraphFile.deleteOnExit();
            byte[] graphBytes = IOUtils.fileToByteArray((File)tmpGraphFile);
            assert (graphBytes != null);
            assert (graphBytes.length > 20);
            Graph graph = this.graphInfo.getGraph();
            graph = (Graph)this.fedmonWebApiClient.update((JsonLdObjectWithUri)graph);
            this.fedmonWebApiClient.setImageData(graph, graphBytes);
            LOG.debug("Created graph " + graph.getUri() + " with image data at " + graph.getImageUri());
        }
        catch (Exception e) {
            LOG.error("Failed to make graph " + this.graphInfo.getId(), (Throwable)e);
        }
        catch (AssertionError e) {
            LOG.error("Failed to make graph " + this.graphInfo.getId(), (Throwable)((Object)e));
        }
        catch (Throwable t) {
            LOG.error("Failed to make graph " + this.graphInfo.getId(), t);
            throw t;
        }
        finally {
            if (tmpGraphFile != null && tmpGraphFile.exists()) {
                tmpGraphFile.delete();
            }
        }
    }

    public TestInstanceRrd.GraphInfo getGraphInfo() {
        return this.graphInfo;
    }
}

