/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsServiceConfig;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceCommandLine;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginsServiceConfig
extends BasicOriginsServiceConfig
implements OriginsServiceConfigIface {
    private static final Logger LOG = LoggerFactory.getLogger(OriginsServiceConfig.class);
    private final TestInstanceFilter testInstanceFilter;
    private final int threadCount;
    private final Integer maxRunCount;
    private final boolean exitWhenIdle;
    private final boolean exitWhenNoInitialTasks;
    private final Long maxRunTime;
    private final TimeUnit maxRunTimeUnit;
    private final Long maxScheduleNewTime;
    private final TimeUnit maxScheduleNewTimeUnit;

    public OriginsServiceConfig(OriginsServiceCommandLine originsServiceCommandLine, String[] args) {
        this(originsServiceCommandLine.parse(args));
    }

    public OriginsServiceConfig(CommandLine line) {
        super(line);
        this.testInstanceFilter = new TestInstanceFilter(line.getOptionValue("version-name", null), line.getOptionValue("test-instance-name", null), line.getOptionValue("test-definition-name", null), line.getOptionValue("test-instance-id", null), null, null, line.getOptionValue("testbed", null), null, Optional.of(false));
        this.exitWhenNoInitialTasks = line.hasOption("exit-when-no-initial-tasks");
        this.exitWhenIdle = line.hasOption("exit-when-idle");
        this.threadCount = Integer.parseInt(line.getOptionValue("threads", "" + (Runtime.getRuntime().availableProcessors() * 2 + 1)));
        String maxRunHelper = line.getOptionValue("max-runs", null);
        this.maxRunCount = maxRunHelper == null ? null : Integer.valueOf(Integer.parseInt(maxRunHelper));
        this.maxRunTime = line.hasOption("max-run-time-s") ? Long.parseLong(line.getOptionValue("max-run-time-s")) : 7200L;
        this.maxRunTimeUnit = TimeUnit.SECONDS;
        this.maxScheduleNewTime = line.hasOption("max-schedule-time-s") ? Long.parseLong(line.getOptionValue("max-schedule-time-s")) : 3600L;
        this.maxScheduleNewTimeUnit = TimeUnit.SECONDS;
    }

    @Override
    public TestInstanceFilter getTestInstanceFilter() {
        return this.testInstanceFilter;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public Integer getMaxRunCount() {
        return this.maxRunCount;
    }

    @Override
    public boolean isExitWhenIdle() {
        return this.exitWhenIdle;
    }

    @Override
    public boolean isExitWhenNoInitialTasks() {
        return this.exitWhenNoInitialTasks;
    }

    @Override
    public Long getMaxRunTime() {
        return this.maxRunTime;
    }

    @Override
    public TimeUnit getMaxRunTimeUnit() {
        return this.maxRunTimeUnit;
    }

    @Override
    public Long getMaxScheduleNewTime() {
        return this.maxScheduleNewTime;
    }

    @Override
    public TimeUnit getMaxScheduleNewTimeUnit() {
        return this.maxScheduleNewTimeUnit;
    }
}

