/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.util;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    public static final String mailSubjectPrefix = "[Fedmon] ";
    public static final long DEFAULT_MIN_DELAY_BETWEEN_EMAILS_MS = 10000L;
    @Nonnull
    private final EmailSenderConfig config;
    private final boolean neverSendMail;
    @Nonnull
    private final Executor executor;
    private static final EmailSender noEmailSender = new EmailSender();

    public EmailSender(@Nonnull EmailSenderConfig config) {
        this.config = config;
        this.neverSendMail = false;
        this.executor = Executors.newSingleThreadExecutor(ThreadFactoryUtil.getFactory((String)"email-sender-pool"));
    }

    private EmailSender() {
        try {
            this.config = new EmailSenderConfig("dummy@example.com", Collections.emptyList(), "dummy", null, null, null);
        }
        catch (AddressException e) {
            throw new RuntimeException("Failed to init non mailing EmailSender");
        }
        this.neverSendMail = true;
        this.executor = new Executor(){

            @Override
            public void execute(@Nonnull Runnable runnable) {
                throw new RuntimeException("should never be used");
            }
        };
    }

    @Nonnull
    public static EmailSender getNoEmailSender() {
        return noEmailSender;
    }

    private long getMinDelayBetweenEmailsMs() {
        Long res = this.config.getMinDelayBetweenMailsMs();
        return res == null ? 10000L : res;
    }

    @Nonnull
    public EmailSenderConfig getConfig() {
        return this.config;
    }

    public void sendExceptionToAdmin(String id, Throwable e) {
        String message = "There was an exception in Fedmon.\nID: " + id + "\n\nStacktrace:\n" + IOUtils.exceptionToStacktraceString((Throwable)e) + "\n";
        this.sendToAdmin("[Fedmon]  Unexpected error " + id, message);
    }

    public void sendToAdmin(String subject, String body) {
        if (this.neverSendMail || !this.hasValidConfig()) {
            LOG.debug("Email not configured: will not try to send");
            return;
        }
        this.executor.execute(() -> {
            this.performSendToAdmin(subject, body);
            try {
                Thread.sleep(this.getMinDelayBetweenEmailsMs());
            }
            catch (InterruptedException e) {
                LOG.warn("In between mail sleep was interrupted. Will ignore it.", (Throwable)e);
            }
        });
        LOG.info("mail queued for sending to admin");
    }

    public void sendTo(List<String> rawTos, String subject, String body) throws AddressException {
        if (this.neverSendMail || !this.hasValidConfig()) {
            LOG.debug("Email not configured: will not try to send");
            return;
        }
        ArrayList<InternetAddress> tos = new ArrayList<InternetAddress>();
        for (String to : rawTos) {
            if (!to.contains("@")) {
                LOG.error("NOT AN EMAIL ADDRESS: " + to + "   (SKIPPING)");
                continue;
            }
            tos.add(new InternetAddress(to));
        }
        if (tos.isEmpty()) {
            LOG.info("mail NOT queued: no valid to addresses");
            return;
        }
        this.executor.execute(() -> {
            this.performSendEmail(tos, subject, body);
            try {
                Thread.sleep(this.getMinDelayBetweenEmailsMs());
            }
            catch (InterruptedException e) {
                LOG.warn("In between mail sleep was interrupted. Will ignore it.", (Throwable)e);
            }
        });
        LOG.info("mail queued for sending to " + tos);
    }

    private void performSendToAdmin(@Nonnull String subject, @Nonnull String body) {
        if (this.neverSendMail || !this.hasValidConfig()) {
            return;
        }
        this.performSendEmail(this.config.getAdminAddresses(), subject, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performSendEmail(@Nonnull List<InternetAddress> tos, @Nonnull String subject, @Nonnull String body) {
        if (this.neverSendMail || !this.hasValidConfig()) {
            return;
        }
        Properties sysProperties = System.getProperties();
        sysProperties.setProperty("mail.smtp.host", this.config.getSmtpServer());
        sysProperties.setProperty("mail.smtp.ssl.enable", "false");
        sysProperties.setProperty("mail.smtp.starttls.enable", "false");
        sysProperties.setProperty("mail.smtp.starttls.required", "false");
        sysProperties.setProperty("mail.smtp.auth", "false");
        String origPreferIpv4 = sysProperties.getProperty("java.net.preferIPv4Stack");
        try {
            sysProperties.setProperty("java.net.preferIPv4Stack", "true");
            Session session = this.config.getSmtpPassword() == null ? Session.getDefaultInstance((Properties)sysProperties) : Session.getInstance((Properties)sysProperties, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EmailSender.this.config.getSmtpUsername(), EmailSender.this.config.getSmtpPassword());
                }
            });
            try {
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)this.config.getFrom());
                for (InternetAddress to : tos) {
                    message.addRecipient(Message.RecipientType.TO, (Address)to);
                }
                message.setSubject(subject);
                message.setText(body);
                Transport.send((Message)message);
                LOG.info("mail successfully sent to " + tos);
            }
            catch (MessagingException e) {
                LOG.error("Error sending mail to " + tos + " using SMTP server " + this.config.getSmtpServer(), (Throwable)e);
            }
        }
        finally {
            sysProperties.setProperty("java.net.preferIPv4Stack", origPreferIpv4);
        }
    }

    public boolean hasValidConfig() {
        return !this.neverSendMail && this.config != null && this.config.getAdminAddresses() != null && !this.config.getAdminAddresses().isEmpty() && this.config.getFrom() != null && this.config.getSmtpServer() != null;
    }

    public static class EmailSenderConfig {
        @Nonnull
        private final InternetAddress from;
        @Nonnull
        private final List<InternetAddress> adminAddresses;
        @Nonnull
        private final String rawFrom;
        @Nonnull
        private final List<String> rawAdminAddresses;
        @Nonnull
        private final String smtpServer;
        private final String smtpUsername;
        private final String smtpPassword;
        private final Long minDelayBetweenMailsMs;

        public EmailSenderConfig(@JsonProperty(value="fromAddress") @Nonnull String fromAddress, @JsonProperty(value="adminAddresses") @Nonnull List<String> adminAddresses, @JsonProperty(value="smtpServer") @Nonnull String smtpServer, @JsonProperty(value="smtpUsername") @Nullable String smtpUsername, @JsonProperty(value="smtpPassword") @Nullable String smtpPassword, @JsonProperty(value="minDelayBetweenMailsMs") @Nullable Long minDelayBetweenMailsMs) throws AddressException {
            this.rawFrom = fromAddress;
            this.rawAdminAddresses = adminAddresses;
            this.from = new InternetAddress(fromAddress);
            this.adminAddresses = new ArrayList<InternetAddress>();
            for (String adminAddress : adminAddresses) {
                this.adminAddresses.add(new InternetAddress(adminAddress));
            }
            this.smtpServer = smtpServer;
            this.smtpUsername = smtpUsername;
            this.smtpPassword = smtpPassword;
            this.minDelayBetweenMailsMs = minDelayBetweenMailsMs;
        }

        @JsonProperty(value="fromAddress")
        @Nonnull
        public String getRawFrom() {
            return this.rawFrom;
        }

        @JsonProperty(value="adminAddresses")
        @Nonnull
        public List<String> getRawAdminAddresses() {
            return this.rawAdminAddresses;
        }

        @JsonIgnore
        @Nonnull
        public InternetAddress getFrom() {
            return this.from;
        }

        @JsonIgnore
        @Nonnull
        public List<InternetAddress> getAdminAddresses() {
            return this.adminAddresses;
        }

        @JsonProperty
        @Nonnull
        public String getSmtpServer() {
            return this.smtpServer;
        }

        @JsonProperty
        @Nullable
        public String getSmtpUsername() {
            return this.smtpUsername;
        }

        @JsonProperty
        @Nullable
        public String getSmtpPassword() {
            return this.smtpPassword;
        }

        @JsonProperty
        @Nullable
        public Long getMinDelayBetweenMailsMs() {
            return this.minDelayBetweenMailsMs;
        }
    }
}

