/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.LogBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerGlimpseBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReport;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.DirectUserModule;
import be.iminds.ilabt.jfed.lib.PostLoginCoreModule;
import be.iminds.ilabt.jfed.lib.PreLoginCoreModule;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserFactory;
import be.iminds.ilabt.jfed.lowlevel.userloginmodel.InvalidLoginException;
import be.iminds.ilabt.jfed.module.BasicTestbedInfoModule;
import be.iminds.ilabt.jfed.module.JFedWebApiClientModule;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.statistics.RSpecStatistics;
import be.iminds.ilabt.jfed.rspec.statistics.RspecStatisticsMaker;
import be.iminds.ilabt.jfed.util.common.Pair;
import be.iminds.ilabt.jfed.util.common.Slf4jHelper;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListResourcesWrapper
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ListResourcesWrapper.class);
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final CallReportFactory callReportFactory;
    private final CallReportWriter callReportWriter;
    public static final TypeAndVersion geni3 = new TypeAndVersion("geni", "3");

    public ListResourcesWrapper(Task task, TestInstance testInstance, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, CallReportFactory callReportFactory, CallReportWriter callReportWriter) {
        super(task, testInstance, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.callReportFactory = callReportFactory;
        this.callReportWriter = callReportWriter;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(@Nonnull Logger testLog, @Nullable PrintWriter consoleOutput) throws InterruptedException {
        Result.ResultStatus status;
        boolean callFailed;
        Server server;
        HashMap<String, Object> subresults = new HashMap<String, Object>();
        CallReport callReport = this.callReportFactory.createCallReport("ListResources Call Details", "ListResources");
        CallReport.State reportState = callReport.getCurState();
        Logger LOG = Slf4jHelper.createMultiplexLogger((Logger[])new Logger[]{testLog, reportState});
        LOG.debug("Starting ListResources at " + new Date());
        ListResourcesResult listResourcesResult = null;
        be.iminds.ilabt.jfed.log.Logger logger = new be.iminds.ilabt.jfed.log.Logger();
        logger.addResultListener((ResultListener)reportState);
        Integer serverId = this.testInstance.getServerIdParameter();
        Server server2 = server = serverId == null ? null : this.testbedInfoSource.getServerById(serverId);
        if (server == null) {
            ListResourcesWrapper.LOG.error("error: server \"" + serverId + "\" not found.");
            ResultBuilder testResult = this.initResult();
            testResult.setSummary(Result.ResultStatus.FAILURE);
            return new TestRunner.TestCallCreatedObjects(testResult);
        }
        String componentManagerUrn = server.getDefaultComponentManagerUrn();
        Boolean useUserProxyOpt = this.testInstance.getBooleanParameterOrDefault("use-user-proxy", this.testDefinition);
        boolean useUserProxy = useUserProxyOpt != null ? useUserProxyOpt : false;
        Server targetServer = server;
        assert (targetServer != null);
        LOG.debug("Will connect to server id=" + targetServer.getId() + " name=" + targetServer.getName() + " (allowedCertificateAlias=" + targetServer.getAllowedCertificateAlias() + ")");
        boolean requestAndCountAll = true;
        try {
            listResourcesResult = requestAndCountAll ? ListResourcesWrapper.callListResources(this.testInstance, this.testDefinition, this.originsService.getConfig().getProperty("webapi_client_url_read_base"), this.originsService.getFedmonWebApiClient(), this.testbedInfoSource, this.authorityFinder, LOG, targetServer, logger, false, useUserProxy) : ListResourcesWrapper.callListResources(this.testInstance, this.testDefinition, this.originsService.getConfig().getProperty("webapi_client_url_read_base"), this.originsService.getFedmonWebApiClient(), this.testbedInfoSource, this.authorityFinder, LOG, targetServer, logger, true, useUserProxy);
            callFailed = false;
        }
        catch (JFedException e) {
            callFailed = true;
            LOG.error("Caught JFedException", (Throwable)e);
        }
        catch (IOException e) {
            callFailed = true;
            LOG.error("Caught IOException", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (AssertionError e) {
            callFailed = true;
            LOG.error("Caught unexpected \"" + e.getClass().getName() + "\":", (Throwable)((Object)e));
            ListResourcesWrapper.LOG.error("Caught unexpected \"" + e.getClass().getName() + "\"", (Throwable)((Object)e));
        }
        catch (Exception e) {
            callFailed = true;
            LOG.error("Caught unexpected \"" + e.getClass().getName() + "\":", (Throwable)e);
            ListResourcesWrapper.LOG.error("Caught unexpected \"" + e.getClass().getName() + "\"", (Throwable)e);
        }
        catch (Throwable t) {
            LOG.error("Caught unexpected \"" + t.getClass().getName() + "\". This is bad, must abort task.", t);
            ListResourcesWrapper.LOG.error("Caught unexpected \"" + t.getClass().getName() + "\". This is bad, must abort task.", t);
            throw t;
        }
        Log createdRspecLog = null;
        ServerGlimpseBuilder glimpse = null;
        if (listResourcesResult == null || listResourcesResult.cancelled || callFailed) {
            status = listResourcesResult != null && listResourcesResult.cancelled && !callFailed ? Result.ResultStatus.CANCELLED : Result.ResultStatus.FAILURE;
        } else {
            TreeMap<String, Map<String, Integer>> countSubresult;
            status = Result.ResultStatus.SUCCESS;
            String rspec = listResourcesResult.rspec;
            TypeAndVersion advRspecTypeAndVersion = listResourcesResult.version;
            if (rspec != null && advRspecTypeAndVersion.equals(geni3)) {
                LOG.debug("Found Advertisement RSpec in ListResources reply. size=" + rspec.length());
                if (rspec.length() < 200000) {
                    try {
                        rspec = XmlUtil.formatXmlFromString((String)rspec);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to convert RSpec to pretty format. This will be ignored.", (Throwable)e);
                    }
                } else {
                    LOG.info("Advertisement RSpec is large. Will not pretty print it.");
                }
                try {
                    createdRspecLog = (Log)this.fedmonWebApiClient.create((JsonLdObjectWithUri)new LogBuilder().setLive(Boolean.valueOf(false)).setName("rspec.xml").setMediaType(Log.LogMediaType.XML).create());
                    if (createdRspecLog != null && createdRspecLog.getContent() != null) {
                        this.fedmonWebApiClient.appendStringContent(createdRspecLog, rspec);
                        subresults.put("rspecUrl", createdRspecLog.getContent().toASCIIString());
                    } else {
                        LOG.error("Something went wrong creating a Log for the rspec at the server");
                    }
                }
                catch (Exception e) {
                    String errorDescription = "Caught unexpected Exception \"" + e.getClass().getName() + "\" while trying to store received Advertisement RSpec (of size " + rspec.length() + " bytes) on server. => will not cause this test to fail, but RSpec might not be in logs.";
                    LOG.error(errorDescription, (Throwable)e);
                    ListResourcesWrapper.LOG.error(errorDescription, (Throwable)e);
                }
                try {
                    RspecStatisticsMaker statMaker = new RspecStatisticsMaker();
                    Pair stats = statMaker.make(rspec, !requestAndCountAll, server, new Timestamp(System.currentTimeMillis()));
                    RSpecStatistics rSpecStatistics = (RSpecStatistics)stats.getKey();
                    glimpse = (ServerGlimpseBuilder)stats.getValue();
                    if (createdRspecLog != null && createdRspecLog.getContent() != null) {
                        glimpse.setRspec(createdRspecLog.getContent());
                    }
                    if (rSpecStatistics.isCountErrors()) {
                        status = Result.ResultStatus.WARNING;
                    }
                    TreeMap<String, Map<String, Integer>> countSubresult2 = new TreeMap<String, Map<String, Integer>>();
                    subresults.put("count", countSubresult2);
                    LOG.debug("\nCounted " + rSpecStatistics.getCount() + " nodes in Advertisement RSpec");
                    countSubresult2.put("summary", ListResourcesWrapper.countMap(rSpecStatistics.getCount(), rSpecStatistics.getCountTotal()));
                    if (requestAndCountAll) {
                        countSubresult2.put("raw", ListResourcesWrapper.countMap(rSpecStatistics.getCountRaw(), rSpecStatistics.getCountRawTotal()));
                        countSubresult2.put("vm", ListResourcesWrapper.countMap(rSpecStatistics.getCountVm(), rSpecStatistics.getCountVmTotal()));
                    } else {
                        countSubresult2.put("raw", ListResourcesWrapper.countMap(rSpecStatistics.getCountRaw(), null));
                        countSubresult2.put("vm", ListResourcesWrapper.countMap(rSpecStatistics.getCountVm(), null));
                    }
                    if (rSpecStatistics.getCountIpv4() >= 0 || rSpecStatistics.getCountIpv4Total() >= 0) {
                        countSubresult2.put("ipv4", ListResourcesWrapper.countMap(rSpecStatistics.getCountIpv4(), rSpecStatistics.getCountIpv4Total() >= 0 ? Integer.valueOf(rSpecStatistics.getCountIpv4Total()) : null));
                    }
                    if (rSpecStatistics.getCountOpenflow() >= 0 || rSpecStatistics.getCountOpenflowTotal() >= 0) {
                        countSubresult2.put("openflow", ListResourcesWrapper.countMap(rSpecStatistics.getCountOpenflow(), rSpecStatistics.getCountOpenflowTotal() >= 0 ? Integer.valueOf(rSpecStatistics.getCountOpenflowTotal()) : null));
                    }
                    if (rSpecStatistics.getCount() < 0 || status == null) {
                        status = Result.ResultStatus.FAILURE;
                    }
                    if (rSpecStatistics.getCount() == -1 && this.testInstance.getServerIdParameter().equals(325)) {
                        status = Result.ResultStatus.SUCCESS;
                        ListResourcesWrapper.LOG.warn("HARDCODED SPECIAL CASE: Forcing test to SUCCESS for bristol_openflow if count == -1");
                        LOG.debug("HARDCODED SPECIAL CASE: Forcing test to SUCCESS for bristol_openflow if count == -1");
                    }
                    LOG.debug("Interpretted node count as " + status);
                }
                catch (Throwable e) {
                    status = Result.ResultStatus.FAILURE;
                    LOG.error("Caught unexpected \"" + e.getClass().getName() + "\":", e);
                    ListResourcesWrapper.LOG.error("Caught unexpected \"" + e.getClass().getName() + "\"", e);
                }
                LOG.debug("Finished ListResources at " + new Date());
            } else if (advRspecTypeAndVersion.equals(geni3)) {
                countSubresult = new TreeMap<String, Map<String, Integer>>();
                subresults.put("count", countSubresult);
                countSubresult.put("summary", ListResourcesWrapper.countMap(-1, null));
                status = Result.ResultStatus.FAILURE;
                LOG.debug("\n\nDid not find Advertisement RSpec in ListResources reply: ListResources " + status);
            } else {
                countSubresult = new TreeMap();
                subresults.put("count", countSubresult);
                countSubresult.put("summary", ListResourcesWrapper.countMap(-1, null));
                status = Result.ResultStatus.SUCCESS;
                LOG.debug("\n\nType of Advertisement RSpec in ListResources reply is not supported (" + advRspecTypeAndVersion + ") -> treating ListResources call as " + status);
            }
        }
        if (glimpse != null) {
            ListResourcesWrapper.LOG.debug("Will update ServerGlimpse. new glimpse:\n" + glimpse.create().toString());
            LOG.debug("Will update ServerGlimpse. new glimpse:\n" + glimpse.create().toString());
        } else {
            ListResourcesWrapper.LOG.debug("no glimpse to update");
            LOG.debug("no glimpse to update");
        }
        String htmlReportContent = null;
        try {
            htmlReportContent = callReport.toHtmlString(false);
        }
        catch (Throwable e) {
            LOG.error("Error writing HTML report", e);
        }
        String xmlReportContent = null;
        try {
            xmlReportContent = this.callReportWriter.writeCallReportToString(callReport, false);
        }
        catch (Throwable e) {
            LOG.error("Error writing XML report", e);
        }
        ResultBuilder testResult = this.initResult();
        testResult.addResults(subresults);
        testResult.setSummary(status);
        TestRunner.TestCallCreatedObjects res = new TestRunner.TestCallCreatedObjects(testResult);
        if (xmlReportContent != null) {
            res.addLog("callXmlLogUrl", "call_log.xml", xmlReportContent, Log.LogMediaType.XML, null);
        }
        if (htmlReportContent != null) {
            res.addLog("callHtmlLogUrl", "call_log.html", htmlReportContent, Log.LogMediaType.HTML, null);
        }
        if (createdRspecLog != null) {
            res.addCreatedLog(createdRspecLog);
        }
        if (glimpse != null) {
            res.addServerGlimpse(glimpse);
            ServerGlimpseBuilder finalGlimpse = glimpse;
            res.addOnResultIdKnownCallback(result -> finalGlimpse.setAdvertisementResult(result));
        }
        return res;
    }

    private String friendlyName(RspecNode node) {
        if (node.getComponentName() != null) {
            return node.getComponentName();
        }
        if (node.getComponentId() != null) {
            return node.getComponentId().getResourceName();
        }
        return null;
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }

    public static ListResourcesResult callListResources(@Nonnull TestInstance testInstance, @Nonnull TestDefinition testDefinition, @Nonnull String webApiCLientUrlReadBase, @Nonnull FedmonWebApiClient webApiClient, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull Logger reportState, @Nonnull Server targetServer, @Nonnull be.iminds.ilabt.jfed.log.Logger logger, boolean available, boolean useUserProxy) throws JFedException, IOException, InterruptedException, FedmonWebApiClient.FedmonWebApiClientException {
        List cred;
        Server userAuth;
        GeniUser user;
        String keyCertContent = ListResourcesWrapper.getTestUserPem(webApiClient, testInstance);
        char[] keyPass = null;
        try {
            GeniUserFactory geniUserFactory = new GeniUserFactory(authorityFinder);
            user = geniUserFactory.createGeniUser(keyCertContent, keyPass, null, null);
            assert (user != null);
            assert (user.getUserUrn() != null);
            assert (user.getUserAuthorityServer() != null);
        }
        catch (InvalidLoginException e) {
            throw new RuntimeException(e);
        }
        reportState.debug("Will make ListResource read Testbed and Server info from \"" + webApiCLientUrlReadBase + "\"");
        CorePreferencesModule preferencesModule = new CorePreferencesModule(webApiCLientUrlReadBase);
        JFedWebApiClientModule webApiClientModule = new JFedWebApiClientModule();
        Injector injector = Guice.createInjector((Module[])new Module[]{new BasicTestbedInfoModule(), new DirectUserModule(user), new PreLoginCoreModule(), new PostLoginCoreModule(), preferencesModule, webApiClientModule});
        AutomaticAggregateManagerWrapper amWrapper = ((AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory)injector.getInstance(AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory.class)).create(logger, targetServer);
        AutomaticUserAndSliceApiWrapper credWrapper = ((AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory)injector.getInstance(AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory.class)).create(logger);
        if (useUserProxy && (userAuth = user.getUserAuthorityServer()) != null && userAuth.getTestbed() != null) {
            if (userAuth.getTestbed().getProxies().isEmpty()) {
                reportState.warn("This logged in user's authority does not have a proxy that jFed can use.");
            } else {
                Proxy authProxyInfo = (Proxy)userAuth.getTestbed().getProxies().get(0);
                VlanRange portRange = new VlanRange(authProxyInfo.getPortRange());
                Integer port = portRange.getFirst();
                GeniUserSshKeyInfo userSshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)user);
                JFedConnection.SshProxyInfo proxyInfo = new JFedConnection.SshProxyInfo(authProxyInfo.getHostname(), port.intValue(), authProxyInfo.transformUsername(user.getUserUrn().getEncodedResourceName()), (SshKeyInfo)userSshKeyInfo, authProxyInfo.getHostKey());
                reportState.info("Using proxy for SA and AM connections: " + (JFedConnection.ProxyInfo)proxyInfo);
                ((SfaConnectionPool)injector.getInstance(SfaConnectionPool.class)).setDefaultProxy((JFedConnection.ProxyInfo)proxyInfo);
            }
        }
        reportState.debug("Will call GetVersion on server with id=" + amWrapper.getAmServer().getId() + " name=" + amWrapper.getAmServer().getName() + " urn=" + amWrapper.getAmServer().getDefaultComponentManagerUrn() + " (allowedCertificateAlias=" + amWrapper.getAmServer().getAllowedCertificateAlias() + " knownCert=" + amWrapper.getAmServer().getCertificateChain() + ")");
        Map getVersionRes = amWrapper.getVersion();
        TypeAndVersion advRspecTypeAndVersion = ListResourcesWrapper.getBestSupportedAdvertismentVersion(getVersionRes, geni3);
        assert (advRspecTypeAndVersion != null);
        reportState.debug("  GetVersion geni_ad_rspec_versions parsing -> best matching advertisement RSpec type is: " + advRspecTypeAndVersion + ". It will be used in the ListResources call.");
        reportState.debug("Will get User Credential form user authority");
        try {
            cred = credWrapper.getUserCredentialsWithRetry(logger, user.getUserUrn());
            reportState.debug("  Got " + cred.size() + " credential(s) from user authority");
        }
        catch (JFedException e) {
            LOG.error("Error while fetching credential. Will CANCEL this result.", (Throwable)e);
            reportState.error("Error while fetching credential. Will CANCEL this result.", (Throwable)e);
            return new ListResourcesResult();
        }
        if (!AutomaticUserAndSliceApiWrapper.hasUsableCredentials((List)cred)) {
            LOG.info("The credentials received from the MA are not usable (missing or too early expire date). Will have to CANCEL this test.");
            reportState.debug("  The credentials received from the MA are not usable (missing or too early expire date). Will have to CANCEL this test.");
            return new ListResourcesResult();
        }
        reportState.debug("Will call ListResources on server with id=" + amWrapper.getAmServer().getId() + " name=" + amWrapper.getAmServer().getName() + " urn=" + amWrapper.getAmServer().getDefaultComponentManagerUrn() + " (allowedCertificateAlias=" + amWrapper.getAmServer().getAllowedCertificateAlias() + ")");
        String rspec = amWrapper.listResources(cred, available, advRspecTypeAndVersion.getType(), advRspecTypeAndVersion.getVersion());
        return new ListResourcesResult(rspec, advRspecTypeAndVersion);
    }

    private static Map<String, Integer> countMap(Integer available, Integer total) {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        if (available != null) {
            res.put("available", available);
        }
        if (total != null) {
            res.put("total", total);
        }
        return res;
    }

    @Nonnull
    private static TypeAndVersion getBestSupportedAdvertismentVersion(@Nullable Map getVersionReply, @Nonnull TypeAndVersion preferred) {
        LOG.debug("getBestSupportedAdvertismentVersion getVersionReply");
        TypeAndVersion fallback = preferred;
        if (getVersionReply == null) {
            LOG.debug("   RET getVersionReply == null");
            return fallback;
        }
        Object valueO = getVersionReply.get("value");
        if (valueO == null) {
            LOG.debug("   RET valueO == null   -> " + XmlRpcPrintUtil.xmlRpcObjectToString((Object)getVersionReply));
            return fallback;
        }
        if (!(valueO instanceof Hashtable)) {
            LOG.debug("   RET  ! (valueO instanceof Hashtable) -> " + XmlRpcPrintUtil.xmlRpcObjectToString((Object)getVersionReply));
            return fallback;
        }
        Hashtable valueHt = (Hashtable)valueO;
        Object adRspecVersions = valueHt.get("geni_ad_rspec_versions");
        if (adRspecVersions == null) {
            LOG.debug("   RET adRspecVersions == null   -> " + XmlRpcPrintUtil.xmlRpcObjectToString((Object)getVersionReply));
            return fallback;
        }
        if (!(adRspecVersions instanceof Vector)) {
            LOG.debug("   RET  ! (adRspecVersions instanceof Vector) -> " + XmlRpcPrintUtil.xmlRpcObjectToString((Object)getVersionReply));
            return fallback;
        }
        Vector adRspecVersionsV = (Vector)adRspecVersions;
        LOG.debug("    -> " + adRspecVersionsV.size() + " advertised");
        if (adRspecVersionsV.size() == 0) {
            return fallback;
        }
        TypeAndVersion valid = null;
        for (Object o : adRspecVersionsV) {
            if (o == null || !(o instanceof Hashtable)) continue;
            Hashtable e = (Hashtable)o;
            String type = "" + e.get("type");
            String namespace = "" + e.get("namespace");
            String version = "" + e.get("version");
            LOG.debug("     -> type=" + type + " version=" + version);
            if (e.get("type") != null && e.get("version") != null) {
                LOG.debug("     -> found valid");
                valid = new TypeAndVersion(type, version);
                if (!valid.equals(preferred)) continue;
                LOG.debug("     -> returning matched preferred");
                return preferred;
            }
            LOG.debug("     -> found invalid");
        }
        if (valid != null) {
            LOG.debug("   -> returning valid");
            return valid;
        }
        LOG.debug("   -> returning fallback");
        return fallback;
    }

    public static class ListResourcesResult {
        public final String rspec;
        public final TypeAndVersion version;
        public final boolean cancelled;

        public ListResourcesResult(String rspec, TypeAndVersion version) {
            this.rspec = rspec;
            this.version = version;
            this.cancelled = false;
        }

        public ListResourcesResult() {
            this.rspec = null;
            this.version = null;
            this.cancelled = true;
        }
    }

    public static class TypeAndVersion {
        private final String type;
        private final String version;

        public TypeAndVersion(String type, String version) {
            this.type = type;
            this.version = version;
        }

        public String getType() {
            return this.type;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "\"" + this.type + "\" \"" + this.version + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TypeAndVersion that = (TypeAndVersion)o;
            if (this.type != null ? !this.type.equalsIgnoreCase(that.type) : that.type != null) {
                return false;
            }
            return !(this.version != null ? !this.version.equalsIgnoreCase(that.version) : that.version != null);
        }

        public int hashCode() {
            int result = this.type != null ? this.type.toLowerCase().hashCode() : 0;
            result = 31 * result + (this.version != null ? this.version.toLowerCase().hashCode() : 0);
            return result;
        }
    }
}

