/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunnerFactory;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.LastResultFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.TestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.fedmon.webapi.service.logic.FedmonLogic;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplayAndSummarizeTestRunner
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ReplayAndSummarizeTestRunner.class);
    private final TestRunnerFactory testRunnerFactory;
    private Integer serverId;
    private String targetTestDefinitionId;
    private boolean needsReplay;

    public ReplayAndSummarizeTestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, TestRunnerFactory testRunnerFactory) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.testRunnerFactory = testRunnerFactory;
    }

    private void processConfig() {
        this.serverId = this.testInstance.getServerIdParameter();
        this.targetTestDefinitionId = this.testInstance.getStringParameterOrDefault("target_testdefinition_name", this.testDefinition);
        this.needsReplay = Objects.equals(this.testInstance.getBooleanParameterOrDefault("enable_replay", this.testDefinition), Boolean.TRUE);
        if (this.serverId == null) {
            throw new IllegalStateException("testinstance with invalid server: serverId==null");
        }
        if (this.targetTestDefinitionId == null || this.targetTestDefinitionId.trim().isEmpty()) {
            throw new IllegalStateException("testinstance with invalid target_testdefinition_name: " + this.targetTestDefinitionId);
        }
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger LOG, PrintWriter outputStream) throws InterruptedException {
        TestRunner.TestCallCreatedObjects testCallCreatedObjects;
        ResultBuilder res;
        TestInstance rerunTi;
        Integer rerunTiId;
        List lastResults;
        LOG.debug("Starting " + this.testInstance.getName() + " with id" + this.testInstance.getId() + " at " + new Date().getTime());
        this.processConfig();
        try {
            Server server = (Server)this.originsService.getFedmonWebApiClient().getById(Server.class, (Object)this.serverId).orElseThrow(() -> new IllegalStateException("testinstance with unknown server: " + this.serverId));
            LOG.debug("Target Test Instances must match server=" + this.serverId + " testdefinitionname=" + this.targetTestDefinitionId);
            assert (server.getTestbedId() != null);
            lastResults = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new LastResultFilter(new TestInstanceFilter(null, null, this.targetTestDefinitionId, null, null, null, server.getTestbedId(), null, Optional.of(false)), true, Optional.empty(), null));
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem reporting test results. Will cancel test", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reporting test results -> cancelling test");
            ResultBuilder res2 = this.initResult();
            res2.setSummary(Result.ResultStatus.CANCELLED);
            return new TestRunner.TestCallCreatedObjects(res2);
        }
        HashMap<Long, TestInstance> testInstanceByResultId = new HashMap<Long, TestInstance>();
        int helpDebugOutputCount = 0;
        for (Result r : lastResults) {
            Optional rti;
            try {
                rti = this.fedmonWebApiClient.get(TestInstance.class, (Object)r.getTestInstanceId());
                if (!rti.isPresent()) {
                    throw new RuntimeException("No TestInstance " + r.getTestInstanceId() + " for Result " + r.getId());
                }
                testInstanceByResultId.put((Long)r.getId(), (TestInstance)rti.get());
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem rreaching fedmon. Will cancel test", (Throwable)e);
                LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
                ResultBuilder res3 = this.initResult();
                res3.setSummary(Result.ResultStatus.CANCELLED);
                return new TestRunner.TestCallCreatedObjects(res3);
            }
            if (helpDebugOutputCount++ < 5) {
                LOG.debug("Got matching test result: " + r);
            }
            assert (((TestInstance)rti.get()).getServerIdParameter() != null);
            assert (((TestInstance)rti.get()).getServerIdParameter().equals(this.serverId));
        }
        LOG.debug("ReplayAndSummarizeTestCall - run at: " + new Date().getTime() + " results received: " + lastResults.size());
        if (this.testInstance == null || lastResults.isEmpty()) {
            throw new IllegalStateException("Something went wrong with ReplayAndSummarizeTestCall prerequisites. " + (lastResults == null) + " " + (this.testInstance == null) + " " + (Serializable)(lastResults != null ? Boolean.valueOf(lastResults.isEmpty()) : "X"));
        }
        ArrayList<Result> successResults = new ArrayList<Result>();
        ArrayList<Result> warningResults = new ArrayList<Result>();
        ArrayList<Result> failedResults = new ArrayList<Result>();
        block20: for (Result res4 : lastResults) {
            TestInstance rti = (TestInstance)testInstanceByResultId.get(res4.getId());
            assert (rti != null);
            if (rti.getTestDefinitionId() == null) {
                LOG.error("Received a test result without test definition name (cannot do anything with this): " + res4);
                continue;
            }
            if (rti.isEnabled() == Boolean.FALSE.booleanValue()) {
                LOG.error("Received a test result that is not enabled (will skip it): " + res4);
                continue;
            }
            switch (res4.getSummaryStatus()) {
                case SUCCESS: {
                    successResults.add(res4);
                    continue block20;
                }
                case WARNING: {
                    warningResults.add(res4);
                    continue block20;
                }
                case CANCELLED: {
                    LOG.warn("Got cancelled result: " + res4.getId() + "  (this should not occur)");
                    continue block20;
                }
            }
            failedResults.add(res4);
        }
        if (!successResults.isEmpty()) {
            rerunTiId = ((Result)successResults.get(0)).getTestInstanceId();
        } else if (!warningResults.isEmpty()) {
            rerunTiId = ((Result)warningResults.get(0)).getTestInstanceId();
        } else if (!failedResults.isEmpty()) {
            rerunTiId = ((Result)failedResults.get(0)).getTestInstanceId();
        } else {
            LOG.warn("There are no results, so nothing can be replayed!");
            rerunTiId = null;
        }
        try {
            rerunTi = rerunTiId == null ? null : (TestInstance)this.fedmonWebApiClient.getById(TestInstance.class, (Object)rerunTiId).orElseThrow(() -> new RuntimeException("Could not find testinstance \"" + rerunTiId + "\" to rerun"));
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem rreaching fedmon. Will cancel test", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
            ResultBuilder res5 = this.initResult();
            res5.setSummary(Result.ResultStatus.CANCELLED);
            return new TestRunner.TestCallCreatedObjects(res5);
        }
        if (this.needsReplay && (rerunTiId == null || rerunTi == null)) {
            LOG.warn("Need to rerun tests, but there is no test to rerun! rerunTiId=" + rerunTiId + " rerunTi=" + rerunTi);
            this.needsReplay = false;
        }
        if (this.needsReplay) {
            boolean noResult;
            ResultBuilder rerunRes;
            TestRunner.TestCallCreatedObjects rerunTestCallCreatedObjects;
            TestInstanceStatistics targetTestInstanceStatistics;
            Frequency targetFrequency;
            TestDefinition targetTestDefinition;
            assert (rerunTiId != null);
            assert (rerunTi != null);
            assert (rerunTi.getTestDefinitionId().equals(this.targetTestDefinitionId));
            LOG.info("Replaying test " + rerunTiId + " (\"" + rerunTi.getName() + "\")");
            String tdname = rerunTi.getTestDefinitionId();
            try {
                targetTestDefinition = (TestDefinition)this.fedmonWebApiClient.getById(TestDefinition.class, (Object)tdname).orElseThrow(() -> new RuntimeException("Could not find targetTestDefinition \"" + tdname + "\""));
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem rreaching fedmon. Will cancel test", (Throwable)e);
                LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
                res = this.initResult();
                res.setSummary(Result.ResultStatus.CANCELLED);
                return new TestRunner.TestCallCreatedObjects(res);
            }
            assert (((String)targetTestDefinition.getId()).equals(this.targetTestDefinitionId));
            assert (((String)targetTestDefinition.getId()).equals(rerunTi.getTestDefinitionId()));
            try {
                TestInstance finalRerunTi = rerunTi;
                targetFrequency = rerunTi.getFrequencyId() == null ? null : (Frequency)this.fedmonWebApiClient.get(Frequency.class, (Object)rerunTi.getFrequencyId()).orElseThrow(() -> new RuntimeException("Could not find Frequency " + finalRerunTi.getFrequencyId()));
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem rreaching fedmon. Will cancel test", (Throwable)e);
                LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
                res = this.initResult();
                res.setSummary(Result.ResultStatus.CANCELLED);
                return new TestRunner.TestCallCreatedObjects(res);
            }
            try {
                targetTestInstanceStatistics = (TestInstanceStatistics)this.fedmonWebApiClient.getTestInstanceStatisticsByTestInstanceId(rerunTiId).orElseThrow(() -> new RuntimeException("Could not find TargetTestInstanceStatistics " + rerunTiId));
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                ReplayAndSummarizeTestRunner.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will cancel test", (Throwable)e);
                LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
                res = this.initResult();
                res.setSummary(Result.ResultStatus.CANCELLED);
                return new TestRunner.TestCallCreatedObjects(res);
            }
            TestRunner automatedTesterTestRunner = this.testRunnerFactory.makeTest(this.task.create(), rerunTi, targetFrequency, targetTestInstanceStatistics, targetTestDefinition);
            long startTime = System.currentTimeMillis();
            try {
                rerunTestCallCreatedObjects = automatedTesterTestRunner.runTestCall(LOG, outputStream);
                rerunRes = rerunTestCallCreatedObjects.getResultBuilder();
                noResult = false;
            }
            catch (TestRunner.NoTestResult e) {
                noResult = true;
                rerunRes = null;
                rerunTestCallCreatedObjects = null;
            }
            long stopTime = System.currentTimeMillis();
            long durationMs = stopTime - startTime;
            if (!noResult) {
                rerunRes.setNestedSubResult((Object)startTime, new String[]{"timing", "startTimeMsSinceEpoch"});
                rerunRes.setNestedSubResult((Object)stopTime, new String[]{"timing", "stopTimeMsSinceEpoch"});
                rerunRes.setNestedSubResult((Object)durationMs, new String[]{"timing", "durationMs"});
                this.getResultUploader().addToQueue(rerunTestCallCreatedObjects);
            }
            res = FedmonLogic.initNewResultFromTask((Task)this.task.create(), (TestInstance)this.testInstance, (Frequency)this.testInstanceFrequency, (TestDefinition)this.testDefinition);
            testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(res);
            if (!noResult) {
                testCallCreatedObjects.setLogs(rerunTestCallCreatedObjects.getLogs());
                for (String key : rerunRes.create().getSubResultKeys()) {
                    res.addSubResult(key, rerunRes.getSubResult(key));
                }
                res.setSummary(rerunRes.getSummary());
            }
        } else {
            Result.ResultStatus summary;
            LOG.info("Will not rerun a test.");
            res = this.initResult();
            testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(res);
            if (!successResults.isEmpty()) {
                summary = Result.ResultStatus.SUCCESS;
            } else if (!warningResults.isEmpty()) {
                summary = Result.ResultStatus.WARNING;
            } else if (!failedResults.isEmpty()) {
                summary = Result.ResultStatus.FAILURE;
            } else {
                LOG.warn("There are not tests to summarize!");
                summary = Result.ResultStatus.WARNING;
            }
            res.setSummary(summary);
        }
        TreeMap<String, Integer> summaryMap = new TreeMap<String, Integer>();
        summaryMap.put("success", successResults.size());
        summaryMap.put("warning", warningResults.size());
        summaryMap.put("failure", failedResults.size());
        summaryMap.put("total", successResults.size() + warningResults.size() + failedResults.size());
        res.addSubResult("summaryCounts", summaryMap);
        return testCallCreatedObjects;
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }
}

