/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.impl;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.DsDef;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateStatusUptimeRrd
extends TestInstanceRrd {
    public static final String UPTIME_DS_NAME = "uptime";
    private static final Logger LOG = LoggerFactory.getLogger(AggregateStatusUptimeRrd.class);
    private Date hackUptime;

    public AggregateStatusUptimeRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, UPTIME_DS_NAME);
    }

    public AggregateStatusUptimeRrd(TestInstance testInstance, Frequency testInstanceFrequency, TestDefinition testDefinition, RrdConfig rrdConfig, File altFile) {
        super(testInstance, testInstanceFrequency, testDefinition, rrdConfig, UPTIME_DS_NAME, altFile);
    }

    @Override
    protected String getDsLine() {
        return this.getStringParam("rrd_uptime_ds");
    }

    @Override
    protected String getStepLine() {
        return this.getStringParam("rrd_uptime_step");
    }

    @Override
    protected String getRraLine() {
        return this.getStringParam("rrd_uptime_rra");
    }

    @Override
    public List<TestInstanceRrd.Val> getValues(@Nonnull Result result) {
        if (this.wasTestInPlannedMaintenance(result)) {
            return Collections.emptyList();
        }
        Object okTimeMsObj = result.getSubResult("okTimeMs");
        if (okTimeMsObj == null) {
            if (result.getSummaryStatus().equals((Object)Result.ResultStatus.SUCCESS)) {
                if (this.hackUptime == null) {
                    this.hackUptime = result.getCreated();
                }
                try {
                    Date lastFail;
                    String lastFailStr = result.getStringSubResult("lastFailDate");
                    if (lastFailStr == null) {
                        lastFail = this.hackUptime;
                        if (lastFail == null) {
                            return Collections.singletonList(new TestInstanceRrd.Val(Double.NaN));
                        }
                    } else {
                        lastFail = RFC3339Util.rfc3339StringToDate((String)lastFailStr);
                    }
                    Timestamp timeStamp = result.getCreated();
                    long okTimeMs = ((Date)timeStamp).getTime() - lastFail.getTime();
                    return Collections.singletonList(new TestInstanceRrd.Val(Double.valueOf(okTimeMs)));
                }
                catch (ParseException e) {
                    return Collections.singletonList(new TestInstanceRrd.Val(Double.NaN));
                }
            }
            this.hackUptime = null;
            return Collections.singletonList(new TestInstanceRrd.Val(0.0));
        }
        if (okTimeMsObj instanceof String) {
            return Collections.singletonList(new TestInstanceRrd.Val(Double.valueOf(Long.parseLong((String)okTimeMsObj))));
        }
        if (okTimeMsObj instanceof Number) {
            Number n = (Number)okTimeMsObj;
            return Collections.singletonList(new TestInstanceRrd.Val(n.doubleValue()));
        }
        LOG.error("Result contains unsupported type for \"okTimeMs\": " + okTimeMsObj.getClass().getName());
        return Collections.emptyList();
    }

    @Override
    public TestInstanceStatistics.RrdStatistics getTestStatistics() {
        return null;
    }

    @Override
    public TestInstanceStatistics.Summation getSummation() {
        return null;
    }

    @Override
    public List<TestInstanceRrd.GraphInfo> getGraphInfo() {
        long now = System.currentTimeMillis() / 1000L;
        ArrayList<TestInstanceRrd.GraphInfo> res = new ArrayList<TestInstanceRrd.GraphInfo>();
        LOG.debug("stored graph start=" + this.rrdDef.getStartTime());
        for (DsDef dsDef : this.rrdDef.getDsDefs()) {
            for (ArcDef arcDef : this.rrdDef.getArcDefs()) {
                long periodS = (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
                long graphStart = now - (long)(arcDef.getRows() * arcDef.getSteps()) * this.rrdDef.getStep();
                LOG.debug("graph start=" + graphStart + " stop=" + now + " diff=" + (now - graphStart));
                res.add(new TestInstanceRrd.GraphInfo(this.name, null, periodS, "Time without failure", this.testInstance, this.testDefinition, graphStart, now, this.rrdDef, dsDef, arcDef));
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public List<TestInstanceRrd.RawDataInfo> getRawDataInfo(String baseUri) {
        return Collections.emptyList();
    }

    @Override
    public File makeGraph(TestInstanceRrd.GraphInfo graphInfo) throws IOException {
        File tmpFile = File.createTempFile(graphInfo.getId(), ".png");
        RrdGraphDef gDef1 = new RrdGraphDef();
        gDef1.setWidth(500);
        gDef1.setHeight(300);
        gDef1.setFilename(tmpFile.getAbsolutePath());
        gDef1.setStartTime(graphInfo.getGraphStartTimeInSecondsSinceEpoch());
        gDef1.setEndTime(graphInfo.getGraphEndTimeInSecondsSinceEpoch());
        gDef1.setUnitsExponent(0);
        gDef1.setAltAutoscale(true);
        gDef1.setVerticalLabel("days");
        String dsNickName = "uptime_ms";
        gDef1.datasource(dsNickName, this.rrdFile.getAbsolutePath(), graphInfo.getDsDef().getDsName(), graphInfo.getArcDef().getConsolFun());
        gDef1.datasource("uptime_days", dsNickName + ",86400000.0,/");
        gDef1.area("uptime_days", (Paint)AggregateStatusUptimeRrd.colorByNr(0), graphInfo.getDsDef().getDsName());
        gDef1.setImageInfo("<img src='%s' width='%d' height='%d'>");
        gDef1.setImageFormat("png");
        LOG.debug("Rendering graph \"" + graphInfo.getId() + "\" to temp file \"" + tmpFile + "\"");
        RrdGraph graph1 = new RrdGraph(gDef1);
        LOG.debug("Rendered graph has size " + graph1.getRrdGraphInfo().getByteCount());
        return tmpFile;
    }
}

