/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.module;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.BasicTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.util.List;
import javax.inject.Singleton;

public class ManualTestbedInfoSourceModule
extends AbstractModule {
    private final List<Testbed> testbeds;
    private final TestbedInfoSource testbedInfoSource;

    public ManualTestbedInfoSourceModule(List<Testbed> testbeds) {
        this.testbeds = testbeds;
        this.testbedInfoSource = BasicTestbedInfoSource.createFromTestbeds(testbeds);
        assert (testbeds.size() <= this.testbedInfoSource.getTestbeds().size()) : "Testbeds are being ignored: " + testbeds.size() + " > " + this.testbedInfoSource.getTestbeds().size();
        assert (testbeds.size() <= this.testbedInfoSource.getServers().size()) : "Servers are being ignored: " + testbeds.size() + " > " + this.testbedInfoSource.getServers().size();
    }

    protected void configure() {
    }

    @Provides
    @Singleton
    private AuthorityFinder provideAuthorityFinder(TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        return new AuthorityFinder(testbedInfoSource, jFedPreferences);
    }

    @Provides
    @Singleton
    private TestbedInfoSource provideTestbedInfoSource() {
        return this.testbedInfoSource;
    }
}

