/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ImageMap<T> {
    private final URL imageUrl;
    private final Map<Bounds, T> selectableRegions = new HashMap<Bounds, T>();

    public ImageMap(URL imageUrl) {
        this.imageUrl = imageUrl;
    }

    public ImageMap(URL imageUrl, Map<Bounds, T> selectableRegions) {
        this.imageUrl = imageUrl;
        this.selectableRegions.putAll(selectableRegions);
    }

    public void addSelectableRegion(Bounds region, T item) {
        this.selectableRegions.put(region, item);
    }

    public URL getImageUrl() {
        return this.imageUrl;
    }

    public Optional<T> getItem(double x, double y) {
        for (Map.Entry<Bounds, T> entry : this.selectableRegions.entrySet()) {
            if (!entry.getKey().contains(x, y)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public Map<Bounds, T> getSelectableRegions() {
        return this.selectableRegions;
    }

    public Optional<Bounds> getSelectableRegion(T item) {
        return this.selectableRegions.entrySet().stream().filter(entry -> Objects.equals(entry.getValue(), item)).map(Map.Entry::getKey).findAny();
    }

    public static final class Bounds {
        private final double minX;
        private final double maxX;
        private final double minY;
        private final double maxY;

        public Bounds(double minX, double maxX, double minY, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public boolean contains(double x, double y) {
            return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getMinX() {
            return this.minX;
        }

        public double getMinY() {
            return this.minY;
        }

        public String toString() {
            return "[{" + this.minX + "," + this.minY + "},{" + this.maxX + "," + this.maxY + "}]";
        }
    }
}

