/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Resource;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResourceClass;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.generator.StitchingTestRSpecGenerator;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiConfigStitchingTestRSpecGenerator
implements StitchingTestRSpecGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(GuiConfigStitchingTestRSpecGenerator.class);
    @Nonnull
    private final JFedGuiConfig jFedGuiConfig;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nullable
    private List<Server> servers = null;
    @Nonnull
    private List<String> nodeNames = Collections.emptyList();
    @Nullable
    private List<String> resourceClasses = null;
    @Nonnull
    private String nodeNamePrefix = "n";

    public GuiConfigStitchingTestRSpecGenerator(@Nonnull JFedGuiConfig jFedGuiConfig, @Nonnull AuthorityFinder authorityFinder, @Nonnull TestbedInfoSource testbedInfoSource) {
        this.jFedGuiConfig = jFedGuiConfig;
        this.authorityFinder = authorityFinder;
        this.testbedInfoSource = testbedInfoSource;
    }

    public void setAms(@Nonnull List<String> ams) {
        assert (!ams.isEmpty());
        this.servers = new ArrayList<Server>();
        for (String am : ams) {
            Server server = null;
            if (am.startsWith("urn:")) {
                server = this.authorityFinder.findByAnyUrn(am, AuthorityFinder.Purpose.REQUEST_RSPEC);
            } else if (am.matches("[0-9]*")) {
                server = this.testbedInfoSource.getServerById(Integer.valueOf(Integer.parseInt(am)));
            } else {
                Testbed testbed = this.testbedInfoSource.getTestbedById(am);
                Server server2 = server = testbed.getDefaultServerId() == null ? null : this.testbedInfoSource.getServerById(testbed.getDefaultServerId());
            }
            if (server == null) {
                throw new RuntimeException("Did not find Server for AM \"" + am + "\" (Only URN, Testbed ID (=string) and Server ID (=int) are supported)");
            }
            this.servers.add(server);
        }
        assert (!this.servers.isEmpty());
        assert (this.servers.size() == ams.size());
    }

    public void setNodeNames(@Nonnull List<String> nodeNames) {
        this.nodeNames = nodeNames;
    }

    public void setResourceClasses(@Nullable List<String> resourceClasses) {
        this.resourceClasses = resourceClasses;
    }

    public void setNodePrefix(@Nullable String prefix) {
        this.nodeNamePrefix = prefix;
    }

    @Nonnull
    public String generateRequest() {
        boolean automaticResourceClass;
        if (this.servers == null || this.servers.isEmpty()) {
            throw new IllegalStateException("generateRequest requires setAMs(...) to set the servers");
        }
        RspecFactory factory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC);
        ModelRspec model = factory.createModelRspec("request");
        int nodeCount = this.servers.size();
        boolean bl = automaticResourceClass = this.resourceClasses == null || this.resourceClasses.isEmpty();
        if (!automaticResourceClass && nodeCount != this.resourceClasses.size()) {
            throw new IllegalStateException("generateRequest requires setResourceClasses(...) to be null or have same size as setAMs(...)  (" + this.resourceClasses.size() + " != " + nodeCount + ")");
        }
        for (int i = 0; i < nodeCount; ++i) {
            Server server = this.servers.get(i);
            ResourceClass chosenResourceClass = null;
            if (automaticResourceClass) {
                List<ResourceClass> resourceClassList = this.jFedGuiConfig.findAllPossibleResourceClasses(server);
                for (ResourceClass resourceClass : resourceClassList) {
                    if (chosenResourceClass != null && resourceClass.getWeightOrZero() <= chosenResourceClass.getWeightOrZero()) continue;
                    chosenResourceClass = resourceClass;
                }
                if (chosenResourceClass == null) {
                    throw new RuntimeException("There is no resourceClass for server " + server.getId() + " that can be used.");
                }
                LOG.debug("Chose ResourceClass " + (String)chosenResourceClass.getId() + " from server ResourceClasses: " + resourceClassList.stream().map(PrimaryIdObject::getId).collect(Collectors.joining(", ")));
            } else {
                chosenResourceClass = this.jFedGuiConfig.getResourceClass(this.resourceClasses.get(i));
                if (chosenResourceClass == null) {
                    throw new RuntimeException("There is no resourceClass that matches requested \"" + this.resourceClasses.get(i) + "\".");
                }
                LOG.debug("Used user specified ResourceClass \"" + (String)chosenResourceClass.getId() + "\".");
            }
            if (((String)chosenResourceClass.getId()).equals("other-servers")) {
                throw new RuntimeException("There is no resource for server " + server.getId() + " (\"" + server.getName() + "\"), cannot generate RSpec.");
            }
            Resource chosenResource = null;
            for (Resource aResource : chosenResourceClass.getResources()) {
                if (aResource.getServerId() == null || !aResource.getServerId().equals(server.getId())) continue;
                LOG.debug("Found Resource for server: " + chosenResource);
                chosenResource = aResource;
            }
            if (chosenResource == null) {
                throw new RuntimeException("No Resource found for server " + server.getId());
            }
            LOG.debug("Chose Resource: " + chosenResource);
            if (chosenResource.getRspecElementName() != null && !chosenResource.getRspecElementName().equalsIgnoreCase("node")) {
                throw new RuntimeException("Resource for server " + server.getId() + " found, but has unsupported RSpec element name: \"" + chosenResource.getRspecElementName() + "\"");
            }
            RspecNode node = factory.createNode(model);
            node.setComponentManagerId(server.getDefaultComponentManagerUrn());
            node.setExclusive(chosenResource.getDefaultExclusive());
            if (i < this.nodeNames.size()) {
                node.setClientId(this.nodeNames.get(i));
            } else {
                node.setClientId(this.nodeNamePrefix + i);
            }
            node.setSliverTypeName(chosenResource.getSliverType());
            if (chosenResource.getHardwareType() != null) {
                node.getHardwareTypes().add(new HardwareType(chosenResource.getHardwareType()));
            }
            if (chosenResource.getDiskImage() != null) {
                node.setSliverTypeDiskImage(chosenResource.getDiskImage());
            }
            model.addNode(node);
        }
        int j = 0;
        ArrayList otherNodes = new ArrayList(model.getNodes());
        for (RspecNode node : model.getNodes()) {
            assert (node.getClientId() != null);
            boolean removed = otherNodes.remove(node);
            assert (removed);
            for (RspecNode otherNode : otherNodes) {
                assert (otherNode.getClientId() != null);
                assert (node != otherNode);
                assert (!node.getClientId().equals(otherNode.getClientId()));
                RspecLink link = factory.createLinkWithClientId(model, "link" + j, null);
                model.addLink(link);
                RspecInterface iface = factory.createInterface(node, link, node.getClientId() + ":if" + node.getInterfaces().size());
                iface.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (j + 2) + ".1", "255.255.255.0", "ipv4"));
                RspecInterface otherIface = factory.createInterface(otherNode, link, otherNode.getClientId() + ":if" + otherNode.getInterfaces().size());
                otherIface.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (j + 2) + ".2", "255.255.255.0", "ipv4"));
                link.getLinkSetting(iface, otherIface).setCapacity_Kbps(Long.valueOf(10000L));
                link.getLinkSetting(otherIface, iface).setCapacity_Kbps(Long.valueOf(10000L));
                ++j;
            }
        }
        return model.toGeni3Rspec();
    }
}

