/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.config.util;

import be.iminds.ilabt.jfed.experimenter_gui.config.ImageMap;
import be.iminds.ilabt.jfed.experimenter_gui.config.util.TestbedNodesMapParseException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestbedNodesMapParser
implements Callable<ImageMap<GeniUrn>> {
    private static final Logger LOG = LoggerFactory.getLogger(TestbedNodesMapParser.class);
    private static final String NAMESPACE_TESTBED_NODES_MAP = "http://jfed.iminds.be/testbeds_nodes_map";
    private static final QName Q_TESTBED_NODES_MAP = new QName("http://jfed.iminds.be/testbeds_nodes_map", "testbed_nodes_map");
    private static final QName Q_TESTBED_NODE = new QName("http://jfed.iminds.be/testbeds_nodes_map", "testbed_node");
    private static final QName Q_BOUNDS = new QName("http://jfed.iminds.be/testbeds_nodes_map", "bounds");
    private static final QName Q_ATT_CM_ID = new QName("component_manager_id");
    private static final QName Q_ATT_C_ID = new QName("component_id");
    private static final QName Q_ATT_MAP_URL = new QName("map_url");
    private static final QName Q_ATT_MIN_X = new QName("minX");
    private static final QName Q_ATT_MAX_X = new QName("maxX");
    private static final QName Q_ATT_MIN_Y = new QName("minY");
    private static final QName Q_ATT_MAX_Y = new QName("maxY");
    private final URL testbedNodesMapUrl;
    private final String imageUrlPrefix;

    public TestbedNodesMapParser(URL testbedNodesMapUrl) {
        this.testbedNodesMapUrl = testbedNodesMapUrl;
        String url = testbedNodesMapUrl.toExternalForm();
        this.imageUrlPrefix = url.substring(0, url.lastIndexOf(47) + 1);
    }

    @Override
    public ImageMap<GeniUrn> call() throws TestbedNodesMapParseException {
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(this.testbedNodesMapUrl.openStream());
            XMLEventReader eventReader = xif.createXMLEventReader(xml);
            XMLEvent e = eventReader.nextEvent();
            assert (e.isStartDocument());
            ImageMap<GeniUrn> res = null;
            while (eventReader.hasNext()) {
                e = eventReader.nextEvent();
                if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), Q_TESTBED_NODES_MAP)) {
                    res = this.readTestbedNodesMap(e, eventReader);
                }
                if (!e.isEndDocument()) continue;
                return res;
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new TestbedNodesMapParseException("Error while parsing testbed nodes maps", e);
        }
        throw new TestbedNodesMapParseException("Could not find end of document");
    }

    private ImageMap<GeniUrn> readTestbedNodesMap(XMLEvent e, XMLEventReader eventReader) throws XMLStreamException, TestbedNodesMapParseException {
        URL mapUrl;
        StartElement startElement = e.asStartElement();
        if (startElement.getAttributeByName(Q_ATT_CM_ID) == null) {
            throw new TestbedNodesMapParseException("Expected a component_manager_id");
        }
        String cmId = startElement.getAttributeByName(Q_ATT_CM_ID).getValue();
        if (startElement.getAttributeByName(Q_ATT_MAP_URL) != null) {
            try {
                mapUrl = new URL(this.imageUrlPrefix + startElement.getAttributeByName(Q_ATT_MAP_URL).getValue());
            }
            catch (MalformedURLException e1) {
                throw new TestbedNodesMapParseException("Could not parse the mapURL into a valid URL", e1);
            }
        } else {
            throw new TestbedNodesMapParseException("Expected a map_url");
        }
        ImageMap<GeniUrn> res = new ImageMap<GeniUrn>(mapUrl);
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), Q_TESTBED_NODE)) {
                this.readTestbedNode(res, e, eventReader);
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), Q_TESTBED_NODES_MAP)) continue;
            return res;
        }
        throw new TestbedNodesMapParseException("Could not find end element for testbed_nodes_maps");
    }

    private void readTestbedNode(ImageMap<GeniUrn> imageMap, XMLEvent e, XMLEventReader eventReader) throws TestbedNodesMapParseException, XMLStreamException {
        GeniUrn cId;
        StartElement startElement = e.asStartElement();
        if (startElement.getAttributeByName(Q_ATT_C_ID) != null) {
            try {
                cId = new GeniUrn(startElement.getAttributeByName(Q_ATT_C_ID).getValue());
            }
            catch (GeniUrn.GeniUrnParseException e1) {
                throw new TestbedNodesMapParseException("Expected a valid GeniUrn as component_id", e1);
            }
        } else {
            throw new TestbedNodesMapParseException("Expected a component_id");
        }
        ImageMap.Bounds bounds = null;
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement() && Objects.equals(e.asStartElement().getName(), Q_BOUNDS)) {
                bounds = this.readBounds(e, eventReader);
            }
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), Q_TESTBED_NODE)) continue;
            imageMap.addSelectableRegion(bounds, cId);
            return;
        }
        throw new TestbedNodesMapParseException("Could not find end element for testbed_node");
    }

    private ImageMap.Bounds readBounds(XMLEvent e, XMLEventReader eventReader) throws TestbedNodesMapParseException, XMLStreamException {
        double maxY;
        StartElement startElement = e.asStartElement();
        if (startElement.getAttributeByName(Q_ATT_MIN_X) == null) {
            throw new TestbedNodesMapParseException("Expected a minX attribute");
        }
        double minX = Double.parseDouble(startElement.getAttributeByName(Q_ATT_MIN_X).getValue());
        if (startElement.getAttributeByName(Q_ATT_MIN_Y) == null) {
            throw new TestbedNodesMapParseException("Expected a minY attribute");
        }
        double minY = Double.parseDouble(startElement.getAttributeByName(Q_ATT_MIN_Y).getValue());
        if (startElement.getAttributeByName(Q_ATT_MAX_X) == null) {
            throw new TestbedNodesMapParseException("Expected a maxX attribute");
        }
        double maxX = Double.parseDouble(startElement.getAttributeByName(Q_ATT_MAX_X).getValue());
        if (startElement.getAttributeByName(Q_ATT_MAX_Y) != null) {
            maxY = Double.parseDouble(startElement.getAttributeByName(Q_ATT_MAX_Y).getValue());
        } else {
            throw new TestbedNodesMapParseException("Expected a maxY attribute");
        }
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName(), Q_BOUNDS)) continue;
            return new ImageMap.Bounds(minX, maxX, minY, maxY);
        }
        throw new TestbedNodesMapParseException("Could not find end element for bounds");
    }
}

