/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ExperimentInfoOutputSpec {
    @Nonnull
    private final ExperimentInfoOutputType type;
    @Nonnull
    private final ExperimentInfoOutputDestination destination;
    @Nullable
    private final String destinationDetail;

    public ExperimentInfoOutputSpec(@Nonnull ExperimentInfoOutputType type, @Nonnull ExperimentInfoOutputDestination destination, @Nullable String destinationDetail) {
        this.type = type;
        this.destination = destination;
        this.destinationDetail = destinationDetail;
        if (destination == ExperimentInfoOutputDestination.LOCAL_FILE && (destinationDetail == null || destinationDetail.trim().isEmpty())) {
            throw new IllegalArgumentException("destination==LOCAL_FILE required non empty destinationDetail");
        }
    }

    public boolean isRequiringAnsibleKey() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ExperimentInfoOutputType.ANSIBLE_ZIP, ExperimentInfoOutputType.ANSIBLE_PUBLIC_KEY, ExperimentInfoOutputType.ANSIBLE_PRIVATE_KEY, ExperimentInfoOutputType.ANSIBLE_FILES, ExperimentInfoOutputType.ANSIBLE_INVENTORY -> true;
            case ExperimentInfoOutputType.MANIFEST_RSPEC, ExperimentInfoOutputType.REQUEST_RSPEC, ExperimentInfoOutputType.SSH_LOGIN_LIST, ExperimentInfoOutputType.SSH_HOST_LIST, ExperimentInfoOutputType.SSH_INFO_CSV, ExperimentInfoOutputType.SSH_INFO_JSON, ExperimentInfoOutputType.CLIENT_ID_LIST -> false;
        };
    }

    @Nonnull
    public ExperimentInfoOutputType getType() {
        return this.type;
    }

    @Nonnull
    public ExperimentInfoOutputDestination getDestination() {
        return this.destination;
    }

    @Nullable
    public String getDestinationDetail() {
        return this.destinationDetail;
    }

    public static enum ExperimentInfoOutputType {
        ANSIBLE_ZIP,
        ANSIBLE_FILES,
        ANSIBLE_INVENTORY,
        ANSIBLE_PRIVATE_KEY,
        ANSIBLE_PUBLIC_KEY,
        MANIFEST_RSPEC,
        REQUEST_RSPEC,
        SSH_HOST_LIST,
        SSH_LOGIN_LIST,
        SSH_INFO_CSV,
        SSH_INFO_JSON,
        CLIENT_ID_LIST;

    }

    public static enum ExperimentInfoOutputDestination {
        LOCAL_FILE,
        LOG_DEBUG,
        LOG_INFO;

    }
}

