/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import java.util.Objects;
import javax.annotation.Nonnull;

public class FileSource {
    @Nonnull
    protected final SourceType type;
    @Nonnull
    protected final String value;
    @Nonnull
    protected final String basename;

    public FileSource(@Nonnull SourceType type, @Nonnull String value, @Nonnull String basename) {
        this.type = type;
        this.value = value;
        this.basename = basename;
    }

    @Nonnull
    public SourceType getType() {
        return this.type;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    @Nonnull
    public String getBasename() {
        return this.basename;
    }

    public boolean isGeneratedKeyPair() {
        return this.type == SourceType.GENERATED && this.value.trim().toLowerCase().startsWith("keypair");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSource that = (FileSource)o;
        return this.type == that.type && Objects.equals(this.value, that.value) && Objects.equals(this.basename, that.basename);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value, this.basename});
    }

    public String toString() {
        return "FileSource(" + this.type + " \"" + this.value + "\" (\"" + this.basename + "\"))";
    }

    public static enum SourceType {
        BUNDLED,
        DIRECT,
        GITHUB,
        GIT,
        DOWNLOAD,
        GENERATED,
        META;

    }
}

