/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.FileSource;
import java.util.Objects;
import javax.annotation.Nonnull;

public class GeneratedRandomFileSource
extends FileSource {
    @Nonnull
    private final String format;
    private final int length;
    @Nonnull
    private final String locationId;

    public GeneratedRandomFileSource(@Nonnull FileSource.SourceType sourceType, @Nonnull String value, @Nonnull String basename, @Nonnull String format, int length, @Nonnull String locationId) {
        super(sourceType, value, basename);
        String formatMatch;
        this.format = format;
        this.length = length;
        this.locationId = locationId;
        switch (formatMatch = format.trim().toLowerCase()) {
            case "binary": 
            case "base64": 
            case "password": 
            case "alphanum": {
                break;
            }
            default: {
                throw new IllegalArgumentException("generated:random does not have a format \"" + format + "\"");
            }
        }
    }

    @Nonnull
    public String getFormat() {
        return this.format;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeneratedRandomFileSource that = (GeneratedRandomFileSource)o;
        return this.length == that.length && this.format.equals(that.format) && this.locationId.equals(that.locationId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.format, this.locationId, this.length);
    }

    @Override
    public String toString() {
        return "GeneratedRandomFileSource{type=" + this.type + ", value='" + this.value + "', basename='" + this.basename + "', format='" + this.format + "', length=" + this.length + "}";
    }
}

