/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.espec.model;

import be.iminds.ilabt.jfed.espec.model.FileSource;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GitFileSource
extends FileSource {
    @Nonnull
    private final String gitUrl;
    @Nullable
    private final String repoSubDir;
    @Nullable
    private final String branch;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String privateKeyPem;
    @Nullable
    private final String filename;

    public GitFileSource(@Nonnull String gitUrl, @Nullable String repoSubDir, @Nullable String branch, @Nullable String username, @Nullable String password, @Nullable String privateKeyPem, @Nullable String filename) {
        super(FileSource.SourceType.GIT, gitUrl, filename == null ? "git-repo" : filename);
        this.gitUrl = gitUrl;
        this.repoSubDir = repoSubDir;
        this.branch = branch;
        this.username = username;
        this.password = password;
        this.privateKeyPem = privateKeyPem;
        this.filename = filename;
    }

    @Nonnull
    public String getGitUrl() {
        return this.gitUrl;
    }

    @Nullable
    public String getRepoSubDir() {
        return this.repoSubDir;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Nullable
    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    @Nullable
    public String getFilename() {
        return this.filename;
    }

    public boolean isFile() {
        return this.filename != null;
    }

    public boolean isDir() {
        return this.filename == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitFileSource that = (GitFileSource)o;
        return Objects.equals(this.gitUrl, that.gitUrl) && Objects.equals(this.repoSubDir, that.repoSubDir) && Objects.equals(this.branch, that.branch) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.privateKeyPem, that.privateKeyPem) && Objects.equals(this.filename, that.filename);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.gitUrl, this.repoSubDir, this.branch, this.username, this.password, this.privateKeyPem, this.filename);
    }

    @Override
    public String toString() {
        return "GitFileSource{gitUrl='" + this.gitUrl + "'" + (String)(this.repoSubDir == null ? "" : ", repoSubDir='" + this.repoSubDir + "'") + (String)(this.branch == null ? "" : ", branch='" + this.branch + "'") + (String)(this.username == null ? "" : "username='" + this.username + "'") + (String)(this.password == null ? "" : ", password='" + this.password + "'") + (String)(this.privateKeyPem == null ? "" : ", privateKeyPem='" + this.privateKeyPem + "'") + (String)(this.filename == null ? "" : ", filename='" + this.filename + "'") + ", basename='" + this.basename + "'}";
    }
}

