/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ScanResult;
import io.github.classgraph.TypeSignature;
import io.github.classgraph.utils.TypeUtils;

public class MethodParameterInfo {
    final AnnotationInfo[] annotationInfo;
    private final int modifiers;
    private final TypeSignature typeDescriptor;
    private final TypeSignature typeSignature;
    private final String name;
    private ScanResult scanResult;

    MethodParameterInfo(AnnotationInfo[] annotationInfo, int modifiers, TypeSignature typeDescriptor, TypeSignature typeSignature, String name) {
        this.name = name;
        this.modifiers = modifiers;
        this.typeDescriptor = typeDescriptor;
        this.typeSignature = typeSignature;
        this.annotationInfo = annotationInfo;
    }

    public String getName() {
        return this.name;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getModifiersStr() {
        return TypeUtils.modifiersToString(this.getModifiers(), true);
    }

    public TypeSignature getTypeSignature() {
        return this.typeSignature;
    }

    public TypeSignature getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public TypeSignature getTypeSignatureOrTypeDescriptor() {
        return this.typeSignature != null ? this.typeSignature : this.typeDescriptor;
    }

    public AnnotationInfo[] getAnnotationInfo() {
        if (!this.scanResult.scanSpec.enableAnnotationInfo) {
            throw new IllegalArgumentException("Please call ClassGraph#enableAnnotationInfo() before #scan()");
        }
        return this.annotationInfo;
    }

    protected void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
        if (this.annotationInfo != null) {
            for (AnnotationInfo ai : this.annotationInfo) {
                ai.setScanResult(scanResult);
            }
        }
        if (this.typeDescriptor != null) {
            this.typeDescriptor.setScanResult(scanResult);
        }
        if (this.typeSignature != null) {
            this.typeSignature.setScanResult(scanResult);
        }
    }

    public String toString() {
        int flag;
        StringBuilder buf = new StringBuilder();
        AnnotationInfo[] annInfo = this.getAnnotationInfo();
        if (annInfo != null) {
            for (int j = 0; j < annInfo.length; ++j) {
                annInfo[j].toString(buf);
                buf.append(' ');
            }
        }
        if (((flag = this.getModifiers()) & 0x10) != 0) {
            buf.append("final ");
        }
        if ((flag & 0x1000) != 0) {
            buf.append("synthetic ");
        }
        if ((flag & 0x8000) != 0) {
            buf.append("mandated ");
        }
        buf.append(this.getTypeSignatureOrTypeDescriptor().toString());
        buf.append(' ');
        buf.append(this.name == null ? "_unnamed_param" : this.name);
        return buf.toString();
    }
}

