/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.classloaderhandler;

import io.github.classgraph.ClassLoaderHandler;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrder;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.ReflectionUtils;
import java.io.File;
import java.util.List;

public class WebsphereLibertyClassLoaderHandler
implements ClassLoaderHandler {
    private static final String PKG_PREFIX = "com.ibm.ws.classloading.internal.";
    private static final String IBM_APP_CLASS_LOADER = "com.ibm.ws.classloading.internal.AppClassLoader";
    private static final String IBM_THREAD_CONTEXT_CLASS_LOADER = "com.ibm.ws.classloading.internal.ThreadContextClassLoader";

    @Override
    public String[] handledClassLoaders() {
        return new String[]{IBM_APP_CLASS_LOADER, IBM_THREAD_CONTEXT_CLASS_LOADER};
    }

    @Override
    public ClassLoader getEmbeddedClassLoader(ClassLoader outerClassLoaderInstance) {
        return null;
    }

    @Override
    public ClassLoaderHandler.DelegationOrder getDelegationOrder(ClassLoader classLoaderInstance) {
        return ClassLoaderHandler.DelegationOrder.PARENT_FIRST;
    }

    @Override
    public void handle(ScanSpec scanSpec, ClassLoader classLoader, ClasspathOrder classpathOrderOut, LogNode log) {
        List classPathElements;
        Object smartClassPath = null;
        Object appLoader = ReflectionUtils.getFieldVal(classLoader, "appLoader", false);
        smartClassPath = appLoader != null ? ReflectionUtils.getFieldVal(appLoader, "smartClassPath", false) : ReflectionUtils.getFieldVal(classLoader, "smartClassPath", false);
        if (smartClassPath != null && (classPathElements = (List)ReflectionUtils.getFieldVal(smartClassPath, "classPath", false)) != null) {
            for (Object classpath : classPathElements) {
                String path = this.getPath(classpath);
                if (path == null || path.length() <= 0) continue;
                classpathOrderOut.addClasspathElement(path, classLoader, log);
            }
        }
    }

    private String getPath(Object classpath) {
        Object container = ReflectionUtils.getFieldVal(classpath, "container", false);
        if (container == null) {
            return "";
        }
        Object delegate = ReflectionUtils.getFieldVal(container, "delegate", false);
        if (delegate == null) {
            return "";
        }
        String path = (String)ReflectionUtils.getFieldVal(delegate, "path", false);
        if (path != null && path.length() > 0) {
            return path;
        }
        Object base = ReflectionUtils.getFieldVal(delegate, "base", false);
        if (base == null) {
            return "";
        }
        Object archiveFile = ReflectionUtils.getFieldVal(base, "archiveFile", false);
        if (archiveFile != null) {
            File file = (File)archiveFile;
            return file.getAbsolutePath();
        }
        return "";
    }
}

