/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.util.TiParamExpander;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.lib.CorePreferencesModule;
import be.iminds.ilabt.jfed.lib.KeyCertFileUserModule;
import be.iminds.ilabt.jfed.lib.PostLoginCoreModule;
import be.iminds.ilabt.jfed.lib.PreLoginCoreModule;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.module.BasicTestbedInfoModule;
import be.iminds.ilabt.jfed.module.JFedWebApiClientModule;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestFactory;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestModule;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestRunner;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import be.iminds.ilabt.jfed.ui.commandline.ContextFile;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTester2TestRunner
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTester2TestRunner.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;

    public AutomatedTester2TestRunner(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.automatedTestExternalExecutableLocations = automatedTestExternalExecutableLocations;
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }

    @Nonnull
    protected ResultBuilder initResult(ApiTestResult result, AutomatedTesterListener automatedTesterListener) {
        String fixedNode;
        ResultBuilder res = this.initResult();
        res.addSubResult("steps", automatedTesterListener.getMethodStates());
        automatedTesterListener.addSummary(res);
        if (res.getSummaryStatus() == null) {
            LOG.error("BUG: automatedTesterListener.addSummary did not set a status");
            res.setSummary(Result.ResultStatus.FAILURE);
        }
        if ((fixedNode = this.testInstance.getStringParameter("fixed_node_urn")) != null) {
            res.addSubResult("fixed_node_urn", (Object)fixedNode);
            GeniUrn fixedNodeUrn = GeniUrn.parse((String)fixedNode);
            if (fixedNodeUrn != null) {
                res.addSubResult("fixed_node_name", (Object)fixedNodeUrn.getResourceName());
            }
        }
        return res;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger LOG, PrintWriter outputStream) {
        ApiTest test;
        String configJsonString;
        GeniUser user;
        TargetAuthority targetAuthority;
        Class<?> testClass;
        LOG.info("Starting " + this.testInstance.getName() + " with id " + this.testInstance.getId() + " at " + new Date().getTime() + "\n");
        LOG.debug("Starting " + this.testInstance.getName() + " with id " + this.testInstance.getId() + " at " + new Date().getTime() + "\n");
        String testUserPem = AutomatedTester2TestRunner.getTestUserPem(this.originsService.getFedmonWebApiClient(), this.testInstance);
        KeyCertFileUserModule userModule = new KeyCertFileUserModule(testUserPem, null, null, null);
        boolean isFailure = false;
        String testClassName = this.testInstance.getStringParameterOrDefault("test_class", this.testDefinition);
        String testGroup = this.testInstance.getStringParameterOrDefault("test_group", this.testDefinition);
        if (testClassName == null || testClassName.trim().isEmpty()) {
            throw new RuntimeException("no test_class specified");
        }
        try {
            testClass = Class.forName(testClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Test init failed: class \"" + testClassName + "\" not found", e);
        }
        ApiTestMetaData apiTestMetaData = ApiTest.getMetaData(testClass);
        Object automatedTesterConfigObj = this.testInstance.getParameterOrDefault("automated_tester_config", this.testDefinition);
        if (automatedTesterConfigObj == null) {
            throw new RuntimeException("No configuration specified in automated_tester_config (must at least be empty object)");
        }
        if (!(automatedTesterConfigObj instanceof Map)) {
            throw new RuntimeException("Non Map configuration specified in automated_tester_config (must be json object)");
        }
        Map automatedTesterConfigMap = (Map)automatedTesterConfigObj;
        automatedTesterConfigMap = TiParamExpander.expandTiParameters((Map)automatedTesterConfigMap, (TestInstance)this.testInstance);
        ApiTestConfig automatedTesterConfig = (ApiTestConfig)MAPPER.convertValue((Object)automatedTesterConfigMap, apiTestMetaData.getConfigClass());
        boolean showCredentials = false;
        BasicTestbedInfoModule authoritiesModule = new BasicTestbedInfoModule();
        String webapiReadBase = this.originsService.getConfig().getProperty("webapi_client_url_read_base");
        LOG.debug("Will make Automated tester read Testbed and Server info from \"" + webapiReadBase + "\"");
        CorePreferencesModule preferencesModule = new CorePreferencesModule(webapiReadBase);
        Integer serverId = this.testInstance.getServerIdParameter();
        if (serverId == null && this.testInstance.getStringParameter("stitchedAuthorities") != null) {
            serverId = 386;
        }
        TestTargetFromServerModule testTargetFromServerModule = new TestTargetFromServerModule(serverId);
        AutomatedTestModule automatedTestModule = new AutomatedTestModule(this.automatedTestExternalExecutableLocations);
        try {
            this.automatedTestExternalExecutableLocations.requireExe("ansible-playbook");
            this.automatedTestExternalExecutableLocations.requireExe("fping");
        }
        catch (AutomatedTestExternalExecutableLocations.ExecutableNotFoundException e) {
            throw new RuntimeException("exes should already have been configured");
        }
        Injector injector = AutomatedTester2TestRunner.createInjector(LOG, (Module)userModule, (Module)preferencesModule, (Module)authoritiesModule, (Module)testTargetFromServerModule, new Module[]{automatedTestModule});
        assert (injector != null);
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        LOG.debug("Got info on " + testbedInfoSource.getServers().size() + " servers.");
        be.iminds.ilabt.jfed.log.Logger callLogger = (be.iminds.ilabt.jfed.log.Logger)injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        if (testGroup == null || testGroup.equals("null") || testGroup.trim().isEmpty()) {
            testGroup = null;
        }
        if ((targetAuthority = (TargetAuthority)injector.getInstance(TargetAuthority.class)) != null) {
            assert (targetAuthority != null);
            Server testedServerToConnect = targetAuthority.getServerToConnect();
            Server testedServerForRspec = targetAuthority.getServerForRspecComponentManager();
            assert (testedServerToConnect != null);
            assert (testedServerForRspec != null);
            LOG.debug("   Tested Server:" + testedServerToConnect.getName());
            LOG.debug("      URN (connect):" + testedServerToConnect.getDefaultComponentManagerUrn());
            LOG.debug("      URN (rspec):" + testedServerForRspec.getDefaultComponentManagerUrn());
            LOG.debug("      Hrn:" + testedServerToConnect.getName());
            LOG.debug("      Server certificates:" + testedServerToConnect.getCertificateChain());
            LOG.debug("      Allowed server certificate hostname alias:" + testedServerToConnect.getAllowedCertificateAlias());
        }
        if ((user = (GeniUser)injector.getInstance(GeniUser.class)) == null) {
            throw new RuntimeException("User PEM specified, but user is null");
        }
        if (!AutomatedTester2TestRunner.checkUser(user, LOG)) {
            throw new RuntimeException("Test user failed validity check");
        }
        LOG.debug("   User:" + user.getUserUrnString());
        LOG.debug("      Authority URN:" + (user.getUserAuthorityServer() == null ? "*null AUTH*" : user.getUserAuthorityServer().getDefaultComponentManagerUrn()));
        try {
            LOG.debug("  \"automated_tester_config\" content: \n" + MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)automatedTesterConfigMap) + "\n");
        }
        catch (JsonProcessingException e) {
            LOG.warn("Failed to convert \"automated_tester_config\" to String for debugging");
        }
        try {
            configJsonString = MAPPER.writeValueAsString((Object)automatedTesterConfigMap);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not convert", e);
        }
        AutomatedTestRunner automatedTestRunner = (AutomatedTestRunner)injector.getInstance(AutomatedTestRunner.class);
        ApiTestFactory testFactory = (ApiTestFactory)injector.getInstance(ApiTestFactory.class);
        try {
            test = testFactory.createApiTest(callLogger, targetAuthority, testClass, configJsonString);
        }
        catch (ApiTestFactory.InvalidApiTestException e) {
            LOG.error("InvalidApiTestException", (Throwable)e);
            throw new RuntimeException("Failed to create test", e);
        }
        assert (test != null);
        String successMethod = this.testInstance.getStringParameterOrDefault("method_required_for_success", this.testDefinition);
        String warningMethod = this.testInstance.getStringParameterOrDefault("method_required_for_warning", this.testDefinition);
        String prerequisiteMethodsProp = this.testInstance.getStringParameterOrDefault("prerequisite_methods", this.testDefinition);
        List<String> successMethodNames = AutomatedTester2TestRunner.extractMethodNames(successMethod, true);
        List<String> warningMethodNames = AutomatedTester2TestRunner.extractMethodNames(warningMethod, true);
        List<String> prerequisiteMethodNames = AutomatedTester2TestRunner.extractMethodNames(prerequisiteMethodsProp, true);
        String notEnoughFreeResourcesDetectionString = this.testInstance.getStringParameterOrDefault("not_enough_free_resources_detection_string", this.testDefinition);
        String notEnoughFreeResourcesDetectionMethod = this.testInstance.getStringParameterOrDefault("not_enough_free_resources_detection_method", this.testDefinition);
        AutomatedTesterListener automatedTesterListener = new AutomatedTesterListener(successMethodNames, warningMethodNames, prerequisiteMethodNames, notEnoughFreeResourcesDetectionString, notEnoughFreeResourcesDetectionMethod);
        ApiTestResult result = null;
        try {
            result = automatedTestRunner.runTest(test, testGroup, (AutomatedTestRunner.TestListener)automatedTesterListener, false);
        }
        catch (ThreadDeath ex) {
            isFailure = true;
            LOG.error("AutomatedTesterTestCall caught ThreadDeath while running test. Must have hanged! Will not retrow ThreadDeath but handle it as test FAILURE.", (Throwable)ex);
        }
        catch (Throwable t) {
            isFailure = true;
            LOG.error("An exception occured while running the Test. Will consider it a failure.", t);
        }
        ResultBuilder resultBuilder = this.initResult(result, automatedTesterListener);
        if (isFailure) {
            resultBuilder.setSummary(Result.ResultStatus.FAILURE);
        }
        TestRunner.TestCallCreatedObjects testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(resultBuilder);
        automatedTesterListener.addExtraResultLogs(testCallCreatedObjects);
        try {
            testCallCreatedObjects.addLog("automatedTesterConfig", "automatedTesterConfig.json", MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)automatedTesterConfigMap), Log.LogMediaType.TEXT, null);
        }
        catch (JsonProcessingException e) {
            LOG.error("Failed to write config to log automatedTesterConfig.json", (Throwable)e);
        }
        if (result != null) {
            LOG.debug("Saving detailed results as HTML Log");
            try {
                String htmlString = result.toHtmlString(false);
                if (htmlString != null) {
                    testCallCreatedObjects.addLog("resultHtml", "result.html", htmlString, Log.LogMediaType.HTML, null);
                }
            }
            catch (Exception e) {
                LOG.error("Failed to generate resultHtml Log");
            }
            String resultXmlOverviewString = AutomatedTester2TestRunner.resultToXmlOverviewString(result, false);
            if (resultXmlOverviewString != null) {
                LOG.debug("Saving detailed results as XML Log");
                testCallCreatedObjects.addLog("resultXml", "result-overview.xml", resultXmlOverviewString, Log.LogMediaType.XML, null);
            }
        }
        LOG.debug("AutomatedTesterTestCall finished");
        return testCallCreatedObjects;
    }

    private static String resultToXmlOverviewString(ApiTestResult result, boolean showSecurityRisks) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            result.toXmlOverview((Writer)writer, showSecurityRisks);
            string = writer.getBuffer().toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOG.error("IOException writing to string", (Throwable)e);
                return null;
            }
        }
        writer.close();
        return string;
    }

    private static Injector createInjector(Logger LOG, Module userModule, Module preferencesModule, Module authoritiesModule, Module testTargetFromServerModule, Module ... extraModules) {
        ArrayList<Module> mods = new ArrayList<Module>();
        mods.addAll(Arrays.asList(extraModules));
        mods.addAll(Arrays.asList(userModule, authoritiesModule, testTargetFromServerModule, new PreLoginCoreModule(), new PostLoginCoreModule(), preferencesModule, new JFedWebApiClientModule()));
        String highLevelModuleClassname = "be.iminds.ilabt.jfed.highlevel.HighLevelModule";
        String sfaOnlyExperimentModuleClassname = "be.iminds.ilabt.jfed.highlevel.SfaOnlyExperimentModule";
        try {
            Class<?> highLevelModuleClass = Class.forName(highLevelModuleClassname);
            Module highLevelModule = (Module)highLevelModuleClass.newInstance();
            Class<?> sfaOnlyExperimentModuleClass = Class.forName(sfaOnlyExperimentModuleClassname);
            Module sfaOnlyExperimentModule = (Module)sfaOnlyExperimentModuleClass.newInstance();
            if (highLevelModule != null && sfaOnlyExperimentModule != null) {
                LOG.debug("Adding HighLevelModule to injector");
                mods.add(highLevelModule);
                LOG.debug("Adding SfaOnlyExperimentModule to injector");
                mods.add(sfaOnlyExperimentModule);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.debug("HighLevelModule and/or SfaOnlyExperimentModule is not available: will not be added to injector");
        }
        catch (InstantiationException e) {
            LOG.warn("Unexpected exception while loading HighLevelModule or SfaOnlyExperimentModule. Will try to continue without them.", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.warn("Unexpected exception while loading HighLevelModule or SfaOnlyExperimentModule. Will try to continue without them.", (Throwable)e);
        }
        try {
            Injector injector = Guice.createInjector(mods);
            return injector;
        }
        catch (AssertionError e) {
            LOG.error("Error creating injector", (Throwable)((Object)e));
            throw new RuntimeException("Error creating injector", (Throwable)((Object)e));
        }
        catch (Exception e) {
            LOG.error("Error creating injector", (Throwable)e);
            throw new RuntimeException("Error creating injector", e);
        }
    }

    @Nonnull
    private static List<String> extractMethodNames(@Nullable String propertyValue, boolean makeLowerCase) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        if (makeLowerCase) {
            propertyValue = propertyValue.toLowerCase();
        }
        return Arrays.asList(propertyValue.trim().split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static class AutomatedTesterListener
    implements AutomatedTestRunner.TestListener {
        private boolean sawPreRequisiteFailure = false;
        private boolean sawAnyFailure = false;
        private boolean sawAnyWarning = false;
        private Boolean successMethodSuccessful = null;
        private Boolean warningMethodSuccessful = null;
        private boolean notEnoughResourcesDetected = false;
        private boolean warningMethodSkippedSeen = false;
        @Nonnull
        private final List<ApiTestResult.ApiTestMethodResult.FedmonResultExtra> fedmonResultExtras = new ArrayList<ApiTestResult.ApiTestMethodResult.FedmonResultExtra>();
        List<Map<String, Object>> methodStates = new ArrayList<Map<String, Object>>();
        @Nonnull
        private final List<String> successMethodNames;
        @Nonnull
        private final List<String> warningMethodNames;
        @Nonnull
        private final List<String> prerequisiteMethodNames;
        @Nullable
        private final String notEnoughFreeResourcesDetectionString;
        @Nullable
        private final String notEnoughFreeResourcesDetectionMethod;
        private final boolean alternativeSummaryMethod;

        public AutomatedTesterListener(@Nonnull List<String> successMethodNames, @Nonnull List<String> warningMethodNames, @Nonnull List<String> prerequisiteMethodNames, @Nullable String notEnoughFreeResourcesDetectionString, @Nullable String notEnoughFreeResourcesDetectionMethod) {
            this.successMethodNames = successMethodNames.stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
            this.warningMethodNames = warningMethodNames.stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
            this.prerequisiteMethodNames = prerequisiteMethodNames.stream().map(String::trim).map(String::toLowerCase).collect(Collectors.toList());
            this.notEnoughFreeResourcesDetectionString = notEnoughFreeResourcesDetectionString == null ? null : notEnoughFreeResourcesDetectionString.trim().toLowerCase();
            this.notEnoughFreeResourcesDetectionMethod = notEnoughFreeResourcesDetectionMethod == null ? null : notEnoughFreeResourcesDetectionMethod.trim().toLowerCase();
            this.alternativeSummaryMethod = !successMethodNames.isEmpty() && !warningMethodNames.isEmpty() || !successMethodNames.isEmpty();
            LOG.debug("AutomatedTesterListener ready. successMethodNames={} warningMethodNames={} prerequisiteMethodNames={}", new Object[]{successMethodNames, warningMethodNames, prerequisiteMethodNames});
        }

        public void onStart(String testname, int testNr, int testCount) {
        }

        public void onResult(ApiTestResult.ApiTestMethodResult result, int testNr, int testCount) {
            TreeMap<String, String> methodInfoMap = new TreeMap<String, String>();
            methodInfoMap.put("name", result.getMethodName());
            methodInfoMap.put("state", result.getState() == null ? "null" : result.getState().toString());
            this.methodStates.add(methodInfoMap);
            String methodName = result.getMethodName().trim().toLowerCase();
            boolean isSuccesMethod = this.successMethodNames.contains(methodName);
            boolean isWarnMethod = this.warningMethodNames.contains(methodName);
            boolean isPrerequisiteMethod = this.prerequisiteMethodNames.contains(methodName);
            if (result.getState() != null) {
                switch (result.getState()) {
                    case SUCCESS: {
                        if (isSuccesMethod && this.successMethodSuccessful == null) {
                            this.successMethodSuccessful = true;
                        }
                        if (!isWarnMethod || this.warningMethodSuccessful != null) break;
                        this.warningMethodSuccessful = true;
                        break;
                    }
                    case WARN: {
                        if ((isSuccesMethod || isWarnMethod) && this.warningMethodSuccessful == null) {
                            this.warningMethodSuccessful = true;
                        }
                        if (isSuccesMethod) {
                            this.warningMethodSuccessful = false;
                        }
                        this.sawAnyWarning = true;
                        break;
                    }
                    case SKIPPED: {
                        if (!isWarnMethod) break;
                        this.warningMethodSkippedSeen = true;
                        break;
                    }
                    default: {
                        this.sawAnyFailure = true;
                        if (isPrerequisiteMethod) {
                            this.sawPreRequisiteFailure = true;
                        }
                        if (isSuccesMethod) {
                            this.successMethodSuccessful = false;
                        }
                        if (!isWarnMethod) break;
                        this.warningMethodSuccessful = false;
                    }
                }
                if (this.notEnoughFreeResourcesDetectionMethod != null && this.notEnoughFreeResourcesDetectionString != null && methodName.equals(this.notEnoughFreeResourcesDetectionMethod) && result.getState() != LogOutput.TestResultState.FAILED) {
                    this.notEnoughResourcesDetected = this.notEnoughResourcesDetected || result.getLogLines().stream().map(LogOutput.LogEntry::getText).filter(Objects::nonNull).map(String::trim).map(String::toLowerCase).filter(t -> t.contains(this.notEnoughFreeResourcesDetectionString)).findAny().isPresent();
                }
            }
            this.fedmonResultExtras.addAll(result.getFedmonResultExtras());
            for (ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra : result.getFedmonResultExtras()) {
                if (extra.getNestedKey().size() != 1 || !Objects.equals(extra.getNestedKey().get(0), "notEnoughFreeResourcesDetected") || !Objects.equals(extra.getValue(), Boolean.TRUE)) continue;
                this.notEnoughResourcesDetected = true;
            }
        }

        public void onAllTestDone(ApiTestResult result, int testCount) {
            if (this.warningMethodSkippedSeen && this.warningMethodSuccessful == null) {
                this.warningMethodSuccessful = false;
            }
        }

        public List<Map<String, Object>> getMethodStates() {
            return this.methodStates;
        }

        public void addSummary(ResultBuilder res) {
            if (this.alternativeSummaryMethod && (!this.warningMethodNames.isEmpty() && this.warningMethodSuccessful == null || this.successMethodSuccessful == null)) {
                LOG.warn("WARNING handling results. successMethodNames=" + this.successMethodNames + " warningMethodNames=" + this.warningMethodNames + " BUT warningMethodSuccessful=" + this.warningMethodSuccessful + " successMethodSuccessful=" + this.successMethodSuccessful);
                TestRunner.addWarningToResult(res, "At least one \"summary method\" not found. warn (" + this.warningMethodNames + ")=>" + this.warningMethodSuccessful + " success (" + this.successMethodNames + ")=>" + this.successMethodSuccessful);
            }
            if (this.notEnoughResourcesDetected) {
                TestRunner.addNoteToResult(res, "Detected that not enough free resources are available. Will force WARN.");
                res.setSummary(Result.ResultStatus.WARNING);
            } else if (this.sawPreRequisiteFailure) {
                LOG.debug("Handling prerequitiste failure");
                TestRunner.addNoteToResult(res, "Detected that prerequitiste method failed. No reliable status can be derived from this test result. Will set status to \"cancelled\"");
                res.setSummary(Result.ResultStatus.CANCELLED);
            } else if (this.alternativeSummaryMethod && this.successMethodSuccessful != null) {
                TestRunner.addNoteToResult(res, "successMethodNames=" + this.successMethodNames + " warningMethodNames=" + this.warningMethodNames + " warningMethodSuccessful=" + this.warningMethodSuccessful + " successMethodSuccessful=" + this.successMethodSuccessful);
                if (this.successMethodSuccessful != null && this.successMethodSuccessful.booleanValue()) {
                    res.setSummary(Result.ResultStatus.SUCCESS);
                } else if (this.warningMethodSuccessful != null) {
                    res.setSummary(this.warningMethodSuccessful != false ? Result.ResultStatus.WARNING : Result.ResultStatus.FAILURE);
                } else {
                    res.setSummary(Result.ResultStatus.FAILURE);
                }
            } else {
                if (this.alternativeSummaryMethod) {
                    LOG.warn("WARNING handling results. Falling back to default summary method");
                    TestRunner.addWarningToResult(res, "Falling back to default \"summary method\"");
                }
                res.setSummary(Result.ResultStatus.SUCCESS);
                if (this.sawAnyWarning) {
                    res.setSummary(Result.ResultStatus.WARNING);
                }
                if (this.sawAnyFailure) {
                    res.setSummary(Result.ResultStatus.FAILURE);
                }
            }
            assert (res.getSummaryStatus() != null);
            for (ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra : this.fedmonResultExtras) {
                if (extra.isLarge()) continue;
                if (extra.getNestedKey().stream().noneMatch(Objects::isNull)) {
                    res.setNestedSubResult(extra.getValue(), extra.getNestedKey().toArray(new String[1]));
                    continue;
                }
                LOG.error("Skipped adding subresult: There was a null in the nested keys: " + extra.getNestedKey());
            }
        }

        public void addExtraResultLogs(TestRunner.TestCallCreatedObjects testCallCreatedObjects) {
            for (ApiTestResult.ApiTestMethodResult.FedmonResultExtra extra : this.fedmonResultExtras) {
                if (!extra.isLarge()) continue;
                String lastName = (String)extra.getNestedKey().get(extra.getNestedKey().size() - 1);
                String value = extra.getValue().toString();
                testCallCreatedObjects.addLog(extra.getNestedKey(), lastName, value, Log.LogMediaType.byHttpMediaType((String)extra.getHttpMediaType()), new Timestamp(System.currentTimeMillis()));
            }
        }
    }

    private static class TestTargetFromServerModule
    extends AbstractModule {
        private final Integer serverId;

        public TestTargetFromServerModule(Integer serverId) {
            this.serverId = serverId;
        }

        protected void configure() {
        }

        @Provides
        public TargetAuthority provideTargetAuthority(TestbedInfoSource testbedInfoSource) throws ContextFile.ContextFileException {
            if (this.serverId != null) {
                Server targetServer = testbedInfoSource.getServerById(this.serverId);
                assert (targetServer != null);
                return new TargetAuthority(targetServer.getDefaultComponentManagerAsGeniUrn(), targetServer, targetServer);
            }
            return null;
        }
    }
}

