/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.rrd4j.graph.PathIterator;

class ImageWorker {
    private static final String DUMMY_TEXT = "Dummy";
    static final int IMG_BUFFER_CAPACITY = 10000;
    private BufferedImage img;
    private Graphics2D g2d;
    private int imgWidth;
    private int imgHeight;
    private AffineTransform initialAffineTransform;

    ImageWorker(int width, int height) {
        this.resize(width, height);
    }

    void resize(int width, int height) {
        if (this.g2d != null) {
            this.dispose();
        }
        this.imgWidth = width;
        this.imgHeight = height;
        this.img = new BufferedImage(width, height, 2);
        this.g2d = this.img.createGraphics();
        this.initialAffineTransform = this.g2d.getTransform();
        this.setAntiAliasing(false);
        this.setTextAntiAliasing(false);
        this.g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    void clip(int x, int y, int width, int height) {
        this.g2d.setClip(x, y, width, height);
    }

    void transform(int x, int y, double angle) {
        this.g2d.translate(x, y);
        this.g2d.rotate(angle);
    }

    void reset() {
        this.g2d.setTransform(this.initialAffineTransform);
        this.g2d.setClip(0, 0, this.imgWidth, this.imgHeight);
    }

    void fillRect(int x, int y, int width, int height, Paint paint) {
        this.g2d.setPaint(paint);
        this.g2d.fillRect(x, y, width, height);
    }

    void fillPolygon(int[] x, int[] y, Paint paint) {
        this.g2d.setPaint(paint);
        this.g2d.fillPolygon(x, y, x.length);
    }

    void fillPolygon(double[] x, double yBottom, double[] yTop, Paint paint) {
        this.g2d.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n + 2];
            int[] yDev = new int[n + 2];
            for (int i = start; i < end; ++i) {
                xDev[i - start] = (int)x[i];
                yDev[i - start] = (int)yTop[i];
            }
            xDev[n] = xDev[n - 1];
            xDev[n + 1] = xDev[0];
            int n2 = (int)yBottom;
            yDev[n + 1] = n2;
            yDev[n] = n2;
            this.g2d.fillPolygon(xDev, yDev, xDev.length);
            this.g2d.drawPolygon(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void fillPolygon(double[] x, double[] yBottom, double[] yTop, Paint paint) {
        this.g2d.setPaint(paint);
        PathIterator path = new PathIterator(yTop);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int n = end - start;
            int[] xDev = new int[n * 2];
            int[] yDev = new int[n * 2];
            for (int i = start; i < end; ++i) {
                int ix1 = i - start;
                int ix2 = n * 2 - 1 - i + start;
                xDev[ix1] = xDev[ix2] = (int)x[i];
                yDev[ix1] = (int)yTop[i];
                yDev[ix2] = (int)yBottom[i];
            }
            this.g2d.fillPolygon(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void drawLine(int x1, int y1, int x2, int y2, Paint paint, Stroke stroke) {
        this.g2d.setStroke(stroke);
        this.g2d.setPaint(paint);
        this.g2d.drawLine(x1, y1, x2, y2);
    }

    void drawPolyline(int[] x, int[] y, Paint paint, Stroke stroke) {
        this.g2d.setStroke(stroke);
        this.g2d.setPaint(paint);
        this.g2d.drawPolyline(x, y, x.length);
    }

    void drawPolyline(double[] x, double[] y, Paint paint, Stroke stroke) {
        this.g2d.setPaint(paint);
        this.g2d.setStroke(stroke);
        PathIterator path = new PathIterator(y);
        int[] pos = path.getNextPath();
        while (pos != null) {
            int start = pos[0];
            int end = pos[1];
            int[] xDev = new int[end - start];
            int[] yDev = new int[end - start];
            for (int i = start; i < end; ++i) {
                xDev[i - start] = (int)x[i];
                yDev[i - start] = (int)y[i];
            }
            this.g2d.drawPolyline(xDev, yDev, xDev.length);
            pos = path.getNextPath();
        }
    }

    void drawString(String text, int x, int y, Font font, Paint paint) {
        this.g2d.setFont(font);
        this.g2d.setPaint(paint);
        this.g2d.drawString(text, x, y);
    }

    double getFontAscent(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.g2d.getFontRenderContext());
        return lm.getAscent();
    }

    double getFontHeight(Font font) {
        LineMetrics lm = font.getLineMetrics(DUMMY_TEXT, this.g2d.getFontRenderContext());
        return lm.getAscent() + lm.getDescent();
    }

    double getStringWidth(String text, Font font) {
        return font.getStringBounds(text, 0, text.length(), this.g2d.getFontRenderContext()).getBounds().getWidth();
    }

    void setAntiAliasing(boolean enable) {
        this.g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, enable ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    void setTextAntiAliasing(boolean enable) {
        this.g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, enable ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    void dispose() {
        this.g2d.dispose();
    }

    void saveImage(OutputStream stream, String type, float quality, boolean interlaced) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(type);
        ImageWriter writer = iter.next();
        BufferedImage outputImage = this.img;
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        ImageWriterSpi imgProvider = writer.getOriginatingProvider();
        this.img.coerceData(false);
        if (!imgProvider.canEncodeImage(outputImage) || "image/jpeg".equals(imgProvider.getMIMETypes()[0].toLowerCase())) {
            int w = this.img.getWidth();
            int h = this.img.getHeight();
            outputImage = new BufferedImage(w, h, 1);
            outputImage.getGraphics().drawImage(this.img, 0, 0, w, h, null);
            if (!imgProvider.canEncodeImage(outputImage)) {
                throw new RuntimeException("Invalid image type");
            }
        }
        if (!imgProvider.isFormatLossless()) {
            iwp.setCompressionMode(2);
            iwp.setCompressionQuality(quality);
        }
        if (iwp.canWriteProgressive()) {
            iwp.setProgressiveMode(interlaced ? 1 : 0);
        }
        if (!imgProvider.canEncodeImage(outputImage)) {
            throw new RuntimeException("Invalid image type");
        }
        ImageOutputStream imageStream = ImageIO.createImageOutputStream(stream);
        writer.setOutput(imageStream);
        try {
            writer.write(null, new IIOImage(outputImage, null, null), iwp);
            imageStream.flush();
        }
        catch (IOException e) {
            writer.abort();
            throw e;
        }
        finally {
            try {
                imageStream.close();
            }
            catch (Exception exception) {}
            writer.dispose();
        }
    }

    byte[] saveImage(String path, String type, float quality, boolean interlaced) throws IOException {
        byte[] bytes = this.getImageBytes(type, quality, interlaced);
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(path));){
            out.write(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getImageBytes(String type, float quality, boolean interlaced) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream(10000);){
            this.saveImage(stream, type, quality, interlaced);
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
    }

    public void loadImage(String imageFile) throws IOException {
        BufferedImage wpImage = ImageIO.read(new File(imageFile));
        TexturePaint paint = new TexturePaint(wpImage, new Rectangle(0, 0, wpImage.getWidth(), wpImage.getHeight()));
        this.g2d.setPaint(paint);
        this.g2d.fillRect(0, 0, wpImage.getWidth(), wpImage.getHeight());
    }
}

