/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.graphmaker;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.GraphTask;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.GraphTaskFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Graph;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdGraphManager
extends RrdManager {
    private static final Logger LOG = LoggerFactory.getLogger(RrdGraphManager.class);
    private final FedmonWebApiClient fedmonWebApiClient;

    public RrdGraphManager(RrdConfig rrdConfig, FedmonWebApiClient fedmonWebApiClient) {
        super(rrdConfig);
        this.fedmonWebApiClient = fedmonWebApiClient;
    }

    public Collection<? extends GraphTask> getGraphTasks(GraphTaskFilter filter, boolean forceUpdate) throws FedmonWebApiClient.FedmonWebApiClientException {
        ArrayList<GraphTask> res = new ArrayList<GraphTask>();
        for (File f : this.getAllRrdFiles()) {
            TestDefinition td;
            TestInstance ti;
            int tid;
            String type;
            block13: {
                Boolean matchType;
                String name = f.getName();
                if (!f.exists() || !name.endsWith(".rrd")) continue;
                name = name.substring(0, name.length() - 4);
                String[] parts = name.split("-", 2);
                LOG.debug("Split RRD filename \"" + name + "\" into parts: " + Arrays.asList(parts));
                if (parts.length != 2 || (matchType = filter.mustRunType(type = parts[0])) != null && !matchType.booleanValue()) continue;
                try {
                    tid = Integer.parseInt(parts[1]);
                    Boolean matchTid = filter.mustRunTid(tid);
                    if (matchTid != null && !matchTid.booleanValue()) {
                    }
                    break block13;
                }
                catch (NumberFormatException e) {
                    LOG.warn("Failure parsing number \"" + parts[1] + "\" in RRD filename \"" + name + "\" -> will ignore RRD file", (Throwable)e);
                }
                continue;
            }
            Frequency tiFreq = (ti = (TestInstance)this.fedmonWebApiClient.getById(TestInstance.class, (Object)tid).get()).getFrequencyId() == null ? null : (Frequency)this.fedmonWebApiClient.getById(Frequency.class, (Object)ti.getFrequencyId()).get();
            TestInstanceRrd rrd = this.get(ti, tiFreq, td = (TestDefinition)this.fedmonWebApiClient.getById(TestDefinition.class, (Object)ti.getTestDefinitionId()).get(), type);
            if (rrd == null) {
                LOG.error("RRD file exists for ti " + ti.getId() + " (" + ti.getName() + ") td=" + (String)td.getId() + " (type=" + td.getType() + ") but TD does not support RRD. Skipping!");
                continue;
            }
            assert (rrd != null);
            List<TestInstanceRrd.GraphInfo> graphInfos = rrd.getGraphInfo();
            assert (graphInfos != null);
            for (TestInstanceRrd.GraphInfo graphInfo : graphInfos) {
                Boolean matchPeriod;
                Optional serverGraph = this.fedmonWebApiClient.get(Graph.class, (Object)graphInfo.getId());
                if (!forceUpdate && serverGraph.isPresent()) {
                    boolean expired;
                    Timestamp expire = ((Graph)serverGraph.get()).getExpire();
                    boolean bl = expired = expire == null || expire.before(new Date());
                    if (!expired) {
                        long diffMin = (graphInfo.getExpireS() - System.currentTimeMillis() / 1000L) / 60L;
                        LOG.debug("Graph " + graphInfo.getId() + " has not yet expired (" + diffMin + " min left) -> not renewing graph");
                        continue;
                    }
                    LOG.debug("Graph has expired. Will update.");
                } else if (serverGraph.isPresent()) {
                    LOG.debug("Force update set: not checking if update needed, doing it anyway.");
                } else {
                    LOG.debug("No previous graph.");
                }
                if ((matchPeriod = filter.mustRunPeriod(graphInfo.getPeriodInSeconds())) != null && !matchPeriod.booleanValue()) continue;
                GraphTask task = new GraphTask(rrd, graphInfo, this.fedmonWebApiClient);
                LOG.debug("Graph file " + graphInfo.getId() + " passed all filters");
                res.add(task);
            }
        }
        return res;
    }
}

