/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.graphmaker;

import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.graphmaker.GraphTask;
import java.util.ArrayList;
import java.util.List;

public class GraphTaskFilter {
    private final List<Integer> tids = new ArrayList<Integer>();
    private final List<String> types = new ArrayList<String>();
    private final List<Long> periods = new ArrayList<Long>();

    public GraphTaskFilter(String graphPeriodFilter, String graphTypeFilter, String testInstanceIdFilter) {
        String[] parts;
        if (graphPeriodFilter != null && !graphPeriodFilter.trim().isEmpty()) {
            for (String p : parts = graphPeriodFilter.split(",")) {
                if (p.equalsIgnoreCase("all")) continue;
                this.periods.add(RrdManager.rrdTimeToS(p));
            }
        }
        if (testInstanceIdFilter != null && !testInstanceIdFilter.trim().isEmpty()) {
            for (String p : parts = testInstanceIdFilter.split(",")) {
                if (p.equalsIgnoreCase("all")) continue;
                this.tids.add(Integer.parseInt(p));
            }
        }
        if (graphTypeFilter != null && !graphTypeFilter.trim().isEmpty()) {
            for (String p : parts = graphTypeFilter.split(",")) {
                if (p.equalsIgnoreCase("all")) continue;
                this.types.add(p);
            }
        }
    }

    public boolean mustRun(GraphTask task) {
        return this.mustRun(task.getGraphInfo());
    }

    public boolean mustRun(TestInstanceRrd.GraphInfo graphInfo) {
        Boolean typeRes = this.mustRunType((String)(graphInfo.getSubType() == null ? graphInfo.getGraphDefinitionId() : graphInfo.getGraphDefinitionId() + "-" + graphInfo.getSubType()));
        if (typeRes != null) {
            return typeRes;
        }
        Boolean tidRes = this.mustRunTid((Integer)graphInfo.getTestInstance().getId());
        if (tidRes != null) {
            return tidRes;
        }
        Boolean periodRes = this.mustRunPeriod(graphInfo.getPeriodInSeconds());
        if (periodRes != null) {
            return periodRes;
        }
        return true;
    }

    public Boolean mustRunTid(int tid) {
        if (!this.tids.isEmpty()) {
            for (Integer t : this.tids) {
                if (tid != t) continue;
                return true;
            }
            return false;
        }
        return null;
    }

    public Boolean mustRunPeriod(long period) {
        if (!this.periods.isEmpty()) {
            for (Long p : this.periods) {
                if (p != period) continue;
                return true;
            }
            return false;
        }
        return null;
    }

    public Boolean mustRunType(String type) {
        if (!this.types.isEmpty()) {
            for (String t : this.types) {
                if (!t.equals(type)) continue;
                return true;
            }
            return false;
        }
        return null;
    }
}

