/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsConstants;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializableApiCallDetailsReader {
    private static final Logger LOG = LoggerFactory.getLogger(SerializableApiCallDetailsReader.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneId.systemDefault());

    public static SerializableApiCallDetails readCall(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, ApiCallDetailsParseException {
        assert (e.isStartElement() && Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CALL));
        int id = -1;
        if (e.asStartElement().getAttributeByName(SerializableApiCallDetailsConstants.Q_CALL_ID) != null) {
            id = Integer.parseInt(e.asStartElement().getAttributeByName(SerializableApiCallDetailsConstants.Q_CALL_ID).getValue());
        }
        String authorityName = null;
        String authorityUrn = null;
        String baseServerUrl = null;
        String callServerUrl = null;
        JFedConnection.ProxyInfo proxyInfo = null;
        String connectionUserUrn = null;
        String connectionBasicHttpAuthenticationUsername = null;
        String connectionId = null;
        String connectionUserCertificates = null;
        String connectionAuthenticationMethod = null;
        String connectionProtocol = null;
        String connectionType = null;
        String httpRequestStatusLine = null;
        String httpRequestHeaders = null;
        String httpRequest = null;
        String httpResponseStatusLine = null;
        String httpResponseHeaders = null;
        String httpResponse = null;
        String apiName = null;
        String javaMethodName = null;
        String geniMethodName = null;
        String xmlRpcRequestJsonString = null;
        String xmlRpcResponseJsonString = null;
        String xmlRpcGeniResponseValue = null;
        String xmlRpcGeniResponseOutput = null;
        String xmlRpcGeniResponseCode = null;
        Integer geniResponseCode = null;
        String geniResponseCodeDescription = null;
        Boolean geniResponseCodeIsSuccess = null;
        String geniResponseOutput = null;
        Date startTime = null;
        Date stopTime = null;
        String protogeniSpewLogUrl = null;
        String exceptionString = null;
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (e.asStartElement().getName().equals(SerializableApiCallDetailsConstants.Q_AUTHORITY_NAME) || e.asStartElement().getName().equals(SerializableApiCallDetailsConstants.Q_AUTHORITY_NAME_ALT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        authorityName = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_AUTHORITY_URN)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        authorityUrn = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_BASE_SERVER_URL)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        baseServerUrl = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CALL_SERVER_URL)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        callServerUrl = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_USER_URN)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionUserUrn = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_HTTP_BASIC_AUTHENTICATION_USERNAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionBasicHttpAuthenticationUsername = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_TYPE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionType = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_AUTH_METHOD)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionAuthenticationMethod = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_CONFIG_PROTOCOL)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionProtocol = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_PROXY_INFO)) {
                    proxyInfo = SerializableApiCallDetailsReader.readProxyInfo(eventReader, e);
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_ID)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionId = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_CONNECTION_USER_CERTS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        connectionUserCertificates = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_LINE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpRequestStatusLine = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_REQUEST_HEADERS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpRequestHeaders = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_REQUEST)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpRequest = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_STATUS_LINE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpResponseStatusLine = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_RESPONSE_HEADERS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpResponseHeaders = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HTTP_REPLY)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        httpResponse = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_API_NAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        apiName = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_JAVA_METHOD_NAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        javaMethodName = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_METHOD_NAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        geniMethodName = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_METHOD_PARAMETERS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_XMLRPC_REQUEST)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        xmlRpcRequestJsonString = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_XMLRPC_REPLY)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        xmlRpcResponseJsonString = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_VALUE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        xmlRpcGeniResponseValue = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_OUTPUT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        xmlRpcGeniResponseOutput = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_CODE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        xmlRpcGeniResponseCode = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        geniResponseCode = Integer.parseInt(e.asCharacters().getData());
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_CODE_DESCRIPTION)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        geniResponseCodeDescription = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_CODE_IS_SUCCESS)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        geniResponseCodeIsSuccess = Boolean.parseBoolean(e.asCharacters().getData());
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_GENI_RESPONSE_OUTPUT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        geniResponseOutput = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_RAW_RESPONSE)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (!e.isCharacters()) assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_START_TIME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    assert (e.isCharacters());
                    startTime = SerializableApiCallDetailsReader.getDateFromString(e.asCharacters().getData());
                    continue;
                }
                if (e.asStartElement().getName().equals(SerializableApiCallDetailsConstants.Q_END_TIME) || e.asStartElement().getName().equals(SerializableApiCallDetailsConstants.Q_END_TIME_ALT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    assert (e.isCharacters());
                    stopTime = SerializableApiCallDetailsReader.getDateFromString(e.asCharacters().getData());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_PROTOGENI_SPEW_LOG_URL)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        protogeniSpewLogUrl = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_EXCEPTION)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        exceptionString = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_CALL, e);
                continue;
            }
            if (e.isEndElement()) {
                if (Objects.equals(e.asEndElement().getName(), SerializableApiCallDetailsConstants.Q_CALL)) {
                    return new SerializableApiCallDetails(id, authorityName, authorityUrn, baseServerUrl, callServerUrl, proxyInfo, connectionUserUrn, connectionBasicHttpAuthenticationUsername, connectionId, connectionUserCertificates, connectionAuthenticationMethod, connectionProtocol, connectionType, httpRequestStatusLine, httpRequestHeaders, httpRequest, httpResponseStatusLine, httpResponseHeaders, httpResponse, apiName, javaMethodName, geniMethodName, xmlRpcRequestJsonString, xmlRpcResponseJsonString, xmlRpcGeniResponseValue, xmlRpcGeniResponseOutput, xmlRpcGeniResponseCode, geniResponseCode, geniResponseCodeDescription, geniResponseCodeIsSuccess, geniResponseOutput, startTime, stopTime, protogeniSpewLogUrl, exceptionString);
                }
                SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_CALL, e);
                continue;
            }
            SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_CALL, e);
        }
        throw SerializableApiCallDetailsReader.createUnexpectedEndException(SerializableApiCallDetailsConstants.Q_CALL, e.getLocation());
    }

    public static JFedConnection.ProxyInfo readProxyInfo(XMLEventReader eventReader, XMLEvent e) throws XMLStreamException, ApiCallDetailsParseException {
        String hostname = null;
        int port = -1;
        String username = "";
        String hostkey = "";
        while (eventReader.hasNext()) {
            e = eventReader.nextEvent();
            if (e.isStartElement()) {
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HOSTNAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        hostname = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_PORT)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        port = Integer.parseInt(e.asCharacters().getData());
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_USERNAME)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        username = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                if (Objects.equals(e.asStartElement().getName(), SerializableApiCallDetailsConstants.Q_HOST_KEY)) {
                    assert (eventReader.hasNext());
                    e = eventReader.nextEvent();
                    if (e.isCharacters()) {
                        hostkey = e.asCharacters().getData();
                        continue;
                    }
                    assert (e.isEndElement());
                    continue;
                }
                SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_PROXY_INFO, e);
                continue;
            }
            if (e.isEndElement()) {
                if (Objects.equals(e.asEndElement().getName(), SerializableApiCallDetailsConstants.Q_PROXY_INFO)) {
                    return new JFedConnection.SshProxyInfo(hostname, port, username, null, hostkey);
                }
                SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_PROXY_INFO, e);
                continue;
            }
            SerializableApiCallDetailsReader.logUnexpectedElement(SerializableApiCallDetailsConstants.Q_PROXY_INFO, e);
        }
        throw SerializableApiCallDetailsReader.createUnexpectedEndException(SerializableApiCallDetailsConstants.Q_PROXY_INFO, e.getLocation());
    }

    private static Date getDateFromString(String input) {
        ZonedDateTime dateTime = ZonedDateTime.from(DATE_TIME_FORMATTER.parse(input));
        return Date.from(dateTime.toInstant());
    }

    private static ApiCallDetailsParseException createUnexpectedEndException(QName name, Location location) {
        return new ApiCallDetailsParseException("Expected to encounter end-tag of " + name.getLocalPart() + ", but never found it before end of stream.", location);
    }

    private static void logUnexpectedElement(QName parent, XMLEvent event) {
        if (event.isCharacters() && event.asCharacters().getData().trim().isEmpty()) {
            return;
        }
        if (event.isEndElement()) {
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            event.writeAsEncodedUnicode(stringWriter);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        String eventContents = stringWriter.toString().trim();
        LOG.warn("Encountered unexpected event {} ({}) while parsing {}@{}", new Object[]{event, eventContents, parent.getLocalPart(), event.getLocation()});
    }

    public static class ApiCallDetailsParseException
    extends Exception {
        private final Location location;

        public ApiCallDetailsParseException(Location location) {
            this.location = location;
        }

        public ApiCallDetailsParseException(Throwable cause, Location location) {
            super(cause);
            this.location = location;
        }

        public ApiCallDetailsParseException(String message, Location location) {
            super(message);
            this.location = location;
        }

        public ApiCallDetailsParseException(String message, Throwable cause, Location location) {
            super(message, cause);
            this.location = location;
        }

        public ApiCallDetailsParseException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace, Location location) {
            super(message, cause, enableSuppression, writableStackTrace);
            this.location = location;
        }
    }
}

