/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.lifecycle;

import com.google.common.annotations.VisibleForTesting;
import io.dropwizard.lifecycle.Managed;
import io.dropwizard.util.Duration;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceManager
implements Managed {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorServiceManager.class);
    private final ExecutorService executor;
    private final Duration shutdownPeriod;
    private final String poolName;

    public ExecutorServiceManager(ExecutorService executor, Duration shutdownPeriod, String poolName) {
        this.executor = executor;
        this.shutdownPeriod = shutdownPeriod;
        this.poolName = poolName;
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws InterruptedException, Exception {
        this.executor.shutdown();
        boolean success = this.executor.awaitTermination(this.shutdownPeriod.getQuantity(), this.shutdownPeriod.getUnit());
        if (!success && LOG.isDebugEnabled()) {
            LOG.debug("Timeout has elapsed before termination completed for executor " + this.executor.toString());
        }
    }

    public String toString() {
        return super.toString() + '(' + this.poolName + ')';
    }

    @VisibleForTesting
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @VisibleForTesting
    public Duration getShutdownPeriod() {
        return this.shutdownPeriod;
    }

    @VisibleForTesting
    public String getPoolName() {
        return this.poolName;
    }
}

