/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.git;

import be.iminds.ilabt.jfed.git.GitAuthPreferences;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GitFetcherCommand {
    @Nonnull
    private final String gitUrl;
    @Nullable
    private final String repoSubDir;
    @Nullable
    private final String branch;
    @Nullable
    private final GitAuthPreferences.GitAuth gitAuth;
    @Nullable
    private final File targetDir;
    private final boolean allowCreateDir;
    private final boolean overwriteFilesInDir;

    public GitFetcherCommand(@Nonnull String gitUrl, @Nullable String repoSubDir, @Nullable String branch, @Nullable GitAuthPreferences.GitAuth gitAuth, @Nullable File targetDir, boolean allowCreateDir, boolean overwriteFilesInDir) {
        this.gitUrl = gitUrl;
        this.repoSubDir = repoSubDir;
        this.branch = branch;
        this.gitAuth = gitAuth;
        this.targetDir = targetDir;
        this.allowCreateDir = allowCreateDir;
        this.overwriteFilesInDir = overwriteFilesInDir;
    }

    public static File createTempDirectory() {
        try {
            return Files.createTempDirectory("git-repo", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary dir for git repo files.", e);
        }
    }

    @Nonnull
    public String getGitUrl() {
        return this.gitUrl;
    }

    @Nullable
    public String getRepoSubDir() {
        return this.repoSubDir;
    }

    @Nullable
    public String getBranch() {
        return this.branch;
    }

    @Nullable
    public GitAuthPreferences.GitAuth getGitAuth() {
        return this.gitAuth;
    }

    @Nullable
    public File getTargetDir() {
        return this.targetDir;
    }

    public boolean isAllowCreateDir() {
        return this.allowCreateDir;
    }

    public boolean isOverwriteFilesInDir() {
        return this.overwriteFilesInDir;
    }
}

