/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.LoginSpec;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.GeniSpecificationNonconformityException;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateManager2
extends AbstractGeniAggregateManager {
    private static final Logger LOG = LoggerFactory.getLogger(AggregateManager2.class);

    public AggregateManager2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), jFedPreferences);
    }

    public AggregateManager2(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, jFedPreferences.getRetrySettings(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2), jFedPreferences);
    }

    public static String getApiName() {
        return "Geni Aggregate Manager API v2";
    }

    public static List<String> createCredentialsList(@Nonnull List<AnyCredential> credentialList) {
        if (credentialList.contains(null)) {
            throw new IllegalArgumentException("Illegal arguments: no AnyCredential is allowed to be null in credentialList: " + credentialList);
        }
        List<String> credentialsList = credentialList.stream().map(AnyCredential::getCredentialXml).collect(Collectors.toList());
        assert (!credentialsList.contains(null));
        return credentialsList;
    }

    @Override
    @Nonnull
    public String getName() {
        return AggregateManager2.getApiName();
    }

    @ApiMethod(order=1, hint="Get static version and configuration information about this aggregate. Return includes:\n\n- The version of the GENI Aggregate Manager API supported by this aggregate manager instance\n- URLs for other versions of this API supported by this aggregate\n- The RSpec formats accepted at this aggregate\n- Other information about the configuration of this aggregate.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<VersionInfo> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "GetVersion", new ArrayList<Object>(), VersionInfo::new);
    }

    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<String> listResources(@Nonnull SfaConnection con, @Nonnull List<AnyCredential> credentialList, @Nonnull String rspecType, @Nonnull String rspecVersion, @Nullable Boolean available, @Nullable Boolean compressed, @Nullable String sliceUrn, @Nullable Map<String, Object> extraOptions) throws JFedException {
        return this.listResources(con, credentialList, rspecType, rspecVersion, available, compressed, sliceUrn, null, extraOptions);
    }

    @ApiMethod(order=2, hint="Return a listing and description of available resources at this aggregate, or resources allocated to a named slice at this aggregate. The resource listing and description provides sufficient information for clients to select among available resources, or to use reserved resources. These listings are known as RSpecs.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<String> listResources(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. For an advertisement rspec request, this must includea valid user credential. For a slice manifest rspec request, this must include a valid credential for the slice.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="rspecType", guiDefault="geni", hint="mandatory rspec type (example: \"geni\")") @Nonnull String rspecType, @ApiMethodParameter(name="rspecVersion", guiDefault="3", hint="mandatory rspec version (example for type \"geni\": \"3\")") @Nonnull String rspecVersion, @ApiMethodParameter(name="available", required=false, hint="optional: if true, show only available local resources, otherwise show everything") @Nullable Boolean available, @ApiMethodParameter(name="compressed", required=false, guiDefault="true", guiDefaultOptional=true, hint="optional: if true compress result (RFC 1950).\nNOTE: if compressed is set, this API will decompress the result automatically.") @Nullable Boolean compressed, @ApiMethodParameter(name="sliceUrn", required=false, hint="optional: if set, show manifest RSpec for the slice instead of the advertisement RSpec for the AM.") @Nullable String sliceUrn, @ApiMethodParameter(name="list_leases", required=false, guiDefault="leases", hint="optional and PLE specific: possible values: \"leases\" or \"resources\".") @Nullable String list_leases, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "rspecType", rspecType, "rspecVersion", rspecVersion);
        if (available != null) {
            methodParams.put("available", available);
        }
        if (compressed != null) {
            methodParams.put("compressed", compressed);
        }
        if (sliceUrn != null) {
            methodParams.put("sliceUrn", sliceUrn);
        }
        if (list_leases != null) {
            methodParams.put("list_leases", list_leases);
        }
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(rspecType, "Illegal argument: rspecType is not allowed to be null");
        Objects.requireNonNull(rspecVersion, "Illegal argument: rspecVersion is not allowed to be null");
        HashMap<String, String> rspecVersionOpt = new HashMap<String, String>();
        rspecVersionOpt.put("type", rspecType);
        rspecVersionOpt.put("version", rspecVersion);
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("geni_rspec_version", rspecVersionOpt);
        if (sliceUrn != null) {
            options.put("geni_slice_urn", sliceUrn);
        }
        if (available != null) {
            options.put("geni_available", available);
        }
        if (compressed != null) {
            options.put("geni_compressed", compressed);
        }
        if (list_leases != null) {
            options.put("list_leases", list_leases);
        }
        if (extraOptions != null) {
            options.putAll(extraOptions);
        }
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "listResources", "ListResources", args, new AbstractApi.CompressedStringConverter(compressed));
    }

    @ApiMethod(order=3, hint="Allocate resources as described in a request RSpec argument to a slice with the named URN. This operation is expected to start the allocated resources asynchronously after the operation has successfully completed. Callers can check on the status of the resources using SliverStatus. Resources will be reserved until a particular time, set by the aggregate according to policy. That expiration time will be no later than the expiration time of the provided slice credential. This method returns a listing and description of the resources reserved for the slice by this operation, in the form of a manifest RSpec.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<String> createSliver(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. This must include a valid credential for the slice.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="urn for the slice on which this sliver needs to be created") @Nonnull String sliceUrn, @ApiMethodParameter(name="rspec", hint=" An RSpec matching the GENI standard request RSpec schema containing the resources that the caller is requesting for allocation to the slice specified in slice_urn.") @Nonnull String rspec, @ApiMethodParameter(name="UserSpecList", hint="An array of user structs, which contain information (typically SSH public keys) about needed to allow users to login on allocated nodes.") @Nullable List<UserSpec> users, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "rspec", rspec, "users", users);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        Objects.requireNonNull(rspec, "Illegal argument: rspec is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        List usersList = users != null ? users.stream().map(UserSpec::getAsMap).collect(Collectors.toList()) : Collections.emptyList();
        Map<String, Object> options = AggregateManager2.createOptionsMap(extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(5);
        args.add(sliceUrn);
        args.add(credentialsList);
        args.add(rspec);
        args.add(usersList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "createSliver", "CreateSliver", args, STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=5, hint="Get the status of a sliver or slivers belonging to the given slice at the given aggregate. Status may include other dynamic reservation or instantiation information as required by the resource type and aggregate. This method is used to provide updates on the state of the resources after the completion of CreateSliver, which began to asynchronously provision and start the resources.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<SliverStatus> sliverStatus(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. This must include a valid credential for the slice.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="URN for the slice of which to request the status of the sliver at this aggregate") @Nonnull String sliceUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        Map<String, Object> options = AggregateManager2.createOptionsMap(extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(sliceUrn);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "sliverStatus", "SliverStatus", args, SliverStatus::new);
    }

    @ApiMethod(order=6, hint="Renews the resources in all slivers at this aggregate belonging to the given slice until the given time, extending the lifetime of the slice. Aggregates may limit how long reservations may be extended. Initial sliver expiration is set by aggregate policy, no later than the slice credential expiration time.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<Boolean> renewSliver(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. This must include a valid credential for the slice.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="URN for the slice which sliver should be renewed") @Nonnull String sliceUrn, @ApiMethodParameter(name="expirationTime", hint="New time at which the sliver is to expire, in RFC3339 format.") @Nonnull String expirationTimeRfc3339, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn, "expirationTimeRfc3339", expirationTimeRfc3339);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(expirationTimeRfc3339, "Illegal argument: expirationTime is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        Map<String, Object> options = AggregateManager2.createOptionsMap(extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(4);
        args.add(sliceUrn);
        args.add(credentialsList);
        args.add(expirationTimeRfc3339);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "renewSliver", "RenewSliver", args, resultValueObject -> {
            if (resultValueObject instanceof Boolean) {
                return (Boolean)resultValueObject;
            }
            if (resultValueObject instanceof Integer) {
                Integer rawResultInteger = (Integer)resultValueObject;
                if (rawResultInteger == 1) {
                    return true;
                }
                if (rawResultInteger == 0) {
                    return false;
                }
                throw new BadReplyGeniException("Unexpected integer to signify a boolean operation: " + rawResultInteger);
            }
            if (resultValueObject instanceof String) {
                return TextUtil.stringToBoolean((String)((String)resultValueObject));
            }
            throw new BadReplyGeniException("Expected an Integer or String as result, but got " + resultValueObject);
        });
    }

    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<Boolean> renewSliver(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn") @Nonnull String sliceUrn, @ApiMethodParameter(name="expirationTime") @Nonnull Date expirationTime, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Objects.requireNonNull(expirationTime, "Illegal argument: expirationTime is not allowed to be null");
        String expirationTimeRfc3339 = RFC3339Util.dateToRFC3339String((Date)expirationTime, (boolean)true, (boolean)true, (boolean)true);
        return this.renewSliver(con, credentialList, sliceUrn, expirationTimeRfc3339, extraOptions);
    }

    @ApiMethod(order=7, hint="Delete any slivers at the given aggregate belonging to the given slice, by stopping the resources if they are still running, and then deallocating the resources associated with the slice. When complete, this slice will own no resources on this aggregate - any such resources will have been stopped.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<Boolean> deleteSliver(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="mandatory list of credentials. This must include a valid credential for the slice.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="urn for the slice of which delete the sliver at this aggregate") @Nonnull String sliceUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        Map<String, Object> options = AggregateManager2.createOptionsMap(extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(sliceUrn);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "deleteSliver", "DeleteSliver", args, BOOLEAN_REPLY_CONVERTER);
    }

    @ApiMethod(order=8, hint="Perform an emergency shut down of a sliver or slivers at this aggregate belonging to the given slice. This operation is intended for administrative use. The sliver is shut down but remains available for further forensics.")
    @Nonnull
    public AbstractGeniAggregateManager.AggregateManagerReply<Boolean> shutdown(@Nonnull SfaConnection con, @ApiMethodParameter(name="credentialList", hint="Mandatory list of credentials, containing a credential authorizing this shutdown.") @Nonnull List<AnyCredential> credentialList, @ApiMethodParameter(name="sliceUrn", hint="URN for the slice of which shutdown the slivers at this aggregate") @Nonnull String sliceUrn, @ApiMethodParameter(name="extraOptions", hint="extra options", required=false, parameterType=ApiMethodParameterType.GENI_EXTRA_OPTIONS) @Nullable Map<String, Object> extraOptions) throws JFedException {
        Map<String, Object> methodParams = AggregateManager2.makeMethodParameters("credentialList", credentialList, "sliceUrn", sliceUrn);
        Objects.requireNonNull(credentialList, "Illegal argument: credentialList is not allowed to be null");
        Objects.requireNonNull(sliceUrn, "Illegal argument: sliceUrn is not allowed to be null");
        List<String> credentialsList = AggregateManager2.createCredentialsList(credentialList);
        Map<String, Object> options = AggregateManager2.createOptionsMap(extraOptions);
        ArrayList<Object> args = new ArrayList<Object>(3);
        args.add(sliceUrn);
        args.add(credentialsList);
        args.add(options);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "shutdown", "Shutdown", args, BOOLEAN_REPLY_CONVERTER);
    }

    public static class SliverStatus {
        protected static final SimpleDateFormat ORCA_EXPIRES_DATE_FORMAT = new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy", Locale.US);
        private final String urn;
        private final String status;
        private final List<ResourceStatus> resources;
        private Date pgExpires;
        private Date orcaExpires;
        private Date geniExpires;
        private Date foamExpires;
        private Date plExpires;
        private List<UserSpec> users = null;

        public SliverStatus(Object resultValueObject) throws BadReplyGeniException {
            String geniExpiresString;
            String plExpiresString;
            String foamExpiresString;
            Map<String, Object> val = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.urn = (String)val.get("geni_urn");
            this.status = (String)val.get("geni_status");
            String pgExpiresString = (String)val.get("pg_expires");
            if (pgExpiresString != null) {
                try {
                    int tIndex = pgExpiresString.indexOf(84);
                    String afterT = tIndex > 0 ? pgExpiresString.substring(tIndex) : pgExpiresString;
                    this.pgExpires = RFC3339Util.rfc3339StringToDate((String)(afterT.contains("Z") || afterT.contains("-") || afterT.contains("+") ? pgExpiresString : pgExpiresString + "Z"));
                }
                catch (ParseException e) {
                    LOG.warn("Note: AMv2 SliverStatus reply contained invalid date for pg_expires: \"" + pgExpiresString + "\" (note: assuming it is zulu time by appending Z!)", (Throwable)e);
                    this.pgExpires = null;
                }
            }
            if ((foamExpiresString = (String)val.get("foam_expires")) != null) {
                try {
                    this.foamExpires = RFC3339Util.iso8601StringToDate((String)foamExpiresString);
                }
                catch (ParseException e) {
                    try {
                        LOG.debug("Note: AMv2 SliverStatus reply contained invalid date for foam_expires: \"" + foamExpiresString + "\" -> will try fallback assuming timezone is missing", (Throwable)e);
                        this.foamExpires = RFC3339Util.iso8601StringToDate((String)(foamExpiresString + "Z"));
                    }
                    catch (ParseException e2) {
                        LOG.warn("Note: AMv2 SliverStatus reply contained invalid date for foam_expires: \"" + foamExpiresString + "\"", (Throwable)e2);
                        this.foamExpires = null;
                    }
                }
            }
            if ((plExpiresString = (String)val.get("pl_expires")) != null) {
                try {
                    this.plExpires = RFC3339Util.rfc3339StringToDate((String)(plExpiresString + "Z"));
                }
                catch (ParseException e) {
                    LOG.warn("Note: AMv2 SliverStatus reply contained invalid date for pl_expires: \"" + plExpiresString + "\"", (Throwable)e);
                    this.plExpires = null;
                }
            }
            if ((geniExpiresString = (String)val.get("geni_expires")) != null) {
                try {
                    this.geniExpires = RFC3339Util.rfc3339StringToDate((String)geniExpiresString);
                }
                catch (ParseException e) {
                    LOG.warn("Note: AMv2 SliverStatus reply contained invalid date for geni_expires: \"" + geniExpiresString + "\"", (Throwable)e);
                    this.geniExpires = null;
                }
            }
            this.resources = new ArrayList<ResourceStatus>();
            List<Map> vect = AbstractApi.apiSpecifiesListOfT(Map.class, val.get("geni_resources"));
            for (Map resourceHT : vect) {
                String u = (String)resourceHT.get("geni_urn");
                String s = (String)resourceHT.get("geni_status");
                String e = (String)resourceHT.get("geni_error");
                this.resources.add(new ResourceStatus(u, s, e));
                String orcaExpiresString = (String)resourceHT.get("orca_expires");
                if (orcaExpiresString == null) continue;
                try {
                    this.orcaExpires = ORCA_EXPIRES_DATE_FORMAT.parse(orcaExpiresString);
                }
                catch (ParseException ex) {
                    LOG.warn("Note: AMv2 SliverStatus reply date for orca_expires could not be parsed: \"" + orcaExpiresString + "\"", (Throwable)ex);
                    this.orcaExpires = null;
                }
                if (this.orcaExpires == null) {
                    try {
                        this.orcaExpires = RFC3339Util.rfc3339StringToDate((String)orcaExpiresString);
                    }
                    catch (ParseException ex) {
                        LOG.warn("Note: AMv2 SliverStatus reply contained invalid RFC3339 date for orca_expires: \"" + orcaExpiresString + "\"", (Throwable)ex);
                        this.orcaExpires = null;
                    }
                }
                LOG.info("processed orca_expires date \"" + orcaExpiresString + "\" to " + this.orcaExpires);
            }
            Object usersObject = val.get("users");
            if (usersObject != null) {
                try {
                    List<Map> usersVect = AbstractApi.apiSpecifiesListOfT(Map.class, usersObject);
                    this.users = new ArrayList<UserSpec>();
                    for (Map userHt : usersVect) {
                        String u = (String)userHt.get("geni_urn");
                        String l = (String)userHt.get("login");
                        ArrayList<String> keysResult = null;
                        if (u == null) {
                            u = (String)userHt.get("urn");
                        }
                        if (u == null) continue;
                        Object keysObject = userHt.get("keys");
                        if (keysObject != null) {
                            List<Map> keys = AbstractApi.apiSpecifiesListOfT(Map.class, keysObject);
                            keysResult = new ArrayList<String>();
                            for (Map keyHt : keys) {
                                String key = (String)keyHt.get("key");
                                String type = (String)keyHt.get("type");
                                if (!Objects.equals(type, "ssh")) {
                                    LOG.warn("Ignoring key of unknown type '{}' for user {}", (Object)type, (Object)u);
                                }
                                keysResult.add(key);
                            }
                        }
                        this.users.add(new LoginSpec(u, keysResult, l));
                    }
                }
                catch (Exception e) {
                    LOG.warn("Error parsing API extension. This is not a big problem. It will be ignored.", (Throwable)e);
                }
            }
        }

        public String getUrn() {
            return this.urn;
        }

        public String getStatus() {
            return this.status;
        }

        public List<ResourceStatus> getResources() {
            return this.resources;
        }

        public Date getPgExpires() {
            return this.pgExpires;
        }

        public Date getFoamExpires() {
            return this.foamExpires;
        }

        public Date getPlExpires() {
            return this.plExpires;
        }

        public Date getGeniExpires() {
            return this.geniExpires;
        }

        public Date getOrcaExpires() {
            return this.orcaExpires;
        }

        public Date getAnyExtExpires() {
            if (this.pgExpires != null) {
                return this.pgExpires;
            }
            if (this.orcaExpires != null) {
                return this.orcaExpires;
            }
            if (this.foamExpires != null) {
                return this.foamExpires;
            }
            if (this.geniExpires != null) {
                return this.geniExpires;
            }
            if (this.plExpires != null) {
                return this.plExpires;
            }
            return null;
        }

        public String toString() {
            return "SliverStatus{urn='" + this.urn + "', status='" + this.status + "', resources=" + this.resources + (String)(this.pgExpires == null ? "" : ", pgExpires=" + this.pgExpires) + (String)(this.foamExpires == null ? "" : ", foamExpires=" + this.foamExpires) + (String)(this.plExpires == null ? "" : ", plExpires=" + this.plExpires) + (String)(this.geniExpires == null ? "" : ", geniExpires=" + this.geniExpires) + (String)(this.orcaExpires == null ? "" : ", orcaExpires=" + this.orcaExpires) + "}";
        }

        @Nullable
        public List<UserSpec> getUsers() {
            return this.users;
        }

        public static class ResourceStatus {
            private final String urn;
            private final String status;
            private final String error;

            public ResourceStatus(String urn, String status, String error) {
                this.urn = urn;
                this.status = status;
                this.error = error;
            }

            public String getUrn() {
                return this.urn;
            }

            public String getStatus() {
                return this.status;
            }

            public String getError() {
                return this.error;
            }

            public String toString() {
                return "ResourceStatus{urn='" + this.urn + "', status='" + this.status + "', error='" + this.error + "'}";
            }
        }
    }

    public static class VersionInfo
    extends AbstractGeniAggregateManager.AbstractVersionInfo {
        private int api;
        private List<VersionPair> apiVersions;
        private List<RspecVersion> requestRspecVersions;
        private List<RspecVersion> adRspecVersions;

        public VersionInfo(Object resultValueObject) throws BadReplyGeniException {
            Map<String, Object> raw = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            Object apiObj = raw.get("geni_api");
            this.api = apiObj instanceof Integer ? (Integer)apiObj : -1;
            Map<String, String> apiVersionHT = AbstractApi.apiSpecifiesMapStringToString(raw.get("geni_api_versions"));
            this.apiVersions = new ArrayList<VersionPair>();
            for (Map.Entry<String, String> entry : apiVersionHT.entrySet()) {
                this.apiVersions.add(new VersionPair(entry.getKey(), entry.getValue()));
            }
            List<Map> requestRspecVersionsV = AbstractApi.apiSpecifiesListOfT(Map.class, raw.get("geni_request_rspec_versions"));
            this.requestRspecVersions = new ArrayList<RspecVersion>();
            for (Map h : requestRspecVersionsV) {
                try {
                    this.requestRspecVersions.add(new RspecVersion(h));
                }
                catch (BadReplyGeniException e) {
                    throw new GeniSpecificationNonconformityException("GetVersion", AggregateManager2.getApiName(), "rspec geni_request_rspec_versions struct does not contain all needed fields", (Exception)((Object)e));
                }
            }
            List<Map> list = AbstractApi.apiSpecifiesListOfT(Map.class, raw.get("geni_ad_rspec_versions"));
            this.adRspecVersions = new ArrayList<RspecVersion>();
            for (Map h : list) {
                try {
                    this.adRspecVersions.add(new RspecVersion(h));
                }
                catch (BadReplyGeniException e) {
                    throw new GeniSpecificationNonconformityException("GetVersion", AggregateManager2.getApiName(), "rspec geni_ad_rspec_versions struct does not contain all needed fields", (Exception)((Object)e));
                }
            }
        }

        @Override
        public int getApi() {
            return this.api;
        }

        public List<VersionPair> getApiVersions() {
            return this.apiVersions;
        }

        public List<RspecVersion> getRequestRspecVersions() {
            return this.requestRspecVersions;
        }

        public List<RspecVersion> getAdRspecVersions() {
            return this.adRspecVersions;
        }

        public String toString() {
            return "VersionInfo{api=" + this.api + ", apiVersions=" + this.apiVersions + ", requestRspecVersions=" + this.requestRspecVersions + ", adRspecVersions=" + this.adRspecVersions + "}";
        }

        public static class VersionPair {
            private final String url;
            private final String versionNr;

            private VersionPair(String versionNr, String url) {
                this.versionNr = versionNr;
                this.url = url;
            }

            public String getUrl() {
                return this.url;
            }

            public String getVersionNr() {
                return this.versionNr;
            }

            public String toString() {
                return "VersionPair{url='" + this.url + "', versionNr='" + this.versionNr + "'}";
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                VersionPair that = (VersionPair)o;
                if (this.url != null ? !Objects.equals(this.url, that.url) : that.url != null) {
                    return false;
                }
                return !(this.versionNr != null ? !Objects.equals(this.versionNr, that.versionNr) : that.versionNr != null);
            }

            public int hashCode() {
                int result = this.url != null ? this.url.hashCode() : 0;
                result = 31 * result + (this.versionNr != null ? this.versionNr.hashCode() : 0);
                return result;
            }
        }

        public static class RspecVersion {
            private final String type;
            private final String version;
            private final String schema;
            private final String namespace;
            private final List<String> extensions;

            private RspecVersion(Map ht) throws BadReplyGeniException {
                Map<String, Object> raw = AbstractApi.apiSpecifiesMapStringToObject(ht);
                this.type = AbstractApi.apiSpecifiesStringInMap(raw, "type");
                this.version = AbstractApi.apiSpecifiesStringInMap(raw, "version");
                this.schema = AbstractApi.apiSpecifiesStringInMap(raw, "schema");
                this.namespace = AbstractApi.apiSpecifiesStringInMap(raw, "namespace");
                this.extensions = AbstractApi.apiSpecifiesListOfT(String.class, ht.get("extensions"));
            }

            private RspecVersion(String type, String version, String schema, String namespace, List<String> extensions) {
                this.type = type;
                this.version = version;
                this.schema = schema;
                this.namespace = namespace;
                this.extensions = extensions;
            }

            public String getType() {
                return this.type;
            }

            public String getVersion() {
                return this.version;
            }

            public String getSchema() {
                return this.schema;
            }

            public String getNamespace() {
                return this.namespace;
            }

            public List<String> getExtensions() {
                ArrayList<String> res = new ArrayList<String>();
                for (String o : this.extensions) {
                    res.add(o);
                }
                return res;
            }

            public String toString() {
                return "RspecVersion{type='" + this.type + "', version='" + this.version + "', schema='" + this.schema + "', namespace='" + this.namespace + "', extensions=" + this.extensions + "}";
            }

            public boolean equalTypeAndVersion(RspecVersion o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (this.type != null ? !Objects.equals(this.type, o.type) : o.type != null) {
                    return false;
                }
                return !(this.version != null ? !Objects.equals(this.version, o.version) : o.version != null);
            }
        }
    }
}

