/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtoGeniClearingHouse1
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(ProtoGeniClearingHouse1.class);

    public static String getApiName() {
        return "ProtoGeni Clearing House API v1";
    }

    @Override
    @Nonnull
    public String getName() {
        return ProtoGeniClearingHouse1.getApiName();
    }

    public ProtoGeniClearingHouse1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_CH, 1), jFedPreferences);
    }

    public ProtoGeniClearingHouse1(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            int code = (Integer)geniDetails.getResultCode();
            try {
                return GeniAMResponseCode.getByCode((int)code).isBusy();
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code to determine if it is busy", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    protected <T> ClearingHouseReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter, null);
    }

    protected <T> ClearingHouseReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter, @Nullable T defaultValue) throws JFedException {
        ClearingHouseReply<T> r;
        XMLRPCCallDetailsWithCodeValueError res = this.executeXmlRpcCommandGeni(con, methodGeniName, args, methodParams == null ? Collections.emptyMap() : methodParams);
        Object resultValueObject = res.getResultValueObject();
        if (resultValueObject != null && !Objects.equals(resultValueObject, 0)) {
            try {
                r = new ClearingHouseReply<T>(res, replyConverter.convertXMLRPCCall(resultValueObject));
            }
            catch (AssertionError | Exception t) {
                this.handleErrorProcessingArguments(res, methodJavaName, methodGeniName, con, (Throwable)t);
                r = null;
            }
        } else {
            r = null;
        }
        if (r == null) {
            r = new ClearingHouseReply<T>(res, defaultValue);
        }
        this.log((XMLRPCCallDetails)res, (ApiCallReply)r, methodJavaName, methodGeniName, con, methodParams);
        return r;
    }

    protected void handleErrorProcessingArguments(XMLRPCCallDetailsWithCodeValueError res, String methodJavaName, String methodGeniName, SfaConnection con, Throwable t) throws JFedException {
        if (ProtoGeniClearingHouse1.isCallSuccess(res)) {
            this.log((XMLRPCCallDetails)res, null, methodJavaName, methodGeniName, con, null);
            throw new JFedException("Error parsing " + methodGeniName + " reply: " + (t == null ? "null" : t.getMessage()), t, (XMLRPCCallDetails)res);
        }
        LOG.error("Error parsing {} reply: {}", new Object[]{methodGeniName, t.getMessage(), t});
    }

    private static boolean isCallSuccess(XMLRPCCallDetailsWithCodeValueError res) {
        Object resultCode = res.getResultCode();
        if (!(resultCode instanceof Integer)) {
            return false;
        }
        try {
            GeniAMResponseCode genicode = GeniAMResponseCode.getByCode((int)((Integer)resultCode));
            return genicode.isSuccess();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @ApiMethod(order=1)
    @Nonnull
    public ClearingHouseReply<Integer> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", Collections.emptyList(), resultValueObject -> {
            if (resultValueObject != null) {
                if (resultValueObject instanceof Integer) {
                    return (Integer)resultValueObject;
                }
                throw new BadReplyGeniException("Expected an integer, but got a " + resultValueObject.getClass().getName() + " as result");
            }
            return null;
        });
    }

    @ApiMethod(order=2)
    public ClearingHouseReply<AnyCredential> getCredential(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getCredential", "GetCredential", Collections.emptyList(), resultValueObject -> {
            if (resultValueObject != null) {
                try {
                    return AnyCredential.createSfa2("ClearingHouse getCredential", resultValueObject.toString());
                }
                catch (CredentialException e) {
                    throw new BadReplyGeniException("Exception processing credential: " + e.getMessage(), e);
                }
            }
            throw new BadReplyGeniException("Expected a ClearingHouse Credential, but got null");
        });
    }

    @ApiMethod(order=3)
    public ClearingHouseReply<List<ComponentInfo>> listComponents(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential") @Nonnull AnyCredential credential) throws JFedException {
        Map<String, Object> methodParams = ProtoGeniClearingHouse1.makeMethodParameters("userCredential", (Object)credential);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("credential", credential.getCredentialXml());
        List<Object> args = Collections.singletonList(params);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "listComponents", "ListComponents", args, resultValueObject -> {
            List<Map> componentsV = ProtoGeniClearingHouse1.apiSpecifiesListOfT(Map.class, resultValueObject);
            ArrayList<ComponentInfo> compList = new ArrayList<ComponentInfo>();
            for (Map ht : componentsV) {
                compList.add(new ComponentInfo(ht));
            }
            return compList;
        });
    }

    public static class ClearingHouseReply<T>
    implements SfaApiCallReply<T> {
        @Nonnull
        private final GeniAMResponseCode genicode;
        private final T val;
        private final String output;
        private final Map rawResult;
        private final XMLRPCCallDetailsWithCodeValueError xmlRpcDetails;

        public int getCode() {
            return this.genicode.getCode();
        }

        @Nonnull
        public GeniAMResponseCode getGeniResponseCode() {
            return this.genicode;
        }

        public T getValue() {
            return this.val;
        }

        public String getOutput() {
            return this.output;
        }

        public Map getRawResult() {
            return this.rawResult;
        }

        public ClearingHouseReply(XMLRPCCallDetailsWithCodeValueError res, T val) {
            GeniAMResponseCode genicode;
            this.xmlRpcDetails = res;
            this.rawResult = res.getResult();
            int intCode = (Integer)res.getResultCode();
            try {
                genicode = GeniAMResponseCode.getByCode((int)intCode);
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code", (Throwable)e);
                genicode = GeniAMResponseCode.SERVER_REPLY_ERROR;
            }
            this.genicode = genicode;
            this.val = val;
            this.output = res.getResultOutput();
        }

        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xmlRpcDetails;
        }

        public XMLRPCCallDetailsWithCodeValueError getXMLRPCCallDetailsWithCodeValueError() {
            return this.xmlRpcDetails;
        }

        @Nullable
        public Object getRawValue() {
            if (this.rawResult == null) {
                return null;
            }
            return this.rawResult.get("value");
        }
    }

    public static class ComponentInfo {
        private final Gid gid;
        private final String hrn;
        private final String url;
        private final String urn;

        public ComponentInfo(Map ht) {
            this.gid = new Gid(ht.get("gid").toString());
            this.hrn = ht.get("hrn").toString();
            this.url = ht.get("url").toString();
            this.urn = ht.get("urn").toString();
        }

        public Gid getGid() {
            return this.gid;
        }

        public String getHrn() {
            return this.hrn;
        }

        public String getUrl() {
            return this.url;
        }

        public String getUrn() {
            return this.urn;
        }

        public String toString() {
            return "ComponentInfo{gid='" + this.gid + "', hrn='" + this.hrn + "', url='" + this.url + "'}";
        }
    }
}

