/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.connection.ApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetailsWithCodeValueError;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.lib.BadReplyGeniException;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.lib.Gid;
import be.iminds.ilabt.jfed.lowlevel.lib.ReplyConverter;
import be.iminds.ilabt.jfed.lowlevel.lib.RetrySettings;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtogeniSliceAuthority
extends AbstractApi {
    private static final Logger LOG = LoggerFactory.getLogger(ProtogeniSliceAuthority.class);
    protected static final ReplyConverter<Boolean> INTEGER_AS_BOOLEAN_REPLY_CONVERTER = resultValueObject -> {
        if (resultValueObject instanceof Integer) {
            return Integer.compare((Integer)resultValueObject, 0) != 0;
        }
        throw new BadReplyGeniException("Expected an integer as a result, but got " + resultValueObject);
    };

    public ProtogeniSliceAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull RetrySettings retrySettings, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, retrySettings, new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1), jFedPreferences);
    }

    public ProtogeniSliceAuthority(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        this(logger, jFedPreferences.getRetrySettings(), jFedPreferences);
    }

    public static List createCredentialsList(List<AnyCredential> credentialList) {
        return AggregateManager2.createCredentialsList(credentialList);
    }

    public static String getApiName() {
        return "ProtoGeni Slice Authority API v1";
    }

    private static void addCredentialParameter(@Nonnull List<AnyCredential> credentials, boolean forceSingleCredential, Map<String, Object> params) {
        if (forceSingleCredential) {
            if (credentials.isEmpty()) {
                throw new IllegalArgumentException("Asked to send a single credential, but got none");
            }
            params.put("credential", credentials.get(0).getCredentialXml());
        } else {
            params.put("credentials", ProtogeniSliceAuthority.createCredentialsList(credentials));
        }
    }

    @Nonnull
    private static AnyCredential parseCredentialResult(String credentialName, Object resultValueObject) throws BadReplyGeniException {
        if (resultValueObject != null) {
            try {
                return AnyCredential.createSfa2(credentialName, resultValueObject.toString());
            }
            catch (Exception e) {
                throw new BadReplyGeniException("Error parsing result credential '" + credentialName + "':" + e.getMessage(), e);
            }
        }
        throw new BadReplyGeniException("Expected credential '" + credentialName + "', but got null");
    }

    @Override
    @Nonnull
    public String getName() {
        return ProtogeniSliceAuthority.getApiName();
    }

    protected <T> SliceAuthorityReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, methodJavaName, methodGeniName, args, replyConverter, null);
    }

    protected <T> SliceAuthorityReply<T> executeAndLogXmlRpcCommandGeni(@Nullable Map<String, Object> methodParams, @Nonnull SfaConnection con, @Nonnull String methodJavaName, @Nonnull String methodGeniName, @Nonnull List<Object> args, @Nonnull ReplyConverter<T> replyConverter, @Nullable T defaultValue) throws JFedException {
        SliceAuthorityReply<T> r;
        XMLRPCCallDetailsWithCodeValueError res = this.executeXmlRpcCommandGeni(con, methodGeniName, args, methodParams == null ? Collections.emptyMap() : methodParams);
        Object resultValueObject = res.getResultValueObject();
        if (resultValueObject != null && !Objects.equals(resultValueObject, 0)) {
            try {
                r = new SliceAuthorityReply<T>(res, replyConverter.convertXMLRPCCall(resultValueObject));
            }
            catch (AssertionError | Exception t) {
                this.handleErrorProcessingArguments(res, methodJavaName, methodGeniName, con, (Throwable)t);
                r = null;
            }
        } else {
            r = null;
        }
        if (r == null) {
            r = new SliceAuthorityReply<T>(res, defaultValue);
        }
        this.log((XMLRPCCallDetails)res, (ApiCallReply)r, methodJavaName, methodGeniName, con, methodParams);
        return r;
    }

    protected void handleErrorProcessingArguments(XMLRPCCallDetailsWithCodeValueError res, String methodJavaName, String methodGeniName, SfaConnection con, Throwable t) throws JFedException {
        if (ProtogeniSliceAuthority.isCallSuccess(res)) {
            this.log((XMLRPCCallDetails)res, null, methodJavaName, methodGeniName, con, null);
            throw new JFedException("Error parsing " + methodGeniName + " reply: " + (t == null ? "null" : t.getMessage()), t, (XMLRPCCallDetails)res);
        }
        LOG.error("Error parsing {} reply: {}", new Object[]{methodGeniName, t.getMessage(), t});
    }

    private static boolean isCallSuccess(XMLRPCCallDetailsWithCodeValueError res) {
        Object resultCode = res.getResultCode();
        if (!(resultCode instanceof Integer)) {
            return false;
        }
        try {
            GeniAMResponseCode genicode = GeniAMResponseCode.getByCode((int)((Integer)resultCode));
            return genicode.isSuccess();
        }
        catch (Exception ignored) {
            return false;
        }
    }

    @Override
    protected boolean isBusyReply(XMLRPCCallDetails res) {
        if (res instanceof XMLRPCCallDetailsWithCodeValueError) {
            XMLRPCCallDetailsWithCodeValueError geniDetails = (XMLRPCCallDetailsWithCodeValueError)res;
            int code = (Integer)geniDetails.getResultCode();
            try {
                return GeniAMResponseCode.getByCode((int)code).isBusy();
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code to determine if it is busy", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @ApiMethod(order=1, hint="GetVersion call: Get info about the version of the API supported at the server.")
    public SliceAuthorityReply<String> getVersion(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getVersion", "get_version", new ArrayList<Object>(), STRING_REPLY_CONVERTER);
    }

    @ApiMethod(order=2, hint="GetCredential call, without arguments: Get the credential of the current user.")
    public SliceAuthorityReply<AnyCredential> getCredential(@Nonnull SfaConnection con) throws JFedException {
        return this.executeAndLogXmlRpcCommandGeni(null, con, "getCredential", "GetCredential", new ArrayList<Object>(), resultValueObject -> {
            if (resultValueObject != null) {
                try {
                    return AnyCredential.createSfa2("SliceAuthority getCredential", resultValueObject.toString());
                }
                catch (CredentialException e) {
                    throw new BadReplyGeniException("Exception processing credential: " + e.getMessage(), e);
                }
            }
            throw new BadReplyGeniException("Expected a ClearingHouse Credential, but got null");
        });
    }

    @ApiMethod(order=3, hint="GetCredential call, with a slice ID arguments: Get the credential of the specified slice.")
    public SliceAuthorityReply<AnyCredential> getSliceCredential(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential for the user requesting the slice credential") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="slice", hint="a slice ID (typically the slice URN).") @Nonnull ResourceId slice) throws JFedException {
        return this.getSliceCredential(con, userCredential.toCredentialList(), true, slice);
    }

    @ApiMethod(order=4, hint="GetCredential call, with a slice ID arguments: Get the credential of the specified slice.")
    public SliceAuthorityReply<AnyCredential> getSliceCredential(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredentials", hint="a list of credentials for the user requesting the slice credential") @Nullable List<AnyCredential> userCredentials, @ApiMethodParameter(name="slice", hint="a slice ID (typically the slice URN).") @Nonnull ResourceId slice) throws JFedException {
        return this.getSliceCredential(con, userCredentials, false, slice);
    }

    protected SliceAuthorityReply<AnyCredential> getSliceCredential(@Nonnull SfaConnection con, @Nullable List<AnyCredential> userCredentials, boolean forceSendSingleCredential, @Nonnull ResourceId slice) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("userCredential", userCredentials != null && !userCredentials.isEmpty() ? userCredentials.get(0) : null, "slice", slice) : ProtogeniSliceAuthority.makeMethodParameters("userCredentials", userCredentials, "slice", slice);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(slice.getType(), slice.getValue());
        params.put("type", "Slice");
        if (userCredentials != null) {
            ProtogeniSliceAuthority.addCredentialParameter(userCredentials, forceSendSingleCredential, params);
        }
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "getSliceCredential", "GetCredential", Collections.singletonList(params), resultValueObject -> ProtogeniSliceAuthority.parseCredentialResult("SliceAuthority getSliceCredential", resultValueObject));
    }

    @ApiMethod(order=5, hint="GetCredential call, with any type: Get the credential for an object of the specified type.")
    public SliceAuthorityReply<AnyCredential> getAnyCredential(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential for the user requesting the slice credential") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="type", hint="the type of object for which to request a credential (for example \"Slice\")", guiDefault="Slice", required=false) @Nullable String type, @ApiMethodParameter(name="resource", hint="an ID (typically an URN or UUID).", required=false) @Nullable ResourceId object) throws JFedException {
        return this.getAnyCredential(con, userCredential.toCredentialList(), true, type, object);
    }

    @ApiMethod(order=6, hint="GetCredential call, with any type: Get the credential for an object of the specified type.")
    public SliceAuthorityReply<AnyCredential> getAnyCredential(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredentials", hint="a list of credentials for the user requesting a credential", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) List<AnyCredential> userCredentials, @ApiMethodParameter(name="type", hint="the type of object for which to request a credential (for example \"Slice\")", guiDefault="Slice", required=false) @Nullable String type, @ApiMethodParameter(name="object", hint="an ID (typically an URN or UUID).", required=false) @Nullable ResourceId object) throws JFedException {
        return this.getAnyCredential(con, userCredentials, false, type, object);
    }

    public SliceAuthorityReply<AnyCredential> getAnyCredential(@Nonnull SfaConnection con, @Nullable List<AnyCredential> userCredentials, boolean forceSendSingleCredential, @Nullable String type, @Nullable ResourceId object) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("userCredential", userCredentials != null && !userCredentials.isEmpty() ? userCredentials.get(0) : null, "type", type, "object", object) : ProtogeniSliceAuthority.makeMethodParameters("userCredentials", userCredentials, "type", type, "object", object);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (object != null) {
            params.put(object.getType(), object.getValue());
        }
        if (type != null) {
            params.put("type", type);
        }
        if (userCredentials != null) {
            ProtogeniSliceAuthority.addCredentialParameter(userCredentials, forceSendSingleCredential, params);
        }
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "getAnyCredential", "GetCredential", Collections.singletonList(params), resultValueObject -> ProtogeniSliceAuthority.parseCredentialResult("SliceAuthority getAnyCredential for type " + type, resultValueObject));
    }

    @ApiMethod(order=10, hint="Resolve call, with a slice ID arguments: Get info about the specified slice.")
    public SliceAuthorityReply<SliceInfo> resolveSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential for the user requesting the info") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="slice", hint="a slice ID (typically the slice URN).") @Nonnull ResourceId slice) throws JFedException {
        return this.resolveSlice(con, userCredential.toCredentialList(), true, slice);
    }

    @ApiMethod(order=11, hint="Resolve call, with a slice ID arguments: Get info about the specified slice.")
    public SliceAuthorityReply<SliceInfo> resolveSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredentials", hint="a list of credentials for the user requesting the info") @Nonnull List<AnyCredential> userCredentials, @ApiMethodParameter(name="slice", hint="a slice ID (typically the slice URN).") @Nonnull ResourceId slice) throws JFedException {
        return this.resolveSlice(con, userCredentials, false, slice);
    }

    public SliceAuthorityReply<SliceInfo> resolveSlice(@Nonnull SfaConnection con, @Nonnull List<AnyCredential> userCredentials, boolean forceSendSingleCredential, @Nonnull ResourceId slice) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("userCredential", !userCredentials.isEmpty() ? userCredentials.get(0) : null, "slice", slice) : ProtogeniSliceAuthority.makeMethodParameters("userCredentials", userCredentials, "slice", slice);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(slice.getType(), slice.getValue());
        ProtogeniSliceAuthority.addCredentialParameter(userCredentials, forceSendSingleCredential, params);
        params.put("type", "Slice");
        List<Object> args = Collections.singletonList(params);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "resolveSlice", "Resolve", args, SliceInfo::new);
    }

    @ApiMethod(order=12, hint="Resolve call, with a user ID arguments: Get info about the specified user.")
    public SliceAuthorityReply<UserInfo> resolveUser(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential for the user requesting the info") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="user", hint="a user ID (typically the user URN).") @Nonnull ResourceId user) throws JFedException {
        return this.resolveUser(con, userCredential.toCredentialList(), true, user);
    }

    @ApiMethod(order=13, hint="Resolve call, with a user ID arguments: Get info about the specified user.")
    public SliceAuthorityReply<UserInfo> resolveUser(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredentials", hint="a list of credentials for the user requesting the info", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> userCredentials, @ApiMethodParameter(name="user", hint="a user ID (typically the user URN).") @Nonnull ResourceId user) throws JFedException {
        return this.resolveUser(con, userCredentials, false, user);
    }

    public SliceAuthorityReply<UserInfo> resolveUser(@Nonnull SfaConnection con, @Nonnull List<AnyCredential> userCredentials, boolean forceSendSingleCredential, @Nonnull ResourceId user) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("userCredential", !userCredentials.isEmpty() ? userCredentials.get(0) : null, "user", user) : ProtogeniSliceAuthority.makeMethodParameters("userCredentials", userCredentials, "user", user);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(user.getType(), user.getValue());
        ProtogeniSliceAuthority.addCredentialParameter(userCredentials, forceSendSingleCredential, params);
        params.put("type", "User");
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "resolveUser", "Resolve", Collections.singletonList(params), UserInfo::new);
    }

    private static List<GeniUrn> processListOfSlicesReply(Object resultObjectValue) throws BadReplyGeniException {
        Map<String, Object> ht = ProtogeniSliceAuthority.apiSpecifiesMapStringToObject(resultObjectValue);
        List<String> slicesVect = ProtogeniSliceAuthority.apiSpecifiesListOfString(ht.get("slices"));
        ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
        for (String s : slicesVect) {
            try {
                res.add(new GeniUrn(s));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                throw new BadReplyGeniException("Not a slice urn: '" + s + "'");
            }
        }
        return res;
    }

    @ApiMethod(order=14, hint="Resolve call, with a free URN and type arguments: Get info about a specified object.")
    public SliceAuthorityReply<Map<String, Object>> resolveAny(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential for the user requesting the info") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="target", hint="an URN") @Nonnull ResourceId target, @ApiMethodParameter(name="type", hint="the type to resolve.") @Nonnull String type) throws JFedException {
        Map<String, Object> methodParams = ProtogeniSliceAuthority.makeMethodParameters("userCredential", userCredential, "target", target, "type", type);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(target.getType(), target.getValue());
        params.put("credential", userCredential.getCredentialXml());
        params.put("type", type);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "resolveAny", "Resolve", Collections.singletonList(params), AbstractApi::apiSpecifiesMapStringToObject);
    }

    @ApiMethod(order=20, hint="BindToSlice call: give another user permission to use a slice.")
    public SliceAuthorityReply<Boolean> bindToSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredential", hint="the credential for the slice to be shared") @Nonnull AnyCredential sliceCredential, @ApiMethodParameter(name="user", hint="the ID of the user which will get permission to use this slice (typically the other user's URN).") @Nonnull ResourceId user) throws JFedException {
        return this.bindToSlice(con, sliceCredential.toCredentialList(), true, user);
    }

    @ApiMethod(order=20, hint="BindToSlice call: give another user permission to use a slice.")
    public SliceAuthorityReply<Boolean> bindToSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredentials", hint="a list if credentials for the slice to be shared") @Nonnull List<AnyCredential> sliceCredentials, @ApiMethodParameter(name="user", hint="the ID of the user which will get permission to use this slice (typically the other user's URN).") @Nonnull ResourceId user) throws JFedException {
        return this.bindToSlice(con, sliceCredentials, false, user);
    }

    public SliceAuthorityReply<Boolean> bindToSlice(@Nonnull SfaConnection con, @Nonnull List<AnyCredential> sliceCredentials, boolean forceSendSingleCredential, @Nonnull ResourceId user) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("sliceCredential", !sliceCredentials.isEmpty() ? sliceCredentials.get(0) : null, "user", user) : ProtogeniSliceAuthority.makeMethodParameters("sliceCredentials", sliceCredentials, "user", user);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(user.getType(), user.getValue());
        ProtogeniSliceAuthority.addCredentialParameter(sliceCredentials, forceSendSingleCredential, params);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "bindToSlice", "BindToSlice", Collections.singletonList(params), INTEGER_AS_BOOLEAN_REPLY_CONVERTER);
    }

    @ApiMethod(order=25, hint="Register call: create a new slice.")
    public SliceAuthorityReply<AnyCredential> register(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential of the user creating this slice.") AnyCredential userCredential, @ApiMethodParameter(name="slice", hint="the URN of the new slice (urn syntax: urn:publicid:IDN+<AUTHORITY>+slice+<SLICENAME>)") ResourceUrn slice) throws JFedException {
        return this.register(con, userCredential.toCredentialList(), true, slice);
    }

    @ApiMethod(order=26, hint="Register call: create a new slice.")
    public SliceAuthorityReply<AnyCredential> register(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredentials", hint="a list of credentials of the user creating this slice.", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) List<AnyCredential> userCredentials, @ApiMethodParameter(name="slice", hint="the URN of the new slice (urn syntax: urn:publicid:IDN+<AUTHORITY>+slice+<SLICENAME>)") ResourceUrn slice) throws JFedException {
        return this.register(con, userCredentials, false, slice);
    }

    public SliceAuthorityReply<AnyCredential> register(@Nonnull SfaConnection con, @Nonnull List<AnyCredential> userCredentials, boolean forceSendSingleCredential, @Nonnull ResourceUrn slice) throws JFedException {
        assert (!userCredentials.isEmpty());
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("userCredential", !userCredentials.isEmpty() ? userCredentials.get(0) : null, "slice", slice) : ProtogeniSliceAuthority.makeMethodParameters("userCredentials", userCredentials, "slice", slice);
        if (!Objects.equals(slice.getType(), "urn")) {
            throw new JFedException("Bad type for ResourceId slice (\"" + slice.getType() + "\"). Only \"urn\" is supported here");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "Slice");
        ProtogeniSliceAuthority.addCredentialParameter(userCredentials, forceSendSingleCredential, params);
        params.put(slice.getType(), slice.getValue());
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "register", "Register", Collections.singletonList(params), resultValueObject -> ProtogeniSliceAuthority.parseCredentialResult("SliceAuthority register " + slice.getValue(), resultValueObject));
    }

    @ApiMethod(order=30, hint="RenewSlice call: Change the expiration date of a slice.")
    public SliceAuthorityReply<AnyCredential> renewSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredential", hint="the credential for the slice to be renewed") @Nonnull AnyCredential sliceCredential, @ApiMethodParameter(name="expiration_rfc3339", hint="A string with the new experiation date, in RFC3339 format.") @Nonnull String expiration_rfc3339) throws JFedException {
        return this.renewSlice(con, sliceCredential.toCredentialList(), true, expiration_rfc3339);
    }

    @ApiMethod(order=31, hint="RenewSlice call: Change the expiration date of a slice.")
    public SliceAuthorityReply<AnyCredential> renewSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredentials", hint="the credential for the slice to be renewed", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials, @ApiMethodParameter(name="expiration_rfc3339", hint="A string with the new experiation date, in RFC3339 format.") @Nonnull String expiration_rfc3339) throws JFedException {
        return this.renewSlice(con, sliceCredentials, false, expiration_rfc3339);
    }

    public SliceAuthorityReply<AnyCredential> renewSlice(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredentials", hint="the credential for the slice to be renewed", parameterType=ApiMethodParameterType.LIST_OF_CREDENTIAL) @Nonnull List<AnyCredential> sliceCredentials, boolean forceSendSingleCredential, @Nonnull String expiration_rfc3339) throws JFedException {
        Map<String, Object> methodParams = forceSendSingleCredential ? ProtogeniSliceAuthority.makeMethodParameters("sliceCredential", !sliceCredentials.isEmpty() ? sliceCredentials.get(0) : null, "expiration_rfc3339", expiration_rfc3339) : ProtogeniSliceAuthority.makeMethodParameters("sliceCredentials", sliceCredentials, "expiration_rfc3339", expiration_rfc3339);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expiration", expiration_rfc3339);
        ProtogeniSliceAuthority.addCredentialParameter(sliceCredentials, forceSendSingleCredential, params);
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "renewSlice", "RenewSlice", Collections.singletonList(params), resultValueObject -> ProtogeniSliceAuthority.parseCredentialResult("SliceAuthority renewSlice", resultValueObject));
    }

    @ApiMethod(order=40, hint="API description:\nPerform an emergency shutdown on a slice, by asking the SA (for that slice) to do an emergency shutdown. Operationally, the request is forwarded to the ClearingHouse which knows the full set of Component Managers. The call returns once the ClearingHouse is notified; the ClearingHouse will process the request asynchronously.\n\nClearinghouse API description:\nPerform an emergency shutdown on a slice. This is typically invoked by the Slice Authority for the slice, but may be invoked by anyone with a clearinghouse credential (this needs to change to allow anyone with a valid slice credential). As it stands, anyone with a slice credential can contact the Slice Authority for the slice, and ask it to do the shutown operation.\nSince the Clearinghouse must contact each Component Manager to tell it to shutdown the slice, this call will return immediately. There is currently no facility to find out if/when the shutdown has completed.\n")
    public SliceAuthorityReply<Boolean> shutdown(@Nonnull SfaConnection con, @ApiMethodParameter(name="sliceCredential", hint="The credential of the slice to shut down.") @Nonnull AnyCredential sliceCredential) throws JFedException {
        Map<String, Object> methodParams = ProtogeniSliceAuthority.makeMethodParameters("sliceCredential", (Object)sliceCredential);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("credential", sliceCredential.getCredentialXml());
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "shutdown", "Shutdown", Collections.singletonList(params), INTEGER_AS_BOOLEAN_REPLY_CONVERTER);
    }

    @ApiMethod(order=50, hint="GetKeys call: Get the public SSH key()s of a user.")
    public SliceAuthorityReply<List<String>> getKeys(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="the credential of the user retrieving ssh keys") @Nonnull AnyCredential userCredential) throws JFedException {
        Map<String, Object> methodParams = ProtogeniSliceAuthority.makeMethodParameters("userCredential", (Object)userCredential);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("credential", userCredential.getCredentialXml());
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "getKeys", "GetKeys", Collections.singletonList(params), resultValueObject -> {
            List<Object> keysV = ProtogeniSliceAuthority.apiSpecifiesListOfT(Object.class, resultValueObject);
            ArrayList<String> keyList = new ArrayList<String>();
            for (Object key : keysV) {
                if (key instanceof String) {
                    keyList.add((String)key);
                    continue;
                }
                if (key instanceof Map) {
                    Map t = (Map)key;
                    String type = (String)t.get("type");
                    if (!Objects.equals(type, "ssh")) {
                        LOG.warn("Key is Map with non 'ssh' type: " + t);
                    }
                    keyList.add((String)t.get("key"));
                    continue;
                }
                throw new BadReplyGeniException("Unexpected type " + key.getClass().getName() + " for user key (val=" + key.toString() + ")");
            }
            return keyList;
        });
    }

    @ApiMethod(order=60, hint=" Remove call: remove a slice.\n\nNote: at the time of writing this documentation, remove was not implemented at the server.")
    public SliceAuthorityReply<Boolean> remove(@Nonnull SfaConnection con, @ApiMethodParameter(name="userCredential", hint="The credential of the user removing a slice.") @Nonnull AnyCredential userCredential, @ApiMethodParameter(name="slice", hint="The ID of the slice to be removed (typically the slice URN).") @Nonnull ResourceId slice) throws JFedException {
        Map<String, Object> methodParams = ProtogeniSliceAuthority.makeMethodParameters("userCredential", userCredential, "slice", slice);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", "Slice");
        params.put("credential", userCredential.getCredentialXml());
        params.put(slice.getType(), slice.getValue());
        return this.executeAndLogXmlRpcCommandGeni(methodParams, con, "remove", "Remove", Collections.singletonList(params), INTEGER_AS_BOOLEAN_REPLY_CONVERTER);
    }

    public static class SliceAuthorityReply<T>
    implements SfaApiCallReply<T> {
        @Nonnull
        private final GeniAMResponseCode genicode;
        private final T val;
        private final String output;
        private final Map rawResult;
        private final XMLRPCCallDetailsWithCodeValueError xmlrpcCallDetails;

        public SliceAuthorityReply(XMLRPCCallDetailsWithCodeValueError res, T val) {
            GeniAMResponseCode genicode;
            this.xmlrpcCallDetails = res;
            this.rawResult = res.getResult();
            int intCode = (Integer)res.getResultCode();
            try {
                genicode = GeniAMResponseCode.getByCode((int)intCode);
            }
            catch (UnknownResponseCodeException e) {
                LOG.warn("Did not recognise AM response code", (Throwable)e);
                genicode = GeniAMResponseCode.SERVER_REPLY_ERROR;
            }
            this.genicode = genicode;
            this.val = val;
            this.output = res.getResultOutput();
        }

        public int getCode() {
            return this.genicode.getCode();
        }

        @Nonnull
        public GeniAMResponseCode getGeniResponseCode() {
            return this.genicode;
        }

        @Nullable
        public Map getRawResult() {
            return this.rawResult;
        }

        @Nullable
        public T getValue() {
            return this.val;
        }

        @Nullable
        public String getOutput() {
            return this.output;
        }

        @Nullable
        public XMLRPCCallDetailsWithCodeValueError getXMLRPCCallDetailsWithCodeValueError() {
            return this.xmlrpcCallDetails;
        }

        @Nullable
        public XMLRPCCallDetails getXMLRPCCallDetails() {
            return this.xmlrpcCallDetails;
        }

        @Nullable
        public Object getRawValue() {
            if (this.rawResult == null) {
                return null;
            }
            return this.rawResult.get("value");
        }
    }

    public static class UserInfo {
        private final String uid;
        private final String name;
        private final String uuid;
        private final String email;
        private final String hrn;
        private final String urn;
        private final List<GeniUrn> slices;
        @Nonnull
        private final Map<GeniUrn, String> subAuthorities;
        @Nullable
        private final X509Certificate certificate;

        public UserInfo(Object resultValueObject) throws BadReplyGeniException {
            Map<String, Object> ht = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.uid = AbstractApi.apiSpecifiesNullableString(ht.get("uid"));
            this.name = AbstractApi.apiSpecifiesNullableString(ht.get("name"));
            this.uuid = AbstractApi.apiSpecifiesNullableString(ht.get("uuid"));
            this.email = AbstractApi.apiSpecifiesNullableString(ht.get("email"));
            this.urn = AbstractApi.apiSpecifiesNullableString(ht.get("urn"));
            this.hrn = AbstractApi.apiSpecifiesNullableString(ht.get("hrn"));
            List<String> slicesVect = AbstractApi.apiSpecifiesListOfString(ht.get("slices"));
            this.slices = new ArrayList<GeniUrn>();
            for (String s : slicesVect) {
                try {
                    this.slices.add(new GeniUrn(s));
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    throw new BadReplyGeniException("Not a valid slice urn: '" + s + "'");
                }
            }
            if (ht.containsKey("subauthorities")) {
                Map<String, String> subAuthHt = AbstractApi.apiSpecifiesMapStringToString(ht.get("subauthorities"));
                this.subAuthorities = new HashMap<GeniUrn, String>();
                for (Map.Entry<String, String> entry : subAuthHt.entrySet()) {
                    GeniUrn urn;
                    String urnStr = entry.getKey();
                    String urlStr = entry.getValue();
                    try {
                        urn = new GeniUrn(urnStr);
                    }
                    catch (GeniUrn.GeniUrnParseException e) {
                        throw new BadReplyGeniException("Not a valid subAuthority urn: '" + urnStr + "'");
                    }
                    String subAuthName = urn.getEncodedSubAuthName();
                    this.subAuthorities.put(urn, urlStr);
                }
            } else {
                LOG.warn("resolveUser did not return 'subauthorities'");
                this.subAuthorities = Collections.emptyMap();
            }
            if (ht.containsKey("gid")) {
                String gid = AbstractApi.apiSpecifiesNonNullString(ht.get("gid"));
                this.certificate = KeyUtil.pemToX509Certificate((String)gid);
            } else {
                LOG.warn("resolveUser did not return 'gid'");
                this.certificate = null;
            }
        }

        public List<GeniUrn> getSlices() {
            return this.slices;
        }

        @Nonnull
        public Map<GeniUrn, String> getSubAuthorities() {
            return this.subAuthorities;
        }

        @Nullable
        public X509Certificate getCertificate() {
            return this.certificate;
        }
    }

    public static class SliceInfo {
        private final GeniUrn sliceUrn;
        private final String uuid;
        private final String creatorUuid;
        private final GeniUrn creatorUrn;
        private final Gid gid;
        private final List<GeniUrn> componentManagers;

        public SliceInfo(Object resultValueObject) throws BadReplyGeniException {
            Map<String, Object> ht = AbstractApi.apiSpecifiesMapStringToObject(resultValueObject);
            this.sliceUrn = AbstractApi.apiSpecifiesGeniUrnInMap(ht, "urn");
            this.uuid = AbstractApi.apiSpecifiesStringInMap(ht, "uuid");
            this.creatorUuid = AbstractApi.apiSpecifiesStringInMap(ht, "creator_uuid");
            this.creatorUrn = AbstractApi.apiSpecifiesGeniUrnInMap(ht, "creator_urn");
            this.gid = new Gid(AbstractApi.apiSpecifiesStringInMap(ht, "gid"));
            List<String> cmV = AbstractApi.apiSpecifiesListOfString(ht.get("component_managers"));
            this.componentManagers = new ArrayList<GeniUrn>();
            for (String cmUrn : cmV) {
                this.componentManagers.add(AbstractApi.apiSpecifiesGeniUrn(cmUrn));
            }
        }

        public GeniUrn getSliceUrn() {
            return this.sliceUrn;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getCreatorUuid() {
            return this.creatorUuid;
        }

        public GeniUrn getCreatorUrn() {
            return this.creatorUrn;
        }

        public Gid getGid() {
            return this.gid;
        }

        public List<GeniUrn> getComponentManagers() {
            return this.componentManagers;
        }
    }
}

