/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api;

import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpCallDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameter;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethodParameterType;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.GeniUrnTypeAdapter;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReputationService
extends RestApi {
    private static final Logger LOG = LoggerFactory.getLogger(ReputationService.class);
    public static final String SERVICE_AVAILABILITY = "availability";
    public static final String SERVICE_OVERALL = "overall";
    public static final String SERVICE_QUALITY = "quality";
    private static final Type SERVICES_MAP_TYPE = new TypeToken<Map<String, Double>>(){}.getType();
    private final Gson gson;

    public ReputationService(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, new ApiInfo.Api(ApiInfo.ApiName.FED4FIRE_SLA_COLLECTOR, 1), jFedPreferences);
        GsonBuilder builder = new GsonBuilder();
        builder.setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);
        builder.registerTypeAdapter(Date.class, (Object)new DateRFC3339Adapter());
        builder.registerTypeAdapter(GeniUrn.class, (Object)new GeniUrnTypeAdapter());
        builder.registerTypeAdapter(SERVICES_MAP_TYPE, (Object)new ServicesMapTypeAdapter());
        this.gson = builder.create();
    }

    @Override
    @Nonnull
    public String getName() {
        return ReputationService.getApiName();
    }

    public static String getApiName() {
        return "Reputation Service";
    }

    @ApiMethod(order=1, hint="POST")
    public RestApi.RestReply<List<SliceReputation>> registerExperiment(@Nonnull HttpConnection con, @ApiMethodParameter(name="User URN", parameterType=ApiMethodParameterType.USER_URN, hint="User URN") @Nonnull GeniUrn userUrn, @ApiMethodParameter(name="Slice URN", parameterType=ApiMethodParameterType.SLICE_URN, hint="Slice URN") @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="Start time", parameterType=ApiMethodParameterType.DATE, hint="Start time") @Nonnull Date startTime, @ApiMethodParameter(name="End time", parameterType=ApiMethodParameterType.SLICE_URN, hint="End time") @Nonnull Date endTime) throws JFedException {
        HttpCallDetails reply;
        String relUrl = "exp";
        Map<String, Object> methodParameters = ReputationService.makeMethodParameters("userUrn", userUrn, "sliceUrn", sliceUrn, "startTime", startTime, "endTime", endTime);
        HashMap<String, List<SliceReputation>> request = new HashMap<String, List<SliceReputation>>();
        SliceReputation experiment = new SliceReputation(userUrn, sliceUrn, startTime, endTime);
        request.put("experiments", Collections.singletonList(experiment));
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.POST, url, ContentType.APPLICATION_JSON, this.gson.toJson(request), relUrl, methodParameters, EMPTY_URL_PARAMS);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Error constructing relative URL \"" + url + "\"", (Throwable)e);
        }
        String jsonString = reply.getResultHttpContent();
        try {
            SliceReputation[] sliceReputations = (SliceReputation[])this.gson.fromJson(jsonString, SliceReputation[].class);
            RestApi.RestReply<List<SliceReputation>> res = new RestApi.RestReply<List<SliceReputation>>(reply, Arrays.asList(sliceReputations));
            this.logNonSfa(reply, res, relUrl, relUrl, (JFedConnection)con, methodParameters, null);
            return res;
        }
        catch (JsonSyntaxException ex) {
            LOG.error("Error while deserializing answer from reputation service", (Throwable)ex);
            this.logNonSfa(reply, null, relUrl, relUrl, (JFedConnection)con, methodParameters, (Exception)((Object)ex));
            return new RestApi.RestReply<Object>(reply, null);
        }
    }

    @ApiMethod(order=2, hint="GET")
    public RestApi.RestReply<TestbedReputation> getReputation(@Nonnull HttpConnection con, @ApiMethodParameter(name="Testbed", parameterType=ApiMethodParameterType.AM_URN, hint="Aggregate URN") @Nonnull GeniUrn aggregateUrn) throws JFedException {
        HttpCallDetails reply;
        String relUrl = "reputation/show";
        Map<String, Object> methodParameters = ReputationService.makeMethodParameters("testbed", (Object)aggregateUrn);
        HashMap<String, Object> urlParams = new HashMap<String, Object>();
        urlParams.put("testbed", aggregateUrn.getEncodedTopLevelAuthority());
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.GET, url, null, null, relUrl, methodParameters, urlParams);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Error constructing relative URL \"" + url + "\"", (Throwable)e);
        }
        String jsonString = reply.getResultHttpContent();
        try {
            TestbedReputation[] testbedReputations = (TestbedReputation[])this.gson.fromJson(jsonString, TestbedReputation[].class);
            RestApi.RestReply<TestbedReputation> res = new RestApi.RestReply<TestbedReputation>(reply, testbedReputations[0]);
            this.logNonSfa(reply, res, relUrl, relUrl, (JFedConnection)con, methodParameters, null);
            return res;
        }
        catch (JsonSyntaxException ex) {
            LOG.error("Error while deserializing answer from reputation service", (Throwable)ex);
            this.logNonSfa(reply, null, relUrl, relUrl, (JFedConnection)con, methodParameters, (Exception)((Object)ex));
            return new RestApi.RestReply<Object>(reply, null);
        }
    }

    @ApiMethod(order=3, hint="GET")
    public RestApi.RestReply<List<TestbedReputation>> getReputations(@Nonnull HttpConnection con) throws JFedException {
        HttpCallDetails reply;
        String relUrl = "reputation/showrep";
        Map<String, Object> methodParameters = Collections.emptyMap();
        String url = con.getServerUrl() + relUrl;
        try {
            reply = this.executeHttpCall(con, relUrl, AbstractApi.HttpVerb.GET, url, null, null, relUrl, methodParameters, EMPTY_URL_PARAMS);
        }
        catch (MalformedURLException e) {
            throw new JFedException("Error constructing relative URL \"" + url + "\"", (Throwable)e);
        }
        String jsonString = reply.getResultHttpContent();
        try {
            TestbedReputation[] testbedReputations = (TestbedReputation[])this.gson.fromJson(jsonString, TestbedReputation[].class);
            RestApi.RestReply<List<TestbedReputation>> res = new RestApi.RestReply<List<TestbedReputation>>(reply, Arrays.asList(testbedReputations));
            this.logNonSfa(reply, res, relUrl, relUrl, (JFedConnection)con, methodParameters, null);
            return res;
        }
        catch (JsonSyntaxException ex) {
            LOG.error("Error while deserializing answer from reputation service", (Throwable)ex);
            this.logNonSfa(reply, null, relUrl, relUrl, (JFedConnection)con, methodParameters, (Exception)((Object)ex));
            return new RestApi.RestReply<Object>(reply, null);
        }
    }

    @ApiMethod(order=4, hint="POST")
    public RestApi.RestReply<String> registerUserQOE(@Nonnull HttpConnection con, @ApiMethodParameter(name="User URN", parameterType=ApiMethodParameterType.USER_URN, hint="User URN") @Nonnull GeniUrn userUrn, @ApiMethodParameter(name="Slice URN", parameterType=ApiMethodParameterType.SLICE_URN, hint="Slice URN") @Nonnull GeniUrn sliceUrn, @ApiMethodParameter(name="Start time", parameterType=ApiMethodParameterType.DATE, hint="Start time") @Nonnull Date startTime, @ApiMethodParameter(name="End time", parameterType=ApiMethodParameterType.SLICE_URN, hint="End time") @Nonnull Date endTime, @ApiMethodParameter(name="Resources", parameterType=ApiMethodParameterType.LIST_OF_URN, hint="List of resources") @Nonnull List<GeniUrn> resources, @ApiMethodParameter(name="Overall score", parameterType=ApiMethodParameterType.INTEGER, hint="Overall score") int overallScore, @ApiMethodParameter(name="Quality score", parameterType=ApiMethodParameterType.INTEGER, hint="Quality score") int qualityScore, @ApiMethodParameter(name="Availability score", parameterType=ApiMethodParameterType.INTEGER, hint="Availability score") int availabilityScore) throws JFedException {
        String relUrl = "userqoe";
        Map<String, Object> methodParameters = ReputationService.makeMethodParameters("userUrn", userUrn, "sliceUrn", sliceUrn, "startTime", startTime, "endTime", endTime, "resources", resources, "overallScore", overallScore, "qualityScore", qualityScore, "availabilityScore", availabilityScore);
        SliceReputation experiment = new SliceReputation(userUrn, sliceUrn, startTime, endTime);
        experiment.setResources(resources);
        HashMap<String, Integer> scores = new HashMap<String, Integer>();
        scores.put(SERVICE_OVERALL, overallScore);
        scores.put(SERVICE_QUALITY, qualityScore);
        scores.put(SERVICE_AVAILABILITY, availabilityScore);
        experiment.setEvaluation(scores);
        return this.internalPost(con, relUrl, relUrl, methodParameters, EMPTY_URL_PARAMS, ContentType.APPLICATION_JSON, this.gson.toJson((Object)experiment), Collections.singletonMap("Content-Type", "application/json"));
    }

    public final class DateRFC3339Adapter
    extends TypeAdapter<Date> {
        public final void write(JsonWriter out, Date value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.value(RFC3339Util.dateToRFC3339String((Date)value));
        }

        public final Date read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                return null;
            }
            try {
                return RFC3339Util.rfc3339StringToDate((String)in.nextString());
            }
            catch (ParseException e) {
                throw new IOException("Unexpected input for Date", e);
            }
        }
    }

    private class ServicesMapTypeAdapter
    implements JsonDeserializer<Map<String, Double>> {
        private ServicesMapTypeAdapter() {
        }

        public Map<String, Double> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (!jsonElement.isJsonArray()) {
                throw new JsonParseException("Expected an JSON Array as outer object for services-map");
            }
            HashMap<String, Double> result = new HashMap<String, Double>();
            for (JsonElement element : jsonElement.getAsJsonArray()) {
                for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                    if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                        throw new JsonParseException("Expected a number as value of " + (String)entry.getKey());
                    }
                    result.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsDouble());
                }
            }
            return result;
        }
    }

    public static class SliceReputation {
        private GeniUrn userUrn;
        private GeniUrn sliceUrn;
        private Date startTime;
        private Date endTime;
        private List<GeniUrn> resources;
        @SerializedName(value="user_eval")
        private Map<String, Integer> evaluation;

        public SliceReputation() {
        }

        public SliceReputation(GeniUrn userUrn, GeniUrn sliceUrn, Date startTime, Date endTime) {
            this.userUrn = userUrn;
            this.sliceUrn = sliceUrn;
            this.startTime = startTime;
            this.endTime = endTime;
        }

        public GeniUrn getUserUrn() {
            return this.userUrn;
        }

        public void setUserUrn(GeniUrn userUrn) {
            this.userUrn = userUrn;
        }

        public GeniUrn getSliceUrn() {
            return this.sliceUrn;
        }

        public void setSliceUrn(GeniUrn sliceUrn) {
            this.sliceUrn = sliceUrn;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public List<GeniUrn> getResources() {
            return this.resources;
        }

        public void setResources(List<GeniUrn> resources) {
            this.resources = resources;
        }

        public Map<String, Integer> getEvaluation() {
            return this.evaluation;
        }

        public void setEvaluation(Map<String, Integer> evaluation) {
            this.evaluation = evaluation;
        }
    }

    public static class TestbedReputation {
        public String testbed;
        public Map<String, Double> services;

        public String getTestbed() {
            return this.testbed;
        }

        public void setTestbed(String testbed) {
            this.testbed = testbed;
        }

        public Map<String, Double> getServices() {
            return this.services;
        }

        public void setServices(Map<String, Double> services) {
            this.services = services;
        }
    }
}

