/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_scripts;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.dropwizard.jackson.Jackson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAllProjectsWithUsers {
    private static final Logger LOG = LoggerFactory.getLogger(GetAllProjectsWithUsers.class);
    @Nonnull
    private final be.iminds.ilabt.jfed.log.Logger logger;
    @Nonnull
    private final UserAndSliceApiWrapper samaWrapper;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    private final FederationMemberAuthorityApi2 ma;
    @Nonnull
    private final FederationSliceAuthorityApi2 sa;
    @Nonnull
    private final GeniUserProvider geniUserProvider;

    @Inject
    public GetAllProjectsWithUsers(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull JFedConnectionProvider connectionProvider) {
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.connectionProvider = connectionProvider;
        if (!geniUserProvider.isUserLoggedIn()) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a logged in user");
        }
        Server userServer = geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        if (userServer.getServices() == null) {
            throw new IllegalArgumentException("Cannot initialize AutomaticUserAndSliceApiWrapper: userAuth.getServices() = null (userAuth.urn=" + userServer.getDefaultComponentManagerUrn() + ")");
        }
        if (!ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_SA, 2) || !ApiInfo.hasService(userServer, ApiInfo.ApiName.GENI_CH_MA, 2)) {
            throw new IllegalArgumentException("user authority should have a \"Common Federation API\" v2 service");
        }
        this.sa = new FederationSliceAuthorityApi2(logger, jFedPreferences);
        this.ma = new FederationMemberAuthorityApi2(logger, jFedPreferences);
        this.samaWrapper = automaticUserAndSliceApiWrapperFactory.create();
    }

    private SfaConnection getSAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_SA, 2));
    }

    private SfaConnection getMAConnection() throws JFedException {
        Server userServer = this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer();
        if (userServer == null) {
            throw new IllegalArgumentException("GetProjectsForUsers requires a user with an auth server");
        }
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.geniUserProvider.getLoggedInGeniUser(), userServer, new ApiInfo.Api(ApiInfo.ApiName.GENI_CH_MA, 2));
    }

    @ApiMethod(order=1, hint="List all project urns as string")
    public Map<String, List<String>> getAllProjectsWithUsers() throws JFedException {
        this.samaWrapper.getLocalUserCredentials(this.logger);
        LOG.info("Got credential for user");
        List<AnyCredential> userCredentials = this.samaWrapper.getLocalUserCredentials(this.logger);
        AbstractFederationApi.FederationApiReply<AbstractFederationApi.ProjectInfoList> reply = this.sa.lookupProject(this.getSAConnection(), userCredentials, null, null, null);
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("Error when querying user projects: " + reply.getGeniResponseCode());
        }
        AbstractFederationApi.ProjectInfoList projectInfos = reply.getValue();
        if (projectInfos == null) {
            String rawValue;
            try {
                rawValue = Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(reply.getRawValue());
            }
            catch (Throwable t) {
                rawValue = "ERROR";
            }
            throw new JFedException("No value in reply from SA: " + reply.getRawResult() + " -> " + rawValue);
        }
        ArrayList<GeniUrn> projectUrnStrings = new ArrayList<GeniUrn>();
        Iterator t = projectInfos.iterator();
        while (t.hasNext()) {
            AbstractFederationApi.ProjectInfo projectInfo = (AbstractFederationApi.ProjectInfo)t.next();
            GeniUrn projectUrn = projectInfo == null ? null : projectInfo.getProjectUrn();
            if (projectUrn == null) continue;
            projectUrnStrings.add(projectUrn);
        }
        LOG.info("Got all projects: {}", projectUrnStrings);
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        for (GeniUrn projectUrn : projectUrnStrings) {
            List<GeniUrn> users = this.samaWrapper.getUsersForSubAuthority(this.logger, projectUrn.getResourceName());
            res.put(projectUrn.toString(), users.stream().map(Object::toString).collect(Collectors.toList()));
        }
        return res;
    }

    public String getAllProjectsWithUserssAsJson() throws JFedException {
        Map<String, List<String>> r = this.getAllProjectsWithUsers();
        try {
            return Jackson.newObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(r);
        }
        catch (JsonProcessingException e) {
            throw new JFedException("Error converting result to JSON", (Throwable)e);
        }
    }
}

