/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XmlRpcApiCallReply;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingDirector;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMv2Wrapper
extends AggregateManagerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(AMv2Wrapper.class);
    private final AggregateManager2 am2;

    public AMv2Wrapper(@Nonnull be.iminds.ilabt.jfed.log.Logger logger, @Nonnull GeniUserProvider geniUserProvider, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull JFedPreferences jFedPreferences, @Nonnull Server amServer) {
        super(logger, geniUserProvider, connectionProvider, jFedPreferences, amServer);
        this.am2 = new AggregateManager2(logger, jFedPreferences);
    }

    protected SfaConnection getConnection() throws JFedException {
        return (SfaConnection)this.getConnection(new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
    }

    @Override
    public void setSpeaksFor(List<AnyCredential> speaksForCredentials, @Nullable GeniUrn speakingForUrn) {
        super.setSpeaksFor(speaksForCredentials, speakingForUrn);
        if (speakingForUrn != null) {
            this.setExtraOptionsForCallsWithCredential(Collections.singletonMap("geni_speaking_for", speakingForUrn.getValue()));
        }
    }

    @Override
    public Map getVersion() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.VersionInfo> reply;
        this.lastAmReply = reply = this.am2.getVersion(this.getConnection());
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("GetVersion Call not successful", reply);
        }
        return reply.getRawResult();
    }

    @Override
    public String listResources(@Nonnull List<AnyCredential> userCredentials, boolean available, @Nonnull String type, @Nonnull String version) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<String> reply;
        this.lastAmReply = reply = this.am2.listResources(this.getConnection(), this.finalizeSliceCredentials(userCredentials), type, version, available, true, null, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("ListResources Call not successful", reply);
        }
        return reply.getValue();
    }

    @Override
    public String createSliver(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, @Nullable List<UserSpec> users, @Nullable Date expirationDate) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<String> reply;
        this.lastAmReply = reply = this.am2.createSliver(this.getConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn.getValue(), rspec, users, this.addCredentialExtraOptions(null));
        if (reply.getGeniResponseCode().isSuccess() && reply.getValue() == null) {
            throw new JFedException("CreateSliver Call has null reply value", reply);
        }
        if (reply.getGeniResponseCode().isSuccess() && !(reply.getValue() instanceof String)) {
            throw new JFedException("CreateSliver Call has invalid reply type: " + reply.getValue().getClass().getName(), reply);
        }
        String manifestRspec = reply.getValue();
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (StitchingDirector.isAnyNotSupported(reply)) {
                throw new AggregateManagerWrapper.AnyVlanUnsupportedException((XmlRpcApiCallReply)reply);
            }
            if (StitchingDirector.isUnavailableVlan(reply)) {
                throw new AggregateManagerWrapper.VlanUnavailableException(StitchingDirector.getUnavailableVlan(reply), (XmlRpcApiCallReply)reply);
            }
            if (AbstractGeniAggregateManager.isCommonError(reply, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES)) {
                throw new AggregateManagerWrapper.NotEnoughFreeResourcesException((XmlRpcApiCallReply)reply);
            }
            if (AbstractGeniAggregateManager.isCommonError(reply, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED)) {
                throw new AggregateManagerWrapper.TermsAndConditionsException((XmlRpcApiCallReply)reply);
            }
            if (AbstractGeniAggregateManager.isCommonError(reply, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM)) {
                throw new AggregateManagerWrapper.ReservationProblemException((XmlRpcApiCallReply)reply);
            }
            boolean ignoreError = false;
            if ("Must delete existing slice first".equalsIgnoreCase(reply.getOutput())) {
                manifestRspec = this.describe(sliceUrn, sliceCredentials);
                ignoreError = true;
            }
            if (!ignoreError) {
                throw new JFedException("CreateSliver Call not successful", reply);
            }
        }
        if (expirationDate != null) {
            try {
                this.renewSlivers(sliceUrn, null, this.finalizeSliceCredentials(sliceCredentials), expirationDate);
            }
            catch (JFedException ex) {
                LOG.error("Error when trying to define expiration date for newly created sliver", (Throwable)ex);
            }
            this.lastAmReply = reply;
        }
        return manifestRspec;
    }

    @Override
    public boolean hasSeperateAllocateAndProvision() {
        return false;
    }

    @Override
    public AggregateManagerWrapper.AllocateReply allocate(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, Date expirationDate) throws JFedException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public AggregateManagerWrapper.AllocateReply allocate(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull String rspec, Date startDate, Date endDate) throws JFedException {
        throw new UnsupportedOperationException("AMv2 does not support reservations");
    }

    @Override
    public String provisionAndStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, List<UserSpec> userSpecs, Date expirationDate) throws JFedException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public AggregateManagerWrapper.ProvisionReply provision(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials, @Nullable List<UserSpec> userSpecs, @Nullable Date expirationDate) throws JFedException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public void poaStart(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public void deleteSliver(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<Boolean> reply;
        this.lastAmReply = reply = this.am2.deleteSliver(this.getConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn.getValue(), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
                return;
            }
            throw new JFedException("Delete Call not successful", reply);
        }
    }

    @Override
    public StatusDetails status(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.SliverStatus> reply;
        LOG.debug("Calling AMv2Wrapper status with " + sliceCredentials.size() + " credentials");
        this.lastAmReply = reply = this.am2.sliverStatus(this.getConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn.getValue(), this.addCredentialExtraOptions(null));
        if (reply.getGeniResponseCode() == GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED) {
            return new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED);
        }
        AggregateManager2.SliverStatus status = reply.getValue();
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("SliverStatus Call not successful", reply);
        }
        if (status == null) {
            throw new JFedException("SliverStatus Call has no return value", reply);
        }
        if (Objects.equals(status.getStatus(), "ready") && status.getResources().isEmpty()) {
            LOG.warn("SliverStatus Call returned \"ready\", but there are no resources. This is either a server error, or there is only a routable_pool in this sliver.");
        }
        StatusDetails res = new StatusDetails(status.getStatus());
        res.addKnownExpires(status.getAnyExtExpires());
        for (AggregateManager2.SliverStatus.ResourceStatus resourceStatus : status.getResources()) {
            if (resourceStatus.getError() != null && !resourceStatus.getError().isEmpty()) {
                res.addError(new ErrorDetails(resourceStatus.getError(), null, resourceStatus.getUrn()));
            }
            res.addSliverStatus(resourceStatus.getUrn(), resourceStatus.getStatus());
        }
        return res;
    }

    @Override
    @Nullable
    public AggregateManager3.StatusInfo status_v3(@Nonnull GeniUrn urn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        throw new RuntimeException("Unsupported operation");
    }

    @Override
    public String describe(@Nonnull GeniUrn sliceUrn, @Nonnull List<AnyCredential> sliceCredentials) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<String> reply;
        String type = "geni";
        String version = "3";
        if (this.amServer.getServerType() != null && this.amServer.getServerType().equalsIgnoreCase("FOAM")) {
            type = "GENI";
        }
        this.lastAmReply = reply = this.am2.listResources(this.getConnection(), this.finalizeSliceCredentials(sliceCredentials), type, "3", null, true, sliceUrn.getValue(), this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            if (reply.getGeniResponseCode() == GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED) {
                throw new JFedException("No such slice found", reply);
            }
            throw new JFedException("ListResources Call not successful", reply);
        }
        return reply.getValue();
    }

    @Override
    public List<GeniUrn> renewSlivers(GeniUrn sliceUrn, List<GeniUrn> sliverUrns, @Nonnull List<AnyCredential> sliceCredentials, @Nonnull Date newExpire) throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply<Boolean> reply;
        if (sliceUrn == null) {
            throw new JFedException("RenewSliver not called, because sliceUrn == null and this call supports only slice URN. (sliverUrns=" + sliverUrns + ")");
        }
        this.lastAmReply = reply = this.am2.renewSliver(this.getConnection(), this.finalizeSliceCredentials(sliceCredentials), sliceUrn.getValue(), newExpire, this.addCredentialExtraOptions(null));
        if (!reply.getGeniResponseCode().isSuccess()) {
            throw new JFedException("RenewSliver Call not successful", reply);
        }
        if (reply.getValue() != null && reply.getValue().equals(Boolean.TRUE) && sliverUrns != null && !sliverUrns.isEmpty()) {
            return new ArrayList<GeniUrn>(sliverUrns);
        }
        return null;
    }

    @Override
    public boolean isExirationdateSetByCreateSliver() {
        return false;
    }

    @Override
    public boolean isShareLanSupported() {
        return false;
    }

    @Override
    public boolean isRestartSupported() {
        return false;
    }

    @Override
    public boolean isReloadOSSupported() {
        return false;
    }

    @Override
    public boolean isOpenConsoleSupported() {
        return false;
    }

    @Override
    public boolean isEditSshKeysSupported() {
        return false;
    }

    @Override
    public boolean areUserDiskImageFunctionsSupported() {
        return false;
    }
}

