/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.credential;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.CredentialException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Objects;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SfaCredential
extends AnyCredential {
    public static boolean debug_expiredate_forceZinsteadOfZero = true;
    public static boolean debug_expiredate_forcezulu = true;
    public static boolean debug_expiredate_discardsubsecond = true;
    public static boolean debug_expiredate_smalltz = false;
    private static final Logger LOG = LoggerFactory.getLogger(SfaCredential.class);
    private static final Random random = new Random(System.currentTimeMillis());
    private String sfaType;
    private String ownerUrn;
    private String targetUrn;
    private String ownerGid;
    private String targetGid;
    private String expires;
    private Date expiresDate;

    public SfaCredential(String name, String credentialXml) throws CredentialException {
        this(name, credentialXml, "geni_sfa", "2");
    }

    public SfaCredential(String name, String credentialXml, String type, String version) throws CredentialException {
        super(name, credentialXml, type, version);
        assert (type.equalsIgnoreCase("sfa") || type.equalsIgnoreCase("geni_sfa")) : "Created SfaCredential not of type sfa, but of type=\"" + type + "\" version=\"" + version + "\"";
        this.initDoc();
        this.parseXml();
    }

    private static Element addElementHelper(Document doc, Element target, String name, String text) {
        Element e = doc.createElement(name);
        if (text != null) {
            e.appendChild(doc.createTextNode(text));
        }
        target.appendChild(e);
        return e;
    }

    public static SfaCredential create(String type, String ownerUrn, String targetUrn, X509Certificate ownerCert, X509Certificate targetCert, X509Certificate signerCert, PrivateKey signerPrivateKey, Date expireDate, String privilegeName, boolean canDelegate, String credentialjFedName) throws CredentialException {
        String xml;
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CredentialException("Failed to create credential: " + e.getMessage(), e);
        }
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("signed-credential");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "http://www.protogeni.net/resources/credential/credential.xsd");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.protogeni.net/resources/credential/ext/policy/1 http://www.protogeni.net/resources/credential/ext/policy/1/policy.xsd");
        doc.appendChild(rootElement);
        Element credential = doc.createElement("credential");
        Attr idAttr = doc.createAttribute("xml:id");
        String credentialId = "cred" + random.nextInt();
        idAttr.setValue(credentialId);
        credential.setAttributeNode(idAttr);
        credential.setIdAttributeNode(idAttr, true);
        rootElement.appendChild(credential);
        SfaCredential.addElementHelper(doc, credential, "type", type);
        SfaCredential.addElementHelper(doc, credential, "serial", "" + Math.random());
        SfaCredential.addElementHelper(doc, credential, "owner_gid", KeyUtil.x509certificateToCredentialXmlGid((X509Certificate)ownerCert));
        SfaCredential.addElementHelper(doc, credential, "owner_urn", ownerUrn);
        SfaCredential.addElementHelper(doc, credential, "target_gid", KeyUtil.x509certificateToCredentialXmlGid((X509Certificate)targetCert));
        SfaCredential.addElementHelper(doc, credential, "target_urn", targetUrn);
        SfaCredential.addElementHelper(doc, credential, "uuid", null);
        SfaCredential.addElementHelper(doc, credential, "expires", SfaCredential.getExpiresDateString(expireDate));
        Element privileges = SfaCredential.addElementHelper(doc, credential, "privileges", null);
        Element privilege = SfaCredential.addElementHelper(doc, privileges, "privilege", null);
        SfaCredential.addElementHelper(doc, privilege, "name", privilegeName);
        SfaCredential.addElementHelper(doc, privilege, "can_delegate", canDelegate ? "1" : "0");
        Element signatures = SfaCredential.addElementHelper(doc, rootElement, "signatures", null);
        try {
            xml = XmlUtil.signXml((Document)doc, (String)credentialId, (String)"signatures", (X509Certificate)signerCert, (Key)signerPrivateKey);
        }
        catch (TransformerException | XMLSecurityException e) {
            throw new CredentialException("Failed to sign generated credential: " + e.getMessage(), e);
        }
        return new SfaCredential(credentialjFedName, xml, "geni_sfa", "3");
    }

    public static SfaCredential createSpeaksFor(String spokenForUrn, String speakerUrn, X509Certificate spokenForCert, X509Certificate speakerCert, PrivateKey spokenForPrivateKey, Date expireDate, String privilegeName, boolean canDelegate) throws CredentialException {
        return SfaCredential.create("speaksfor", speakerUrn, spokenForUrn, speakerCert, spokenForCert, spokenForCert, spokenForPrivateKey, expireDate, privilegeName, canDelegate, "SpeaksFor Credential");
    }

    private static String getExpiresDateString(Date expireDate) {
        String res = RFC3339Util.dateToRFC3339String((Date)expireDate, (boolean)debug_expiredate_forcezulu, (boolean)debug_expiredate_discardsubsecond, (boolean)debug_expiredate_forceZinsteadOfZero);
        if (debug_expiredate_smalltz) {
            res = res.replace('T', 't');
            res = res.replace('Z', 'z');
        }
        try {
            Date reconstructExpires = RFC3339Util.rfc3339StringToDate((String)res);
            if (debug_expiredate_discardsubsecond) {
                expireDate = new Date(expireDate.getTime() - expireDate.getTime() % 1000L);
            }
            if (reconstructExpires.getTime() != expireDate.getTime()) {
                throw new RuntimeException("ERROR reconstructing date: expireDate=" + expireDate + " res=\"" + res + "\" reconstructExpires=" + reconstructExpires + "   -> " + reconstructExpires.getTime() + " != " + expireDate.getTime());
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    private void parseXml() throws CredentialException {
        assert (this.xmlDoc != null);
        assert (Objects.equals(this.xmlDoc.getDocumentElement().getTagName(), "signed-credential")) : "Document element is not <signed-credential> but \"" + this.xmlDoc.getDocumentElement().getTagName() + "\"";
        NodeList nl = this.xmlDoc.getDocumentElement().getChildNodes();
        if (nl.getLength() == 0) {
            throw new CredentialException("Cannot find any <signed-credential> element children!");
        }
        Element credentialEl = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) {
                if (nl.item(i) instanceof Text && nl.item(i).getTextContent().trim().isEmpty()) continue;
                LOG.warn("<signed-credential> contains non credential: class=" + nl.item(i).getClass().getName() + " value=" + nl.item(i).toString());
                continue;
            }
            Element e = (Element)nl.item(i);
            if (!Objects.equals(e.getTagName(), "credential")) continue;
            if (credentialEl != null) {
                throw new CredentialException("No support for multiple credentials implemented.");
            }
            credentialEl = e;
        }
        if (credentialEl == null) {
            throw new CredentialException("No credential element found in credential.");
        }
        Element typeEl = (Element)credentialEl.getElementsByTagName("type").item(0);
        if (typeEl == null) {
            throw new CredentialException("XML credential element does not contain type element");
        }
        this.sfaType = typeEl.getTextContent();
        Element ownerUrnEl = (Element)credentialEl.getElementsByTagName("owner_urn").item(0);
        if (ownerUrnEl == null) {
            throw new CredentialException("XML credential element does not contain owner_urn element");
        }
        this.ownerUrn = ownerUrnEl.getTextContent();
        Element targetUrnEl = (Element)credentialEl.getElementsByTagName("target_urn").item(0);
        this.targetUrn = targetUrnEl.getTextContent();
        if (credentialEl.getElementsByTagName("owner_gid") == null) {
            throw new CredentialException("XML credential element does not contain owner_gid element");
        }
        if (credentialEl.getElementsByTagName("owner_gid").getLength() > 0) {
            Element ownerGidEl = (Element)credentialEl.getElementsByTagName("owner_gid").item(0);
            this.ownerGid = ownerGidEl.getTextContent();
        }
        if (credentialEl.getElementsByTagName("target_gid") == null) {
            throw new CredentialException("XML credential element does not contain target_gid element");
        }
        if (credentialEl.getElementsByTagName("target_gid").getLength() > 0) {
            Element targetGidEl = (Element)credentialEl.getElementsByTagName("target_gid").item(0);
            this.targetGid = targetGidEl.getTextContent();
        }
        if (credentialEl.getElementsByTagName("expires") == null) {
            throw new CredentialException("XML credential element does not contain expires element");
        }
        if (credentialEl.getElementsByTagName("expires").getLength() > 0) {
            Element expiresEl = (Element)credentialEl.getElementsByTagName("expires").item(0);
            this.expires = expiresEl.getTextContent();
            try {
                this.expiresDate = RFC3339Util.iso8601StringToDate((String)this.expires);
            }
            catch (ParseException e) {
                LOG.error("XML credential expires element is not a valid ISO8601 date: \"" + this.expires + "\"", (Throwable)e);
                this.expiresDate = null;
            }
        }
    }

    public String getSfaType() {
        return this.sfaType;
    }

    public String getTargetUrn() {
        return this.targetUrn;
    }

    public String getOwnerUrn() {
        return this.ownerUrn;
    }

    public String getOwnerGid() {
        return this.ownerGid;
    }

    public String getTargetGid() {
        return this.targetGid;
    }

    @Override
    public String getExpires() {
        return this.expires;
    }

    @Override
    public Date getExpiresDate() {
        return this.expiresDate;
    }

    @Override
    public Boolean isTargetSubAuthority() {
        if (this.targetUrn == null) {
            return null;
        }
        GeniUrn targetU = GeniUrn.parse((String)this.targetUrn);
        if (targetU == null) {
            return null;
        }
        return targetU.getEncodedSubAuthName() != null;
    }

    @Override
    public boolean check(TestbedInfoSource testbedInfoSource) throws CredentialException {
        Server auth;
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        if (this.ownerUrn != null && (auth = testbedInfoSource.getFromAnyUrn(this.ownerUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY)) != null) {
            jFedTrustStore.addTrustedPemCertificateIfNotAdded(auth.getCertificateChain());
        }
        if (this.targetUrn != null && (auth = testbedInfoSource.getFromAnyUrn(this.targetUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_OTHER_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY)) != null) {
            jFedTrustStore.addTrustedPemCertificateIfNotAdded(auth.getCertificateChain());
        }
        return this.check(jFedTrustStore.getTrustStore());
    }

    public SfaCredential delegate(String newOwnerUrn, X509Certificate newOwnerCert, PrivateKey originalOwnerPrivateKey, Date expireDate, String delegatedRights, boolean canDelegate) throws CredentialException {
        String xml;
        DocumentBuilder docBuilder;
        Element originalCredential = (Element)this.xmlDoc.getElementsByTagName("credential").item(0);
        Element originalSignatures = (Element)this.xmlDoc.getElementsByTagName("signatures").item(0);
        String originalTargetUrn = originalCredential.getElementsByTagName("target_urn").item(0).getTextContent();
        String originalTargetCertString = originalCredential.getElementsByTagName("target_gid").item(0).getTextContent();
        String originalOwnerUrn = originalCredential.getElementsByTagName("owner_urn").item(0).getTextContent();
        String originalOwnerCertString = originalCredential.getElementsByTagName("owner_gid").item(0).getTextContent();
        Date originalCredentialExpires = this.getExpiresDate();
        if (originalCredentialExpires != null && originalCredentialExpires.before(expireDate)) {
            LOG.info("when delegating credential, requested expire date was after expire date of credential being delegated. This is not allowed, using original date of date of credential being delegated as expires date instead. requested date = " + this.expires + ". original expires date = " + originalCredentialExpires);
            expireDate = originalCredentialExpires;
        }
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new CredentialException("Failed to create delegated credential: " + e.getMessage(), e);
        }
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("signed-credential");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "http://www.protogeni.net/resources/credential/credential.xsd");
        rootElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "http://www.protogeni.net/resources/credential/ext/policy/1 http://www.protogeni.net/resources/credential/ext/policy/1/policy.xsd");
        doc.appendChild(rootElement);
        Element credential = doc.createElement("credential");
        Attr idAttr = doc.createAttribute("xml:id");
        String credId = "cred" + Math.round(Math.random() * 1000.0);
        idAttr.setValue(credId);
        credential.setAttributeNode(idAttr);
        credential.setIdAttributeNode(idAttr, true);
        rootElement.appendChild(credential);
        SfaCredential.addElementHelper(doc, credential, "type", "privilege");
        SfaCredential.addElementHelper(doc, credential, "serial", "" + Math.random());
        SfaCredential.addElementHelper(doc, credential, "owner_gid", KeyUtil.x509certificateToCredentialXmlGid((X509Certificate)newOwnerCert));
        SfaCredential.addElementHelper(doc, credential, "owner_urn", newOwnerUrn);
        SfaCredential.addElementHelper(doc, credential, "target_gid", originalTargetCertString);
        SfaCredential.addElementHelper(doc, credential, "target_urn", originalTargetUrn);
        SfaCredential.addElementHelper(doc, credential, "uuid", null);
        SfaCredential.addElementHelper(doc, credential, "expires", SfaCredential.getExpiresDateString(expireDate));
        Element privileges = SfaCredential.addElementHelper(doc, credential, "privileges", null);
        Element privilege = SfaCredential.addElementHelper(doc, privileges, "privilege", null);
        SfaCredential.addElementHelper(doc, privilege, "name", delegatedRights);
        SfaCredential.addElementHelper(doc, privilege, "can_delegate", canDelegate ? "1" : "0");
        Element parent = SfaCredential.addElementHelper(doc, credential, "parent", null);
        Node importedOriginalCredential = doc.importNode(originalCredential, true);
        parent.appendChild(importedOriginalCredential);
        Element signatures = SfaCredential.addElementHelper(doc, rootElement, "signatures", null);
        NodeList origSignatures = originalSignatures.getChildNodes();
        for (int i = 0; i < origSignatures.getLength(); ++i) {
            Node importedOriginalSig = doc.importNode(origSignatures.item(i), true);
            signatures.appendChild(importedOriginalSig);
        }
        X509Certificate originalOwnerCert = KeyUtil.pemToX509Certificate((String)originalOwnerCertString);
        try {
            xml = XmlUtil.signXml((Document)doc, (String)credId, (String)"signatures", (X509Certificate)originalOwnerCert, (Key)originalOwnerPrivateKey);
        }
        catch (TransformerException | XMLSecurityException e) {
            throw new CredentialException("Failed to sign delegated credential: " + e.getMessage(), e);
        }
        return new SfaCredential("Delegated Credential", xml, "geni_sfa", "3");
    }
}

