/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum GeniUniformFederationApiResponseCode implements GeniResponseCode
{
    NONE(0, "No error encountered \u2013 the return value is a successful result. An empty list form a query should be interpreted as \u2018nothing found matching criteria\u2019."),
    AUTHENTICATION_ERROR(1, "The invoking tool or member did not provide appropriate credentials indicating that they are known to the CH or that they possessed the private key of the entity they claimed to be"),
    AUTHORIZATION_ERROR(2, "The invoking tool or member does not have the authority to invoke the given call with the given arguments"),
    ARGUMENT_ERROR(3, "The arguments provided to the call were mal-formed or mutually inconsistent."),
    DATABASE_ERROR(4, "An error from the underlying database was returned. (More info should be provided in the \u2018output\u2019 return value]"),
    SEARCHFAILED(12, "Search Failed (eg for slice)"),
    BUSY(14, "Busy"),
    BUSY_LOWLEVEL(-32001, "Busy"),
    NOT_IMPLEMENTED_ERROR(100, "The given method is not implemented on the server."),
    SERVER_ERROR(101, "An error in the client/server connection"),
    INTERNAL_NONGENI_ERROR(50, "Internal error in client application"),
    SERVER_REPLY_ERROR(51, "The client could not parse the server's reply. Either the server sent something strange, or this is a bug in the client");

    private final int code;
    private final String description;
    private static final Map<Integer, GeniUniformFederationApiResponseCode> RESPONSE_CODE_BY_CODE;

    private GeniUniformFederationApiResponseCode(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public boolean isSuccess() {
        return this.code == 0 || this.code == 16;
    }

    public boolean isBusy() {
        return this.code == 14 || this.code == -32001;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static GeniUniformFederationApiResponseCode getByCode(int c) throws UnknownResponseCodeException {
        GeniUniformFederationApiResponseCode res = RESPONSE_CODE_BY_CODE.get(c);
        if (res == null) {
            throw new UnknownResponseCodeException("GeniUniformFederationApiResponseCode " + c + " does not exists");
        }
        return res;
    }

    public String toString() {
        return "GeniUniformFederationApiResponseCode{code=" + this.code + ", description='" + this.description + "'}";
    }

    static {
        RESPONSE_CODE_BY_CODE = Arrays.stream(GeniUniformFederationApiResponseCode.values()).collect(Collectors.toMap(GeniUniformFederationApiResponseCode::getCode, Function.identity()));
    }
}

