/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info;

import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.PEMUtil;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.PermanentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesSshKeyInfo
implements PuTTYFilesKeyInfo {
    private static final Logger LOG = LoggerFactory.getLogger(PreferencesSshKeyInfo.class);
    @Nullable
    private final File privKeyFile;
    @Nullable
    private final File pubKeyFile;
    @Nonnull
    private final PEMUtil.PEM privKey;
    @Nullable
    private PEMUtil.PEM unlockedPrivKey = null;
    @Nullable
    private final PublicKeyConvertor pubKey;

    public PreferencesSshKeyInfo(@Nullable File privKeyFile, @Nullable File pubKeyFile, @Nonnull String privKeyText, @Nullable String pubKeyText) throws InvalidSshKeyInfoException {
        PublicKeyConvertor fromPubKeyText;
        this.privKeyFile = privKeyFile;
        this.pubKeyFile = pubKeyFile;
        try {
            this.privKey = PEMUtil.extractPEM((String)privKeyText);
            if (!this.privKey.isEncrypted()) {
                this.unlockedPrivKey = this.privKey;
            }
        }
        catch (PEMUtil.PEMDecodingException e) {
            LOG.debug("Could not parse private key (privKeyFile=" + privKeyFile + " privKeyText head=" + privKeyText.substring(0, 50) + "). error: " + e.getMessage(), (Throwable)e);
            throw new InvalidSshKeyInfoException("Could not parse private key contents", e);
        }
        if (!this.privKey.includesPubKey()) {
            if (pubKeyText == null) {
                if (this.privKey.isEncrypted()) {
                    throw new InvalidSshKeyInfoException("A public key must be provided when the private key is encrypted");
                }
                throw new InvalidSshKeyInfoException("A public key must be provided when the private key doesn't include it");
            }
            try {
                this.pubKey = PublicKeyConvertor.fromOpensshFormat((String)pubKeyText);
            }
            catch (Exception ex) {
                throw new InvalidSshKeyInfoException("A valid public key must be provided", ex);
            }
        }
        try {
            this.pubKey = this.privKey.toPublicKeyConvertor();
        }
        catch (PEMUtil.PEMDecodingException e) {
            LOG.debug("Could not get public key from private key: " + e.getMessage(), (Throwable)e);
            throw new InvalidSshKeyInfoException("Could not get public key from private key", e);
        }
        if (pubKeyText != null && !(fromPubKeyText = PublicKeyConvertor.fromOpensshFormat((String)pubKeyText)).equals((Object)this.pubKey)) {
            throw new InvalidSshKeyInfoException("Provided public and private key do not match!");
        }
    }

    @Override
    public boolean canReturnLockedPrivateKeyFile() {
        return true;
    }

    @Override
    public TmpFile getPrivateKeyFile() {
        if (this.privKeyFile != null) {
            return new PermanentFile(this.privKeyFile);
        }
        File tmpDir = new File(JFedUtils.getUserDataDirectoryFile(), "tmp");
        if (!tmpDir.exists()) {
            tmpDir.mkdir();
        }
        return new TmpContentFile("sskKeyPrefE", "pem", this.privKey.toString(), true);
    }

    @Override
    public boolean canReturnLockedPuttyKeyFile() {
        return false;
    }

    @Override
    public TmpFile getPuttyKeyFile() {
        if (this.pubKey == null) {
            return null;
        }
        return this.getUnlockedPuttyKeyFile();
    }

    @Override
    public TmpFile getUnencryptedPrivateKeyFile() {
        if (!this.privKey.isEncrypted()) {
            return this.getPrivateKeyFile();
        }
        if (this.unlockedPrivKey != null) {
            return new TmpContentFile("sskKeyPrefUE", ".pem", this.unlockedPrivKey.toString(), true);
        }
        return null;
    }

    @Override
    public TmpFile getUnlockedPuttyKeyFile() {
        if (this.pubKey == null || this.unlockedPrivKey == null) {
            return null;
        }
        String ppkContent = this.pubKey.getPublicKey() instanceof RSAPublicKey ? PuTTYPrivateKeyFile.createContent("jFed-tmp-ppk", (RSAPublicKey)this.pubKey.getPublicKey(), (RSAPrivateCrtKey)this.privKey.toPrivateKey(), null) : null;
        return new TmpContentFile("sskKeyPrefUE", ".ppk", ppkContent);
    }

    @Nullable
    public String getComment() {
        return null;
    }

    public boolean hasUnencryptedPrivateKey() {
        return this.unlockedPrivKey != null;
    }

    public boolean isLocked() {
        return this.unlockedPrivKey == null;
    }

    public boolean unlock(char[] password) {
        try {
            this.unlockedPrivKey = this.privKey.decrypt(password);
            if (this.pubKey != null && !Objects.equals(this.pubKey, this.unlockedPrivKey.toPublicKeyConvertor())) {
                throw new IllegalStateException("The public key derived from the private key doesn't match the public key in this PreferencesSshKeyInfo");
            }
            return true;
        }
        catch (PEMUtil.PEMDecodingException e) {
            LOG.debug("Could not decode private key with provided password");
            return false;
        }
    }

    @Nonnull
    public PublicKey getPublicKey() {
        return this.pubKey != null ? this.pubKey.getPublicKey() : null;
    }

    public PrivateKey getPrivateKey() {
        return this.privKey.toPrivateKey();
    }
}

