/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.basic_model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicStringRspec {
    private static final Logger LOG = LoggerFactory.getLogger(BasicStringRspec.class);
    @Nonnull
    protected final String xmlString;
    protected boolean wellFormed;
    protected boolean validRspec;
    protected Boolean isPossiblyStitching = null;
    protected final List<Set<String>> stitchingCms = new ArrayList<Set<String>>();
    protected List<String> allComponentManagers;
    private String rspecType;
    public static final String NAMESPACE_RSPEC = "http://www.geni.net/resources/rspec/3";
    public static final String NAMESPACE_PROXY = "http://jfed.iminds.be/proxy/1.0";
    public static final String NAMESPACE_OPENFLOW = "http://www.geni.net/resources/rspec/ext/openflow/3";
    public static final String NAMESPACE_JFED = "http://jfed.iminds.be/rspec/ext/jfed/1";
    public static final String NAMESPACE_JFED_MS_RDP = "http://jfed.iminds.be/service-ms-rdp/1.0/";
    public static final QName Q_RSPEC = new QName("http://www.geni.net/resources/rspec/3", "rspec");
    public static final QName Q_ATT_RSPEC_TYPE = new QName("type");
    public static final QName Q_NODE = new QName("http://www.geni.net/resources/rspec/3", "node");
    public static final QName Q_NODE_AVAILABLE = new QName("http://www.geni.net/resources/rspec/3", "available");
    public static final QName Q_ATT_NODE_AVAILABLE_NOW = new QName("now");
    public static final QName Q_LINK = new QName("http://www.geni.net/resources/rspec/3", "link");
    public static final QName Q_INTERFACE = new QName("http://www.geni.net/resources/rspec/3", "interface");
    public static final QName Q_ATT_CLIENT_ID = new QName("client_id");
    public static final QName Q_ATT_NODE_EXCLUSIVE = new QName("exclusive");
    public static final QName Q_NODE_SLIVERTYPE = new QName("http://www.geni.net/resources/rspec/3", "sliver_type");
    public static final QName Q_ATT_NODE_SLIVERTYPE_NAME = new QName("name");
    public static final QName Q_ATT_COM_MAN_ID = new QName("component_manager_id");
    public static final QName Q_ATT_COM_ID = new QName("component_id");
    public static final QName Q_LINK_COM_MAN = new QName("http://www.geni.net/resources/rspec/3", "component_manager");
    public static final QName Q_ATT_LINK_COM_MAN_NAME = new QName("name");
    public static final QName Q_LINK_TYPE = new QName("http://www.geni.net/resources/rspec/3", "link_type");
    public static final QName Q_ATT_LINK_TYPE_NAME = new QName("name");
    public static final QName Q_NODE_SERVICES = new QName("http://www.geni.net/resources/rspec/3", "services");
    public static final QName Q_NODE_SERVICES_LOGIN = new QName("http://www.geni.net/resources/rspec/3", "login");
    public static final QName Q_NODE_SERVICES_RDP = new QName("http://jfed.iminds.be/service-ms-rdp/1.0/", "ms-rdp");
    public static final QName Q_NODE_SERVICES_LOGIN_PROXY = new QName("http://jfed.iminds.be/proxy/1.0", "proxy");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_PROXY_PROXY = new QName("proxy");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_PROXY_FOR = new QName("for");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_AUTH = new QName("authentication");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_HOSTNAME = new QName("hostname");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_PORT = new QName("port");
    public static final QName Q_ATT_NODE_SERVICES_LOGIN_USERNAME = new QName("username");
    public static final QName Q_ATT_NODE_SERVICES_RDP_PASSWORD = new QName("password");
    public static final QName Q_JFED_ANSIBLE_GROUP = new QName("http://jfed.iminds.be/rspec/ext/jfed/1", "ansible_group");
    public static final QName Q_ATT_ANSIBLE_GROUP_NAME = new QName("name");
    public static final String NAMESPACE_EMULAB_EXT = "http://www.protogeni.net/resources/rspec/ext/emulab/1";
    public static final QName Q_ROUTABLE_POOL = new QName("http://www.protogeni.net/resources/rspec/ext/emulab/1", "routable_pool");
    private static final Pattern PROXY_PATTERN = Pattern.compile("([^@]*)@([^:]*):([0-9]*)");
    private static final Pattern PROXY_PATTERN_2 = Pattern.compile("([^@]*)@([^:]*)");

    public BasicStringRspec(@Nonnull String xmlString) {
        this.xmlString = xmlString;
        try {
            this.wellFormed = true;
            this.validRspec = true;
            this.parse();
        }
        catch (Exception e) {
            LOG.warn("XML is not well-formed and cannot be parsed: " + e.getMessage(), (Throwable)e);
            this.wellFormed = false;
        }
    }

    @Nonnull
    public static List<String> parseOpenflowComponentManagers(String xmlString) {
        HashSet<String> allComponentManagersSet = new HashSet<String>();
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(xmlString));
            XMLStreamReader streamReader = xif.createXMLStreamReader(xml);
            block6: while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        String comManId;
                        if (!Objects.equals(streamReader.getName().getNamespaceURI(), NAMESPACE_OPENFLOW) || (comManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart())) == null) continue block6;
                        allComponentManagersSet.add(comManId);
                        continue block6;
                    }
                    case 4: {
                        continue block6;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            LOG.trace("Error parsing openflow RSpec: ignored", (Throwable)e);
        }
        return new ArrayList<String>(allComponentManagersSet);
    }

    @Nonnull
    public String getXmlString() {
        return this.xmlString;
    }

    public boolean isWellFormed() {
        return this.wellFormed;
    }

    public boolean isValidRspec() {
        return this.wellFormed && this.validRspec;
    }

    protected void parse() {
        HashSet<String> allComponentManagersSet = new HashSet<String>();
        this.wellFormed = true;
        this.validRspec = true;
        int rspecCount = 0;
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(this.xmlString));
            XMLStreamReader streamReader = xif.createXMLStreamReader(xml);
            int link = 0;
            HashSet<String> curLinkComMan = new HashSet<String>();
            int rspecLevel = 0;
            boolean currentLinkCannotBeStitching = false;
            block7: while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 2: {
                        if (Objects.equals(streamReader.getName(), Q_RSPEC)) {
                            --rspecLevel;
                        }
                        if (!Objects.equals(streamReader.getName(), Q_LINK)) continue block7;
                        if (curLinkComMan.size() > 1 && !currentLinkCannotBeStitching) {
                            this.isPossiblyStitching = true;
                            this.stitchingCms.add(curLinkComMan);
                        }
                        curLinkComMan = new HashSet();
                        continue block7;
                    }
                    case 1: {
                        String linkTypeName;
                        String comManId;
                        if (Objects.equals(streamReader.getName(), Q_RSPEC)) {
                            ++rspecCount;
                            if (++rspecLevel == 1) {
                                this.rspecType = streamReader.getAttributeValue(Q_ATT_RSPEC_TYPE.getNamespaceURI(), Q_ATT_RSPEC_TYPE.getLocalPart());
                            }
                        }
                        if (rspecLevel > 0 && Objects.equals(streamReader.getName(), Q_NODE)) {
                            comManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart());
                            if (comManId == null) continue block7;
                            allComponentManagersSet.add(comManId);
                            continue block7;
                        }
                        if (Objects.equals(streamReader.getName(), Q_ROUTABLE_POOL) && (comManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart())) != null) {
                            allComponentManagersSet.add(comManId);
                        }
                        if (rspecLevel > 0 && Objects.equals(streamReader.getName(), Q_LINK)) {
                            ++link;
                            currentLinkCannotBeStitching = false;
                            continue block7;
                        }
                        if (rspecLevel > 0 && Objects.equals(streamReader.getName(), Q_LINK_TYPE) && (linkTypeName = streamReader.getAttributeValue(null, Q_ATT_LINK_TYPE_NAME.getLocalPart())) != null && !Objects.equals(linkTypeName, "lan") && !Objects.equals(linkTypeName, "vlan")) {
                            currentLinkCannotBeStitching = true;
                        }
                        if (rspecLevel <= 0 || !Objects.equals(streamReader.getName(), Q_LINK_COM_MAN) || (comManId = streamReader.getAttributeValue(null, Q_ATT_LINK_COM_MAN_NAME.getLocalPart())) == null) continue block7;
                        allComponentManagersSet.add(comManId);
                        curLinkComMan.add(comManId);
                        continue block7;
                    }
                    case 4: {
                        continue block7;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            LOG.error("Error parsing rspec. Will be ignored: " + e.getMessage(), (Throwable)e);
            this.wellFormed = false;
            return;
        }
        if (rspecCount <= 0) {
            this.validRspec = false;
        }
        if (this.isPossiblyStitching == null) {
            this.isPossiblyStitching = false;
        }
        allComponentManagersSet.addAll(BasicStringRspec.parseOpenflowComponentManagers(this.xmlString));
        this.allComponentManagers = new ArrayList<String>(allComponentManagersSet);
        assert (this.stitchingCms.isEmpty() == (this.isPossiblyStitching == false));
    }

    @Nonnull
    public List<String> getAllComponentManagerUrns() {
        if (this.allComponentManagers != null) {
            return this.allComponentManagers;
        }
        if (!this.isWellFormed()) {
            return Collections.emptyList();
        }
        this.parse();
        return this.allComponentManagers;
    }

    @Nonnull
    public List<Server> getAllComponentManager(TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, AuthorityFinder.Purpose purpose) {
        List<String> allComponentManagerUrns = this.getAllComponentManagerUrns();
        assert (allComponentManagerUrns != null);
        ArrayList<Server> res = new ArrayList<Server>();
        for (String cm : allComponentManagerUrns) {
            Server auth = authorityFinder.findByUrn(cm, purpose);
            res.add(auth);
        }
        return res;
    }

    @Nullable
    public Boolean isStitching(@Nullable TestbedInfoSource testbedInfoSource, @Nullable AuthorityFinder authorityFinder) {
        if (this.isPossiblyStitching == null) {
            if (!this.isWellFormed()) {
                return null;
            }
            this.parse();
        }
        if (!this.isPossiblyStitching.booleanValue()) {
            return false;
        }
        if (testbedInfoSource == null) {
            return this.isPossiblyStitching;
        }
        assert (!this.stitchingCms.isEmpty());
        for (Set<String> urns : this.stitchingCms) {
            Server firstServer = null;
            for (String urn : urns) {
                Server server = testbedInfoSource.getByUrn(urn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL);
                if (server == null) {
                    LOG.warn("Authority not found for " + urn + " during stitch check -> falling back to assuming link is stitched");
                    return true;
                }
                assert (server.getTestbed() != null);
                assert (server.getTestbed().getId() != null);
                if (firstServer == null) {
                    firstServer = server;
                    continue;
                }
                if (Objects.equals(firstServer.getTestbed().getId(), server.getTestbed().getId())) continue;
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static String makeUniqueNodeId(@Nullable String clientId, @Nullable String componentId, @Nullable String componentManagerId) {
        String compManPart = "@" + (componentManagerId == null ? "unspecified" : componentManagerId);
        if (clientId != null) {
            return clientId + compManPart;
        }
        return (componentId == null ? "nodeWithoutAnyId" : componentId) + compManPart;
    }

    @Nonnull
    public static String makeUniqueLinkId(@Nullable String clientId, @Nullable String componentId, @Nullable Collection<String> componentManagerIds) {
        Object compManPart;
        if (componentManagerIds != null && !componentManagerIds.isEmpty()) {
            compManPart = "@";
            ArrayList<String> sortedComponentManagerIds = new ArrayList<String>(componentManagerIds);
            Collections.sort(sortedComponentManagerIds);
            boolean first = true;
            for (String componentManagerId : sortedComponentManagerIds) {
                compManPart = first ? (String)compManPart + componentManagerId : (String)compManPart + "&" + componentManagerId;
                first = false;
            }
        } else {
            compManPart = "@unspecified";
        }
        if (clientId != null) {
            return clientId + (String)compManPart;
        }
        return (componentId == null ? "linkWithoutAnyId" : componentId) + (String)compManPart;
    }

    @Nonnull
    public static String makeUniqueInterfaceId(@Nullable String clientId, @Nullable String componentId, @Nullable String nodeUniqueId) {
        Object atPart;
        Object object = atPart = nodeUniqueId == null ? "@unknownNode" : "@" + nodeUniqueId;
        if (clientId != null) {
            return clientId + (String)atPart;
        }
        return (componentId == null ? "ifaceWithoutAnyId" : componentId) + (String)atPart;
    }

    @Nullable
    private static JFedConnection.SshProxyInfo parseProxy(@Nonnull String proxyString) {
        try {
            Matcher mProxy = PROXY_PATTERN.matcher(proxyString);
            if (mProxy.matches()) {
                int proxyPort = Integer.parseInt(mProxy.group(3));
                return new JFedConnection.SshProxyInfo(mProxy.group(2), proxyPort, mProxy.group(1), null, null);
            }
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse port in \"" + proxyString + "\"");
            return null;
        }
        Matcher mProxy2 = PROXY_PATTERN_2.matcher(proxyString);
        if (mProxy2.matches()) {
            return new JFedConnection.SshProxyInfo(mProxy2.group(2), 22, mProxy2.group(1), null, null);
        }
        return null;
    }

    @Nonnull
    public List<LoginService> findNodeLoginInfoByUniqueId(@Nonnull String nodeUniqueId) {
        List<LoginService> res = this.findNodeLoginInfo(streamReader -> {
            String clientId = streamReader.getAttributeValue(null, Q_ATT_CLIENT_ID.getLocalPart());
            String compManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart());
            String uniqueId = BasicStringRspec.makeUniqueNodeId(clientId == null ? null : clientId.trim(), null, compManId == null ? null : compManId.trim());
            return Objects.equals(uniqueId, nodeUniqueId.trim());
        });
        if (!res.isEmpty() || nodeUniqueId.indexOf(64) < 0) {
            return res;
        }
        return this.findNodeLoginInfoByClientId(nodeUniqueId.substring(0, nodeUniqueId.indexOf(64)));
    }

    @Nonnull
    public List<RdpService> findNodeRdpInfoByUniqueId(@Nonnull String nodeUniqueId) {
        List<RdpService> res = this.findNodeRdpInfo(streamReader -> {
            String clientId = streamReader.getAttributeValue(null, Q_ATT_CLIENT_ID.getLocalPart());
            String compManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart());
            String uniqueId = BasicStringRspec.makeUniqueNodeId(clientId == null ? null : clientId.trim(), null, compManId == null ? null : compManId.trim());
            return Objects.equals(uniqueId, nodeUniqueId.trim());
        });
        if (!res.isEmpty() || nodeUniqueId.indexOf(64) < 0) {
            return res;
        }
        return this.findNodeRdpInfoByClientId(nodeUniqueId.substring(0, nodeUniqueId.indexOf(64)));
    }

    @Nonnull
    public List<LoginService> findNodeLoginInfoByClientId(@Nonnull String nodeClientId) {
        return this.findNodeLoginInfo(streamReader -> {
            String clientId = streamReader.getAttributeValue(null, Q_ATT_CLIENT_ID.getLocalPart());
            return Objects.equals(clientId, nodeClientId.trim());
        });
    }

    @Nonnull
    public List<RdpService> findNodeRdpInfoByClientId(@Nonnull String nodeClientId) {
        return this.findNodeRdpInfo(streamReader -> {
            String clientId = streamReader.getAttributeValue(null, Q_ATT_CLIENT_ID.getLocalPart());
            return Objects.equals(clientId, nodeClientId.trim());
        });
    }

    public List<LoginService> findNodeLoginInfo(@Nonnull Predicate<XMLStreamReader> nodeElementFilter) {
        assert (nodeElementFilter != null);
        if (!this.isWellFormed()) {
            return Collections.emptyList();
        }
        ArrayList<LoginService> res = new ArrayList<LoginService>();
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(this.xmlString));
            XMLStreamReader streamReader = xif.createXMLStreamReader(xml);
            HashMap<LoginService, JFedConnection.SshProxyInfo> proxyMapping = new HashMap<LoginService, JFedConnection.SshProxyInfo>();
            boolean atCorrectNode = false;
            while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        if (Objects.equals(streamReader.getName(), Q_NODE)) {
                            atCorrectNode = nodeElementFilter.test(streamReader);
                            break;
                        }
                        if (atCorrectNode && Objects.equals(streamReader.getName(), Q_NODE_SERVICES_LOGIN_PROXY)) {
                            String attProxy = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PROXY_PROXY.getLocalPart());
                            String attFor = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PROXY_FOR.getLocalPart());
                            LOG.debug("Found proxy in service attProxy=" + attProxy + " attFor=" + attFor);
                            if (attProxy != null && attFor != null && !attProxy.trim().isEmpty() && !attFor.trim().isEmpty()) {
                                JFedConnection.SshProxyInfo proxy = BasicStringRspec.parseProxy(attProxy);
                                JFedConnection.SshProxyInfo proxyFor = BasicStringRspec.parseProxy(attFor);
                                if (proxy != null && proxyFor != null) {
                                    LoginService forLoginService = new LoginService("ssh-keys", proxyFor.getHostname(), proxyFor.getPort(), proxyFor.getUsername(), proxy);
                                    proxyMapping.put(forLoginService, proxy);
                                    LOG.debug("Found and registered proxy " + attProxy + " (=" + proxy + ") for " + attFor + " (=" + forLoginService + ")");
                                } else {
                                    LOG.warn("Invalid SSH proxy attribute: attProxy=" + attProxy + " attFor=" + attFor);
                                }
                            } else {
                                LOG.warn("Invalid SSH proxy attribute (empty): attProxy=" + attProxy + " attFor=" + attFor);
                            }
                        }
                        if (!atCorrectNode || !Objects.equals(streamReader.getName(), Q_NODE_SERVICES_LOGIN)) break;
                        String attAuth = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_AUTH.getLocalPart());
                        String attHostname = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_HOSTNAME.getLocalPart());
                        String attPort = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PORT.getLocalPart());
                        String attUsername = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_USERNAME.getLocalPart());
                        try {
                            res.add(new LoginService(attAuth, attHostname, attPort == null ? 22 : Integer.parseInt(attPort), attUsername, null));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Found matching login details but with non numeric port (\"" + attPort + "\") -> These login details will be ignored.", (Throwable)e);
                        }
                        break;
                    }
                    case 2: {
                        if (!Objects.equals(streamReader.getName(), Q_NODE)) break;
                        atCorrectNode = false;
                    }
                }
            }
            if (!proxyMapping.isEmpty()) {
                for (int i = 0; i < res.size(); ++i) {
                    LoginService ls = (LoginService)res.get(i);
                    LoginService matchLs = null;
                    JFedConnection.SshProxyInfo matchProxy = null;
                    for (Map.Entry e : proxyMapping.entrySet()) {
                        LoginService curLs = (LoginService)e.getKey();
                        if (!Objects.equals(curLs.getHostname(), ls.getHostname()) || !Objects.equals(curLs.getUsername(), ls.getUsername()) || curLs.getPort() != ls.getPort()) continue;
                        matchLs = curLs;
                        matchProxy = (JFedConnection.SshProxyInfo)e.getValue();
                        break;
                    }
                    if (matchLs != null && matchProxy != null) {
                        LoginService updatedLs = new LoginService(matchLs.getAuthentication(), matchLs.getHostname(), matchLs.getPort(), matchLs.getUsername(), matchProxy);
                        res.set(i, updatedLs);
                        LOG.debug("Found proxy for " + ls + " : " + matchProxy);
                        continue;
                    }
                    LOG.debug("Did not find proxy for " + ls);
                }
            }
            for (LoginService pls : proxyMapping.keySet()) {
                boolean removed = false;
                block12: for (int i = 0; i < res.size(); ++i) {
                    LoginService ls = (LoginService)res.get(i);
                    for (Map.Entry e : proxyMapping.entrySet()) {
                        JFedConnection.SshProxyInfo proxyInfo = (JFedConnection.SshProxyInfo)e.getValue();
                        if (!Objects.equals(proxyInfo.getHostname(), ls.getHostname()) || !Objects.equals(proxyInfo.getUsername(), ls.getUsername()) || proxyInfo.getPort() != ls.getPort()) continue;
                        res.remove(i);
                        removed = true;
                        break block12;
                    }
                }
                if (removed) {
                    LOG.debug("Removed proxy from results");
                    continue;
                }
                LOG.warn("Failed to remove proxy from results");
            }
            if (proxyMapping.keySet().isEmpty()) {
                LOG.debug("There are no proxies to remove");
            }
        }
        catch (XMLStreamException e) {
            LOG.error("Error parsing rspec. Will be ignored: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    public List<RdpService> findNodeRdpInfo(@Nonnull Predicate<XMLStreamReader> nodeElementFilter) {
        assert (nodeElementFilter != null);
        if (!this.isWellFormed()) {
            return Collections.emptyList();
        }
        ArrayList<RdpService> res = new ArrayList<RdpService>();
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(this.xmlString));
            XMLStreamReader streamReader = xif.createXMLStreamReader(xml);
            HashMap<LoginService, JFedConnection.SshProxyInfo> proxyMapping = new HashMap<LoginService, JFedConnection.SshProxyInfo>();
            boolean atCorrectNode = false;
            while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        if (Objects.equals(streamReader.getName(), Q_NODE)) {
                            atCorrectNode = nodeElementFilter.test(streamReader);
                            break;
                        }
                        if (atCorrectNode && Objects.equals(streamReader.getName(), Q_NODE_SERVICES_LOGIN_PROXY)) {
                            String attProxy = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PROXY_PROXY.getLocalPart());
                            String attFor = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PROXY_FOR.getLocalPart());
                            LOG.debug("Found proxy in service attProxy=" + attProxy + " attFor=" + attFor);
                            if (attProxy != null && attFor != null && !attProxy.trim().isEmpty() && !attFor.trim().isEmpty()) {
                                JFedConnection.SshProxyInfo proxy = BasicStringRspec.parseProxy(attProxy);
                                JFedConnection.SshProxyInfo proxyFor = BasicStringRspec.parseProxy(attFor);
                                if (proxy != null && proxyFor != null) {
                                    LoginService forLoginService = new LoginService("ssh-keys", proxyFor.getHostname(), proxyFor.getPort(), proxyFor.getUsername(), proxy);
                                    proxyMapping.put(forLoginService, proxy);
                                    LOG.debug("Found and registered proxy " + attProxy + " (=" + proxy + ") for " + attFor + " (=" + forLoginService + ")");
                                } else {
                                    LOG.warn("Invalid SSH proxy attribute: attProxy=" + attProxy + " attFor=" + attFor);
                                }
                            } else {
                                LOG.warn("Invalid SSH proxy attribute (empty): attProxy=" + attProxy + " attFor=" + attFor);
                            }
                        }
                        if (!atCorrectNode || !Objects.equals(streamReader.getName(), Q_NODE_SERVICES_RDP)) break;
                        String attHostname = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_HOSTNAME.getLocalPart());
                        String attPort = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_PORT.getLocalPart());
                        String attUsername = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_LOGIN_USERNAME.getLocalPart());
                        String attPassword = streamReader.getAttributeValue(null, Q_ATT_NODE_SERVICES_RDP_PASSWORD.getLocalPart());
                        try {
                            res.add(new RdpService(attHostname, attPort == null ? 3389 : Integer.parseInt(attPort), attUsername, attPassword, null));
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Found matching login details but with non numeric port (\"" + attPort + "\") -> These login details will be ignored.", (Throwable)e);
                        }
                        break;
                    }
                    case 2: {
                        if (!Objects.equals(streamReader.getName(), Q_NODE)) break;
                        atCorrectNode = false;
                    }
                }
            }
            if (!proxyMapping.isEmpty()) {
                for (int i = 0; i < res.size(); ++i) {
                    RdpService rdps = (RdpService)res.get(i);
                    LoginService matchLs = null;
                    JFedConnection.SshProxyInfo matchProxy = null;
                    for (Map.Entry e : proxyMapping.entrySet()) {
                        LoginService curLs = (LoginService)e.getKey();
                        if (!Objects.equals(curLs.getHostname(), rdps.getHostname()) || !Objects.equals(curLs.getUsername(), rdps.getUsername()) || curLs.getPort() != rdps.getPort()) continue;
                        matchLs = curLs;
                        matchProxy = (JFedConnection.SshProxyInfo)e.getValue();
                        break;
                    }
                    if (matchLs != null && matchProxy != null) {
                        RdpService updatedRdps = new RdpService(rdps.getHostname(), rdps.getPort(), rdps.getUsername(), rdps.getPassword(), matchProxy);
                        res.set(i, updatedRdps);
                        LOG.debug("Found proxy for " + rdps + " : " + matchProxy);
                        continue;
                    }
                    LOG.debug("Did not find proxy for " + rdps);
                }
            }
        }
        catch (XMLStreamException e) {
            LOG.error("Error parsing rspec. Will be ignored: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @Nullable
    public List<BasicNodeInfo> getBasicNodeInfo() {
        if (!this.isWellFormed()) {
            return null;
        }
        ArrayList<BasicNodeInfo> res = new ArrayList<BasicNodeInfo>();
        try {
            XMLInputFactory xif = XMLInputFactory.newFactory();
            StreamSource xml = new StreamSource(new StringReader(this.xmlString));
            XMLStreamReader streamReader = xif.createXMLStreamReader(xml);
            String comManId = null;
            String comId = null;
            String clientId = null;
            Boolean available = null;
            Boolean exclusive = null;
            ArrayList<String> sliverTypes = new ArrayList<String>();
            ArrayList<String> ansibleGroups = new ArrayList<String>();
            while (streamReader.hasNext()) {
                streamReader.next();
                switch (streamReader.getEventType()) {
                    case 1: {
                        String ansibleGroup;
                        String sliverType;
                        if (Objects.equals(streamReader.getName(), Q_NODE)) {
                            comManId = streamReader.getAttributeValue(null, Q_ATT_COM_MAN_ID.getLocalPart());
                            comId = streamReader.getAttributeValue(null, Q_ATT_COM_ID.getLocalPart());
                            clientId = streamReader.getAttributeValue(null, Q_ATT_CLIENT_ID.getLocalPart());
                            exclusive = TextUtil.objectToBoolean((Object)streamReader.getAttributeValue(null, Q_ATT_NODE_EXCLUSIVE.getLocalPart()));
                        }
                        if (Objects.equals(streamReader.getName(), Q_NODE_AVAILABLE)) {
                            available = TextUtil.objectToBoolean((Object)streamReader.getAttributeValue(null, Q_ATT_NODE_AVAILABLE_NOW.getLocalPart()));
                        }
                        if (Objects.equals(streamReader.getName(), Q_NODE_SLIVERTYPE) && (sliverType = streamReader.getAttributeValue(null, Q_ATT_NODE_SLIVERTYPE_NAME.getLocalPart())) != null) {
                            sliverTypes.add(sliverType);
                        }
                        if (!Objects.equals(streamReader.getName(), Q_JFED_ANSIBLE_GROUP) || (ansibleGroup = streamReader.getAttributeValue(null, Q_ATT_ANSIBLE_GROUP_NAME.getLocalPart())) == null) break;
                        ansibleGroups.add(ansibleGroup);
                        break;
                    }
                    case 2: {
                        if (!Objects.equals(streamReader.getName(), Q_NODE)) break;
                        if (clientId != null || comId != null || comManId != null) {
                            res.add(new BasicNodeInfo(clientId, comId, comManId, available, exclusive, sliverTypes, ansibleGroups));
                        }
                        comManId = null;
                        comId = null;
                        clientId = null;
                        available = null;
                        exclusive = null;
                        sliverTypes = new ArrayList();
                        ansibleGroups = new ArrayList();
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            LOG.error("Error parsing rspec. Will be ignored: " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    @Nullable
    public String getRspecType() {
        return this.rspecType;
    }

    public static class LoginService {
        @Nonnull
        private final String authentication;
        @Nonnull
        private final String hostname;
        private final int port;
        @Nonnull
        private final String username;
        @Nullable
        private final JFedConnection.SshProxyInfo sshProxy;

        public LoginService(@Nonnull String authentication, @Nonnull String hostname, int port, @Nonnull String username, @Nullable JFedConnection.SshProxyInfo sshProxy) {
            assert (authentication != null);
            assert (hostname != null);
            assert (username != null);
            this.authentication = authentication;
            this.hostname = hostname;
            this.port = port <= 0 ? 22 : port;
            this.username = username;
            this.sshProxy = sshProxy;
        }

        @Nonnull
        public String getAuthentication() {
            return this.authentication;
        }

        @Nonnull
        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        @Nonnull
        public String getUsername() {
            return this.username;
        }

        @Nullable
        public JFedConnection.SshProxyInfo getSshProxy() {
            return this.sshProxy;
        }

        public String toString() {
            return "LoginService{authentication='" + this.authentication + "', hostname='" + this.hostname + "', port=" + this.port + ", username='" + this.username + "', sshProxy='" + this.sshProxy + "'}";
        }

        public String toDescription(boolean addUser, boolean addProxy) {
            LoginService loginService = this;
            Object proxy = addUser && loginService.getSshProxy() != null ? "\n   with testbed proxy\n   " + loginService.getSshProxy().getUsername() + "@" + (String)(loginService.getSshProxy().getHostname().contains(":") ? "[" + loginService.getSshProxy().getHostname() + "]" : loginService.getSshProxy().getHostname()) + ":" + loginService.getSshProxy().getPort() : "";
            Object user = addUser ? loginService.getUsername() + "@" : "";
            if (loginService.getHostname().contains(":")) {
                return (String)user + "[" + loginService.getHostname() + "]:" + loginService.getPort() + (String)proxy;
            }
            return (String)user + loginService.getHostname() + ":" + loginService.getPort() + (String)proxy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoginService)) {
                return false;
            }
            LoginService that = (LoginService)o;
            return this.port == that.port && Objects.equals(this.authentication, that.authentication) && Objects.equals(this.hostname, that.hostname) && Objects.equals(this.username, that.username) && Objects.equals(this.sshProxy, that.sshProxy);
        }

        public int hashCode() {
            return Objects.hash(this.authentication, this.hostname, this.port, this.username, this.sshProxy);
        }
    }

    public static class RdpService {
        @Nullable
        private final String password;
        @Nonnull
        private final String hostname;
        private final int port;
        @Nullable
        private final String username;
        @Nullable
        private final JFedConnection.SshProxyInfo sshProxy;

        public RdpService(@Nonnull String hostname, int port, @Nullable String username, @Nullable String password, @Nullable JFedConnection.SshProxyInfo sshProxy) {
            assert (hostname != null);
            this.password = password;
            this.hostname = hostname;
            this.port = port <= 0 ? 3389 : port;
            this.username = username;
            this.sshProxy = sshProxy;
        }

        @Nullable
        public String getPassword() {
            return this.password;
        }

        @Nonnull
        public String getHostname() {
            return this.hostname;
        }

        public int getPort() {
            return this.port;
        }

        @Nullable
        public String getUsername() {
            return this.username;
        }

        @Nullable
        public JFedConnection.SshProxyInfo getSshProxy() {
            return this.sshProxy;
        }

        public String toString() {
            return "RdpService{password='" + this.password + "', hostname='" + this.hostname + "', port=" + this.port + ", username='" + this.username + "', sshProxy='" + this.sshProxy + "'}";
        }
    }

    public static class BasicNodeInfo {
        @Nullable
        private final String clientId;
        @Nullable
        private final String componentId;
        @Nullable
        private final String componentManagerId;
        @Nonnull
        private final Collection<String> sliverTypes;
        @Nullable
        private final Boolean available;
        @Nullable
        private final Boolean exclusive;
        @Nonnull
        private final List<String> ansibleGroups;

        public BasicNodeInfo(@Nullable String clientId, @Nullable String componentId, @Nullable String componentManagerId, @Nullable Boolean available, @Nullable Boolean exclusive, @Nullable Collection<String> sliverTypes, @Nullable List<String> ansibleGroups) {
            this.clientId = clientId;
            this.componentId = componentId;
            this.componentManagerId = componentManagerId;
            this.available = available;
            this.exclusive = exclusive;
            this.sliverTypes = sliverTypes == null ? Collections.emptyList() : sliverTypes;
            this.ansibleGroups = ansibleGroups == null ? Collections.emptyList() : ansibleGroups;
        }

        @Nullable
        public String getClientId() {
            return this.clientId;
        }

        @Nullable
        public String getComponentId() {
            return this.componentId;
        }

        @Nullable
        public String getComponentManagerId() {
            return this.componentManagerId;
        }

        @Nullable
        public Boolean isAvailable() {
            return this.available;
        }

        @Nonnull
        public Collection<String> getSliverTypes() {
            return this.sliverTypes;
        }

        @Nullable
        public Boolean isExclusive() {
            return this.exclusive;
        }

        @Nonnull
        public List<String> getAnsibleGroups() {
            return this.ansibleGroups;
        }

        @Nonnull
        public String getUniqueId() {
            return BasicStringRspec.makeUniqueNodeId(this.clientId == null ? null : this.clientId.trim(), this.componentId == null ? null : this.componentId.trim(), this.componentManagerId == null ? null : this.componentManagerId.trim());
        }
    }
}

