/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.lib;

import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.InvalidSshKeyInfoException;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import javax.annotation.Nonnull;

public class SSHKeyHelper {
    @Nonnull
    private final RSAPrivateKey sshPrivateKey;
    @Nonnull
    private final KeyPair keyPair;
    @Nonnull
    private final RSAPublicKey sshPublicKey;
    @Nonnull
    private final String sshPublicKeyString;

    public SSHKeyHelper() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(4096);
        this.keyPair = generator.genKeyPair();
        this.sshPrivateKey = (RSAPrivateKey)this.keyPair.getPrivate();
        this.sshPublicKey = (RSAPublicKey)this.keyPair.getPublic();
        this.sshPublicKeyString = KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormat((RSAPublicKey)this.sshPublicKey);
    }

    public SSHKeyHelper(X509Certificate cert, PrivateKey privateKey) throws NoSuchAlgorithmException {
        this(cert.getPublicKey(), privateKey);
    }

    public SSHKeyHelper(RSAPrivateKey privateKey) throws NoSuchAlgorithmException {
        this(KeyUtil.rsaPrivateKeyToRsaPublicKey((RSAPrivateKey)privateKey), (PrivateKey)privateKey);
    }

    public SSHKeyHelper(PublicKey publicKey, PrivateKey privateKey) {
        assert (publicKey != null);
        assert (privateKey != null);
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new RuntimeException("SSHKeyHelper only works with RSAPublicKey (not with " + publicKey.getClass().getName() + ")");
        }
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new RuntimeException("SSHKeyHelper only works with RSAPrivateKey (not with " + privateKey.getClass().getName() + ")\"");
        }
        this.sshPrivateKey = (RSAPrivateKey)privateKey;
        this.sshPublicKey = (RSAPublicKey)publicKey;
        this.keyPair = new KeyPair(this.sshPublicKey, this.sshPrivateKey);
        this.sshPublicKeyString = KeyUtil.rsaPublicKeyToOpenSshAuthorizedKeysFormat((RSAPublicKey)this.sshPublicKey);
    }

    @Nonnull
    public RSAPrivateKey getSshPrivateKey() {
        return this.sshPrivateKey;
    }

    public char[] getPEMPrivateKey() {
        return KeyUtil.privateKeyToPem((PrivateKey)this.sshPrivateKey);
    }

    public char[] getPEMRsaPrivateKey() {
        return KeyUtil.rsaPrivateKeyToPem((RSAPrivateKey)this.sshPrivateKey);
    }

    public char[] getPEMAnyPrivateKey() {
        return KeyUtil.privateKeyToAnyPem((PrivateKey)this.sshPrivateKey);
    }

    @Nonnull
    public RSAPublicKey getSshPublicKey() {
        return this.sshPublicKey;
    }

    @Nonnull
    public String getSshPublicKeyString() {
        return this.sshPublicKeyString;
    }

    public SshKeyInfo toSshKeyInfo() {
        try {
            return SshKeyInfoFactory.createBasicSshKeyInfo(this.sshPublicKey, this.sshPrivateKey);
        }
        catch (InvalidSshKeyInfoException e) {
            throw new RuntimeException("Unexpected failure to create BasicSshKeyInfo", e);
        }
    }
}

