/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeniUrn
extends ResourceUrn {
    private static final Pattern EXCLUDED_URN_PATTERNS = Pattern.compile("[/#?\\\\\"&<>\\[\\]^`{|}~\\x7F-\\xFF\\x00-\\x20]");
    private static final Logger LOG = LoggerFactory.getLogger(GeniUrn.class);
    private static final String URN_REGEX = "urn:publicid:IDN\\+([0-9a-zA-Z._:-]*)\\+([a-zA-Z]*)\\+([+;%/0-9a-zA-Z._:-]*)";
    private static final Pattern URN_PATTERN = Pattern.compile("urn:publicid:IDN\\+([0-9a-zA-Z._:-]*)\\+([a-zA-Z]*)\\+([+;%/0-9a-zA-Z._:-]*)");
    @Nonnull
    private final String topLevelAuthority_enc;
    @Nonnull
    private final String topLevelAuthority_withoutSubAuth_enc;
    @Nonnull
    private final String resourceType_enc;
    @Nonnull
    private final String resourceName_enc;
    @Nonnull
    private final String topLevelAuthority_dec;
    @Nonnull
    private final String topLevelAuthority_withoutSubAuth_dec;
    @Nonnull
    private final String resourceType_dec;
    @Nonnull
    private final String resourceName_dec;

    public static GeniUrn createGeniUrnFromEncodedParts(String topLevelAuthority, String resourceType, String resourceName) {
        return new GeniUrn(topLevelAuthority, resourceType, resourceName, true);
    }

    public static GeniUrn createGeniUrnFromDecodedParts(String topLevelAuthority, String resourceType, String resourceName) {
        return new GeniUrn(topLevelAuthority, resourceType, resourceName, false);
    }

    public static GeniUrn createGeniUrnFromPublicID(@Nonnull String publicIdString) {
        String[] parts = publicIdString.split(" ", 4);
        if (parts.length > 1 && !Objects.equals(parts[0], "IDN")) {
            throw new IllegalArgumentException("Not a public ID String, should start with \"IDN\": \"" + publicIdString + "\"");
        }
        if (parts.length < 4) {
            throw new IllegalArgumentException("Not a public ID String: \"" + publicIdString + "\" (" + parts.length + " parts)");
        }
        return GeniUrn.createGeniUrnFromDecodedParts(parts[1], parts[2], parts[3]);
    }

    public GeniUrn replaceTopLevelAuthority(@Nonnull String newTopLevelAuthority) {
        return GeniUrn.createGeniUrnFromDecodedParts(newTopLevelAuthority, this.resourceType_dec, this.resourceName_dec);
    }

    public GeniUrn replaceSubAuthority(@Nullable String newSubAuthority) {
        if (newSubAuthority == null) {
            return GeniUrn.createGeniUrnFromDecodedParts(this.topLevelAuthority_withoutSubAuth_dec, this.resourceType_dec, this.resourceName_dec);
        }
        return GeniUrn.createGeniUrnFromDecodedParts(this.topLevelAuthority_withoutSubAuth_dec + "//" + newSubAuthority, this.resourceType_dec, this.resourceName_dec);
    }

    public GeniUrn(@Nonnull String urn) throws GeniUrnParseException {
        super(urn);
        assert (urn != null);
        assert (EXCLUDED_URN_PATTERNS != null);
        if (EXCLUDED_URN_PATTERNS.matcher(urn).find()) {
            throw new GeniUrnParseException(urn);
        }
        Matcher urnMatcher = URN_PATTERN.matcher(urn);
        if (!urnMatcher.matches()) {
            throw new GeniUrnParseException(urn);
        }
        this.topLevelAuthority_enc = urnMatcher.group(1);
        this.resourceType_enc = urnMatcher.group(2);
        this.resourceName_enc = urnMatcher.group(3);
        this.topLevelAuthority_dec = GeniUrn.urnDecoding(this.topLevelAuthority_enc);
        this.resourceType_dec = GeniUrn.urnDecoding(this.resourceType_enc);
        this.resourceName_dec = GeniUrn.urnDecoding(this.resourceName_enc);
        if (this.topLevelAuthority_dec == null || this.resourceType_dec == null || this.resourceName_dec == null) {
            throw new GeniUrnParseException(urn);
        }
        if (this.topLevelAuthority_dec.isEmpty() || this.resourceType_dec.isEmpty() || this.resourceName_dec.isEmpty()) {
            throw new GeniUrnParseException(urn);
        }
        this.topLevelAuthority_withoutSubAuth_enc = this.topLevelAuthority_enc.replaceFirst(":.*", "");
        this.topLevelAuthority_withoutSubAuth_dec = GeniUrn.urnDecoding(this.topLevelAuthority_withoutSubAuth_enc);
    }

    @Nullable
    @Contract(value="null -> null")
    public static GeniUrn parse(@Nullable String urn) {
        if (urn == null) {
            return null;
        }
        try {
            return new GeniUrn(urn);
        }
        catch (GeniUrnParseException e) {
            return null;
        }
    }

    @Nonnull
    public static String urnEncoding(@Nonnull String text) {
        text = text.trim();
        Object res = "";
        boolean prevIsWhitespace = false;
        block5: for (int i = 0; i < text.length(); ++i) {
            int d;
            char c = text.charAt(i);
            int n = d = i < text.length() - 1 ? (int)text.charAt(i + 1) : 88;
            if (Character.isWhitespace(c)) {
                if (!prevIsWhitespace) {
                    res = (String)res + "+";
                }
                prevIsWhitespace = true;
                continue;
            }
            prevIsWhitespace = false;
            switch (c) {
                case '#': 
                case '\'': 
                case '+': 
                case ':': 
                case ';': 
                case '?': {
                    if (d == 58) {
                        res = (String)res + ";";
                        ++i;
                        continue block5;
                    }
                }
                case '/': {
                    if (d == 47) {
                        res = (String)res + ":";
                        ++i;
                        continue block5;
                    }
                }
                case '%': {
                    res = (String)res + "%" + Integer.toHexString(c).toUpperCase();
                    continue block5;
                }
                default: {
                    res = (String)res + c;
                }
            }
        }
        return res;
    }

    @Nonnull
    public static String urnDecoding(@Nonnull String urnText) {
        Object res = "";
        block8: for (int i = 0; i < urnText.length(); ++i) {
            char c = urnText.charAt(i);
            String next2 = "";
            if (i < urnText.length() - 2) {
                next2 = urnText.substring(i + 1, i + 3);
            }
            switch (c) {
                case ':': {
                    res = (String)res + "//";
                    continue block8;
                }
                case ';': {
                    res = (String)res + "::";
                    continue block8;
                }
                case '+': {
                    res = (String)res + " ";
                    continue block8;
                }
                case '%': {
                    try {
                        int charCode = Integer.parseInt(next2, 16);
                        res = (String)res + (char)charCode;
                        i += 2;
                    }
                    catch (NumberFormatException e) {
                        res = (String)res + c;
                    }
                    continue block8;
                }
                default: {
                    res = (String)res + c;
                }
            }
        }
        return res;
    }

    @Nonnull
    public static GeniUrn removeSubAuth(@Nonnull GeniUrn urn) {
        return GeniUrn.createGeniUrnFromEncodedParts(urn.getEncodedTopLevelAuthority_withoutSubAuth(), urn.getEncodedResourceType(), urn.getEncodedResourceName());
    }

    public static boolean valid(@Nullable String urn) {
        if (urn == null) {
            return false;
        }
        try {
            new GeniUrn(urn);
            return true;
        }
        catch (GeniUrnParseException e) {
            return false;
        }
    }

    private GeniUrn(@Nonnull String topLevelAuthority_in, @Nonnull String resourceType_in, @Nonnull String resourceName_in, boolean encoded) {
        super("dummy");
        if (encoded) {
            this.topLevelAuthority_enc = topLevelAuthority_in;
            this.resourceType_enc = resourceType_in;
            this.resourceName_enc = resourceName_in;
            this.topLevelAuthority_dec = GeniUrn.urnDecoding(this.topLevelAuthority_enc);
            this.resourceType_dec = GeniUrn.urnDecoding(this.resourceType_enc);
            this.resourceName_dec = GeniUrn.urnDecoding(this.resourceName_enc);
        } else {
            this.topLevelAuthority_enc = GeniUrn.urnEncoding(topLevelAuthority_in);
            this.resourceType_enc = GeniUrn.urnEncoding(resourceType_in);
            this.resourceName_enc = GeniUrn.urnEncoding(resourceName_in);
            this.topLevelAuthority_dec = GeniUrn.urnDecoding(this.topLevelAuthority_enc);
            this.resourceType_dec = GeniUrn.urnDecoding(this.resourceType_enc);
            this.resourceName_dec = GeniUrn.urnDecoding(this.resourceName_enc);
        }
        this.value = this.toString();
        assert (this.topLevelAuthority_dec != null);
        assert (this.resourceType_dec != null);
        assert (this.resourceName_dec != null);
        assert (!this.topLevelAuthority_dec.isEmpty());
        assert (!this.resourceType_dec.isEmpty());
        assert (!this.resourceName_dec.isEmpty());
        this.topLevelAuthority_withoutSubAuth_enc = this.topLevelAuthority_enc.replaceFirst(":.*", "");
        this.topLevelAuthority_withoutSubAuth_dec = GeniUrn.urnDecoding(this.topLevelAuthority_withoutSubAuth_enc);
    }

    @Nonnull
    public String getEncodedTopLevelAuthority() {
        return this.topLevelAuthority_enc;
    }

    @Nonnull
    public String getEncodedTopLevelAuthority_withoutSubAuth() {
        return this.topLevelAuthority_withoutSubAuth_enc;
    }

    @Nonnull
    public String getEncodedResourceType() {
        return this.resourceType_enc;
    }

    @Nonnull
    public String getEncodedResourceName() {
        return this.resourceName_enc;
    }

    @Nonnull
    public String getTopLevelAuthority() {
        return this.topLevelAuthority_dec;
    }

    @Nonnull
    public String getTopLevelAuthority_withoutSubAuth() {
        return this.topLevelAuthority_withoutSubAuth_dec;
    }

    @Nonnull
    public String getResourceType() {
        return this.resourceType_dec;
    }

    @Nonnull
    public String getResourceName() {
        return this.resourceName_dec;
    }

    public boolean hasSubAuthority() {
        return this.topLevelAuthority_enc.contains(":");
    }

    @Nullable
    public String getEncodedSubAuthName() {
        String[] s = this.topLevelAuthority_enc.split(":", 2);
        if (s.length < 2) {
            return null;
        }
        return s[1];
    }

    @Nullable
    public String getSubAuthName() {
        String[] s = this.topLevelAuthority_dec.split("//", 2);
        if (s.length < 2) {
            return null;
        }
        return s[1];
    }

    @Nullable
    public String getEncodedSubAuthNames(int limit) {
        if (limit < 1) {
            LOG.error("Bad call: limit=" + limit + " but must be >= 1");
            return null;
        }
        assert (limit >= 1);
        String[] s = this.topLevelAuthority_enc.split(":");
        if (s.length <= limit) {
            return null;
        }
        Object res = s[1];
        for (int i = 2; i <= limit; ++i) {
            res = (String)res + ":" + s[i];
        }
        return res;
    }

    @Nullable
    public String getSubAuthNames(int limit) {
        if (limit < 1) {
            LOG.error("Bad call: limit=" + limit + " but must be >= 1");
            return null;
        }
        assert (limit >= 1);
        String[] s = this.topLevelAuthority_dec.split("//");
        if (s.length <= limit) {
            return null;
        }
        Object res = s[1];
        for (int i = 2; i <= limit; ++i) {
            res = (String)res + "//" + s[i];
        }
        return res;
    }

    @Nullable
    public String getEncodedSubAuthName(int index) {
        String[] s = this.topLevelAuthority_enc.split(":");
        if (s.length <= index + 1) {
            return null;
        }
        return s[index + 1];
    }

    @Nullable
    public String getSubAuthName(int index) {
        String[] s = this.topLevelAuthority_dec.split("//");
        if (s.length <= index + 1) {
            return null;
        }
        return s[index + 1];
    }

    public int getSubAuthCount() {
        String[] s = this.topLevelAuthority_enc.split(":");
        if (s.length < 2) {
            return 0;
        }
        return s.length - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            LOG.warn("Comparing String to GeniUrn, this is most likely a bug! (will always be false)", (Throwable)new RuntimeException("bug"));
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeniUrn geniUrn = (GeniUrn)o;
        if (!Objects.equals(this.resourceName_enc, geniUrn.resourceName_enc)) {
            return false;
        }
        if (!Objects.equals(this.resourceType_enc, geniUrn.resourceType_enc)) {
            return false;
        }
        return Objects.equals(this.topLevelAuthority_enc, geniUrn.topLevelAuthority_enc);
    }

    public boolean equalsIgnoringSubAuth(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof String) {
            LOG.warn("Comparing String to GeniUrn, this is most likely a bug! (will always be false)", (Throwable)new RuntimeException("bug"));
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeniUrn geniUrn = (GeniUrn)o;
        if (!Objects.equals(this.resourceName_enc, geniUrn.resourceName_enc)) {
            return false;
        }
        if (!Objects.equals(this.resourceType_enc, geniUrn.resourceType_enc)) {
            return false;
        }
        return Objects.equals(this.topLevelAuthority_withoutSubAuth_enc, geniUrn.topLevelAuthority_withoutSubAuth_enc);
    }

    public boolean hasCompatibleAuthority(@Nonnull GeniUrn o) {
        if (!Objects.equals(this.getEncodedTopLevelAuthority_withoutSubAuth(), o.getEncodedTopLevelAuthority_withoutSubAuth())) {
            return false;
        }
        if (this.hasSubAuthority() && o.hasSubAuthority()) {
            String compManSubAuth;
            int minSubAuthCount = Math.min(this.getSubAuthCount(), o.getSubAuthCount());
            assert (minSubAuthCount > 0);
            String sliverSubAuth = this.getEncodedSubAuthNames(minSubAuthCount);
            if (!Objects.equals(sliverSubAuth, compManSubAuth = o.getEncodedSubAuthNames(minSubAuthCount))) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = this.topLevelAuthority_enc.hashCode();
        result = 31 * result + this.resourceType_enc.hashCode();
        result = 31 * result + this.resourceName_enc.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "urn:publicid:IDN+" + this.topLevelAuthority_enc + "+" + this.resourceType_enc + "+" + this.resourceName_enc;
    }

    public class GeniUrnParseException
    extends Exception {
        public GeniUrnParseException(String badUrn) {
            super("String \"" + badUrn + "\" is not a valid Geni Urn");
        }
    }

    public static class JsonSerializer
    extends com.fasterxml.jackson.databind.JsonSerializer<GeniUrn> {
        public void serialize(GeniUrn geniUrn, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (geniUrn == null) {
                return;
            }
            jsonGenerator.writeString(geniUrn.getValue());
        }
    }

    public static class JsonDeserializer
    extends com.fasterxml.jackson.databind.JsonDeserializer<GeniUrn> {
        public GeniUrn deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            if (node.isTextual()) {
                String urnStr = node.asText();
                try {
                    return new GeniUrn(urnStr);
                }
                catch (GeniUrnParseException e) {
                    throw new IOException("Failed to parse GeniUrn \"" + urnStr + "\"", e);
                }
            }
            throw new IOException("Invalid JSON type for GeniUrn. Must be JSON string, but is " + node.getNodeType().name());
        }
    }
}

