/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.common;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class TimeUtil {
    private TimeUtil() {
    }

    public static String calcAgo(Date date) {
        return TimeUtil.calcAgo(date.toInstant());
    }

    public static String calcAgo(Instant date) {
        return TimeUtil.calcAgo(date, Instant.now());
    }

    public static String calcIn(Instant date) {
        return TimeUtil.calcIn(date, Instant.now());
    }

    public static String calcIn(Instant date, Instant now) {
        long ms = date.toEpochMilli() - now.toEpochMilli();
        if (ms < -5000L) {
            return "in the past";
        }
        if (ms < 4000L) {
            return "almost now";
        }
        if (ms < 20000L) {
            return "in a few seconds";
        }
        if (ms < 60000L) {
            return "in less than a minute";
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(ms);
        if (minutes == 1L) {
            return "in one minute";
        }
        if (minutes < 60L) {
            return "in " + minutes + " minutes";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(ms);
        if (hours == 1L) {
            return "in one hour";
        }
        if (hours < 28L) {
            return "in " + hours + " hours";
        }
        long days = TimeUnit.MILLISECONDS.toDays(ms);
        if (days < 61L) {
            return "in " + days + " days";
        }
        if (days < 730L) {
            return "in more than " + Math.floor((double)days / 30.0) + " months";
        }
        return "in more than " + Math.floor((double)days / 356.0) + " years";
    }

    public static String calcAgo(Instant date, Instant now) {
        long ms = now.toEpochMilli() - date.toEpochMilli();
        if (ms < -5000L) {
            return TimeUtil.calcIn(date, now);
        }
        if (ms < 4000L) {
            return "just now";
        }
        if (ms < 20000L) {
            return "a few seconds ago";
        }
        if (ms < 60000L) {
            return "less than a minute ago";
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(ms);
        if (minutes < 60L) {
            return minutes + " minutes ago";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(ms);
        if (hours < 28L) {
            return hours + " hours ago";
        }
        long days = TimeUnit.MILLISECONDS.toDays(ms);
        if (days < 61L) {
            return days + " days ago";
        }
        if (days < 730L) {
            return "more than " + Math.floor((double)days / 30.0) + " months ago";
        }
        return "more than " + Math.floor((double)days / 356.0) + " years ago";
    }

    public static String calcDiff(Instant dateA, Instant dateB) {
        return TimeUtil.durationToSingleHumanString(Duration.between(dateA, dateB).abs());
    }

    public static String durationToSingleHumanString(Duration duration) {
        long ms = duration.abs().toMillis();
        assert (ms >= 0L);
        if (ms < 4000L) {
            return ms + " ms";
        }
        if (ms < 20000L) {
            return (double)ms / 1000.0 + " s";
        }
        if (ms < 60000L) {
            return Math.round((double)ms / 1000.0) + " s";
        }
        long minutes = TimeUnit.MILLISECONDS.toMinutes(ms);
        if (minutes < 60L) {
            return minutes + " minutes";
        }
        long hours = TimeUnit.MILLISECONDS.toHours(ms);
        if (hours < 28L) {
            return hours + " hours";
        }
        long days = TimeUnit.MILLISECONDS.toDays(ms);
        if (days < 61L) {
            return days + " days";
        }
        if (days < 730L) {
            return "more than " + Math.floor((double)days / 30.0) + " months";
        }
        return "more than " + Math.floor((double)days / 356.25) + " years";
    }

    public static String durationToDoubleHumanString(Duration duration) {
        long ms = duration.abs().toMillis();
        assert (ms >= 0L);
        if (ms < 1000L) {
            return ms + " ms";
        }
        if (ms < 60000L) {
            return duration.toSeconds() + " s and " + duration.toMillisPart() + " ms";
        }
        if (ms < 3600000L) {
            return duration.toMinutes() + " minutes and " + duration.toSecondsPart() + " s";
        }
        if (ms < 86400000L) {
            return duration.toHours() + " hour and " + duration.toMinutes() + " minutes";
        }
        if (ms < 5356800000L) {
            return duration.toDays() + " days and " + duration.toHoursPart() + " hour";
        }
        long days = duration.toDays();
        if (days < 730L) {
            return "more than " + Math.floor((double)days / 30.5) + " months (" + days + " days)";
        }
        return "more than " + Math.floor((double)days / 356.25) + " years (" + days + " days)";
    }
}

