/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import java.io.FileInputStream;
import java.security.PrivateKey;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.cli.CommandLine;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicOriginsServiceConfig
implements BasicOriginsServiceConfigIface {
    private static final Logger LOG = LoggerFactory.getLogger(BasicOriginsServiceConfig.class);
    protected final boolean debug;
    protected final boolean debugTiming;
    protected final String userLoginPemFilename;
    protected final FedmonWebApiClientConfig webApiClientConfig;
    protected final String proxyUsername;
    protected final String proxyHostname;
    private final String configFileName;
    private final Properties originsServiceProperties;

    public BasicOriginsServiceConfig(CommandLine line) {
        PrivateKey userPrivateKey;
        List userCertificate;
        String userLoginPemFilename = line.getOptionValue("pem", null);
        this.debugTiming = line.hasOption("debug-timing");
        this.debug = line.hasOption("debug");
        this.configFileName = line.getOptionValue("configfile", "~/.jFed/config");
        this.originsServiceProperties = new Properties();
        try {
            this.originsServiceProperties.load(new FileInputStream(this.configFileName));
        }
        catch (Exception e) {
            System.out.println("Config file not found: \"" + this.configFileName + "\"");
            System.exit(-2);
        }
        if (userLoginPemFilename == null) {
            userLoginPemFilename = this.originsServiceProperties.getProperty("webapi_client_ssl_userauth_pem");
            LOG.debug("webapi_client_ssl_userauth_pem property is " + userLoginPemFilename);
        }
        this.userLoginPemFilename = userLoginPemFilename;
        LOG.debug("final userLoginPemFilename is " + this.userLoginPemFilename);
        assert (this.userLoginPemFilename != null);
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        if (this.userLoginPemFilename == null) {
            throw new RuntimeException("No user login specified: no write access to fedmon API.");
        }
        try {
            String pemContent = IOUtils.fileToString((String)this.userLoginPemFilename);
            if (pemContent.trim().isEmpty()) {
                throw new RuntimeException("empty PEM file \"" + this.userLoginPemFilename + "\"");
            }
            userCertificate = KeyUtil.pemToX509CertificateChain((String)pemContent);
            if (userCertificate == null) {
                throw new RuntimeException("No certificate found in PEM file \"" + this.userLoginPemFilename + "\"");
            }
            userPrivateKey = KeyUtil.pemToAnyPrivateKey((String)pemContent, null);
            if (userPrivateKey == null) {
                throw new RuntimeException("No unencrypted private key found in PEM file \"" + this.userLoginPemFilename + "\"");
            }
            LOG.debug("Using certificate and private SSH key from PEM file " + this.userLoginPemFilename + " for SSL connection client authentication.");
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading user PEM file", e);
        }
        this.webApiClientConfig = new FedmonWebApiClientPropertiesConfig(this.originsServiceProperties, jFedTrustStore, userCertificate, userPrivateKey, null);
        LOG.debug("webApiClientConfig=" + this.webApiClientConfig);
        this.proxyUsername = this.originsServiceProperties.getProperty("proxyUsername", "fedmon");
        this.proxyHostname = this.originsServiceProperties.getProperty("proxyHostname", "bastion.test.iminds.be");
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isDebugTiming() {
        return this.debugTiming;
    }

    @Override
    public FedmonWebApiClientConfig getWebApiClientConfig() {
        return this.webApiClientConfig;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    @Override
    public String getProxyHostname() {
        return this.proxyHostname;
    }

    @Override
    public String getProperty(@Nonnull String key) {
        return this.originsServiceProperties.getProperty(key);
    }

    @Override
    @Nullable
    @Contract(value="_,!null -> !null")
    public String getProperty(@Nonnull String key, @Nullable String defaultVal) {
        return this.originsServiceProperties.getProperty(key, defaultVal);
    }
}

