/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsServiceConfig;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceCommandLine;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfig;
import be.iminds.ilabt.jfed.fedmon.origins_service.OriginsServiceConfigIface;
import be.iminds.ilabt.jfed.fedmon.origins_service.ResultUploader;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunnerFactory;
import be.iminds.ilabt.jfed.fedmon.origins_service.time_debugging.TimingDebugger;
import be.iminds.ilabt.jfed.fedmon.origins_service.util.EmailSender;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Admin;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TaskBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.User;
import be.iminds.ilabt.jfed.fedmon.webapi.service.logic.FedmonLogic;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.MemoryApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.authority.JFedTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocationsImpl;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.sentry.SentryUtil;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.embed.swing.JFXPanel;
import javax.annotation.Nonnull;
import javax.mail.internet.AddressException;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginsService
implements BasicOriginsService {
    private static final Logger LOG = LoggerFactory.getLogger(OriginsService.class);
    private final AtomicBoolean userRequestedShutdown = new AtomicBoolean(false);
    @Nonnull
    private final ResultUploader resultUploader;
    @Nonnull
    private final FedmonWebApiClient fedmonWebApiClient;
    @Nonnull
    private final OriginsServiceConfig config;
    @Nonnull
    private final EmailSender emailSender;
    @Nonnull
    private final AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;
    private static boolean javaFXInitialized = false;

    public static void initJavaFX() {
        if (javaFXInitialized) {
            return;
        }
        try {
            long timeMillis = System.currentTimeMillis();
            new JFXPanel();
            System.out.println("JavaFX was initialised in " + (System.currentTimeMillis() - timeMillis) + "ms");
            javaFXInitialized = true;
        }
        catch (Throwable t) {
            javaFXInitialized = true;
            LOG.warn("Failed to initialize JavaFX (perhaps no X11 server present?). This could be ignored, but might cause very hard to debug problems later on. Will instead stop to prevent this", t);
            throw new RuntimeException("Failed to initialize JavaFX. Stopping to prevent hard to find bugs.");
        }
    }

    public static void main(String[] args) throws IOException {
        new OriginsService(args);
    }

    @Override
    @Nonnull
    public ResultUploader getResultUploader() {
        return this.resultUploader;
    }

    @Override
    @Nonnull
    public FedmonWebApiClient getFedmonWebApiClient() {
        return this.fedmonWebApiClient;
    }

    @Override
    @Nonnull
    public BasicOriginsServiceConfig getConfig() {
        return this.config;
    }

    @Override
    @Nonnull
    public EmailSender getEmailSender() {
        return this.emailSender;
    }

    @Override
    @Nonnull
    public AutomatedTestExternalExecutableLocations getAutomatedTestExternalExecutableLocations() {
        return this.automatedTestExternalExecutableLocations;
    }

    public TestDefinition getExistingTestDefinition(String name) throws FedmonWebApiClient.FedmonWebApiClientException {
        Optional res = this.fedmonWebApiClient.getById(TestDefinition.class, (Object)name);
        assert (res != null);
        if (!res.isPresent()) {
            throw new RuntimeException("Assumed that TestDefinition existed");
        }
        return (TestDefinition)res.get();
    }

    public TestInstance getExistingTestInstance(int id) throws FedmonWebApiClient.FedmonWebApiClientException {
        Optional res = this.fedmonWebApiClient.getById(TestInstance.class, (Object)id);
        assert (res != null);
        if (!res.isPresent()) {
            throw new RuntimeException("Assumed that TestInstance existed");
        }
        return (TestInstance)res.get();
    }

    private static Long longPropHelper(Object propVal) {
        if (propVal == null) {
            return null;
        }
        if (propVal instanceof Long) {
            return (Long)propVal;
        }
        if (propVal instanceof Number) {
            return ((Number)propVal).longValue();
        }
        if (propVal instanceof String) {
            try {
                return Long.parseLong((String)propVal);
            }
            catch (NumberFormatException e) {
                LOG.warn("Email config: Bad delay between sending emails configured: \"" + propVal + "\"");
            }
        }
        return null;
    }

    public OriginsService(String[] args) throws IOException {
        boolean runningThreadsLeft;
        Future<ResultBuilder> future;
        LinkedList<TestRunner> initialTestRunners;
        Admin adminConf;
        EmailSender.EmailSenderConfig emailSenderConfig;
        final Thread mainThread = Thread.currentThread();
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                OriginsService.this.userRequestedShutdown.set(true);
                mainThread.interrupt();
                System.err.println("Shutdown hook ran. Probably due to SIGINT. In any case, we will exit ASAP!");
                System.err.flush();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        OriginsServiceCommandLine originsServiceCommandLine = new OriginsServiceCommandLine();
        CommandLine line = originsServiceCommandLine.parse(args);
        this.config = new OriginsServiceConfig(line);
        if (line.hasOption("help")) {
            originsServiceCommandLine.help();
            throw new RuntimeException("Help");
        }
        this.automatedTestExternalExecutableLocations = new AutomatedTestExternalExecutableLocationsImpl((AutomatedTestExternalExecutableLocationsImpl.PropConfig)this.config);
        try {
            this.automatedTestExternalExecutableLocations.requireExe("ansible-playbook");
            this.automatedTestExternalExecutableLocations.requireExe("fping");
        }
        catch (AutomatedTestExternalExecutableLocations.ExecutableNotFoundException e) {
            throw new RuntimeException("Exe not found", e);
        }
        try {
            String adminAddressesString = this.config.getProperty("emailSenderAdminAddresses");
            List<String> adminAddresses = adminAddressesString == null ? Collections.emptyList() : Arrays.asList(adminAddressesString.split(" ")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            emailSenderConfig = new EmailSender.EmailSenderConfig(this.config.getProperty("emailSenderFromAddress"), adminAddresses, this.config.getProperty("emailSenderSmtpServer"), this.config.getProperty("emailSenderSmtpUsername"), this.config.getProperty("emailSenderSmtpPassword"), OriginsService.longPropHelper(this.config.getProperty("emailMinDelayBetweenMailsMs")));
        }
        catch (AddressException e) {
            LOG.warn("Bad address in EmailSender config", (Throwable)e);
            emailSenderConfig = null;
        }
        EmailSender emailSender = this.emailSender = emailSenderConfig == null ? EmailSender.getNoEmailSender() : new EmailSender(emailSenderConfig);
        if (!this.emailSender.hasValidConfig()) {
            System.err.println("!!!!!!");
            System.err.println("!!!!!!");
            System.err.println("!!!!!! EmailSender has invalid configuration -> it will not be able to send emails !!!!!!!!");
            System.err.println("!!!!!!");
            System.err.println("!!!!!!");
        }
        OriginsService.initJavaFX();
        SentryUtil.initSentry();
        JFedCorePreferences jFedPreferences = new JFedCorePreferences();
        ConnectivityDetector connectivityDetector = new ConnectivityDetector(null);
        connectivityDetector.forceNoInternet(false);
        TestbedInfoSource testbedInfoSource = new JFedTestbedInfoSource((JFedPreferences)jFedPreferences, connectivityDetector, new URL("https://flsmonitor-api.fed4fire.eu/"), null).get();
        AuthorityFinder authorityFinder = new AuthorityFinder(testbedInfoSource, (JFedPreferences)jFedPreferences);
        SerializableApiCallDetailsFactory serializableApiCallDetailsFactory = new SerializableApiCallDetailsFactory();
        MemoryApiCallDetailsCache apiCallDetailsCache = new MemoryApiCallDetailsCache(serializableApiCallDetailsFactory);
        CallReportFactory callReportFactory = new CallReportFactory((ApiCallDetailsCache)apiCallDetailsCache);
        CallReportWriter callReportWriter = new CallReportWriter((ApiCallDetailsCache)apiCallDetailsCache);
        this.fedmonWebApiClient = new FedmonWebApiCachedClient(this.config.getWebApiClientConfig());
        this.resultUploader = new ResultUploader(this);
        try {
            adminConf = this.fedmonWebApiClient.getAdminConfig();
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            LOG.error("Exception contacting web service for AdminInfo. => Exiting.", (Throwable)e);
            System.err.println("Exception contacting web service for AdminInfo => Exiting. Exception details:");
            e.printStackTrace();
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(1);
            return;
        }
        if (adminConf.getDisableProductionTests().booleanValue() && this.config.getTestInstanceFilter().hasVersionNameFilter() && this.config.getTestInstanceFilter().matchesVersion("prod")) {
            LOG.info("Production tests have been disabled => Exiting.");
            System.err.println("Production tests have been disabled => Exiting.");
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(1);
            return;
        }
        TimingDebugger timingDebugger = null;
        if (this.config.isDebugTiming()) {
            timingDebugger = new TimingDebugger();
        }
        String runInfo = ManagementFactory.getRuntimeMXBean().getName();
        try {
            System.out.println("Filling some caches...");
            this.fedmonWebApiClient.getAll(TestDefinition.class);
            this.fedmonWebApiClient.getAll(User.class);
            this.fedmonWebApiClient.getAll(Frequency.class);
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            LOG.error("Exception filling caches. This can be ignored, but there is probably something wrong.", (Throwable)e);
            System.err.println("Exception filling caches. This can be ignored, but there is probably something wrong.");
            e.printStackTrace();
        }
        if (this.userRequestedShutdown.get()) {
            System.err.println("Aborting run due to user request (SIGINT, SIGKILL, or similar).");
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(0);
        }
        TestRunnerFactory testRunnerFactory = new TestRunnerFactory(testbedInfoSource, authorityFinder, callReportFactory, callReportWriter, this, this.automatedTestExternalExecutableLocations);
        try {
            int maxRequestCount = this.config.getMaxRunCount() != null ? Math.min(this.config.getMaxRunCount(), this.config.getThreadCount()) : this.config.getThreadCount();
            initialTestRunners = new LinkedList<TestRunner>(testRunnerFactory.requestTestRunners(maxRequestCount, runInfo + "-initial", this.config.getTestInstanceFilter()));
        }
        catch (Throwable t) {
            LOG.error("Something went wrong getting initial Tasks. Will abort.", t);
            System.err.println("Something went wrong getting initial Tasks. Will abort. " + t.getMessage());
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(-1);
            return;
        }
        if (timingDebugger != null) {
            timingDebugger.setInfoAllTasks(initialTestRunners);
            timingDebugger.setInfoResultUploader(this.resultUploader);
        }
        LOG.info("jFed Origins service run at: " + new Date().getTime() + " Tasks in queue: " + initialTestRunners.size());
        System.out.println("Test overview:");
        if (initialTestRunners == null) {
            System.out.println("jFed Origins service cannot start: Something went wrong while contacting the webService. Check your connection and try again.");
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(-1);
            throw new RuntimeException("This should never happen.");
        }
        if (initialTestRunners.isEmpty() && this.config.isExitWhenNoInitialTasks()) {
            System.out.println("jFed Origins service will not start: No initial tasks received and --exit-when-no-initial-tasks option set");
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(0);
        }
        LOG.info("Creating fedmon origins threadpool with " + this.config.getThreadCount() + " threads.");
        ExecutorService internalThreadPool = Executors.newFixedThreadPool(this.config.getThreadCount(), ThreadFactoryUtil.getFactory((String)"fedmon-origins-pool"));
        ExecutorCompletionService<ResultBuilder> completionService = new ExecutorCompletionService<ResultBuilder>(internalThreadPool);
        ArrayList<TestRunner> allRunners = new ArrayList<TestRunner>();
        if (timingDebugger != null) {
            timingDebugger.setInfoThreadCount(this.config.getThreadCount());
        }
        Date startRunnersDate = new Date();
        LOG.info("Starting TestRunners @ " + startRunnersDate);
        while (!initialTestRunners.isEmpty() && !this.userRequestedShutdown.get()) {
            boolean skip;
            TestRunner test = (TestRunner)initialTestRunners.poll();
            String skipReason = null;
            if (test.getTestInstance().isEnabled() && FedmonLogic.mustRunNow(test.getTestInstance(), test.getFrequency(), test.getTestInstanceStatistics())) {
                if (this.config.getMaxRunCount() == null || allRunners.size() < this.config.getMaxRunCount()) {
                    if (timingDebugger != null) {
                        timingDebugger.informSubmitTask(test);
                    }
                    System.out.println("SCHEDULING " + test.getTestInstance().getName());
                    future = completionService.submit(test);
                    test.setFuture(future);
                    allRunners.add(test);
                    skip = false;
                } else {
                    skipReason = "ERROR: initialTestRunners has more testrunner than max " + this.config.getMaxRunCount() + "  SKIPPING  " + test.getTestInstance().getName();
                    skip = true;
                }
            } else {
                skip = true;
                skipReason = !test.getTestInstance().isEnabled() ? "DISABLED   " + test.getTestInstance().getName() : "EARLY      " + test.getTestInstance().getName();
            }
            if (!skip) continue;
            System.err.println(skipReason);
            Task origTask = test.getTask();
            TaskBuilder updatedTask = new TaskBuilder(origTask);
            updatedTask.setState(Task.State.CANCELLED);
            updatedTask.setLog(skipReason);
            try {
                this.fedmonWebApiClient.update((JsonLdObjectWithUri)updatedTask.create());
            }
            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                System.err.println("Error registering cancelled task \"" + origTask.getId() + "\": " + e.getMessage());
                LOG.error("Error registering cancelled task \"" + origTask.getId() + "\"", (Throwable)e);
            }
        }
        if (timingDebugger != null) {
            timingDebugger.timeStartPhase(TimingDebugger.OriginsServicePhase.EXECUTE_TASKS);
        }
        Date startWaitingDate = new Date();
        System.out.println("\n\nAll initial TestRunners have been scheduled. Will wait for them to end, and create new ones as needed. @" + startWaitingDate);
        Date lastRunnerFinishedDate = null;
        int finishedLiveCount = 0;
        while (!this.userRequestedShutdown.get()) {
            try {
                future = completionService.poll(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                if (!this.userRequestedShutdown.get()) {
                    LOG.error("Unexpected InterruptedException. Will stop.", (Throwable)e);
                    break;
                }
                LOG.info("InterruptedException due to SIGINT or similar. Will stop.");
                future = null;
            }
            int finishedRecount = 0;
            int refusingToStopCount = 0;
            int expiredCount = 0;
            int activeThreadCount = 0;
            for (TestRunner testRunner : allRunners) {
                if (testRunner.isCompleted()) {
                    ++finishedRecount;
                    continue;
                }
                if (testRunner.isRefusingToStop()) {
                    ++refusingToStopCount;
                }
                ++activeThreadCount;
                if (!testRunner.isExpired()) continue;
                ++expiredCount;
            }
            if (future != null) {
                ++finishedLiveCount;
                lastRunnerFinishedDate = new Date();
            }
            if (activeThreadCount < this.config.getThreadCount() && !this.userRequestedShutdown.get() && this.mustScheduleNew(allRunners.size(), finishedRecount, expiredCount, refusingToStopCount, startRunnersDate, lastRunnerFinishedDate, this.config)) {
                try {
                    List<TestRunner> newRunners = testRunnerFactory.requestTestRunners(1, runInfo + "-secondary-" + allRunners.size(), this.config.getTestInstanceFilter());
                    if (!newRunners.isEmpty()) {
                        TestRunner newTestRunner;
                        if (!this.userRequestedShutdown.get()) {
                            if (newRunners.size() > 1) {
                                LOG.error("ERROR: fedmon web API gave more than the 1 task requested: " + newRunners.size());
                            }
                            System.out.println("SCHEDULING " + ((newTestRunner = (TestRunner)newRunners.iterator().next()).getTestInstance() == null ? "?" : newTestRunner.getTestInstance().getName()));
                            LOG.debug("SCHEDULING " + (newTestRunner.getTestInstance() == null ? "?" : newTestRunner.getTestInstance().getName()));
                            Future<ResultBuilder> newFuture = completionService.submit(newTestRunner);
                            newTestRunner.setFuture(newFuture);
                            allRunners.add(newTestRunner);
                        } else {
                            newTestRunner = (TestRunner)newRunners.iterator().next();
                            LOG.debug("Server has a task but we have just been requested to cancel, so we will cancel it before it even starts.");
                            newTestRunner.cancelTask();
                        }
                    } else {
                        LOG.debug("Server has no tasks right now.");
                        if (activeThreadCount == 0 && this.config.isExitWhenIdle()) {
                            System.out.println("jFed Origins service will exit: No new tasks received, no running tasks, and --exit-when-idle option set");
                            break;
                        }
                    }
                }
                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                    System.err.println("Error requesting additional task: " + e.getMessage());
                    LOG.error("Error equesting additional task", (Throwable)e);
                }
            }
            assert (finishedRecount >= finishedLiveCount);
            if (!this.mustEndAll(allRunners.size(), finishedLiveCount, expiredCount, refusingToStopCount, startRunnersDate, lastRunnerFinishedDate, this.config) && !this.userRequestedShutdown.get()) continue;
            break;
        }
        if (this.userRequestedShutdown.get()) {
            LOG.info("Stopped waiting for running tasks + user requested shutdown");
        }
        int runningThreadsCount = 0;
        for (TestRunner testRunner : allRunners) {
            if (testRunner.isCompleted()) continue;
            ++runningThreadsCount;
            if (testRunner.getFuture() == null) continue;
            testRunner.getFuture().cancel(true);
        }
        boolean bl = runningThreadsLeft = runningThreadsCount > 0;
        if (runningThreadsLeft) {
            try {
                if (this.userRequestedShutdown.get()) {
                    LOG.debug("Just cancelled all running tasks (" + runningThreadsCount + "). Now giving running tasks an extra second to finish.");
                    Thread.sleep(1000L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException testRunner) {
                // empty catch block
            }
        }
        if (timingDebugger != null) {
            timingDebugger.timeSwitchPhase(TimingDebugger.OriginsServicePhase.EXECUTE_TASKS, TimingDebugger.OriginsServicePhase.RESULT_UPLOAD);
        }
        LOG.info("jFed Origins service has finished executing tasks.");
        if (runningThreadsLeft) {
            LOG.debug("There are " + runningThreadsCount + " running threads left.");
        } else {
            LOG.debug("There are no running threads left.");
        }
        if (!this.userRequestedShutdown.get()) {
            LOG.info("Will now wait until results have been uploaded.");
        } else {
            LOG.info("Will now wait until results have been uploaded. (There was a SIGINT, but this is important enough to wait for)");
        }
        if (runningThreadsLeft) {
            this.resultUploader.waitUntilFinished(60000L);
        } else {
            this.resultUploader.waitUntilFinished(60000L);
        }
        if (timingDebugger != null) {
            timingDebugger.timeSwitchPhase(TimingDebugger.OriginsServicePhase.RESULT_UPLOAD, TimingDebugger.OriginsServicePhase.FINISH);
        }
        LOG.info("jFed Origins service has finished (task + result upload)");
        if (this.config.isDebug()) {
            LOG.debug("(waiting a while before stopping, due to debug mode enabled).");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                LOG.info("InterruptedException", (Throwable)ex);
            }
        }
        if (timingDebugger != null) {
            timingDebugger.timeStopPhase(TimingDebugger.OriginsServicePhase.FINISH);
            timingDebugger.stop();
        }
        System.out.println("jFed Origins service has finished.");
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
        System.exit(0);
        throw new RuntimeException("This should never happen.");
    }

    private boolean mustEndAll(int scheduledCount, int finishedCount, int expiredCount, int refusingToStopCount, Date startRunnersDate, Date lastRunnerFinishedDate, OriginsServiceConfigIface config) {
        long currentRunTime = System.currentTimeMillis() - startRunnersDate.getTime();
        TimeUnit currentRunTimeTimeUnit = TimeUnit.MILLISECONDS;
        if (this.userRequestedShutdown.get()) {
            LOG.debug("Stopping: user has signalled we need to stop (SIGINT, SIGKILL or similar).");
            return true;
        }
        LOG.debug("mustEndAll(scheduledCount=" + scheduledCount + ", finishedCount=" + finishedCount + ", expiredCount=" + expiredCount + ", refusingToStopCount=" + refusingToStopCount + ", currentRunTime=" + currentRunTime + "ms, config.getThreadCount()=" + config.getThreadCount() + ", config.getMaxRunCount()=" + config.getMaxRunCount() + ", config.getMaxRunTime()=" + config.getMaxRunTime() + " " + config.getMaxRunTimeUnit().toString() + ")");
        if (refusingToStopCount >= config.getThreadCount()) {
            LOG.debug("Stopping: More or equal refusingToStop TestRunners than threads.");
            return true;
        }
        if (config.getMaxRunCount() != null && finishedCount >= config.getMaxRunCount()) {
            LOG.debug("Stopping: More or equal finished TestRunners than max to run.");
            return true;
        }
        if (scheduledCount <= finishedCount + refusingToStopCount) {
            boolean mustEnd;
            boolean bl = mustEnd = !this.mustScheduleNew(scheduledCount, finishedCount, expiredCount, refusingToStopCount, startRunnersDate, lastRunnerFinishedDate, config);
            if (mustEnd) {
                LOG.debug("Stopping: No active TestRunners and no new should be scheduled");
            }
            return mustEnd;
        }
        long maxRunTime = config.getMaxRunTime();
        TimeUnit maxRunTimeTimeUnit = config.getMaxRunTimeUnit();
        if (currentRunTimeTimeUnit.toMillis(currentRunTime) > maxRunTimeTimeUnit.toMillis(maxRunTime)) {
            LOG.debug("Stopping: Maximum run time exceeded.");
            return true;
        }
        return false;
    }

    private boolean mustScheduleNew(int scheduledCount, int finishedCount, int expiredCount, int refusingToStopCount, Date startRunnersDate, Date lastRunnerFinishedDate, OriginsServiceConfigIface config) {
        long currentRunTime = System.currentTimeMillis() - startRunnersDate.getTime();
        TimeUnit currentRunTimeTimeUnit = TimeUnit.MILLISECONDS;
        LOG.debug("mustScheduleNew(scheduledCount=" + scheduledCount + ", finishedCount=" + finishedCount + ", expiredCount=" + expiredCount + ", refusingToStopCount=" + refusingToStopCount + ", currentRunTime=" + currentRunTime + "ms, config.getMaxRunCount()=" + config.getMaxRunCount() + ", config.getMaxScheduleNewTime()=" + config.getMaxScheduleNewTime() + " " + config.getMaxScheduleNewTimeUnit().toString() + ")");
        if (config.getMaxRunCount() != null && scheduledCount >= config.getMaxRunCount() - 1) {
            LOG.debug("Not scheduling new: maximum number already scheduled");
            return false;
        }
        Long maxScheduleNewTime = config.getMaxScheduleNewTime();
        TimeUnit maxScheduleNewTimeTimeUnit = config.getMaxScheduleNewTimeUnit();
        if (maxScheduleNewTime != null && currentRunTimeTimeUnit.toMillis(currentRunTime) > maxScheduleNewTimeTimeUnit.toMillis(maxScheduleNewTime)) {
            LOG.debug("Not scheduling new: Maximum schedule time exceeded.");
            return false;
        }
        return true;
    }
}

