/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_service.testrunners;

import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.ListResourcesWrapper;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.webapi.client.ExtendedTestInstanceFilter;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Log;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Result;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ResultBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Task;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceStatistics;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReport;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.Slf4jHelper;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesToTestInstances
extends TestRunner {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesToTestInstances.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final CallReportFactory callReportFactory;
    private final CallReportWriter callReportWriter;

    public ResourcesToTestInstances(Task task, TestInstance test, Frequency testInstanceFrequency, TestInstanceStatistics testInstanceStatistics, TestDefinition testDefinition, BasicOriginsService originsService, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, CallReportFactory callReportFactory, CallReportWriter callReportWriter) {
        super(task, test, testInstanceFrequency, testInstanceStatistics, testDefinition, originsService);
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.callReportFactory = callReportFactory;
        this.callReportWriter = callReportWriter;
    }

    @Override
    @Nonnull
    public FedmonWebApiClient getFedmonWebApiClient() {
        return this.fedmonWebApiClient;
    }

    @Override
    @Nonnull
    public TestRunner.TestCallCreatedObjects runTestCall(Logger testLog, PrintWriter outputStream) {
        Result.ResultStatus status;
        CallReport callReport = this.callReportFactory.createCallReport("ResourcesToTestInstances Call Details", "ResourcesToTestInstances");
        CallReport.State reportState = callReport.getCurState();
        Logger LOG = Slf4jHelper.createMultiplexLogger((Logger[])new Logger[]{testLog, reportState});
        LOG.debug("Starting ResourcesToTestInstances with id" + this.testInstance.getId() + " at " + new Date());
        HashMap subresults = new HashMap();
        try {
            Server targetServer;
            boolean deleteNonAvailable = Objects.equals(this.testInstance.getBooleanParameterOrDefault("delete_non_available", this.testDefinition), Boolean.TRUE);
            boolean disableNonAvailable = Objects.equals(this.testInstance.getBooleanParameterOrDefault("disable_non_available", this.testDefinition), Boolean.TRUE);
            boolean deleteMissing = Objects.equals(this.testInstance.getBooleanParameterOrDefault("delete_missing", this.testDefinition), Boolean.TRUE);
            boolean disableMissing = Objects.equals(this.testInstance.getBooleanParameterOrDefault("disable_missing", this.testDefinition), Boolean.TRUE);
            boolean deleteAll = Objects.equals(this.testInstance.getBooleanParameterOrDefault("delete_all", this.testDefinition), Boolean.TRUE);
            boolean targetEnabled = Objects.equals(this.testInstance.getBooleanParameterOrDefault("target_enabled", this.testDefinition), Boolean.TRUE);
            boolean targetRunNow = Objects.equals(this.testInstance.getBooleanParameterOrDefault("target_run_now", this.testDefinition), Boolean.TRUE);
            boolean targetNonAvailableRunNow = Objects.equals(this.testInstance.getBooleanParameterOrDefault("target_non_available_run_now", this.testDefinition), Boolean.TRUE);
            boolean useOnlyAvailableResources = !Objects.equals(this.testInstance.getBooleanParameterOrDefault("use_only_available_resources", this.testDefinition), Boolean.FALSE);
            Integer targetFrequencyId = this.testInstance.getIntegerParameterOrDefault("target_frequency", this.testDefinition);
            Frequency targetFrequency = (Frequency)this.fedmonWebApiClient.getById(Frequency.class, (Object)targetFrequencyId).orElseThrow(() -> new RuntimeException("Did not find frequency with ID " + targetFrequencyId));
            String targetUser = this.testInstance.getStringParameterOrDefault("target_user", this.testDefinition);
            String hardwareTypeFilterRaw = this.testInstance.getStringParameterOrDefault("filter_on_hardware_type", this.testDefinition);
            String targetContextFileContent = this.testInstance.getStringParameterOrDefault("target_context_file", this.testDefinition);
            Object targetAutomatedTesterConfigJsonContent = this.testInstance.getParameterOrDefault("target_automated_tester_config_json", this.testDefinition);
            String targetTestDefinition = this.testInstance.getStringParameterOrDefault("target_test_definition", this.testDefinition);
            Integer countFilter = this.testInstance.getIntegerParameterOrDefault("filter_on_count", this.testDefinition);
            Integer serverId = this.testInstance.getServerIdParameter();
            if (serverId == null) {
                throw new IllegalStateException("testinstance with invalid server: " + serverId);
            }
            if (targetTestDefinition == null) {
                throw new IllegalStateException("testinstance without target_test_definition");
            }
            if (targetTestDefinition.trim().isEmpty()) {
                throw new IllegalStateException("testinstance with invalid target_test_definition: \"" + targetTestDefinition + "\"");
            }
            if (hardwareTypeFilterRaw != null && hardwareTypeFilterRaw.trim().isEmpty()) {
                hardwareTypeFilterRaw = null;
            }
            if (targetContextFileContent != null && targetContextFileContent.trim().isEmpty()) {
                targetContextFileContent = null;
            }
            if (targetAutomatedTesterConfigJsonContent != null && targetAutomatedTesterConfigJsonContent instanceof String && ((String)targetAutomatedTesterConfigJsonContent).trim().isEmpty()) {
                targetAutomatedTesterConfigJsonContent = null;
            }
            HashSet<String> hardwareTypeFilter = new HashSet<String>();
            if (hardwareTypeFilterRaw != null) {
                hardwareTypeFilter.addAll(Arrays.asList(hardwareTypeFilterRaw.split(",")));
                LOG.debug("hardwareTypeFilter=" + hardwareTypeFilter + "  from \"" + hardwareTypeFilterRaw + "\"");
            }
            if ((targetServer = this.testbedInfoSource.getServerById(serverId)) == null) {
                throw new IllegalStateException("testinstance with unknown server: " + serverId);
            }
            LOG.debug("Will connect to server id=" + targetServer.getId() + " name=" + targetServer.getName() + " (allowedCertificateAlias=" + targetServer.getAllowedCertificateAlias() + ")");
            String testbedId = targetServer.getTestbedId();
            if (testbedId == null) {
                throw new RuntimeException("Internal error: testinstance with server " + serverId + " without testbed ");
            }
            boolean errorDuringProcessing = false;
            List alreadyExistingTestInstances = this.fedmonWebApiClient.search((FedmonWebApiClient.FedmonFilter)new ExtendedTestInstanceFilter(null, null, targetTestDefinition, null, null, null, testbedId, null, Optional.empty(), Optional.empty(), Optional.empty()));
            HashMap<String, TestInstance> existingTestInstancesByNode = new HashMap<String, TestInstance>();
            for (TestInstance ti : alreadyExistingTestInstances) {
                String nodeUrnString;
                if (!ti.getName().startsWith("auto") || (nodeUrnString = ti.getStringParameter("fixed_node_urn")) == null || nodeUrnString.trim().isEmpty()) continue;
                existingTestInstancesByNode.put(nodeUrnString, ti);
            }
            LOG.debug("Found " + alreadyExistingTestInstances.size() + " TestInstances for testbed " + testbedId + " of which " + existingTestInstancesByNode.size() + " are automaticly generated node login tests.");
            if (deleteAll) {
                LOG.warn("delete_all set: Deleting " + existingTestInstancesByNode.size() + " existing tests");
                for (TestInstance ti : existingTestInstancesByNode.values()) {
                    this.fedmonWebApiClient.delete((JsonLdObjectWithUri)ti);
                }
                status = Result.ResultStatus.SUCCESS;
            } else {
                be.iminds.ilabt.jfed.log.Logger logger = new be.iminds.ilabt.jfed.log.Logger();
                logger.addResultListener((ResultListener)reportState);
                ListResourcesWrapper.ListResourcesResult listResourcesResult = ListResourcesWrapper.callListResources(this.testInstance, this.testDefinition, this.originsService.getConfig().getProperty("webapi_client_url_read_base"), this.fedmonWebApiClient, this.testbedInfoSource, this.authorityFinder, LOG, targetServer, logger, useOnlyAvailableResources, false);
                LOG.debug("Got Advertisement RSpec of all resources. size=" + listResourcesResult.rspec.length());
                if (listResourcesResult.cancelled) {
                    LOG.debug("    ListResources result -> CANCELLED");
                }
                LOG.debug("    ListResources result version = " + listResourcesResult.version);
                LOG.debug("    ListResources result RSpec head = " + TextUtil.abbreviate((String)listResourcesResult.rspec, (int)100));
                if (listResourcesResult.rspec.length() > 100) {
                    LOG.debug("    ListResources result RSpec tail = " + listResourcesResult.rspec.substring(listResourcesResult.rspec.length() - 100, listResourcesResult.rspec.length()));
                }
                if (listResourcesResult.rspec != null && listResourcesResult.version.equals(ListResourcesWrapper.geni3)) {
                    AdvertisementRspecSource advertisementRspecSource = new AdvertisementRspecSource(listResourcesResult.rspec, ModelRspecType.BASIC);
                    ImmutableModelRspec modelRspec = advertisementRspecSource.getImmutableModelRspec();
                    if (!advertisementRspecSource.isXmlBased()) {
                        LOG.warn("    ListResources result RSpec source.isXmlBased() = " + advertisementRspecSource.isXmlBased());
                    }
                    if (advertisementRspecSource.getLastInvalidRspecException() != null) {
                        LOG.warn("    ListResources result RSpec source encountered parse error", (Throwable)advertisementRspecSource.getLastInvalidRspecException());
                    }
                    HashMap<String, RspecNode> listResourcesNodes = new HashMap<String, RspecNode>();
                    if (modelRspec != null && modelRspec.getNodes() != null) {
                        LOG.debug("Advertisement RSpec has " + modelRspec.getNodes().size() + " nodes");
                        int nodeIndex = 0;
                        for (RspecNode node : modelRspec.getNodes()) {
                            GeniUrn componentId = node.getComponentId();
                            if (componentId == null) continue;
                            if (hardwareTypeFilterRaw != null) {
                                boolean matchesHwType = false;
                                for (HardwareType hardwareType : node.getHardwareTypes()) {
                                    if (!hardwareTypeFilter.contains(hardwareType.getName())) continue;
                                    matchesHwType = true;
                                    break;
                                }
                                if (!matchesHwType) {
                                    LOG.debug("Ignoring node " + componentId + " because no harware_type matches " + hardwareTypeFilter);
                                    continue;
                                }
                            }
                            if (countFilter != null && countFilter > 0 && nodeIndex >= countFilter) {
                                LOG.debug("Ignoring node " + componentId + " because it is node " + nodeIndex + " and max allowed is " + countFilter);
                                continue;
                            }
                            ++nodeIndex;
                            HashMap<String, Object> parameters = new HashMap<String, Object>();
                            parameters.put("fixed_node_urn", componentId.toString());
                            if (targetContextFileContent != null) {
                                parameters.put("context-file", targetContextFileContent);
                            }
                            if (targetAutomatedTesterConfigJsonContent != null) {
                                Object changedJson = JSonHelper.jsonObjectStringReplacer((Object)targetAutomatedTesterConfigJsonContent, s -> s.replaceAll(Pattern.quote("$$$FIXED_NODE_URN$$$"), componentId.toString()));
                                parameters.put("automated_tester_config", changedJson);
                            }
                            listResourcesNodes.put(componentId.toString(), node);
                            if (existingTestInstancesByNode.containsKey(componentId.toString())) {
                                boolean mustRunNow;
                                boolean nodeAvailable;
                                String targetName = "auto" + this.testInstance.getId() + "-" + componentId.getResourceName();
                                boolean changed = false;
                                TestInstance nodeTestInstance = (TestInstance)existingTestInstancesByNode.get(componentId.toString());
                                if (nodeTestInstance.isEnabled() != targetEnabled) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getTestDefinitionId(), targetTestDefinition)) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getParameters(), parameters)) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getUserIdParameter(), targetUser)) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getServerIdParameter(), targetServer)) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getName(), targetName)) {
                                    changed = true;
                                }
                                if (!Objects.equals(nodeTestInstance.getFrequencyId(), targetFrequencyId)) {
                                    changed = true;
                                }
                                if (nodeTestInstance.getTestVersion() == null != (this.testInstance.getTestVersion() == null)) {
                                    changed = true;
                                }
                                if (nodeTestInstance.getTestVersion() != null && this.testInstance != null && nodeTestInstance.getTestVersion().equals(this.testInstance.getTestVersion())) {
                                    changed = true;
                                }
                                if (changed) {
                                    LOG.debug("Found test for existing node that needs update: " + componentId);
                                    TestInstanceBuilder updatedTodeTestInstance = new TestInstanceBuilder(nodeTestInstance);
                                    updatedTodeTestInstance.setName(targetName);
                                    updatedTodeTestInstance.setTestDefinition(targetTestDefinition, null);
                                    updatedTodeTestInstance.setTestVersion(this.testInstance.getTestVersion());
                                    updatedTodeTestInstance.setEnabled(Boolean.valueOf(targetEnabled));
                                    updatedTodeTestInstance.setFrequency(targetFrequency);
                                    updatedTodeTestInstance.setParameters(parameters);
                                    updatedTodeTestInstance.setUserParameter(targetUser, targetUser, null);
                                    updatedTodeTestInstance.setServerParameter(targetServer);
                                    try {
                                        this.fedmonWebApiClient.update((JsonLdObjectWithUri)updatedTodeTestInstance.create());
                                    }
                                    catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                        LOG.error("Error updating TestInstance " + this.testInstance.getId(), (Throwable)e);
                                        errorDuringProcessing = true;
                                    }
                                } else {
                                    LOG.debug("Found test for existing node: " + componentId);
                                }
                                boolean bl = nodeAvailable = !Objects.equals(node.getAvailable(), Boolean.FALSE);
                                if (!targetRunNow && !targetNonAvailableRunNow) continue;
                                boolean bl2 = mustRunNow = nodeAvailable ? targetRunNow : targetNonAvailableRunNow;
                                if (!mustRunNow) {
                                    if (!nodeAvailable) {
                                        LOG.debug("NOT running test (" + nodeTestInstance.getId() + ") again for unavailable node");
                                        continue;
                                    }
                                    LOG.debug("NOT running test (" + nodeTestInstance.getId() + ") again for AVAILABLE node  (= CONFIG EDGE CASE! Are you sure this is what you want?)");
                                    continue;
                                }
                                if (!nodeAvailable) {
                                    LOG.debug("Requesting that test (" + nodeTestInstance.getId() + ") runs again for unavailable node");
                                } else {
                                    LOG.debug("Requesting that test (" + nodeTestInstance.getId() + ") runs again");
                                }
                                try {
                                    TestInstanceStatistics changedTis = this.fedmonWebApiClient.setTestInstanceStatisticsRunNow((Integer)nodeTestInstance.getId());
                                    LOG.debug("   -> Changed next_run to " + changedTis.getNextRun());
                                }
                                catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                    LOG.error("Error forcing run now for TestInstance " + nodeTestInstance.getId(), (Throwable)e);
                                    errorDuringProcessing = true;
                                }
                                continue;
                            }
                            LOG.debug("Add test for missing node: " + componentId);
                            TestInstanceBuilder newNodeTestInstance = new TestInstanceBuilder();
                            newNodeTestInstance.setName("auto" + this.testInstance.getId() + "-" + componentId.getResourceName());
                            newNodeTestInstance.setTestDefinition(targetTestDefinition, null);
                            newNodeTestInstance.setTestVersion(this.testInstance.getTestVersion());
                            newNodeTestInstance.setEnabled(Boolean.valueOf(targetEnabled));
                            newNodeTestInstance.setFrequency(targetFrequency);
                            newNodeTestInstance.setParameters(parameters);
                            newNodeTestInstance.setUserParameter(targetUser, targetUser, null);
                            newNodeTestInstance.setServerParameter(targetServer);
                            try {
                                this.fedmonWebApiClient.create((JsonLdObjectWithUri)newNodeTestInstance.create());
                            }
                            catch (FedmonWebApiClient.FedmonWebApiClientException e) {
                                LOG.error("Error creating TestInstance for fixed_node_urn " + componentId, (Throwable)e);
                                errorDuringProcessing = true;
                            }
                        }
                    } else if (modelRspec == null) {
                        LOG.debug("Advertisement RSpec has modelRspec == null");
                    } else {
                        LOG.debug("Advertisement RSpec has modelRspec.getNodes() == null");
                    }
                    for (Map.Entry e : existingTestInstancesByNode.entrySet()) {
                        String nodeUrnString = (String)e.getKey();
                        TestInstance ti = (TestInstance)e.getValue();
                        if (listResourcesNodes.containsKey(nodeUrnString) || ti == null) continue;
                        if (!ti.isEnabled()) {
                            LOG.debug("Found disabled test for node that no longer is available (" + nodeUrnString + "). Will leave as is.");
                            continue;
                        }
                        if (disableNonAvailable || disableMissing) {
                            LOG.info("Found enabled test for node that no longer is available: will disable it: " + nodeUrnString);
                            TestInstanceBuilder updatedNodeTestInstance = new TestInstanceBuilder(ti);
                            updatedNodeTestInstance.setTestVersion(this.testInstance.getTestVersion());
                            updatedNodeTestInstance.setEnabled(Boolean.valueOf(false));
                            updatedNodeTestInstance.setFrequency(targetFrequency);
                            this.fedmonWebApiClient.update((JsonLdObjectWithUri)updatedNodeTestInstance.create());
                            continue;
                        }
                        if (deleteNonAvailable || deleteMissing) {
                            LOG.info("Found enabled test for node that no longer is available: will DELETE it: " + nodeUrnString);
                            this.fedmonWebApiClient.delete((JsonLdObjectWithUri)ti);
                            continue;
                        }
                        LOG.info("Found enabled test for node that no longer is available: \"" + nodeUrnString + "\" delete_non_available is not set, so will do nothing.");
                    }
                    LOG.info("Processed all nodes.");
                    status = errorDuringProcessing ? Result.ResultStatus.FAILURE : Result.ResultStatus.SUCCESS;
                } else {
                    LOG.warn("Unsupported Advertisement RSpec type. Can do nothing: " + listResourcesResult.version);
                    status = Result.ResultStatus.FAILURE;
                }
            }
        }
        catch (FedmonWebApiClient.FedmonWebApiClientException e) {
            ResourcesToTestInstances.LOG.error("Caught FedmonWebApiClientException: problem reaching fedmon. Will cancel test", (Throwable)e);
            LOG.debug("Caught FedmonWebApiClientException -> problem reaching fedmon -> cancelling test");
            status = Result.ResultStatus.CANCELLED;
        }
        catch (Throwable t) {
            LOG.error("Caught unexpected error", t);
            Result.ResultStatus status2 = Result.ResultStatus.FAILURE;
            throw new RuntimeException(t);
        }
        LOG.debug("Finished ResourcesToTestInstances at " + new Date());
        ResultBuilder testResult = this.initResult();
        testResult.addResults(subresults);
        TestRunner.TestCallCreatedObjects testCallCreatedObjects = new TestRunner.TestCallCreatedObjects(testResult);
        try {
            String html = callReport.toHtmlString(false);
            testCallCreatedObjects.addLog("callHtmlLogUrl", "call_log.html", html, Log.LogMediaType.HTML, null);
        }
        catch (Throwable e) {
            LOG.error("Error writing HTML report", e);
        }
        try {
            String xml = this.callReportWriter.writeCallReportToString(callReport, false);
            testCallCreatedObjects.addLog("callXmlLogUrl", "call_log.xml", xml, Log.LogMediaType.XML, null);
        }
        catch (Throwable e) {
            LOG.error("Error writing XML report", e);
        }
        testResult.setSummary(status);
        return testCallCreatedObjects;
    }

    @Override
    @Nonnull
    protected ResultBuilder initResult() {
        return this.createBasicTestResult(null);
    }

    public void handleCommandOutput(String commandOutput) {
    }
}

