/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.UnknownResponseCodeException;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public enum GeniAMResponseCode implements GeniResponseCode
{
    GENIRESPONSE_SUCCESS(0, "Success"),
    GENIRESPONSE_BADARGS(1, "Bad Arguments: malformed arguments"),
    GENIRESPONSE_ERROR(2, "Error (other)"),
    GENIRESPONSE_FORBIDDEN(3, "Operation Forbidden: eg supplied credentials do not provide sufficient privileges (on given slice)"),
    GENIRESPONSE_BADVERSION(4, "Bad Version (eg of RSpec)"),
    GENIRESPONSE_SERVERERROR(5, "Server Error"),
    GENIRESPONSE_TOOBIG(6, "Too Big (eg request RSpec)"),
    GENIRESPONSE_REFUSED(7, "Operation Refused"),
    GENIRESPONSE_TIMEDOUT(8, "Operation Timed Out"),
    GENIRESPONSE_DBERROR(9, "Database Error"),
    GENIRESPONSE_RPCERROR(10, "RPC Error"),
    GENIRESPONSE_UNAVAILABLE(11, "Unavailable (eg server in lockdown)"),
    GENIRESPONSE_SEARCHFAILED(12, "Search Failed (eg for slice)"),
    GENIRESPONSE_UNSUPPORTED(13, "Operation Unsupported"),
    GENIRESPONSE_BUSY(14, "Busy (resource, slice); try again later"),
    GENIRESPONSE_EXPIRED(15, "Expired (eg slice)"),
    GENIRESPONSE_INPROGRESS(16, "In Progress"),
    GENIRESPONSE_ALREADYEXISTS(17, "Already Exists (eg the slice}"),
    GENIRESPONSE_VLAN_UNAVAILABLE(24, "VLAN tag(s) requested not available (likely stitching failure)"),
    SERVERBUSY(-32001, "Server is (temporarily) too busy; try again later"),
    INTERNAL_NONGENI_ERROR(50, "Internal error in client application", true),
    SERVER_REPLY_ERROR(51, "The client could not parse the server's reply. Either the server sent something strange, or this is a bug in the client", true),
    SERVER_TIMEOUT_ERROR(52, "The connection to the server timed out.", true);

    private final int code;
    private final String description;
    private final boolean internal;
    private static final Map<Integer, GeniAMResponseCode> RESPONSE_CODE_BY_CODE;

    private GeniAMResponseCode(int code, String description, boolean internal) {
        this.code = code;
        this.description = description;
        this.internal = internal;
    }

    private GeniAMResponseCode(int code, String description) {
        this.code = code;
        this.description = description;
        this.internal = false;
    }

    @Nonnull
    public static GeniAMResponseCode getByCode(int c) throws UnknownResponseCodeException {
        GeniAMResponseCode res = RESPONSE_CODE_BY_CODE.get(c);
        if (res == null) {
            throw new UnknownResponseCodeException("GeniAMResponseCode " + c + " does not exists");
        }
        return res;
    }

    public boolean isInternal() {
        return this.internal;
    }

    @Override
    public boolean isSuccess() {
        return this.code == 0 || this.code == 16;
    }

    @Override
    public boolean isBusy() {
        return this.code == 14 || this.code == -32001;
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "GeniAMResponseCode{code=" + this.code + ", description='" + this.description + "'}";
    }

    static {
        RESPONSE_CODE_BY_CODE = Arrays.stream(GeniAMResponseCode.values()).collect(Collectors.toMap(GeniAMResponseCode::getCode, Function.identity()));
    }
}

