/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSonHelper {
    public static Object jsonStringToXmlRpcLikeObject(String jsonString) {
        if (jsonString == null) {
            return null;
        }
        if (jsonString.trim().isEmpty()) {
            return null;
        }
        if (Objects.equals(jsonString.trim(), "null")) {
            return null;
        }
        LinkedList<JsonHelper> objectsToProcess = new LinkedList<JsonHelper>();
        PrimitiveHelper base = new PrimitiveHelper();
        base.source = new JSONTokener(jsonString).nextValue();
        objectsToProcess.add(base);
        while (!objectsToProcess.isEmpty()) {
            JsonHelper jsonHelper = (JsonHelper)objectsToProcess.pollFirst();
            boolean handled = false;
            if (jsonHelper.getSourceObject() instanceof JSONObject) {
                handled = true;
                JSONObject o = (JSONObject)jsonHelper.getSourceObject();
                HashMap<Object, Object> ht = new HashMap<Object, Object>();
                for (Object key : o.keySet()) {
                    MapHelper htHelp = new MapHelper();
                    htHelp.target = ht;
                    htHelp.key = key;
                    htHelp.value = o.get((String)key);
                    objectsToProcess.add(htHelp);
                }
                jsonHelper.setTranslation(ht);
            }
            if (jsonHelper.getSourceObject() instanceof JSONArray) {
                handled = true;
                JSONArray a = (JSONArray)jsonHelper.getSourceObject();
                Object[] v = new Object[a.length()];
                for (int i = 0; i < a.length(); ++i) {
                    ListArrayHelper vh = new ListArrayHelper();
                    vh.target = v;
                    vh.index = i;
                    vh.item = a.get(i);
                    objectsToProcess.add(vh);
                }
                jsonHelper.setTranslation(v);
            }
            if (handled) continue;
            jsonHelper.setTranslation(jsonHelper.getSourceObject());
        }
        return base.translation;
    }

    public static Object jsonObjectStringReplacer(Object jsonIn, Function<String, String> stringReplacer) {
        if (jsonIn == null) {
            return null;
        }
        LinkedList<JsonHelper> objectsToProcess = new LinkedList<JsonHelper>();
        PrimitiveHelper base = new PrimitiveHelper();
        base.source = jsonIn;
        objectsToProcess.add(base);
        while (!objectsToProcess.isEmpty()) {
            JsonHelper jsonHelper = (JsonHelper)objectsToProcess.pollFirst();
            boolean handled = false;
            if (jsonHelper.getSourceObject() instanceof Map) {
                handled = true;
                Map o = (Map)jsonHelper.getSourceObject();
                HashMap<Object, Object> ht = new HashMap<Object, Object>();
                for (Object key : o.keySet()) {
                    MapHelper htHelp = new MapHelper();
                    htHelp.target = ht;
                    htHelp.key = key;
                    htHelp.value = o.get((String)key);
                    objectsToProcess.add(htHelp);
                }
                jsonHelper.setTranslation(ht);
            }
            if (jsonHelper.getSourceObject() instanceof List) {
                handled = true;
                List a = (List)jsonHelper.getSourceObject();
                ArrayList<Object> v = new ArrayList<Object>(Arrays.asList(new Object[a.size()]));
                for (int i = 0; i < a.size(); ++i) {
                    ListListHelper vh = new ListListHelper();
                    vh.target = v;
                    vh.index = i;
                    vh.item = a.get(i);
                    objectsToProcess.add(vh);
                }
                jsonHelper.setTranslation(v);
            }
            if (jsonHelper.getSourceObject() instanceof String) {
                jsonHelper.setTranslation(stringReplacer.apply((String)jsonHelper.getSourceObject()));
                handled = true;
            }
            if (handled) continue;
            jsonHelper.setTranslation(jsonHelper.getSourceObject());
        }
        return base.translation;
    }

    public static String jsonObjectToString(Object o) {
        return XmlRpcPrintUtil.xmlRpcObjectToString(o);
    }

    private static class PrimitiveHelper
    implements JsonHelper {
        Object source;
        Object translation;

        private PrimitiveHelper() {
        }

        @Override
        public Object getSourceObject() {
            return this.source;
        }

        @Override
        public void setTranslation(Object o) {
            this.translation = o;
        }
    }

    private static interface JsonHelper {
        public Object getSourceObject();

        public void setTranslation(Object var1);
    }

    private static class MapHelper
    implements JsonHelper {
        Map<Object, Object> target;
        Object key;
        Object value;

        private MapHelper() {
        }

        @Override
        public Object getSourceObject() {
            return this.value;
        }

        @Override
        public void setTranslation(Object o) {
            this.target.put(this.key, o);
        }
    }

    private static class ListArrayHelper
    implements JsonHelper {
        Object[] target;
        int index;
        Object item;

        private ListArrayHelper() {
        }

        @Override
        public Object getSourceObject() {
            return this.item;
        }

        @Override
        public void setTranslation(Object o) {
            this.target[this.index] = o;
        }
    }

    private static class ListListHelper
    implements JsonHelper {
        List target;
        int index;
        Object item;

        private ListListHelper() {
        }

        @Override
        public Object getSourceObject() {
            return this.item;
        }

        @Override
        public void setTranslation(Object o) {
            this.target.set(this.index, o);
        }
    }
}

