/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;

public abstract class AbstractFederationApi2Test
extends BaseApiTest<LegacyApiTestConfig> {
    protected AbstractFederationApi.GetVersionResult getVersionResult;

    @Inject
    public AbstractFederationApi2Test(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public void checkCorrectnessXmlRpcResult(AbstractFederationApi.FederationApiReply res) {
        Map raw = res.getRawResult();
        Object code = raw.get("code");
        Object value = raw.get("value");
        Object output = raw.get("output");
        this.assertNotNull(code, "Invalid XmlRpc reply: \"code\" not found");
        this.assertNotNull(value, "Invalid XmlRpc reply: \"value\" not found");
        this.assertNotNull(output, "Invalid XmlRpc reply: \"output\" not found");
        this.assertTrue(code instanceof Integer);
        this.assertTrue(output instanceof String);
    }

    protected void checkGetVersion(AbstractFederationApi.FederationApiReply<? extends AbstractFederationApi.GetVersionResult> reply, AbstractFederationApi api, boolean isAuthority) throws JFedException {
        this.checkCorrectnessXmlRpcResult(reply);
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
        this.getVersionResult = (AbstractFederationApi.GetVersionResult)reply.getValue();
        this.assertTrue(this.getVersionResult.getFields() != null);
        Object raw = reply.getRawResult().get("value");
        this.assertNotNull(raw, "get_version return value not found");
        Map<String, Object> htRes = this.assertStringObjectMap(raw);
        this.setErrorsNotFatal();
        String version = this.assertMapContainsNonemptyString(htRes, "VERSION");
        Object fieldsObj = htRes.get("FIELDS");
        Map fields = null;
        if (fieldsObj != null) {
            if (fieldsObj instanceof Map) {
                fields = (Map)fieldsObj;
            } else {
                this.errorNonFatal("get_version FIELDS should be a dictionary (Map), but it is a " + fieldsObj.getClass().getName());
            }
        }
        if (!isAuthority) {
            this.assertFalse(htRes.containsKey("ROLES"), "Registry should not have ROLES field in get_version");
            this.assertFalse(htRes.containsKey("CREDENTIAL_TYPES"), "Registry should not have CREDENTIAL_TYPES field in get_version");
        } else {
            List credentialTypes = this.assertMapContainsList(htRes, "CREDENTIAL_TYPES");
            this.assertNotEmpty(credentialTypes);
            List<String> services = this.assertMapContainsList(htRes, "SERVICES", String.class);
            if (services != null) {
                this.note("SERVICES advertised in get_version: " + services);
                for (String requiredService : api.getRequiredApiServices()) {
                    this.assertTrue(services.contains(requiredService), "The required service " + requiredService + " is not specified in the get_version SERVICES");
                }
                ArrayList knownServices = new ArrayList(api.getRequiredApiServices());
                knownServices.addAll(api.getOptionalApiServices());
                ArrayList<String> unknownServices = new ArrayList<String>(services);
                unknownServices.removeAll(knownServices);
                this.assertEmpty(unknownServices, "Some services advertised in get_version SERVICES are unknown: " + unknownServices + "   (note: all known services: " + knownServices + ")");
            }
        }
        this.setErrorsFatal();
        ArrayList<String> knownFieldValueKeys = new ArrayList<String>();
        knownFieldValueKeys.add("OBJECT");
        knownFieldValueKeys.add("TYPE");
        knownFieldValueKeys.add("CREATE");
        knownFieldValueKeys.add("MATCH");
        knownFieldValueKeys.add("UPDATE");
        knownFieldValueKeys.add("PROTECT");
        if (fields != null) {
            this.note("FIELDS advertised in get_version: " + fields.keySet());
            Iterator iterator = fields.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entryO;
                Map.Entry entry = entryO = iterator.next();
                this.assertInstanceOf(entry.getKey(), String.class, "FIELDS contains entry with non-String key: " + entry.getKey().getClass().getName());
                this.assertInstanceOf(entry.getValue(), Map.class, "FIELDS contains entry with non-Map value: " + entry.getValue().getClass().getName());
                String key = (String)entry.getKey();
                Map<String, Object> value = this.assertStringObjectMap(entry.getValue());
                this.setErrorsNotFatal();
                boolean startWithUnderscore = key.startsWith("_");
                if (isAuthority) {
                    this.assertTrue(value.containsKey("OBJECT"), "FIELD definition for field \"" + key + "\" should contain OBJECT key");
                }
                this.assertTrue(value.containsKey("TYPE"), "FIELD definition for field \"" + key + "\" should contain TYPE key");
                if (value.containsKey("OBJECT") || !isAuthority) {
                    ArrayList requiredFields;
                    boolean isRequiredField;
                    String objectName = (String)value.get("OBJECT");
                    if (objectName == null && !isAuthority) {
                        objectName = "SERVICE";
                    }
                    if (isRequiredField = (requiredFields = new ArrayList(api.getMinimumFieldNames(objectName))).contains(key)) {
                        this.note("The FIELD \"" + key + "\" is a required field. This means that some settings for this default field are being overridden.");
                    } else {
                        this.assertTrue(startWithUnderscore, "supplementary FIELDS should start with and underscore: " + key);
                    }
                    if (!Objects.equals(objectName, "MEMBER")) {
                        this.assertFalse(value.containsKey("PROTECT"), "FIELD definition for field \"" + key + "\" should NOT contain PROTECT key for OBJECT != MEMBER");
                    }
                }
                for (String vk : value.keySet()) {
                    AbstractFederationApi.GetVersionResult.FieldInfo.Protect e2;
                    Object vv = value.get(vk);
                    this.warnIfNot(knownFieldValueKeys.contains(vk), "Unknown field key " + vk + " for entry " + key);
                    if (Objects.equals(vk, "OBJECT")) {
                        this.warnIfNot(api.getApiObjects().contains(vv), "Unknown OBJECT " + vv + " for FIELD " + key);
                    }
                    if (Objects.equals(vk, "TYPE")) {
                        try {
                            AbstractFederationApi.GetVersionResult.FieldInfo.FieldType fieldType = AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.valueOf((String)("" + vv));
                        }
                        catch (IllegalArgumentException e2) {
                            this.errorNonFatal("Unknown TYPE " + vv + " for FIELD " + key);
                        }
                    }
                    if (Objects.equals(vk, "PROTECT")) {
                        try {
                            e2 = AbstractFederationApi.GetVersionResult.FieldInfo.Protect.valueOf((String)("" + vv));
                        }
                        catch (IllegalArgumentException e3) {
                            this.errorNonFatal("Unknown PROTECT value " + vv + " for FIELD " + key);
                        }
                    }
                    if (!Objects.equals(vk, "CREATE")) continue;
                    try {
                        e2 = AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.valueOf((String)("" + vv).replace(' ', '_'));
                    }
                    catch (IllegalArgumentException e4) {
                        this.errorNonFatal("Unknown CREATE value " + vv + " for FIELD " + key);
                    }
                }
                if (this.getVersionResult.getFields() != null) {
                    this.assertTrue(this.getVersionResult.getFields().containsKey(key), "Bug in jFed: GetVersionResult does not contain failed that is defined in get_version: \"" + key + "\". All fields in GetVersionResult=" + this.getVersionResult.getFields().keySet());
                }
                this.setErrorsFatal();
            }
        }
    }

    protected void addRequiredSupplementaryFieldsToCreate(Map<String, String> fields, String objectName) {
        Map projectSupplementaryFields;
        if (this.getVersionResult != null && (projectSupplementaryFields = this.getVersionResult.getFieldsForObject(objectName)).size() > 0) {
            for (Map.Entry e : projectSupplementaryFields.entrySet()) {
                String fieldName = (String)e.getKey();
                AbstractFederationApi.GetVersionResult.FieldInfo fieldInfo = (AbstractFederationApi.GetVersionResult.FieldInfo)e.getValue();
                if (fields.containsKey(fieldName) || !Objects.equals(fieldInfo.getCreationAllowed(), AbstractFederationApi.GetVersionResult.FieldInfo.CreationAllowed.REQUIRED)) continue;
                ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo.FieldType> fakeableTypes = new ArrayList<AbstractFederationApi.GetVersionResult.FieldInfo.FieldType>();
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URN);
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.URL);
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.UID);
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.STRING);
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.EMAIL);
                fakeableTypes.add(AbstractFederationApi.GetVersionResult.FieldInfo.FieldType.KEY);
                if (fakeableTypes.contains(fieldInfo.getType())) {
                    fields.put(fieldName, "dummy");
                    continue;
                }
                this.warn("Do not know how to add supplementary field '" + fieldName + "' which has CREATION=REQUIRED and is of TYPE=" + fieldInfo.getType());
            }
        }
    }

    protected void checkLookupCorrectness(AbstractFederationApi.FederationApiReply reply) {
        this.setErrorsFatal();
        Object rawReplyValue = reply.getRawValue();
        this.assertInstanceOf(rawReplyValue, Map.class, "Lookup result should be a dictionary (=Map), but is of type " + rawReplyValue.getClass().getName());
        Map rawReplyValueHt = (Map)rawReplyValue;
        this.setErrorsNotFatal();
        for (Map.Entry e : rawReplyValueHt.entrySet()) {
            Object rawKey = e.getKey();
            Object rawVal = e.getValue();
            this.assertInstanceOf(rawKey, String.class, "Lookup dictionary should contain dictionaries string (URN) to dictionary. But at least one key is not String but " + rawKey.getClass().getName());
            this.assertInstanceOf(rawVal, Map.class, "Lookup dictionary should contain dictionaries string to dictionary (=Map). But at least one value is not dict but " + rawVal.getClass().getName());
        }
        this.setErrorsFatal();
    }
}

