/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class ConnectivityTestAggregateManager3
extends BaseApiTest<LegacyApiTestConfig> {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "One simple \"Geni Aggregate Manager API v3\" Test (XmlRpc and GetVersion). This is mainly useful to test connectivity to the tested AM.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            return Collections.emptyList();
        }
    };
    private AggregateManager3 am3;
    private Map versionRawResult = null;
    private AggregateManager3.VersionInfo versionInfo = null;

    @Inject
    public ConnectivityTestAggregateManager3(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public SfaConnection getAM3Connection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM3CorrectnessXmlRpcResult code == null in " + res);
        this.assertNotNull(value, "testAM3CorrectnessXmlRpcResult value == null in " + res);
        this.assertInstanceOf(code, Map.class, "testAM3CorrectnessXmlRpcResult code is not Map in " + res);
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM3CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + res);
        this.assertEquals(genicode.getClass(), Integer.class, "testAM3CorrectnessXmlRpcResult code.geni_code is not int in " + res);
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + res);
            this.assertEquals(output.getClass(), String.class, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else {
            if (output == null) {
                this.note("testAM3CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
            }
            if (output != null && !(output instanceof String)) {
                this.note("testAM32CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
            }
        }
    }

    @Override
    public void setUp() {
        this.am3 = new AggregateManager3(this.logger, this.getJFedPreferences());
    }

    @ApiTest.Test
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.getVersion(this.getAM3Connection());
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.versionRawResult = reply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        Object ver = this.versionRawResult.get("geni_api");
        assert (ver != null);
        assert (ver instanceof Integer);
        int v = (Integer)ver;
        this.assertEquals(v, 3, "AM (backward compatibility \"geni_api\" field) is not version 3");
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager3.VersionInfo)reply.getValue();
        this.assertNotNull(this.versionInfo);
        this.assertEquals(this.versionInfo.getApi(), 3, "AM is not version 3");
    }
}

