/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class DummyTest
extends BaseApiTest<LegacyApiTestConfig> {
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "A dummy test generating some fake results. This is useful to test the testing functionality. It also does 1 GetVersion test.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            return Collections.emptyList();
        }
    };
    private ProtogeniSliceAuthority sa;

    @Inject
    public DummyTest(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    @Override
    public void setUp() {
        this.note("Note in Setup");
        this.sa = new ProtogeniSliceAuthority(this.logger, this.getJFedPreferences());
    }

    @ApiTest.Test(description="Test A. Should be successful.", softDepends={"testGetVersion"})
    public void testA() throws JFedException {
        this.note("testA started");
        this.assertTrue(true);
    }

    @ApiTest.Test(description="Test B, should be a warning", hardDepends={"testA"})
    public void testB() {
        this.assertTrue(true);
        this.warn("warning in testB");
    }

    @ApiTest.Test(description="Test C, should be error", hardDepends={"testB", "testA"})
    public void testC() throws JFedException {
        this.note("testC started");
        this.assertTrue(true);
        this.errorNonFatal("error in testC");
        this.warn("warning in testC");
        this.note("test continues after error");
    }

    @ApiTest.Test(description="Test D, should be error due to exception", hardDepends={"testA"}, softDepends={"testB", "testC"})
    public void testD() {
        this.note("testD started");
        this.assertTrue(true);
        throw new RuntimeException("Faked error in testD");
    }

    @ApiTest.Test(description="Test E, should be skipped because test D failed", hardDepends={"testD"})
    public void testE() throws JFedException {
        this.note("testE should never be started");
        this.assertTrue(false);
        this.warn("warning in testE");
        this.note("note and warning never reached");
    }

    @ApiTest.Test(description="Test F, should be skipped because it wants to be skipped itselfd", softDepends={"testE"})
    public void testF() {
        this.note("testF started");
        this.skip("testF requests to be skipped for this DummyTest");
        this.errorNonFatal("error in testF");
        this.note("never reached");
        this.assertTrue(false);
    }

    public SfaConnection getConnection() throws JFedException {
        assert (this.connectionProvider != null);
        assert (this.user != null);
        assert (this.testedAuthority.getServerToConnect() != null);
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.PROTOGENI_SA, 1));
    }

    public void testSACorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code);
        this.assertNotNull(value);
        this.assertNotNull(output);
        this.assertInstanceOf(code, Integer.class);
        this.assertInstanceOf(output, String.class);
    }

    @ApiTest.Test
    public void testGetVersion() throws JFedException {
        ProtogeniSliceAuthority.SliceAuthorityReply reply = this.sa.getVersion(this.getConnection());
        this.testSACorrectnessXmlRpcResult(reply.getRawResult());
        this.assertTrue(reply.getGeniResponseCode().isSuccess());
    }
}

