/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class GPULabTestConfig
implements ApiTestConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GPULabTestConfig.class);
    @Nonnull
    private final String gpulabURL;
    @Nonnull
    private final String version;
    @Nonnull
    private final Integer minGPUs;
    @Nonnull
    private final Integer minCPUs;
    @Nonnull
    private final Integer minSlaves;
    @Nonnull
    private final Integer minClusters;
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();

    public GPULabTestConfig() {
        this.gpulabURL = "https://dev.gpulab.ilabt.imec.be/";
        this.version = "dev";
        this.minGPUs = 1;
        this.minCPUs = 1;
        this.minSlaves = 1;
        this.minClusters = 1;
    }

    @JsonCreator
    public GPULabTestConfig(@JsonProperty(value="gpulabURL") @Nullable String gpulabURL, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="minGPUs") @Nullable Integer minGPUs, @JsonProperty(value="minCPUs") @Nullable Integer minCPUs, @JsonProperty(value="minSlaves") @Nullable Integer minSlaves, @JsonProperty(value="minClusters") @Nullable Integer minClusters) {
        this.gpulabURL = gpulabURL == null ? new GPULabTestConfig().getGpulabURL() : gpulabURL;
        this.version = version == null ? new GPULabTestConfig().getVersion() : version;
        this.minGPUs = minGPUs == null ? new GPULabTestConfig().getMinGPUs() : minGPUs;
        this.minCPUs = minCPUs == null ? new GPULabTestConfig().getMinCPUs() : minCPUs;
        this.minSlaves = minSlaves == null ? new GPULabTestConfig().getMinSlaves() : minSlaves;
        this.minClusters = minClusters == null ? new GPULabTestConfig().getMinClusters() : minClusters;
    }

    @Override
    public boolean isValid() {
        return this.gpulabURL.startsWith("https://");
    }

    @Nonnull
    @JsonProperty
    public String getGpulabURL() {
        return this.gpulabURL;
    }

    @Nonnull
    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @Nonnull
    public Integer getMinGPUs() {
        return this.minGPUs;
    }

    @Nonnull
    public Integer getMinCPUs() {
        return this.minCPUs;
    }

    @Nonnull
    public Integer getMinSlaves() {
        return this.minSlaves;
    }

    @Nonnull
    public Integer getMinClusters() {
        return this.minClusters;
    }

    @Override
    @Nonnull
    public String stringValue() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to covert " + this.getClass().getName() + " to String", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GPULabTestConfig that = (GPULabTestConfig)o;
        return this.gpulabURL.equals(that.gpulabURL) && this.version.equals(that.version) && this.minGPUs.equals(that.minGPUs) && this.minCPUs.equals(that.minCPUs) && this.minSlaves.equals(that.minSlaves) && this.minClusters.equals(that.minClusters);
    }

    public int hashCode() {
        return Objects.hash(this.gpulabURL, this.version, this.minGPUs, this.minCPUs, this.minSlaves, this.minClusters);
    }
}

