/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.advertisement.geni_rspec_3.NodeContents;
import be.iminds.ilabt.jfed.rspec.advertisement.geni_rspec_3.RSpecContents;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class TestAggregateManager2
extends BaseApiTest<LegacyApiTestConfig> {
    protected CommonAMTest commonAMTest;
    protected AggregateManager2 am2;
    protected List<AnyCredential> userCredentials;
    protected NodeLoginTestStep nodeLoginTestStep;
    protected Boolean createSliceIfNotExists = true;
    protected Boolean reuseSliceIfExists = false;
    protected Boolean beLessStrict = false;
    protected Boolean disableComplianceTests = false;
    protected Boolean disableCleanup = false;
    protected Map versionRawResult = null;
    protected AggregateManager2.VersionInfo versionInfo = null;
    protected CommonAMTest.SliceInfo sliceNoSliver;
    protected String fixedNodeUrn = null;
    protected String fixedNodeSliverType = null;
    protected CommonAMTest.SliceInfo sliceSliver;
    protected String createSliverManifestRspec = null;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Many Aggregate Manager (Geni AM API v2) Tests. 2 slices and a sliver will be created during the tests. The sliver will be deleted. This will not test ListResources when requesting an advertisement request (takes too long, use TestAggregateManager2AllListResources).";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("fixed_ssh_public_key_file");
            res.add("fixed_ssh_private_key_file");
            res.add("fixed_ssh_private_key_password");
            res.add("skip_final_manifest_check");
            res.add("nodelogin_deadline_ms");
            res.add("create_slice_if_not_exists");
            res.add("reuse_slice_if_exists");
            res.add("fixed_slice_name");
            res.add("fixed_project_name");
            res.add("try_to_use_project_for_slices");
            res.add("be_less_strict");
            res.add("disable_compliance_tests");
            res.add("disable_slice_cleanup");
            CommonAMTest.addOptionsForFixedRspec(res);
            CommonAMTest.addCredentialOptions(res);
            CommonAMTest.addOptionsForNodeLoginSshProxy(res);
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            CommonAMTest.addOptionsForRspecTypeVersion(res);
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }
    };
    AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.VersionInfo> getVersionReply;
    private String requestRspec;
    private Boolean notEnoughResourcesDetected = null;

    @Inject
    public TestAggregateManager2(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    protected List<AnyCredential> getUserCredentialList() {
        return this.commonAMTest.getUserCredentialListForAM();
    }

    public SfaConnection getAM2Connection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 2));
    }

    protected void assertValidStatus(String status) {
        ArrayList<String> apiPossibleStatus = new ArrayList<String>();
        apiPossibleStatus.add("ready");
        apiPossibleStatus.add("configuring");
        apiPossibleStatus.add("failed");
        apiPossibleStatus.add("unknown");
        ArrayList<String> otherPossibleStatus = new ArrayList<String>();
        otherPossibleStatus.add("changing");
        otherPossibleStatus.add("notready");
        ArrayList<String> possibleStatus = new ArrayList<String>();
        possibleStatus.addAll(apiPossibleStatus);
        possibleStatus.addAll(otherPossibleStatus);
        this.assertTrue(possibleStatus.contains(status), "Invalid geni_status: \"" + status + "\" is not one of " + possibleStatus);
        if (!apiPossibleStatus.contains(status)) {
            this.warn("SliverStatus returns invalid geni_status: \"" + status + "\" is not one of " + apiPossibleStatus);
        }
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        this.assertNotNull(res, "testAM2CorrectnessXmlRpcResult res is null");
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM2CorrectnessXmlRpcResult code == null in " + res);
        this.assertNotNull(value, "testAM2CorrectnessXmlRpcResult value == null in " + res);
        this.assertInstanceOf(code, Map.class, "testAM2CorrectnessXmlRpcResult code is not Map in " + res);
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM2CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + res);
        this.assertEquals(genicode.getClass(), Integer.class, "testAM2CorrectnessXmlRpcResult code.geni_code is not int in " + res);
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + res);
            this.assertEquals(output.getClass(), String.class, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else {
            if (output == null) {
                this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
            }
            if (output != null && !(output instanceof String)) {
                this.warn("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
            }
        }
    }

    @Override
    public void setUp() {
        this.commonAMTest = new CommonAMTest(this, this.getTestbedInfoSource());
        this.am2 = new AggregateManager2(this.logger, this.getJFedPreferences());
        this.commonAMTest.processCredentialOptions(this.testbedInfoSource, this.authorityFinder);
        System.out.println("Fetching User credential needed for AM tests");
        this.userCredentials = this.commonAMTest.getUserCredentialListForAM();
        this.createSliceIfNotExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("create_slice_if_not_exists"));
        this.reuseSliceIfExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("reuse_slice_if_exists"));
        this.disableComplianceTests = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_compliance_tests"));
        this.disableCleanup = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_slice_cleanup"));
        if (this.createSliceIfNotExists == null) {
            this.createSliceIfNotExists = true;
        }
        if (this.reuseSliceIfExists == null) {
            this.reuseSliceIfExists = false;
        }
        if (this.disableComplianceTests == null) {
            this.disableComplianceTests = false;
        }
        if (this.disableCleanup == null) {
            this.disableCleanup = false;
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("be_less_strict") != null) {
            Object v = ((LegacyApiTestConfig)this.getTestConfig()).get("be_less_strict");
            this.note("be_less_strict option specified: " + v);
            this.beLessStrict = TextUtil.objectToBoolean((Object)("" + v));
            if (this.beLessStrict.booleanValue()) {
                this.note(" be_less_strict activated: turning some failures into warnings");
            } else {
                this.note(" be_less_strict is NOT activated");
            }
        }
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
    }

    @ApiTest.Test(groups={"getversion", "nonodelogin"})
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        this.getVersionReply = this.am2.getVersion(this.getAM2Connection());
        this.testAM2CorrectnessXmlRpcResult(this.getVersionReply.getRawResult());
        this.versionRawResult = this.getVersionReply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        Object ver = this.versionRawResult.get("geni_api");
        this.assertTrue(ver != null);
        this.assertTrue(ver instanceof Integer);
        int v = (Integer)ver;
        this.assertTrue(v == 2);
        this.assertEquals(this.getVersionReply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager2.VersionInfo)this.getVersionReply.getValue();
        this.assertNotNull(this.versionInfo);
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, groups={"nonodelogin"})
    public void testGetVersionResultCorrectness() throws JFedException {
        String[] rspecVersionListnames;
        Map value = (Map)this.versionRawResult.get("value");
        this.assertEquals(value.get("geni_api"), 2);
        this.assertNotNull(value.get("geni_api_versions"), "geni_api_versions not in version result");
        this.assertTrue(value.get("geni_api_versions") instanceof Map, "geni_api_versions is not a Map but a " + value.get("geni_api_versions").getClass().getName());
        for (String name : rspecVersionListnames = new String[]{"geni_request_rspec_versions", "geni_ad_rspec_versions"}) {
            this.assertNotNull(value.get(name), name + " not in version result");
            Object[] v = this.assertInstanceOf(value.get(name), Object[].class, name + " is not a List but a " + value.get(name).getClass().getName());
            this.assertTrue(v.length > 0, name + " array is empty");
            for (Object o : v) {
                Object[] extensions;
                this.assertTrue(o instanceof Map, name + " array should contain only Map not a " + o.getClass().getName());
                Map t = (Map)o;
                this.assertMapContainsNonemptyString(t, "type");
                this.assertMapContainsNonemptyString(t, "version");
                this.assertMapContainsString(t, "schema");
                this.assertMapContainsString(t, "namespace");
                Object extensionsO = t.get("extensions");
                this.assertNotNull(extensionsO);
                for (Object e : extensions = this.assertInstanceOf(extensionsO, Object[].class, "value for extensions of " + name + " is not a String but a " + extensionsO.getClass().getName())) {
                    this.assertTrue(e instanceof String, "an extension of \"+name+\" is not a string but a " + e.getClass().getName());
                }
            }
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionResultCorrectness"}, groups={"nonodelogin"})
    public void testGetVersionResultApiVersionsCorrectness() throws JFedException, MalformedURLException {
        Map value = (Map)this.versionRawResult.get("value");
        Map versions = (Map)value.get("geni_api_versions");
        Object o = versions.get(2);
        if (o == null) {
            this.note("geni_api_versions for Integer 2 is null. (Note that for String \"2\" it is \"" + versions.get("2") + "). This test will accept String instead of int: the API specifies it should be int, but almost every server uses a String.");
            o = versions.get("2");
        }
        this.assertNotNull(o, "geni_api_versions for value 2 is null (tried with both int 2 and string \"2\").");
        this.assertTrue(o instanceof String, "value for 2 is not a String but a " + o.getClass().getName());
        boolean serverUrlWithLocalhost = false;
        try {
            URL serverUrl = new URL(this.getVersionReply.getXMLRPCCallDetails().getServerUrl());
            serverUrlWithLocalhost = serverUrl.getHost().equals("localhost") || serverUrl.getHost().equals("127.0.0.1");
        }
        catch (Exception e) {
            this.note("Unexpected exception in test. Test will ignore this, but this might be an automated tester bug", e);
        }
        if (!serverUrlWithLocalhost) {
            for (Object key : versions.keySet()) {
                this.assertTrue(key instanceof Integer || key instanceof String, "geni_api_versions keys should be Integer or String, not " + key.getClass().getName());
                if (key instanceof Integer) {
                    versionNr = (Integer)key;
                } else {
                    this.note("geni_api_versions contains String key \"" + key + "\". This test will accept String instead of int: the API specifies it should be int, but almost every server uses a String.");
                    versionNr = Integer.parseInt((String)key);
                }
                Object val = versions.get(key);
                this.assertTrue(val instanceof String, "geni_api_versions values should be String, not " + val.getClass().getName());
                String urlS = (String)val;
                URL url = new URL(urlS);
                String host = url.getHost();
                this.assertFalse(Objects.equals(host, "localhost"), "Illegal host in URL: " + url + " (host in URL should not be the non-global \"" + host + "\")");
                this.assertFalse(Objects.equals(host, "127.0.0.1"), "Illegal host in URL: " + url + " (host in URL should not be the non-global \"" + host + "\")");
            }
        } else {
            this.note("The URL of the server has localhost. This test will assume that this is a test server, and will therefor NOT warn or fail if the URL's in GetVersion have localhost in them.");
        }
        Object urn = value.get("urn");
        if (urn != null) {
            String testUrnString;
            String urnString;
            this.setErrorsNotFatal();
            this.assertInstanceOf(urn, String.class, "if URN is defined, it should be a String, not a " + urn.getClass().getName());
            if (urn instanceof String && !Objects.equals(urnString = (String)urn, testUrnString = this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn())) {
                this.warn("URN in GetVersion (" + urnString + ") does not match the URN used to start this test (" + testUrnString + "). This could either be a problem on the server, a bad URN in GetVersion, or it could be that the jFed has wrong info about this authority. This failure could result in a failure to allocate resources (as the component_manager urn used will not match this server).");
            }
            this.setErrorsNotFatal();
        } else {
            this.note("GetVersion does not specify \"urn\" (which contains the component manager urn). This is not mandatory, but it is useful to include.");
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionResultCorrectness"}, softDepends={"testGetVersionResultApiVersionsCorrectness"}, groups={"nonodelogin"})
    public void testGetVersionResultNoDuplicates() throws JFedException {
        ArrayList<AggregateManager2.VersionInfo.RspecVersion> adRspecVersions = new ArrayList<AggregateManager2.VersionInfo.RspecVersion>();
        for (AggregateManager2.VersionInfo.RspecVersion rspecVer : this.versionInfo.getAdRspecVersions()) {
            for (AggregateManager2.VersionInfo.RspecVersion other : adRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion(rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Advertisement RSpec:type=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            adRspecVersions.add(rspecVer);
        }
        ArrayList<AggregateManager2.VersionInfo.RspecVersion> reqRspecVersions = new ArrayList<AggregateManager2.VersionInfo.RspecVersion>();
        for (AggregateManager2.VersionInfo.RspecVersion rspecVer : this.versionInfo.getRequestRspecVersions()) {
            for (AggregateManager2.VersionInfo.RspecVersion other : reqRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion(rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Request RSpectype=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            reqRspecVersions.add(rspecVer);
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates"}, groups={"nonodelogin"})
    public void testListResourcesBadCredential() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), new ArrayList(), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), Boolean.valueOf(true), null, null);
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertFalse(reply.getGeniResponseCode().isSuccess());
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates"}, groups={"nonodelogin"})
    public void testSliverStatusBadSlice() throws JFedException {
        String badSliceUrn = "urn:publicid:IDN+" + this.commonAMTest.getUserAuthorityServer().getUrnTld() + "+slice+NonExisting";
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.sliverStatus(this.getAM2Connection(), this.getUserCredentialList(), badSliceUrn, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertFalse(reply.getGeniResponseCode().isSuccess(), "SliverStatus reply GeniResponse code is SUCCESS (0) when given a non existing slice \"" + badSliceUrn + "\"");
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates"}, groups={"nonodelogin"})
    public void testCreateSliceNoSliver() throws JFedException, IOException {
        String fixedProjectName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_project_name");
        boolean tryToUseProject = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("try_to_use_project_for_slices")) != Boolean.FALSE;
        this.sliceNoSliver = this.commonAMTest.createSlice("n", fixedProjectName, tryToUseProject, true);
        assert (this.sliceNoSliver != null);
        assert (this.sliceNoSliver.urn != null) : "sliceNoSliver.urn is null";
        assert (this.sliceNoSliver.urn.getValue().startsWith("urn:publicid:IDN+"));
        assert (this.sliceNoSliver.credentials != null) : "sliceNoSliver.credential is null";
        assert (!this.sliceNoSliver.credentials.isEmpty()) : "sliceNoSliver.credential is empty";
    }

    @ApiTest.Test(hardDepends={"testCreateSliceNoSliver"}, groups={"nosliver", "nonodelogin"})
    public void testSliverStatusNoSliverSlice() throws JFedException {
        assert (this.sliceNoSliver != null);
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.sliverStatus(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceNoSliver), this.sliceNoSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertFalse(reply.getGeniResponseCode().isSuccess(), "SliverStatus reply GeniResponse code is SUCCESS (0) when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver. (should fail because no sliver found for the slice)");
        this.assertNotNull(reply.getRawResult());
        Object rawValueResult = reply.getRawResult().get("value");
        if (rawValueResult != null) {
            this.warnIfNot(rawValueResult instanceof Map, "SliverStatus result is not null, which is allowed on failure, but in that case it is expected to be a valid response, which would be a struct. However, it is a " + rawValueResult.getClass().getSimpleName() + " -> value=\"" + rawValueResult.toString() + "\"");
        }
        this.warnIfNot(rawValueResult != null == (reply.getValue() != null), "Mismatch: SliverStatus processed result value is " + (reply.getValue() != null ? "not null" : "null") + " but RAW SliverStatus result value is " + (rawValueResult != null ? "not null" : "null"));
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates"}, groups={"listavailableresources", "nodelogin", "nonodelogin"})
    public void testListResourcesAvailableNoSlice() throws JFedException {
        String rspec = this.testListResourcesAvailableNoSlice_internal(this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()).toLowerCase(), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), true);
        String testUrnString = this.testedAuthority.getRspecUrn().getValue();
        int nodecount = 0;
        int matchingNodecount = 0;
        HashSet<String> componentManagerIds = new HashSet<String>();
        String fixedNodeUrn = null;
        String fixedNodeSliverType = null;
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will not check the validity of the result.");
            return;
        }
        try {
            Class<RSpecContents> docClass = RSpecContents.class;
            String packageName = docClass.getPackage().getName();
            JAXBContext jc = JAXBContext.newInstance((String)packageName);
            Unmarshaller u = jc.createUnmarshaller();
            JAXBElement doc = (JAXBElement)u.unmarshal((Reader)new StringReader(rspec));
            RSpecContents c = (RSpecContents)doc.getValue();
            String typ = c.getType();
            this.assertNotNull(typ, "Received advertisement RSpec does not specify a type: " + rspec);
            this.assertEquals(typ, "advertisement", "Received advertisement RSpec is not a advertisement, it is a: \"" + typ + "\"");
            for (Object o : c.getAnyOrNodeOrLink()) {
                JAXBElement el;
                if (!(o instanceof JAXBElement) || !((el = (JAXBElement)o).getValue() instanceof NodeContents)) continue;
                NodeContents node = (NodeContents)el.getValue();
                ++nodecount;
                String componentManagerId = node.getComponentManagerId();
                String nodeId = node.getComponentId();
                componentManagerIds.add(componentManagerId);
                if (Objects.equals(componentManagerId, testUrnString)) {
                    ++matchingNodecount;
                }
                for (Object nodeElO : node.getAnyOrRelationOrLocation()) {
                    JAXBElement nodeEl;
                    if (!(nodeElO instanceof JAXBElement) || !((nodeEl = (JAXBElement)nodeElO).getValue() instanceof NodeContents.SliverType)) continue;
                    NodeContents.SliverType st = (NodeContents.SliverType)nodeEl.getValue();
                    String sliverTypeName = st.getName();
                    if (!Objects.equals(componentManagerId, testUrnString) || fixedNodeUrn != null && !CommonAMTest.preferSliverType(sliverTypeName, fixedNodeSliverType)) continue;
                    fixedNodeUrn = nodeId;
                    fixedNodeSliverType = sliverTypeName;
                }
            }
        }
        catch (JAXBException e) {
            throw new RuntimeException("Exception parsing advertisement RSpec Xml: " + e.getMessage(), e);
        }
        if (matchingNodecount == 0) {
            if (componentManagerIds.isEmpty()) {
                this.note("Could not find a single node for this component_managers_id (" + testUrnString + ") in the advertisement. No nodes of other component_managers_id's found either.");
            } else {
                this.warn("Could not find a single node for this component_managers_id (" + testUrnString + ") in the advertisement. Did find nodes for the following component_managers_id's: " + componentManagerIds);
            }
            this.note("There are probably no free nodes left");
        } else {
            this.note("Found nodes for the following component_managers_id's: " + componentManagerIds);
        }
        if (fixedNodeUrn == null) {
            this.note("Could not find a suitable fixed node in the advertisement request");
        } else {
            this.note("Found potential fixed node: " + fixedNodeUrn);
        }
        this.note("Best sliver type found: " + fixedNodeSliverType);
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates", "testListResourcesAvailableNoSlice"}, groups={"listavailableresources", "nonodelogin"})
    public void testListResourcesAvailableNoSliceUpperCase() throws JFedException {
        this.note("This tests if uppercase rspec type also works. The AMv2 API says: \"type and version are case-insensitive strings, matching those in geni_ad_rspec_versions as returned by GetVersion at this aggregate.\"");
        this.testListResourcesAvailableNoSlice_internal(this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()).toUpperCase(), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), true);
    }

    public String testListResourcesAvailableNoSlice_internal(String rspecType, String rspecVersion, boolean available) throws JFedException {
        assert (this.userCredentials != null);
        assert (!this.userCredentials.isEmpty());
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.getUserCredentialList(), rspecType, rspecVersion, Boolean.valueOf(available), Boolean.valueOf(true), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given no slice urn and available=" + available);
        String rspec = (String)reply.getValue();
        this.assertNotNull(rspec, "ListResources reply is completely empty when given no slice urn and available=" + available);
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will not check the validity of the result.");
            return rspec;
        }
        int nodeCount = CommonAMTest.testValidGeni3AdvertisementRspec(this, rspec);
        this.note("The received RSpec has a length of " + rspec.length() + " characters, and lists " + nodeCount + " nodes.");
        return rspec;
    }

    @ApiTest.Test(hardDepends={"testCreateSliceNoSliver"}, groups={"nosliver", "nonodelogin"})
    public void testListResourcesNoSliverSlice() throws JFedException {
        assert (this.sliceNoSliver != null) : "sliceNoSliver is null";
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceNoSliver), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), null, Boolean.valueOf(true), this.sliceNoSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        String specsText = "ListResources returns an RSpec in GENI standard schema. \nWhen a valid geni_slice_urn option is supplied, the returned RSpec will be a Manifest RSpec of the type corresponding to geni_rspec_version, but in manifest format. \nIf no resources are allocated to the indicated slice by this aggregate, an empty RSpec should be returned -- aggregates should NOT return an error.";
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        String rspec = (String)reply.getValue();
        this.assertNotNull(rspec, "ListResources reply is completely empty when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 0, "ListResources reply when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified) is not an valid RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
        this.assertTrue(CommonAMTest.isEmptyRspec(this, rspec), "ListResources reply when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified) is not an empty RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
    }

    @ApiTest.Test(hardDepends={"testCreateSliceNoSliver"}, groups={"nosliver", "nonodelogin"})
    public void testListResourcesNoSliverSliceAvailable() throws JFedException {
        assert (this.sliceNoSliver != null) : "sliceNoSliver is null";
        String specsText = "ListResources returns an RSpec in GENI standard schema. \nWhen a valid geni_slice_urn option is supplied, the returned RSpec will be a Manifest RSpec of the type corresponding to geni_rspec_version, but in manifest format. \nIf no resources are allocated to the indicated slice by this aggregate, an empty RSpec should be returned -- aggregates should NOT return an error.";
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceNoSliver), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), Boolean.valueOf(true), this.sliceNoSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=true). (according to the specs:\"" + specsText + "\")");
        String rspec = (String)reply.getValue();
        this.assertNotNull(rspec, "ListResources reply is completely empty when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 0, "ListResources reply  when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=true) is not an valid RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
        this.assertTrue(CommonAMTest.isEmptyRspec(this, rspec), "ListResources reply  when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=true) is not an empty RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
        reply = this.am2.listResources(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceNoSliver), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(false), Boolean.valueOf(true), this.sliceNoSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=false). (according to the specs:\"" + specsText + "\")");
        rspec = (String)reply.getValue();
        this.assertNotNull(rspec, "ListResources reply is completely empty when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 0, "ListResources reply  when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=false) is not an valid RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
        this.assertTrue(CommonAMTest.isEmptyRspec(this, rspec), "ListResources reply  when given a slice \"" + this.sliceNoSliver.urn + "\" that has no sliver (available=false) is not an empty RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
    }

    @ApiTest.Test(softDepends={"testGetVersionResultApiVersionsCorrectness", "testGetVersionResultNoDuplicates"}, hardDepends={"testGetVersionXmlRpcCorrectness"}, groups={"nonodelogin"})
    public void testCreateSliceSliver() throws JFedException, IOException {
        boolean tryToUseProject;
        String fixedSliceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_slice_name");
        String fixedProjectName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_project_name");
        boolean bl = tryToUseProject = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("try_to_use_project_for_slices")) != Boolean.FALSE;
        if (this.reuseSliceIfExists.booleanValue() && fixedSliceName != null) {
            this.sliceSliver = this.commonAMTest.reuseSlice(fixedSliceName);
            if (this.sliceSliver != null) {
                return;
            }
            if (!this.createSliceIfNotExists.booleanValue()) {
                throw new RuntimeException("create_slice_if_not_exists is false, and slice does not exist.");
            }
        }
        this.sliceSliver = fixedSliceName == null ? this.commonAMTest.createSlice("s", fixedProjectName, tryToUseProject, true) : this.commonAMTest.createSlice(fixedSliceName, false, fixedProjectName, tryToUseProject, true);
        assert (this.sliceSliver != null);
        assert (this.sliceSliver.urn != null) : "sliceSliver.urn is null";
        assert (this.sliceSliver.urn.getValue().startsWith("urn:publicid:IDN+"));
        assert (this.sliceSliver.credentials != null) : "sliceSliver.credential is null";
        assert (!this.sliceSliver.credentials.isEmpty()) : "sliceSliver.credential is empty";
    }

    @ApiTest.Test(hardDepends={"testCreateSliceSliver"}, softDepends={"testListResourcesAvailableNoSlice"}, groups={"createsliver", "createslivernowait", "nonodelogin"})
    public void testCreateSliver() throws JFedException, NoSuchAlgorithmException, IOException {
        assert (this.sliceSliver != null) : "sliceSliver is null";
        NodeLoginTestStepConfig nodeLoginTestStepConfig = NodeLoginTestStepConfig.generateFromLegacyConfig(this, (LegacyApiTestConfig)this.getTestConfig(), this.geniUserProvider);
        this.nodeLoginTestStep = new NodeLoginTestStep(this, nodeLoginTestStepConfig);
        String rspecArg = this.commonAMTest.getFixedRspecOption();
        if (rspecArg == null) {
            this.note("Searching RSpec to use on authority \"" + this.testedAuthority.getRspecUrn() + "\" (connecting to " + this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn() + ") with type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
            this.requestRspec = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.sliceSliver.urn);
            if (this.requestRspec == null) {
                this.skip("testCreateSliver skipped, because no RSpec example known for authority \"" + this.testedAuthority.getRspecUrn() + "\" type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
            }
        } else {
            this.note("Using RSpec supplied in configuration");
            this.requestRspec = rspecArg;
            if (!this.commonAMTest.isGeniFixedRspec()) {
                this.fatalError("The specified request RSpec is not a geni v3 RSpec. This test does not yet support that case.");
            }
        }
        String sshKey = "todo";
        ArrayList<String> sshKeys = new ArrayList<String>();
        sshKeys.add(this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKeyString());
        UserSpec userSpec = new UserSpec(this.getUser().getUserUrnString(), sshKeys);
        ArrayList<UserSpec> userSpecs = new ArrayList<UserSpec>();
        userSpecs.add(userSpec);
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.createSliver(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.sliceSliver.urn.getValue(), this.requestRspec, userSpecs, this.commonAMTest.addCredentialExtraOptions(null));
        if (Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_REFUSED) && Objects.equals(reply.getOutput(), "Must delete existing slice first")) {
            this.warn("Received \"Must delete existing slice first\". Probably, the call succeeded but timed out in a previous attempt. This occurs when the server is very busy. We will continue as if the call succeeded.");
            return;
        }
        this.notEnoughResourcesDetected = AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Will skip further tests. Full message: " + reply.getOutput());
            return;
        }
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "CreateSliver did not succeed");
        this.createSliverManifestRspec = (String)reply.getValue();
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will skip some checks because of this.");
            return;
        }
        int manifestNodeCount = CommonAMTest.testValidGeni3ManifestRspec(this, this.createSliverManifestRspec);
        this.assertNotEquals(manifestNodeCount, 0, "CreateSliver returned a manifest RSpec without any nodes. (Expected at least 1 node) " + this.createSliverManifestRspec);
        this.assertEquals(manifestNodeCount, 1, "CreateSliver returned a manifest RSpec with an incorrect number of nodes. Expected 1 but got " + manifestNodeCount + " " + this.createSliverManifestRspec);
        this.assertNotNull(this.nodeLoginTestStep);
        this.assertFalse(this.nodeLoginTestStep.hasParsed());
        this.setErrorsNotFatal();
        this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, this.createSliverManifestRspec));
        this.setErrorsFatal();
        this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.createSliverManifestRspec, null, null);
        this.assertFalse(CommonAMTest.isEmptyRspec(this, this.createSliverManifestRspec), "CreateSliver returned and empty RSpec: " + this.createSliverManifestRspec);
        System.out.println("Created sliver for \"" + this.sliceSliver.urn.getValue() + "\" manifestRspec=" + this.createSliverManifestRspec);
    }

    public void validSuccesStatus(AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.SliverStatus> reply) {
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "SliverStatus reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
        this.assertInstanceOf(reply.getRawResult().get("value"), Map.class, "SliverStatus value should be a Map. Not: " + reply.getRawResult().get("value"));
        Map rawValue = (Map)reply.getRawResult().get("value");
        String geniUrn = this.assertMapContainsNonemptyString(rawValue, "geni_urn");
        this.assertValidUrn(geniUrn, null);
        String urntype = GeniUrn.parse((String)geniUrn).getEncodedResourceType();
        if (!Objects.equals(urntype, "sliver")) {
            if (Objects.equals(urntype, "slice")) {
                this.note("URN type in SliverStatus is \"slice\", but expecting \"sliver\". This is not in compliance with API. However, the API is unlogical here, and a lot of servers return a slice URN here. And in the AMv3 API, it is slice URN.");
            } else {
                throw new RuntimeException("urntype is " + urntype + " in " + geniUrn + " but expecting \"sliver\" or \"slice\"");
            }
        }
        String geniStatus = this.assertMapContainsNonemptyString(rawValue, "geni_status");
        this.assertValidStatus(geniStatus);
        List geniResources = this.assertMapContainsList(rawValue, "geni_resources");
        for (Object geniResource : geniResources) {
            this.assertNotNull(geniResource);
            this.assertInstanceOf(geniResource, Map.class, "one of the geni_resources is not a Map but a " + geniResource.getClass().getName());
            Map ht = (Map)geniResource;
            String resourceUrn = this.assertMapContainsNonemptyString(ht, "geni_urn");
            this.assertValidUrn(resourceUrn, null);
            String resourceStatus = this.assertMapContainsNonemptyString(ht, "geni_status");
            this.assertValidStatus(resourceStatus);
            this.assertMapContainsString(ht, "geni_error");
        }
    }

    @ApiTest.Test(hardDepends={"testCreateSliver"}, groups={"nonodelogin"})
    public void testSliverStatusExistingSliver() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        assert (this.sliceSliver != null) : "sliceSliver is null";
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.sliverStatus(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.sliceSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.SliverStatus>)reply);
    }

    @ApiTest.Test(hardDepends={"testCreateSliver"}, groups={"nonodelogin"})
    public void testListResourcesExistingSliver() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        assert (this.sliceSliver != null) : "sliceSliver is null";
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), null, Boolean.valueOf(true), this.sliceSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
        String rspec = (String)reply.getValue();
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 1, "ListResources reply  when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver is not an valid RSpec: " + rspec);
        this.assertFalse(CommonAMTest.isEmptyRspec(this, rspec), "ListResources reply  when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver is an empty RSpec: " + rspec);
    }

    @ApiTest.Test(hardDepends={"testCreateSliver"}, softDepends={"testSliverStatusExistingSliver", "testListResourcesExistingSliver"}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void testCreatedSliverBecomesReady() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        assert (this.sliceSliver != null) : "sliceSliver is null";
        long now = System.currentTimeMillis();
        long deadline = now + 1200000L;
        int failcount = 0;
        while (now < deadline) {
            Map rawValue;
            String geniStatus;
            AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.sliverStatus(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.sliceSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
            if (!this.disableComplianceTests.booleanValue()) {
                this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager2.SliverStatus>)reply);
            }
            if ((geniStatus = this.assertMapContainsNonemptyString(rawValue = (Map)reply.getRawResult().get("value"), "geni_status")).equalsIgnoreCase("ready")) {
                this.note("testCreatedSliverBecomesReady @ " + new Date() + " -> sliver ready: " + rawValue);
                return;
            }
            if (geniStatus.equalsIgnoreCase("failed")) {
                this.warn("testCreatedSliverBecomesReady @ " + new Date() + " -> sliver FAILED: " + rawValue);
                ++failcount;
            }
            if (failcount >= 2) {
                this.fatalError("testCreatedSliverBecomesReady @ " + new Date() + " -> sliver FAILED: " + rawValue);
            }
            this.note("testCreatedSliverBecomesReady @ " + new Date() + "-> sliver not ready: " + geniStatus + ".  Trying again in 30 seconds...");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        throw new RuntimeException("Sliver did not become ready within 20 minutes!");
    }

    @ApiTest.Test(hardDepends={"testCreateSliver"}, softDepends={"testCreatedSliverBecomesReady"}, groups={"nodelogin", "nonodelogin"})
    public void checkManifestOnceSliverIsReady() throws JFedException, IOException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.listResources(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), null, Boolean.valueOf(true), this.sliceSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "ListResources reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
        String rspec = (String)reply.getValue();
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will skip some checks because of this.");
            return;
        }
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 1, "ListResources reply  when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver is not an valid RSpec: " + rspec);
        this.assertFalse(CommonAMTest.isEmptyRspec(this, rspec), "ListResources reply  when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver is an empty RSpec: " + rspec);
        String manifestRspec = (String)reply.getValue();
        if (this.createSliverManifestRspec == null || manifestRspec == null || !Objects.equals(manifestRspec, this.createSliverManifestRspec)) {
            this.note("Manifest RSpec returned by ListResources after Sliver becomes ready differs from manifest RSpec returned by CreateSliver");
            if (this.createSliverManifestRspec != null) {
                this.note("Manifest RSpec returned by CreateSliver " + (this.createSliverManifestRspec.contains("ssh-keys") ? "contains" : "DOES NOT contain") + " 'ssh-keys'. length=" + this.createSliverManifestRspec.length() + " chars. ");
            } else {
                this.note("Manifest RSpec returned by CreateSliver is null");
            }
            if (manifestRspec != null) {
                this.note("Manifest RSpec returned by ListResources after Sliver becomes ready " + (manifestRspec.contains("ssh-keys") ? "contains" : "DOES NOT contain") + " 'ssh-keys'. length=" + manifestRspec.length() + " chars.");
                this.setErrorsNotFatal();
                this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, manifestRspec));
                this.setErrorsFatal();
                this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(manifestRspec, null, null);
                if (TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("skip_final_manifest_check")) != Boolean.TRUE) {
                    this.nodeLoginTestStep.checkManifestCorrectness(manifestRspec, this.testedAuthority);
                }
            } else {
                this.errorNonFatal("Manifest RSpec returned by ListResources after Sliver becomes ready is null");
            }
        }
    }

    @ApiTest.Test(hardDepends={"testCreateSliver"}, softDepends={"testCreatedSliverBecomesReady", "checkManifestOnceSliverIsReady"}, groups={"nodelogin"})
    public void testNodeLogin() throws JFedException, IOException {
        this.assertNotNull(this.geniUserProvider);
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        assert (this.nodeLoginTestStep != null);
        assert (this.nodeLoginTestStep.hasParsed());
        this.nodeLoginTestStep.testNodeLogin(this.beLessStrict == false, this.geniUserProvider, this.sliceSliver.urn.toString());
    }

    @ApiTest.Test(hardDepends={"testCreatedSliverBecomesReady"}, softDepends={"testNodeLogin"}, groups={"nonodelogin"})
    public void testRenewSliver() throws JFedException {
        assert (this.sliceSliver != null) : "sliceSliver is null";
        Date expirationTime = new Date(System.currentTimeMillis() + 300000L);
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.renewSliver(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.sliceSliver.urn.getValue(), expirationTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "RenewSliver reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
        this.assertTrue((Boolean)reply.getValue(), "RenewSliver reply's value (which means success) is not true when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
    }

    @ApiTest.Test(softDepends={"testNodeLogin", "testRenewSliver", "testCreatedSliverBecomesReady", "checkManifestOnceSliverIsReady"}, groups={"createsliver", "nodelogin", "nonodelogin"})
    public void testDeleteSliver() throws JFedException {
        if (this.disableCleanup.booleanValue()) {
            this.skip("No cleanup needed.");
        }
        if (this.sliceSliver == null) {
            this.skip("Skipped because other test created nothing to delete");
        }
        assert (this.sliceSliver != null) : "sliceSliver is null";
        System.out.println("DeleteSliver for slice " + this.sliceSliver.urn.getValue());
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am2.deleteSliver(this.getAM2Connection(), this.commonAMTest.getSliceCredentialListForAM(this.sliceSliver), this.sliceSliver.urn.getValue(), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM2CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "DeleteSliver reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
        this.assertTrue((Boolean)reply.getValue(), "DeleteSliver reply's value (which means success) is not true when given a slice \"" + this.sliceSliver.urn.getValue() + "\" that has a sliver.");
    }
}

