/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestAggregateManager3
extends BaseApiTest<LegacyApiTestConfig> {
    NodeLoginTestStep nodeLoginTestStep;
    private CommonAMTest commonAMTest;
    private AggregateManager3 am3;
    private boolean beLessStrict = false;
    private Boolean createSliceIfNotExists = true;
    private Boolean reuseSliceIfExists = false;
    private Boolean disableGetVersionComplianceTests = false;
    private Boolean disableCleanup = false;
    private Boolean geniEndTimeOptionForAllocate = true;
    private Boolean geniEndTimeOptionForProvision = true;
    private Map versionRawResult = null;
    private AggregateManager3.VersionInfo versionInfo = null;
    private CommonAMTest.SliceInfo slice0;
    private CommonAMTest.SliceInfo sliceS;
    private String sliverSUrnStr;
    private ResourceUrn sliverSUrn;
    private boolean foundNodeLoginInProvison = false;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Many Aggregate Manager (Geni AM API v3) Tests. 2 slices and a sliver will be created during the tests. The sliver will be deleted. This will not test ListResources.";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("fixed_ssh_public_key_file");
            res.add("fixed_ssh_private_key_file");
            res.add("fixed_ssh_private_key_password");
            CommonAMTest.addCredentialOptions(res);
            res.add("be_less_strict");
            res.add("skip_final_manifest_check");
            res.add("geni_end_time_option_for_allocate_call");
            res.add("geni_end_time_option_for_provision_call");
            res.add("nodelogin_deadline_ms");
            res.add("create_slice_if_not_exists");
            res.add("reuse_slice_if_exists");
            res.add("disable_compliance_tests");
            res.add("disable_slice_cleanup");
            res.add("fixed_slice_name");
            res.add("fixed_project_name");
            res.add("try_to_use_project_for_slices");
            CommonAMTest.addOptionsForFixedRspec(res);
            CommonAMTest.addOptionsForNodeLoginSshProxy(res);
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            CommonAMTest.addOptionsForRspecTypeVersion(res);
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }
    };
    AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.VersionInfo> getVersionReply;
    private String requestRspec;
    private Boolean notEnoughResourcesDetected = null;

    @Inject
    public TestAggregateManager3(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    private static List<String> toStringList(String s) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s);
        return res;
    }

    private static List<String> toStringList(String s1, String s2) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s1);
        res.add(s2);
        return res;
    }

    private static List<String> toStringList(String s1, String s2, String s3) {
        ArrayList<String> res = new ArrayList<String>();
        res.add(s1);
        res.add(s2);
        res.add(s3);
        return res;
    }

    public SfaConnection getAM3Connection() throws JFedException {
        return (SfaConnection)this.connectionProvider.getConnectionByAuthority(this.user, this.testedAuthority.getServerToConnect(), new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, 3));
    }

    public void testAM3CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM3CorrectnessXmlRpcResult code == null in " + res);
        this.assertNotNull(value, "testAM3CorrectnessXmlRpcResult value == null in " + res);
        this.assertInstanceOf(code, Map.class, "testAM3CorrectnessXmlRpcResult code is not Map in " + res);
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM3CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + res);
        this.assertEquals(genicode.getClass(), Integer.class, "testAM3CorrectnessXmlRpcResult code.geni_code is not int in " + res);
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + res);
            this.assertEquals(output.getClass(), String.class, "testAM3CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else {
            if (output == null) {
                this.note("testAM3CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
            }
            if (output != null && !(output instanceof String)) {
                this.warn("testAM3CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
            }
        }
    }

    @Override
    public void setUp() {
        Object v;
        this.assertNotNull(this.user);
        this.assertNotNull(this.user.getUserAuthorityServerId());
        this.commonAMTest = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        this.am3 = new AggregateManager3(this.logger, this.getJFedPreferences());
        this.createSliceIfNotExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("create_slice_if_not_exists"));
        this.reuseSliceIfExists = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("reuse_slice_if_exists"));
        this.disableGetVersionComplianceTests = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_getversion_compliance_tests"));
        this.disableCleanup = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("disable_slice_cleanup"));
        if (this.createSliceIfNotExists == null) {
            this.createSliceIfNotExists = true;
        }
        if (this.reuseSliceIfExists == null) {
            this.reuseSliceIfExists = false;
        }
        if (this.disableGetVersionComplianceTests == null) {
            this.disableGetVersionComplianceTests = false;
        }
        if (this.disableCleanup == null) {
            this.disableCleanup = false;
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("be_less_strict") != null) {
            v = ((LegacyApiTestConfig)this.getTestConfig()).get("be_less_strict");
            this.note("be_less_strict option specified: " + v);
            this.beLessStrict = TextUtil.objectToBoolean((Object)("" + v));
            if (this.beLessStrict) {
                this.note(" be_less_strict activated: turning some failures into warnings");
            } else {
                this.note(" be_less_strict is NOT activated");
            }
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("geni_end_time_option_for_allocate_call") != null) {
            v = ((LegacyApiTestConfig)this.getTestConfig()).get("geni_end_time_option_for_allocate_call");
            this.geniEndTimeOptionForAllocate = TextUtil.objectToBoolean((Object)("" + v));
        }
        if (((LegacyApiTestConfig)this.getTestConfig()).get("geni_end_time_option_for_provision_call") != null) {
            v = ((LegacyApiTestConfig)this.getTestConfig()).get("geni_end_time_option_for_provision_call");
            this.geniEndTimeOptionForProvision = TextUtil.objectToBoolean((Object)("" + v));
        }
        this.commonAMTest.processCredentialOptions(this.testbedInfoSource, this.authorityFinder);
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
    }

    @ApiTest.Test(groups={"getversion", "nonodelogin"})
    public void testGetVersionXmlRpcCorrectness() throws JFedException {
        this.getVersionReply = this.am3.getVersion(this.getAM3Connection());
        this.testAM3CorrectnessXmlRpcResult(this.getVersionReply.getRawResult());
        this.versionRawResult = this.getVersionReply.getRawResult();
        this.assertNotNull(this.versionRawResult);
        if (!this.disableGetVersionComplianceTests.booleanValue()) {
            Object ver = this.versionRawResult.get("geni_api");
            this.assertNotNull(ver);
            this.assertTrue(ver instanceof Integer);
            int v = (Integer)ver;
            this.assertEquals(v, 3, "AM (backward compatibility \"geni_api\" field) is not version 3");
        }
        this.assertEquals(this.getVersionReply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "GeniResponse code is not SUCCESS (0)");
        this.versionInfo = (AggregateManager3.VersionInfo)this.getVersionReply.getValue();
        this.assertNotNull(this.versionInfo);
        this.assertEquals(this.versionInfo.getApi(), 3, "AM is not version 3");
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, groups={"getversion", "nonodelogin"})
    public void testGetVersionResultCorrectness() throws JFedException {
        String[] credentialTypeListnames;
        String[] rspecVersionListnames;
        this.note("This test does not call GetVersion again, it uses the result received by \"testGetVersionXmlRpcCorrectness\"");
        Map value = (Map)this.versionRawResult.get("value");
        this.assertEquals(value.get("geni_api"), 3, "AM \"geni_api\" field in GetVersion reply is not version the Integer 3");
        if (this.disableGetVersionComplianceTests.booleanValue()) {
            this.skip("Compliance testing is disabled. Will skip this test.");
        }
        this.assertNotNull(value.get("geni_api_versions"), "geni_api_versions not in version result");
        this.assertTrue(value.get("geni_api_versions") instanceof Map, "geni_api_versions is not a Map but a " + value.get("geni_api_versions").getClass().getName());
        for (String name : rspecVersionListnames = new String[]{"geni_request_rspec_versions", "geni_ad_rspec_versions"}) {
            this.assertNotNull(value.get(name), name + " not in GetVersion result");
            Object[] v = this.assertInstanceOf(value.get(name), Object[].class, name + " is not a List but a " + value.get(name).getClass().getName());
            this.assertTrue(v.length > 0, name + " array is empty");
            for (Object o : v) {
                Object[] extensions;
                this.assertTrue(o instanceof Map, name + " array should contain only Map not a " + o.getClass().getName());
                Map t = (Map)o;
                this.assertMapContainsNonemptyString(t, "type");
                this.assertMapContainsNonemptyString(t, "version");
                this.assertMapContainsString(t, "schema");
                this.assertMapContainsString(t, "namespace");
                Object extensionsO = t.get("extensions");
                this.assertNotNull(extensionsO);
                for (Object e : extensions = this.assertInstanceOf(extensionsO, Object[].class, "value for extensions of " + name + " is not a String but a " + extensionsO.getClass().getName())) {
                    this.assertTrue(e instanceof String, "an extension of \"+name+\" is not a string but a " + e.getClass().getName());
                }
            }
        }
        for (String name : credentialTypeListnames = new String[]{"geni_credential_types"}) {
            this.assertNotNull(value.get(name), name + " not in GetVersion result");
            Object[] v = this.assertInstanceOf(value.get(name), Object[].class, name + " is not a List but a " + value.get(name).getClass().getName());
            this.assertTrue(v.length > 0, name + " array is empty");
            for (Object o : v) {
                this.assertTrue(o instanceof Map, name + " array should contain only Map not a " + o.getClass().getName());
                Map t = (Map)o;
                String typ = this.assertMapContainsNonemptyString(t, "geni_type");
                Object[] objectArray = this.assertMapContainsNonemptyString(t, "geni_version");
            }
        }
        Object urn = value.get("urn");
        if (urn != null) {
            this.setErrorsNotFatal();
            this.assertInstanceOf(urn, String.class, "if URN is defined, it should be a String, not a " + urn.getClass().getName());
            if (urn instanceof String) {
                String urnString = (String)urn;
                String testUrnString = this.testedAuthority.getServerToConnect().getDefaultComponentManagerUrn();
                if (!Objects.equals(urnString, testUrnString)) {
                    this.warn("URN in GetVersion (" + urnString + ") does not match the URN used to start this test (" + testUrnString + "). This could either be a problem on the server, a bad URN in GetVersion, or it could be that the jFed has wrong info about this authority. This failure could result in a failure to allocate resources (as the component_manager urn used will not match this server).");
                }
                this.setErrorsFatal();
                this.assertValidUrn(urnString, null, "GetVersion specified \"urn\" as \"" + urnString + "\", but that does not parse as a valid URN.");
            }
            this.setErrorsFatal();
        } else {
            this.note("GetVersion does not specify \"urn\" (which contains the component manager urn). This is not mandatory, but it is useful to include.");
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultCorrectness"}, groups={"getversion", "nonodelogin"})
    public void testGetVersionResultApiVersionsCorrectness() throws JFedException, MalformedURLException {
        if (this.disableGetVersionComplianceTests.booleanValue()) {
            this.skip("Compliance testing is disabled. Will skip this test.");
        }
        this.note("This test does not call GetVersion again, it uses the result received by \"testGetVersionXmlRpcCorrectness\"");
        Map value = (Map)this.versionRawResult.get("value");
        Map versions = (Map)value.get("geni_api_versions");
        Object o = versions.get("3");
        if (o == null && (o = versions.get(3)) != null) {
            this.warn("geni_api_versions for key=\"3\" (Integer value in String) is null. (Note that for key=3 (Integer) it is \"" + o + "). This test will accept Integer instead of String, but the API specifies it should be a String.");
        }
        this.assertNotNull(o, "geni_api_versions for key=3 is null (tried with both int 3 and string \"3\").");
        this.assertTrue(o instanceof String, "value for key=\"3\" is not a String but a " + o.getClass().getName());
        boolean serverUrlWithLocalhost = false;
        try {
            URL serverUrl = new URL(this.getVersionReply.getXMLRPCCallDetails().getServerUrl());
            serverUrlWithLocalhost = serverUrl.getHost().equals("localhost") || serverUrl.getHost().equals("127.0.0.1");
        }
        catch (Exception e) {
            this.note("Unexpected exception in test. Test will ignore this, but this might be an automated tester bug", e);
        }
        if (!serverUrlWithLocalhost) {
            for (Object key : versions.keySet()) {
                this.assertTrue(key instanceof Integer || key instanceof String, "geni_api_versions keys should be Integer (or String), not " + key.getClass().getName());
                if (key instanceof Integer) {
                    this.warn("geni_api_versions contains a key of type Integer with value " + key + ". This test will accept keys of type Integer instead of String, but the API specifies it should be String.");
                    versionNr = (Integer)key;
                } else {
                    versionNr = Integer.parseInt((String)key);
                }
                Object val = versions.get(key);
                this.assertTrue(val instanceof String, "geni_api_versions values should be String, not " + val.getClass().getName());
                String urlS = (String)val;
                URL url = new URL(urlS);
                String host = url.getHost();
                if (!this.beLessStrict) {
                    this.assertFalse(Objects.equals(host, "localhost"), "Illegal host in URL: " + url + " (host in URL should not be the non-global \"" + host + "\")");
                    this.assertFalse(Objects.equals(host, "127.0.0.1"), "Illegal host in URL: " + url + " (host in URL should not be the non-global \"" + host + "\")");
                    continue;
                }
                if (!host.equals("localhost") && !host.equals("127.0.0.1")) continue;
                this.warn("Illegal host in URL: " + url + " (host in URL should not be the non-global \"" + host + "\")");
            }
        } else {
            this.note("The URL of the server has localhost. This test will assume that this is a test server, and will therefor NOT warn or fail if the URL's in GetVersion have localhost in them.");
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultApiVersionsCorrectness", "testGetVersionResultCorrectness"}, groups={"getversion", "nonodelogin"})
    public void testGetVersionResultNoDuplicates() throws JFedException {
        if (this.disableGetVersionComplianceTests.booleanValue()) {
            this.skip("Compliance testing is disabled. Will skip this test.");
        }
        this.note("This test does not call GetVersion again, it uses the result received by \"testGetVersionXmlRpcCorrectness\"");
        ArrayList<Object> adRspecVersions = new ArrayList<Object>();
        for (Object rspecVer : this.versionInfo.getAdRspecVersions()) {
            for (Object other : adRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion((AggregateManager3.VersionInfo.RspecVersion)rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Advertisement RSpec:type=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            adRspecVersions.add(rspecVer);
        }
        ArrayList<AggregateManager3.VersionInfo.RspecVersion> reqRspecVersions = new ArrayList<AggregateManager3.VersionInfo.RspecVersion>();
        for (AggregateManager3.VersionInfo.RspecVersion rspecVer : this.versionInfo.getRequestRspecVersions()) {
            for (AggregateManager3.VersionInfo.RspecVersion other : reqRspecVersions) {
                this.assertFalse(other.equalTypeAndVersion(rspecVer), "VersionInfo Result invalid: Duplicate Rspec type/version pair in supported Request RSpectype=" + other.getType() + " version=" + other.getVersion() + " VS type=" + rspecVer.getType() + " version=" + rspecVer.getVersion() + " ");
            }
            reqRspecVersions.add(rspecVer);
        }
        ArrayList<AggregateManager3.VersionInfo.CredentialType> credentialTypes = new ArrayList<AggregateManager3.VersionInfo.CredentialType>();
        for (AggregateManager3.VersionInfo.CredentialType credentialType : this.versionInfo.getCredentialTypes()) {
            for (AggregateManager3.VersionInfo.CredentialType other : credentialTypes) {
                this.assertFalse(Objects.equals(other, credentialType), "VersionInfo Result invalid: Duplicate CredentialType type/version pair in supported Request RSpectype=" + other.getType() + " version=" + other.getVersion() + " VS type=" + credentialType.getType() + " version=" + credentialType.getVersion() + " ");
            }
            credentialTypes.add(credentialType);
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates", "testGetVersionResultApiVersionsCorrectness"}, groups={"nonodelogin"}, description="This test calls ListResources without any credentials. That should fail.")
    public void testListResourcesBadCredential() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.listResources(this.getAM3Connection(), new ArrayList(), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), Boolean.valueOf(true), null);
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertFalse(reply.getGeniResponseCode().isSuccess(), "The ListResources call should fail when given no credentials. Instead, it returned success!");
        if (reply.getGeniResponseCode().equals((Object)GeniAMResponseCode.GENIRESPONSE_FORBIDDEN) || reply.getGeniResponseCode().equals((Object)GeniAMResponseCode.GENIRESPONSE_ERROR)) {
            this.warn("The ListResources call should fail with error code 1 \"Bad Arguments: malformed arguments\" when given no credentials. Instead, it returned " + reply.getGeniResponseCode() + "  " + reply.getGeniResponseCode().getDescription());
        } else {
            this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_BADARGS, "The ListResources call should fail with error code 1 \"Bad Arguments: malformed arguments\" when given no credentials. Instead, it returned " + reply.getGeniResponseCode() + "  " + reply.getGeniResponseCode().getDescription());
        }
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates", "testGetVersionResultApiVersionsCorrectness"}, groups={"nonodelogin"})
    public void testListAvailableResources() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.listResources(this.getAM3Connection(), this.commonAMTest.getUserCredentialListForAM(), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), Boolean.valueOf(true), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertTrue(reply.getGeniResponseCode().isSuccess(), "The ListResources call did not return success but " + reply.getGeniResponseCode());
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates", "testGetVersionResultApiVersionsCorrectness"}, groups={"nonodelogin"}, description="This test calls Status with user credentials, and the urn of a non exisiting slice. That should fail.")
    public void testStatusBadSlice() throws JFedException {
        String badSliceUrn = "urn:publicid:IDN+" + this.commonAMTest.getUserAuthorityServer().getUrnTld() + "+slice+NonExisting";
        ArrayList<CallSite> urns = new ArrayList<CallSite>();
        urns.add((CallSite)((Object)badSliceUrn));
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.status(this.getAM3Connection(), urns, this.commonAMTest.getUserCredentialListForAM(), Boolean.valueOf(false), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertFalse(reply.getGeniResponseCode().isSuccess(), "SliverStatus reply GeniResponse code is SUCCESS (0) when given a non existing slice \"" + badSliceUrn + "\"");
    }

    @ApiTest.Test(hardDepends={"testGetVersionXmlRpcCorrectness"}, softDepends={"testGetVersionResultNoDuplicates", "testGetVersionResultApiVersionsCorrectness", "testStatusBadSlice", "testStatusBadSlice", "testListResourcesBadCredential", "testListAvailableResources"}, description="Create the slices used in the next tests", groups={"nonodelogin"})
    public void createTestSlices() throws JFedException, IOException {
        String fixedProjectName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_project_name");
        boolean tryToUseProject = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("try_to_use_project_for_slices")) != Boolean.FALSE;
        this.slice0 = this.commonAMTest.createSlice("n", fixedProjectName, tryToUseProject, true);
        String fixedSliceName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("fixed_slice_name");
        if (this.reuseSliceIfExists.booleanValue() && fixedSliceName != null) {
            this.sliceS = this.commonAMTest.reuseSlice(fixedSliceName);
            if (this.sliceS != null) {
                return;
            }
            if (!this.createSliceIfNotExists.booleanValue()) {
                throw new RuntimeException("create_slice_if_not_exists is false, and slice does not exist.");
            }
        }
        this.sliceS = fixedSliceName == null ? this.commonAMTest.createSlice("s", fixedProjectName, tryToUseProject, true) : this.commonAMTest.createSlice(fixedSliceName, false, fixedProjectName, tryToUseProject, true);
        this.assertNotNull(this.slice0.urnString, "slice0.urnString may not be null");
        this.assertTrue(this.slice0.urnString.startsWith("urn:publicid:IDN+"));
        this.assertNotNull(this.slice0.credentials != null, "slice0.credential may not be null");
        this.assertNotEmpty(this.slice0.credentials, "slice0.credential may not be empty");
        this.assertValidUrn(this.slice0.urnString, "slice");
        this.assertNotNull(this.sliceS.urnString, "sliceS.urnString may not be null");
        this.assertTrue(this.sliceS.urnString.startsWith("urn:publicid:IDN+"));
        this.assertNotNull(this.sliceS.credentials, "sliceS.credential may not be null");
        this.assertNotEmpty(this.sliceS.credentials, "sliceS.credential may not be empty");
        this.assertValidUrn(this.sliceS.urnString, "slice");
    }

    @ApiTest.Test(hardDepends={"createTestSlices"}, groups={"nonodelogin"}, description="Call Status on a slice without slivers. It is expected an error such as 12 \"Search Failed (eg for slice)\" is returned.")
    public void testStatusNoSliverSlice() throws JFedException {
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.slice0.urnString), this.commonAMTest.getSliceCredentialListForAM(this.slice0), Boolean.valueOf(false), this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        String spec = "Attempting to get Status() for a slice (no slivers identified) with no current slivers at this aggregate\n may return an empty list for geni_slivers, may return a list of previous slivers that have since been\n deleted, or may even return an error (e.g. SEARCHFAILED or EXPIRED).\n Note therefore that geni_slivers may be an empty list.";
        this.note("AMV3 spec says: \"" + spec + "\"");
        boolean isSuccess = reply.getGeniResponseCode().isSuccess();
        boolean emptySliverList = isSuccess && ((AggregateManager3.StatusInfo)reply.getValue()).getSliverInfo().isEmpty();
        boolean isSearchFailed = Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED);
        boolean isExpired = Objects.equals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_EXPIRED);
        if (isSuccess) {
            this.assertTrue(emptySliverList, "The reply to the Status call has response code SUCCESS (0) when given a slice \"" + this.slice0.urnString + "\" that has no sliver. However, the sliver list is not empty, as would be expected (because there are no previous slivers in this slice)");
        } else if (!isSearchFailed && !isExpired) {
            this.warn("The reply to the Status call has response code " + reply.getGeniResponseCode() + " when given a slice \"" + this.slice0.urnString + "\" that has no sliver. This is acceptable behaviour. However, there are more fitting errors to return, such as code 12 \"Search Failed (eg for slice)\" or code 15 \"Expired\"");
        }
    }

    public void verifyDescribeReplyNoSliver(String urn, AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo> reply) {
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        String specsText = "If a slice urn is supplied and there are no slivers in the given slice at this aggregate, then geni_rspec shall be a valid manifest RSpec, containing zero (0) node or link elements - that is, specifying no resources. geni_slivers may be an empty array, or may be an array of previous slivers that have since been deleted or expired. Calling Describe on one or more sliver URNs that are unknown, deleted or expired shall result in an error (e.g. SEARCHFAILED, EXPIRED or ERROR geni_code). ";
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Describe reply GeniResponse code is not SUCCESS (0) when given a slice \"" + urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        AggregateManager3.ManifestInfo manifestInfo = (AggregateManager3.ManifestInfo)reply.getValue();
        this.assertNotNull(manifestInfo, "Describe reply is completely empty when given a slice \"" + urn + "\" that has no sliver (available=unspecified). (according to the specs:\"" + specsText + "\")");
        String rspec = manifestInfo.getManifestRspec();
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will skip some checks because of this.");
            return;
        }
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, rspec), 0, "Describe reply when given a slice \"" + urn + "\" that has no sliver (available=unspecified) is not an valid RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
        this.assertTrue(CommonAMTest.isEmptyRspec(this, rspec), "Describe reply when given a slice \"" + urn + "\" that has no sliver (available=unspecified) is not an empty RSpec (according to the specs:\"" + specsText + "\"): " + rspec);
    }

    @ApiTest.Test(hardDepends={"createTestSlices"}, groups={"nonodelogin"})
    public void testDescribeNoSliverSlice() throws JFedException {
        this.assertNotNull(this.slice0);
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.describe(this.getAM3Connection(), TestAggregateManager3.toStringList(this.slice0.urnString), this.commonAMTest.getSliceCredentialListForAM(this.slice0), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), this.commonAMTest.addCredentialExtraOptions(null));
        this.verifyDescribeReplyNoSliver(this.slice0.urnString, (AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo>)reply);
        reply = this.am3.describe(this.getAM3Connection(), TestAggregateManager3.toStringList(this.slice0.urnString), this.commonAMTest.getSliceCredentialListForAM(this.slice0), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(false), this.commonAMTest.addCredentialExtraOptions(null));
        this.verifyDescribeReplyNoSliver(this.slice0.urnString, (AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo>)reply);
    }

    @ApiTest.Test(hardDepends={"createTestSlices"}, groups={"nonodelogin"}, softDepends={"testStatusNoSliverSlice", "testDescribeNoSliverSlice"})
    public void testAllocate() throws JFedException, NoSuchAlgorithmException, ParseException, IOException {
        this.assertNotNull(this.sliceS);
        String rspecArg = this.commonAMTest.getFixedRspecOption();
        if (rspecArg == null) {
            this.requestRspec = this.commonAMTest.getOneNodeRequestRSpec(this.testedAuthority.getServerForRspecComponentManager(), this.sliceS.urn);
            if (this.requestRspec == null) {
                this.skip("testCreateSliver skipped, because no RSpec example known for type=\"" + this.testedAuthority.getServerForRspecComponentManager().getServerType() + "\"");
            }
        } else {
            this.requestRspec = rspecArg;
            if (!this.commonAMTest.isGeniFixedRspec()) {
                this.fatalError("The specified request RSpec is not a geni v3 RSpec. This test does not yet support that case.");
            }
        }
        String endTime = null;
        if (this.geniEndTimeOptionForAllocate.booleanValue()) {
            Date expireDate = new Date(System.currentTimeMillis() + 1200000L);
            endTime = RFC3339Util.dateToRFC3339String((Date)expireDate);
        }
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.allocate(this.getAM3Connection(), this.sliceS.urnString, this.commonAMTest.getSliceCredentialListForAM(this.sliceS), this.requestRspec, endTime, this.commonAMTest.addCredentialExtraOptions(null));
        this.notEnoughResourcesDetected = AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Will skip further tests. Full message: " + reply.getOutput());
            return;
        }
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Allocate did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfo = (AggregateManager3.AllocateAndProvisionInfo)reply.getValue();
        String replyRequestRspec = allocateAndProvisionInfo.getRspec();
        this.assertNotNull(replyRequestRspec, "Allocate should return a request RSpec" + replyRequestRspec);
        List sliverInfos = allocateAndProvisionInfo.getSliverInfo();
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver allocated");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        this.sliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        this.sliverSUrn = new ResourceUrn(this.sliverSUrnStr);
        this.assertEquals(sliverInfo.getAllocationStatus(), "geni_allocated", "Allocated sliver should be in geni_allocated state");
        try {
            Date expireDate = sliverInfo.getExpiresDate();
            Date now = new Date();
            if (!now.before(expireDate)) {
                this.warn("newly allocated sliver does not expire in the future! now=" + now + " expireDate=\"" + expireDate + "\"");
            }
        }
        catch (ParseException e) {
            this.warn("geni_expire data is NOT a valid RFC3339 date: \"" + sliverInfo.getExpires() + "\"");
        }
        System.out.println("Allocated sliver for \"" + this.sliceS.urnString + "\" replyRequestRspec=" + replyRequestRspec);
    }

    @ApiTest.Test(hardDepends={"testAllocate"}, groups={"nonodelogin"})
    public void testProvision() throws JFedException, NoSuchAlgorithmException, ParseException {
        AbstractGeniAggregateManager.AggregateManagerReply reply;
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Skipping...");
            return;
        }
        this.assertNotNull(this.geniUserProvider);
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        List<String> urns = TestAggregateManager3.toStringList(this.sliverSUrnStr);
        if (this.versionInfo.isSingleSliceAllocation()) {
            urns = TestAggregateManager3.toStringList(this.sliceS.urnString);
        }
        NodeLoginTestStepConfig nodeLoginTestStepConfig = NodeLoginTestStepConfig.generateFromLegacyConfig(this, (LegacyApiTestConfig)this.getTestConfig(), this.geniUserProvider);
        this.nodeLoginTestStep = new NodeLoginTestStep(this, nodeLoginTestStepConfig);
        ArrayList<String> sshKeys = new ArrayList<String>();
        sshKeys.add(this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKeyString());
        UserSpec userSpec = new UserSpec(this.user.getUserUrnString(), sshKeys);
        ArrayList<UserSpec> users = new ArrayList<UserSpec>();
        users.add(userSpec);
        String endTime = null;
        if (this.geniEndTimeOptionForProvision.booleanValue()) {
            Date expireDate = new Date(System.currentTimeMillis() + 3600000L);
            endTime = RFC3339Util.dateToRFC3339String((Date)expireDate);
        }
        if (Objects.equals((reply = this.am3.provision(this.getAM3Connection(), urns, this.commonAMTest.getSliceCredentialListForAM(this.sliceS), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), null, endTime, users, this.commonAMTest.addCredentialExtraOptions(null))).getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_REFUSED) && Objects.equals(reply.getOutput(), "Must delete existing slice first")) {
            this.warn("Received \"Must delete existing slice first\". Probably, the call succeeded but timed out in a previous attempt. This occurs when the server is very busy. We will continue as if the call succeeded.");
            return;
        }
        this.notEnoughResourcesDetected = AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Will skip further tests. Full message: " + reply.getOutput());
            return;
        }
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Provision did not succeed");
        AggregateManager3.AllocateAndProvisionInfo allocateAndProvisionInfo = (AggregateManager3.AllocateAndProvisionInfo)reply.getValue();
        String manifestRspec = allocateAndProvisionInfo.getRspec();
        this.assertNotNull(manifestRspec, "Provision should return a manifest RSpec");
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will skip some checks because of this.");
        } else {
            this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, manifestRspec), 1, "Provision did not return a valid RSpec" + manifestRspec);
            this.assertFalse(CommonAMTest.isEmptyRspec(this, manifestRspec), "Provision returned and empty RSpec: " + manifestRspec);
            this.setErrorsNotFatal();
            this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, manifestRspec));
            this.setErrorsFatal();
            assert (!this.nodeLoginTestStep.hasParsed());
            this.foundNodeLoginInProvison = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(manifestRspec, null, null);
            if (this.foundNodeLoginInProvison) {
                this.note("Successfully found node login info in Provision reply");
            } else {
                this.note("Did not find node login info in Provision reply");
            }
        }
        List sliverInfos = allocateAndProvisionInfo.getSliverInfo();
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver provisioned");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        String resSliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(resSliverSUrnStr);
        this.assertValidUrn(resSliverSUrnStr, "sliver");
        this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Provisioned result has different URN than request");
        this.assertEquals(sliverInfo.getAllocationStatus(), "geni_provisioned", "according to specification, sliver should immediately be in geni_provisioned state after the Provision call");
        try {
            Date expireDate = sliverInfo.getExpiresDate();
            Date now = new Date();
            this.assertTrue(now.before(expireDate), "provisioned sliver does not expire in the future! now=" + now + " expireDate=" + expireDate);
        }
        catch (ParseException e) {
            this.warn("geni_expire data is NOT a valid RFC3339 date: \"" + sliverInfo.getExpires() + "\"");
        }
        System.out.println("Provisioned sliver for \"" + this.sliceS.urnString + "\" manifestRspec=" + manifestRspec);
    }

    @ApiTest.Test(hardDepends={"testProvision"}, groups={"nonodelogin"})
    public void testSliverBecomesProvisioned() throws JFedException, ParseException {
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Skipping...");
            return;
        }
        this.assertNotNull(this.sliceS);
        long now = System.currentTimeMillis();
        long deadline = now + 1200000L;
        while (now < deadline) {
            AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
            this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo>)reply);
            AggregateManager3.StatusInfo statusInfo = (AggregateManager3.StatusInfo)reply.getValue();
            List sliverInfos = statusInfo.getSliverInfo();
            AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
            this.assertNotEquals(sliverInfo.getAllocationStatus(), "geni_unallocated", "sliver became geni_unallocated while waiting for it to be provisioned.");
            this.assertNotEquals(sliverInfo.getAllocationStatus(), "geni_allocated", "sliver became geni_allocated while waiting for it to be provisioned.");
            this.assertEquals(sliverInfo.getAllocationStatus(), "geni_provisioned", "sliver is not in geni_provisioned while waiting for it to be provisioned.");
            this.assertNotEquals(sliverInfo.getOperationalStatus(), "geni_failed", "sliver operational state became \"geni_failed\" while waiting for it to be provisioned. We assume this is a failure.");
            String resSliverSUrnStr = sliverInfo.getSliverUrn();
            this.assertNotNull(resSliverSUrnStr);
            this.assertValidUrn(resSliverSUrnStr, "sliver");
            this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Status sliver URN has different URN than in Allocate and Provision");
            if (!Objects.equals(sliverInfo.getOperationalStatus(), "geni_pending_allocation")) {
                System.out.println("testSliverBecomesReady -> sliver is now fully provisioned: operational_state=" + sliverInfo.getOperationalStatus());
                return;
            }
            System.out.println("testCreatedSliverBecomesReady -> sliver not fully provisioned: operational_state=" + sliverInfo.getOperationalStatus() + ".  Trying again in 30 seconds...");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        throw new RuntimeException("Sliver did not become ready within 20 minutes!");
    }

    @ApiTest.Test(hardDepends={"testSliverBecomesProvisioned"}, groups={"nonodelogin"})
    public void testPerformOperationalAction() throws JFedException, NoSuchAlgorithmException, ParseException {
        AbstractGeniAggregateManager.AggregateManagerReply reply;
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Skipping...");
            return;
        }
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        List<String> urns = TestAggregateManager3.toStringList(this.sliverSUrnStr);
        if (this.versionInfo.isSingleSliceAllocation()) {
            urns = TestAggregateManager3.toStringList(this.sliceS.urnString);
        }
        String action = "geni_start";
        try {
            reply = this.am3.performOperationalAction(this.getAM3Connection(), urns, this.commonAMTest.getSliceCredentialListForAM(this.sliceS), action, null, this.commonAMTest.addCredentialExtraOptions(null));
        }
        catch (JFedException e) {
            if (this.beLessStrict) {
                this.warn("Exception while executing performOperationalAction. Due to be_less_strict, this will be ignored. Message: " + e.getMessage());
                return;
            }
            throw e;
        }
        this.notEnoughResourcesDetected = AbstractGeniAggregateManager.isCommonError((AbstractGeniAggregateManager.AggregateManagerReply)reply, (AbstractGeniAggregateManager.CommonAMError)AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("There were not enough free resources for this test. Will skip further tests. Full message: " + reply.getOutput());
            return;
        }
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "PerformOperationalAction did not succeed");
        if (!(reply.getRawResult().get("value") instanceof Object[])) {
            if (this.beLessStrict) {
                this.note("ERROR: Invalid reply to PerformOperationalAction. The \"value\" of a successful call should be a List (API specifies: \"list of struct\"), but it was: " + reply.getRawResult().get("value").getClass() + ". \nNote: This ERROR has been converted to just a note because of the be_less_strict option");
            } else {
                this.warn("ERROR: Invalid reply to PerformOperationalAction. The \"value\" of a successful call should be a List (API specifies: \"list of struct\"), but it was: " + reply.getRawResult().get("value").getClass() + ". \nNote: This ERROR has been converted to a warning so that dependent tests can run.");
            }
            return;
        }
        if (reply.getValue() == null) {
            if (this.beLessStrict) {
                this.note("ERROR: Invalid reply to PerformOperationalAction.\nNote: This ERROR has been converted to a warning so that dependent tests can run.");
            } else {
                this.warn("ERROR: Invalid reply to PerformOperationalAction.\nNote: This ERROR has been converted to a warning so that dependent tests can run.");
            }
            return;
        }
        List sliverInfos = (List)reply.getValue();
        this.assertNotNull(sliverInfos, "jFed failed to process the PerformOperationalAction reply correctly. (this is either an invalid reply to PerformOperationalAction or a jFed bug)");
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver returned for PerformOperationalAction");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        String resSliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(resSliverSUrnStr);
        this.assertValidUrn(resSliverSUrnStr, "sliver");
        this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "PerformOperationalAction result has different URN than request");
        this.sliverSUrn = new ResourceUrn(this.sliverSUrnStr);
        try {
            Date expireDate = sliverInfo.getExpiresDate();
            Date now = new Date();
            this.assertTrue(now.before(expireDate), "started sliver does not expire in the future! now=" + now + " expireDate=" + expireDate);
        }
        catch (ParseException e) {
            this.warn("geni_expire data is NOT a valid RFC3339 date: \"" + sliverInfo.getExpires() + "\"");
        }
        System.out.println("PerformOperationalAction for \"" + this.sliceS.urnString + "\" action=" + action);
    }

    public void validSuccesStatus(AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo> reply) throws ParseException {
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "SliverStatus reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceS.urnString + "\" that has a sliver.");
        this.assertInstanceOf(reply.getRawResult().get("value"), Map.class, "SliverStatus value should be a Map. Not: " + reply.getRawResult().get("value"));
        AggregateManager3.StatusInfo statusInfo = (AggregateManager3.StatusInfo)reply.getValue();
        this.assertNotNull(statusInfo);
        String resSliceUrn = statusInfo.getSliceUrn();
        this.assertNotNull(resSliceUrn);
        this.assertValidUrn(resSliceUrn, "slice");
        this.assertEquals(resSliceUrn, this.sliceS.urnString, "Status slice urn is not correct slice");
        List sliverInfos = statusInfo.getSliverInfo();
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver status");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        String resSliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(resSliverSUrnStr);
        this.assertValidUrn(resSliverSUrnStr, "sliver");
        this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Provisioned result has different URN than request");
        this.sliverSUrn = new ResourceUrn(this.sliverSUrnStr);
        this.assertNotNull(sliverInfo.getAllocationStatus());
        this.assertNotNull(sliverInfo.getOperationalStatus());
        try {
            Date expireDate = sliverInfo.getExpiresDate();
            Date now = new Date();
            this.assertTrue(now.before(expireDate), "sliver does not expire in the future! now=" + now + " expireDate=" + expireDate);
        }
        catch (ParseException e) {
            this.warn("geni_expire data is NOT a valid RFC3339 date: \"" + sliverInfo.getExpires() + "\"");
        }
        this.assertNotNull(sliverInfo.getExpires());
    }

    @ApiTest.Test(hardDepends={"testPerformOperationalAction"}, groups={"postProvisionTests", "nonodelogin"})
    public void testStatusExistingSliver() throws JFedException, ParseException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo>)reply);
    }

    public void checkDescribeExistingSliver(AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo> reply, String sliceUrn, String sliverUrn) {
        this.testAM3CorrectnessXmlRpcResult(reply.getRawResult());
        this.assertEquals(reply.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "Describe reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceS.urnString + "\" that has a sliver.");
        AggregateManager3.ManifestInfo manifestInfo = (AggregateManager3.ManifestInfo)reply.getValue();
        this.assertNotNull(manifestInfo, "Describe reply is completely empty when given a provisioned sliver \"" + sliverUrn + "\"");
        this.assertEquals(manifestInfo.getSliceUrn(), sliceUrn, "Describe reply is for another slice URN than requested");
        String manifestRspec = manifestInfo.getManifestRspec();
        if (!this.commonAMTest.isRspecTypeGeni3((LegacyApiTestConfig)this.getTestConfig())) {
            this.note("The RSpec type configured is NOT \"geni\" \"3\" but \"" + this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()) + "\" \"" + this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()) + "\". This test does not support this, and will skip some checks because of this.");
            return;
        }
        this.assertEquals(CommonAMTest.testValidGeni3ManifestRspec(this, manifestRspec), 1, "Describe reply rspec when given a provisioned sliver \"" + sliverUrn + "\" is not an valid RSpec");
        List sliverInfos = manifestInfo.getSliverInfos();
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver status");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        String resSliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(resSliverSUrnStr);
        this.assertValidUrn(resSliverSUrnStr, "sliver");
        this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Describe reply sliver info has different sliver URN than request");
        this.sliverSUrn = new ResourceUrn(this.sliverSUrnStr);
        this.assertNotNull(sliverInfo.getAllocationStatus());
        this.assertNotNull(sliverInfo.getOperationalStatus());
        this.assertNotNull(sliverInfo.getExpires());
        this.setErrorsNotFatal();
        this.assertTrue(CommonAMTest.sameNodesInRequestAndManifest(this, this.requestRspec, manifestRspec));
        this.setErrorsFatal();
        boolean foundNodeLoginInDescribe = this.nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(manifestRspec, null, null);
        if (foundNodeLoginInDescribe) {
            this.note("Successfully found node login info in Describe reply");
        } else {
            this.note("Did not find node login info in Describe reply");
        }
        if (this.foundNodeLoginInProvison) {
            this.assertTrue(foundNodeLoginInDescribe, "Found node login info in the Provision reply. But this same nod login info was NOT found again in the Describe call done afterwards!");
        }
        if (TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("skip_final_manifest_check")) != Boolean.TRUE) {
            this.nodeLoginTestStep.checkManifestCorrectness(manifestRspec, this.testedAuthority);
        }
    }

    @ApiTest.Test(hardDepends={"testPerformOperationalAction"}, groups={"createslivernowait", "postProvisionTests", "nonodelogin"})
    public void testDescribeProvisionedSliver() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.describe(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliverSUrnStr), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), this.commonAMTest.addCredentialExtraOptions(null));
        this.assertNotNull(this.versionInfo);
        if (this.versionInfo.isSingleSliceAllocation()) {
            String apiText = "    geni_single_allocation: <XML-RPC boolean 1/0, default 0>: When true (not default), and performing one of (Describe, Allocate, Renew, Provision, Delete), such an AM requires you to include either the slice urn or the urn of all the slivers in the same state. If you attempt to run one of those operations on just some slivers in a given state, such an AM will return an error. \n\n   For example, at an AM where geni_single_allocation is true you must Provision all geni_allocated slivers at once. If you supply a list of sliver URNs to Provision that is only 'some' of the geni_allocated slivers for this slice at this AM, then the AM will return an error. Similarly, such an aggregate would return an error from Describe if you request a set of sliver URNs that is only some of the geni_provisioned slivers.";
            this.note("The server reported geni_single_allocation to be true in the GetVersion reply. This will call Describe with the urn of the single sliver in this slice. According to the API this is valid: \n\n" + apiText);
        }
        this.checkDescribeExistingSliver((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo>)reply, this.sliceS.urnString, this.sliverSUrnStr);
    }

    @ApiTest.Test(hardDepends={"testPerformOperationalAction"}, softDepends={"testStatusExistingSliver", "testDescribeProvisionedSliver"}, groups={"createsliver", "nodelogin", "postProvisionTests", "nonodelogin"})
    public void testSliverBecomesStarted() throws JFedException, ParseException {
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        long now = System.currentTimeMillis();
        long deadline = now + 1200000L;
        while (now < deadline) {
            AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
            this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo>)reply);
            AggregateManager3.StatusInfo statusInfo = (AggregateManager3.StatusInfo)reply.getValue();
            List sliverInfos = statusInfo.getSliverInfo();
            AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
            this.assertNotEquals(sliverInfo.getAllocationStatus(), "geni_unallocated", "sliver became geni_unallocated while waiting for it to start.");
            this.assertNotEquals(sliverInfo.getAllocationStatus(), "geni_allocated", "sliver became geni_allocated while waiting for it to start.");
            this.assertEquals(sliverInfo.getAllocationStatus(), "geni_provisioned", "sliver is not in geni_provisioned while waiting for it to start.");
            this.assertNotEquals(sliverInfo.getOperationalStatus(), "geni_failed", "sliver operational state became \"geni_failed\" while waiting for it to start.");
            String resSliverSUrnStr = sliverInfo.getSliverUrn();
            this.assertNotNull(resSliverSUrnStr);
            this.assertValidUrn(resSliverSUrnStr, "sliver");
            this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Status sliver URN has different URN than in Allocate and Provision");
            if (Objects.equals(sliverInfo.getOperationalStatus(), "geni_ready")) {
                System.out.println("testSliverBecomesReady -> sliver ready: " + sliverInfo.getOperationalStatus());
                return;
            }
            System.out.println("testCreatedSliverBecomesReady -> sliver not ready: " + sliverInfo.getOperationalStatus() + ".  Trying again in 30 seconds...");
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            now = System.currentTimeMillis();
        }
        throw new RuntimeException("Sliver did not become ready within 20 minutes!");
    }

    @ApiTest.Test(hardDepends={"testPerformOperationalAction"}, softDepends={"testSliverBecomesStarted"}, groups={"postProvisionTests", "nonodelogin"})
    public void testDescribeReadySliver() throws JFedException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.sliceS);
        this.assertNotNull(this.sliverSUrnStr);
        this.assertValidUrn(this.sliverSUrnStr, "sliver");
        AbstractGeniAggregateManager.AggregateManagerReply reply = this.am3.describe(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliverSUrnStr), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), this.commonAMTest.getRspecTypeName((LegacyApiTestConfig)this.getTestConfig()), this.commonAMTest.getRspecTypeVersion((LegacyApiTestConfig)this.getTestConfig()), Boolean.valueOf(true), this.commonAMTest.addCredentialExtraOptions(null));
        this.checkDescribeExistingSliver((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.ManifestInfo>)reply, this.sliceS.urnString, this.sliverSUrnStr);
    }

    @ApiTest.Test(hardDepends={"testPerformOperationalAction"}, softDepends={"testSliverBecomesStarted", "testDescribeReadySliver"}, groups={"nodelogin", "postProvisionTests"})
    public void testNodeLogin() throws JFedException, IOException {
        this.assertNotNull(this.geniUserProvider);
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        assert (this.nodeLoginTestStep != null);
        this.nodeLoginTestStep.testNodeLogin(!this.beLessStrict, this.geniUserProvider, this.sliceS.urn.toString());
    }

    @ApiTest.Test(hardDepends={"testSliverBecomesStarted"}, softDepends={"testNodeLogin"}, groups={"postProvisionTests", "nonodelogin"})
    public void testRenewSliver() throws JFedException, ParseException {
        Date startExpirationTime;
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.skip("Test skipped because not enough free resources detected while tying to create the sliver(s)");
        }
        this.assertNotNull(this.sliceS);
        AbstractGeniAggregateManager.AggregateManagerReply replyStatus1 = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo>)replyStatus1);
        this.assertEquals(((AggregateManager3.StatusInfo)replyStatus1.getValue()).getSliceUrn(), this.sliceS.urnString);
        this.assertEquals(((AggregateManager3.StatusInfo)replyStatus1.getValue()).getSliverInfo().size(), 1);
        String startExpirationTimeString = ((AggregateManager3.SliverInfo)((AggregateManager3.StatusInfo)replyStatus1.getValue()).getSliverInfo().get(0)).getExpires();
        try {
            startExpirationTime = RFC3339Util.iso8601StringToDate((String)startExpirationTimeString);
        }
        catch (ParseException e) {
            throw new RuntimeException("geni_expire data is NOT a valid RFC3339 date: \"" + startExpirationTimeString + "\"", e);
        }
        Date sliceExpireTime = AnyCredential.getExpireTime(this.sliceS.credentials);
        if (sliceExpireTime != null && !sliceExpireTime.after(startExpirationTime)) {
            this.note("Sliver expires at same time as slice. Will renew slice first, so sliver can be then be renewed");
            Date newSliceExpirationTime = new Date(startExpirationTime.getTime() + 600000L);
            this.sliceS = this.commonAMTest.renewSlice(this.sliceS, newSliceExpirationTime);
        }
        Date newSliverExpirationTime = new Date(startExpirationTime.getTime() + 300000L);
        String newSliverExpirationTimeString = RFC3339Util.dateToRFC3339String((Date)newSliverExpirationTime, (boolean)true, (boolean)true, (boolean)true);
        AbstractGeniAggregateManager.AggregateManagerReply replyRenew = this.am3.renew(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), newSliverExpirationTimeString, null, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(replyRenew.getRawResult());
        this.assertEquals(replyRenew.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "RenewSliver reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceS.urnString + "\" that has a sliver.");
        this.assertEquals(((List)replyRenew.getValue()).size(), 1);
        String renewResSliverExpirationTimeString = ((AggregateManager3.SliverInfo)((List)replyRenew.getValue()).get(0)).getExpires();
        Date renewResSliverExpirationTime = RFC3339Util.rfc3339StringToDate((String)renewResSliverExpirationTimeString);
        this.assertEquals(renewResSliverExpirationTime.getTime(), newSliverExpirationTime.getTime(), "Sliver expiration time has not been set to the data asked in Renew reply: str: requested=\"" + newSliverExpirationTimeString + "\" set=\"" + renewResSliverExpirationTimeString + "\"  date: requested=\"" + newSliverExpirationTime + "\" set=\"" + renewResSliverExpirationTime + "\"");
        AbstractGeniAggregateManager.AggregateManagerReply replyStatus2 = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.validSuccesStatus((AbstractGeniAggregateManager.AggregateManagerReply<AggregateManager3.StatusInfo>)replyStatus2);
        this.assertEquals(((AggregateManager3.StatusInfo)replyStatus2.getValue()).getSliceUrn(), this.sliceS.urnString);
        this.assertEquals(((AggregateManager3.StatusInfo)replyStatus2.getValue()).getSliverInfo().size(), 1);
        String statusResSliverExpirationTimeString = ((AggregateManager3.SliverInfo)((AggregateManager3.StatusInfo)replyStatus2.getValue()).getSliverInfo().get(0)).getExpires();
        Date statusResSliverExpirationTime = RFC3339Util.rfc3339StringToDate((String)statusResSliverExpirationTimeString);
        this.assertEquals(statusResSliverExpirationTime.getTime(), newSliverExpirationTime.getTime(), "Sliver expiration time has not been set to the data asked in Status reply: str: requested=\"" + newSliverExpirationTimeString + "\" set=\"" + statusResSliverExpirationTimeString + "\"  date: requested=\"" + newSliverExpirationTime + "\" set=\"" + statusResSliverExpirationTime + "\"");
    }

    @ApiTest.Test(softDepends={"testNodeLogin", "testRenewSliver", "testSliverBecomesStarted"}, groups={"createsliver", "nodelogin", "postProvisionTests", "nonodelogin"})
    public void testDeleteSliver() throws JFedException {
        if (this.disableCleanup.booleanValue()) {
            this.skip("No cleanup needed.");
        }
        if (this.sliceS.urnString == null) {
            this.skip("Skipped because other test created nothing to delete");
        }
        this.assertNotNull(this.sliceS);
        System.out.println("DeleteSliver for slice " + this.sliceS.urnString);
        AbstractGeniAggregateManager.AggregateManagerReply reply2 = this.am3.delete(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(reply2.getRawResult());
        this.assertEquals(reply2.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS, "DeleteSliver reply GeniResponse code is not SUCCESS (0) when given a slice \"" + this.sliceS.urnString + "\" that has a sliver.");
        List sliverInfos = (List)reply2.getValue();
        this.assertEquals(sliverInfos.size(), 1, "should be exactly 1 sliver status");
        AggregateManager3.SliverInfo sliverInfo = (AggregateManager3.SliverInfo)sliverInfos.get(0);
        String resSliverSUrnStr = sliverInfo.getSliverUrn();
        this.assertNotNull(resSliverSUrnStr);
        this.assertValidUrn(resSliverSUrnStr, "sliver");
        this.assertEquals(resSliverSUrnStr, this.sliverSUrnStr, "Delete reply sliver info has different sliver URN than request");
        this.sliverSUrn = new ResourceUrn(this.sliverSUrnStr);
        this.assertNotNull(sliverInfo.getAllocationStatus());
        this.assertEquals(sliverInfo.getAllocationStatus(), "geni_unallocated");
        AbstractGeniAggregateManager.AggregateManagerReply replyStatus = this.am3.status(this.getAM3Connection(), TestAggregateManager3.toStringList(this.sliceS.urnString), this.commonAMTest.getSliceCredentialListForAM(this.sliceS), null, this.commonAMTest.addCredentialExtraOptions(null));
        this.testAM3CorrectnessXmlRpcResult(replyStatus.getRawResult());
        if (replyStatus.getGeniResponseCode().isSuccess()) {
            this.assertEquals(replyStatus.getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SUCCESS);
            this.assertInstanceOf(replyStatus.getRawResult().get("value"), Map.class, "SliverStatus value should be a Map. Not: " + replyStatus.getRawResult().get("value"));
            AggregateManager3.StatusInfo statusInfo = (AggregateManager3.StatusInfo)replyStatus.getValue();
            this.assertNotNull(statusInfo);
            String resSliceUrn = statusInfo.getSliceUrn();
            this.assertNotNull(resSliceUrn);
            this.assertValidUrn(resSliceUrn, "slice");
            this.assertEquals(resSliceUrn, this.sliceS.urnString, "Status slice urn is not correct slice");
            List sliverInfosStatus = statusInfo.getSliverInfo();
            if (sliverInfosStatus.isEmpty()) {
                return;
            }
            for (AggregateManager3.SliverInfo si : sliverInfosStatus) {
                String siSliverUrnStr = si.getSliverUrn();
                this.assertNotNull(siSliverUrnStr);
                this.assertValidUrn(siSliverUrnStr, "sliver");
                this.assertEquals(si.getAllocationStatus(), "geni_unallocated");
            }
            return;
        }
    }
}

